/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import mpi.Datatype;
import mpi.Errhandler;
import mpi.Group;
import mpi.Intercomm;
import mpi.MPI;
import mpi.MPIException;
import mpi.Prequest;
import mpi.Request;
import mpi.Status;

public class Comm {
    protected static final int SELF = 1;
    protected static final int WORLD = 2;
    protected static long nullHandle;
    protected long handle;

    Comm() {
    }

    void setType(int n) {
        this.GetComm(n);
    }

    private native void GetComm(int var1);

    protected Comm(long l) {
        this.handle = l;
    }

    public Object clone() {
        return new Comm(this.dup());
    }

    protected native long dup();

    public native int Size() throws MPIException;

    public native int Rank() throws MPIException;

    public static native int Compare(Comm var0, Comm var1) throws MPIException;

    public native void Free() throws MPIException;

    public native boolean Is_null();

    public Group Group() throws MPIException {
        return new Group(this.group());
    }

    private native long group();

    public native boolean Test_inter() throws MPIException;

    public Intercomm Create_intercomm(Comm comm, int n, int n2, int n3) throws MPIException {
        return new Intercomm(this.GetIntercomm(comm, n, n2, n3));
    }

    public native long GetIntercomm(Comm var1, int var2, int var3, int var4);

    public byte[] Object_Serialize(Object object, int n, int n2, Datatype datatype) throws MPIException {
        if (datatype.Size() != 0) {
            byte[] byArray;
            Object[] objectArray = (Object[])object;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                for (int i = 0; i < n2; ++i) {
                    int n3 = datatype.Extent() * i;
                    for (int j = 0; j < datatype.displacements.length; ++j) {
                        objectOutputStream.writeObject(objectArray[n3 + n + datatype.displacements[j]]);
                    }
                }
                objectOutputStream.flush();
                objectOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byArray = null;
            }
            return byArray;
        }
        return new byte[0];
    }

    public void Object_Deserialize(Object object, byte[] byArray, int n, int n2, Datatype datatype) throws MPIException {
        if (datatype.Size() != 0) {
            Object[] objectArray = (Object[])object;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                for (int i = 0; i < n2; ++i) {
                    int n3 = datatype.Extent() * i;
                    for (int j = 0; j < datatype.displacements.length; ++j) {
                        objectArray[n3 + n + datatype.displacements[j]] = objectInputStream.readObject();
                    }
                }
                objectInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void Send(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            this.send(nArray, 0, 2, MPI.INT, n3, n4);
            this.send(byArray, 0, byArray.length, MPI.BYTE, n3, n4);
        } else {
            this.send(object, n, n2, datatype, n3, n4);
        }
    }

    private native void send(Object var1, int var2, int var3, Datatype var4, int var5, int var6);

    public Status Recv(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            Status status = new Status();
            int[] nArray = new int[2];
            this.Recv(nArray, 0, 2, MPI.INT, n3, n4, status);
            byte[] byArray = new byte[nArray[0]];
            this.Recv(byArray, 0, nArray[0], MPI.BYTE, status.source, n4, status);
            this.Object_Deserialize(object, byArray, n, nArray[1], datatype);
            status.object_count = nArray[1];
            return status;
        }
        return this.Recv(object, n, n2, datatype, n3, n4, new Status());
    }

    private native Status Recv(Object var1, int var2, int var3, Datatype var4, int var5, int var6, Status var7);

    public Status Sendrecv(Object object, int n, int n2, Datatype datatype, int n3, int n4, Object object2, int n5, int n6, Datatype datatype2, int n7, int n8) throws MPIException {
        if (datatype.isObject() || datatype2.isObject()) {
            Request[] requestArray = new Request[]{this.Isend(object, n, n2, datatype, n3, n4), this.Irecv(object2, n5, n6, datatype2, n7, n8)};
            Status[] statusArray = Request.Waitall(requestArray);
            return statusArray[1];
        }
        return this.Sendrecv(object, n, n2, datatype, n3, n4, object2, n5, n6, datatype2, n7, n8, new Status());
    }

    private native Status Sendrecv(Object var1, int var2, int var3, Datatype var4, int var5, int var6, Object var7, int var8, int var9, Datatype var10, int var11, int var12, Status var13);

    public Status Sendrecv_replace(Object object, int n, int n2, Datatype datatype, int n3, int n4, int n5, int n6) throws MPIException {
        if (datatype.isObject()) {
            Status status = new Status();
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            this.Sendrecv_replace(nArray, 0, 2, MPI.INT, n3, n4, n5, n6, status);
            byte[] byArray2 = new byte[nArray[0]];
            this.Sendrecv(byArray, 0, byArray.length, MPI.BYTE, n3, n4, byArray2, 0, byArray2.length, MPI.BYTE, status.source, n6, status);
            this.Object_Deserialize(object, byArray2, n, nArray[1], datatype);
            status.object_count = nArray[1];
            return status;
        }
        return this.Sendrecv_replace(object, n, n2, datatype, n3, n4, n5, n6, new Status());
    }

    private native Status Sendrecv_replace(Object var1, int var2, int var3, Datatype var4, int var5, int var6, int var7, int var8, Status var9);

    public void Bsend(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            this.bsend(nArray, 0, 2, MPI.INT, n3, n4);
            this.bsend(byArray, 0, nArray[0], MPI.BYTE, n3, n4);
        } else {
            this.bsend(object, n, n2, datatype, n3, n4);
        }
    }

    private native void bsend(Object var1, int var2, int var3, Datatype var4, int var5, int var6);

    public void Ssend(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            this.send(nArray, 0, 2, MPI.INT, n3, n4);
            this.ssend(byArray, 0, byArray.length, MPI.BYTE, n3, n4);
        } else {
            this.ssend(object, n, n2, datatype, n3, n4);
        }
    }

    private native void ssend(Object var1, int var2, int var3, Datatype var4, int var5, int var6);

    public void Rsend(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            this.rsend(nArray, 0, 2, MPI.INT, n3, n4);
            this.rsend(byArray, 0, byArray.length, MPI.BYTE, n3, n4);
        } else {
            this.rsend(object, n, n2, datatype, n3, n4);
        }
    }

    private native void rsend(Object var1, int var2, int var3, Datatype var4, int var5, int var6);

    public Request Isend(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            Request request = this.Isend(nArray, 0, 2, MPI.INT, n3, n4, new Request());
            Request request2 = new Request(request);
            this.Isend(byArray, 0, byArray.length, MPI.BYTE, n3, n4, request2);
            return request2;
        }
        return this.Isend(object, n, n2, datatype, n3, n4, new Request());
    }

    protected native Request Isend(Object var1, int var2, int var3, Datatype var4, int var5, int var6, Request var7);

    public Request Ibsend(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            Request request = this.Ibsend(nArray, 0, 2, MPI.INT, n3, n4, new Request());
            Request request2 = new Request(request);
            this.Ibsend(byArray, 0, byArray.length, MPI.BYTE, n3, n4, request2);
            return request2;
        }
        return this.Ibsend(object, n, n2, datatype, n3, n4, new Request());
    }

    protected native Request Ibsend(Object var1, int var2, int var3, Datatype var4, int var5, int var6, Request var7);

    public Request Issend(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            Request request = this.Issend(nArray, 0, 2, MPI.INT, n3, n4, new Request());
            Request request2 = new Request(request);
            this.Isend(byArray, 0, byArray.length, MPI.BYTE, n3, n4, request2);
            return request2;
        }
        return this.Issend(object, n, n2, datatype, n3, n4, new Request());
    }

    protected native Request Issend(Object var1, int var2, int var3, Datatype var4, int var5, int var6, Request var7);

    public Request Irsend(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray = this.Object_Serialize(object, n, n2, datatype);
            int[] nArray = new int[]{byArray.length, n2};
            Request request = this.Irsend(nArray, 0, 2, MPI.INT, n3, n4, new Request());
            Request request2 = new Request(request);
            this.Isend(byArray, 0, byArray.length, MPI.BYTE, n3, n4, request2);
            return request2;
        }
        return this.Irsend(object, n, n2, datatype, n3, n4, new Request());
    }

    protected native Request Irsend(Object var1, int var2, int var3, Datatype var4, int var5, int var6, Request var7);

    public Request Irecv(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        if (datatype.isObject()) {
            int[] nArray = new int[2];
            Request request = new Request(object, n, n2, datatype, n4, this, nArray);
            this.Irecv(nArray, 0, 2, MPI.INT, n3, n4, request);
            return request;
        }
        return this.Irecv(object, n, n2, datatype, n3, n4, new Request());
    }

    protected native Request Irecv(Object var1, int var2, int var3, Datatype var4, int var5, int var6, Request var7);

    public Prequest Send_init(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        return new Prequest(0, object, n, n2, datatype, n3, n4, this);
    }

    public Prequest Bsend_init(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        return new Prequest(1, object, n, n2, datatype, n3, n4, this);
    }

    public Prequest Ssend_init(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        return new Prequest(2, object, n, n2, datatype, n3, n4, this);
    }

    public Prequest Rsend_init(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        return new Prequest(3, object, n, n2, datatype, n3, n4, this);
    }

    public Prequest Recv_init(Object object, int n, int n2, Datatype datatype, int n3, int n4) throws MPIException {
        return new Prequest(object, n, n2, datatype, n3, n4, this);
    }

    public int Pack(Object object, int n, int n2, Datatype datatype, byte[] byArray, int n3) throws MPIException {
        if (datatype.isObject()) {
            byte[] byArray2 = this.Object_Serialize(object, n, n2, datatype);
            System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
            return n3 + byArray2.length;
        }
        return this.pack(object, n, n2, datatype, byArray, n3);
    }

    private native int pack(Object var1, int var2, int var3, Datatype var4, byte[] var5, int var6);

    public int Unpack(byte[] byArray, int n, Object object, int n2, int n3, Datatype datatype) throws MPIException {
        if (datatype.isObject()) {
            Object[] objectArray = (Object[])object;
            int n4 = 0;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, byArray.length - n);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                for (int i = 0; i < n3; ++i) {
                    int n5 = datatype.Extent() * i;
                    for (int j = 0; j < datatype.displacements.length; ++j) {
                        objectArray[n5 + n2 + datatype.displacements[j]] = objectInputStream.readObject();
                    }
                }
                n4 = byteArrayInputStream.available();
                objectInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return byArray.length - n4;
        }
        return this.unpack(byArray, n, object, n2, n3, datatype);
    }

    private native int unpack(byte[] var1, int var2, Object var3, int var4, int var5, Datatype var6);

    public native int Pack_size(int var1, Datatype var2) throws MPIException;

    public Status Iprobe(int n, int n2) throws MPIException {
        return this.Iprobe(n, n2, new Status());
    }

    private native Status Iprobe(int var1, int var2, Status var3) throws MPIException;

    public Status Probe(int n, int n2) throws MPIException {
        return this.Probe(n, n2, new Status());
    }

    private native Status Probe(int var1, int var2, Status var3) throws MPIException;

    public native int Attr_get(int var1) throws MPIException;

    public native int Topo_test() throws MPIException;

    public native void Abort(int var1) throws MPIException;

    public native void Errhandler_set(Errhandler var1) throws MPIException;

    public Errhandler Errorhandler_get() throws MPIException {
        return new Errhandler(this.errorhandler_get());
    }

    private native long errorhandler_get();

    private static native void init();

    static {
        Comm.init();
    }
}

