#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import jpype
import share


def onJvmStartup( jvm ):
	
	# factory shortcut
	global f; f = jpype.JPackage( "edu.duke.donaldLab.jdshot" )
	
	# symmetry shortcuts
	global Cn; Cn = f.grid.Symmetry.Cn
	global Dn; Dn = f.grid.Symmetry.Dn


def initJvm( jvm ):
	jvm.addStartupHandler( onJvmStartup )
	return jvm


def getJvm( ):
	return initJvm( share.getJvm() )


def getOligomer( monomer, gridPoint, numSubunits, symmetry ):
	
	generator = symmetry.newStructureGenerator( monomer )
	return generator.getStructure( gridPoint, numSubunits )


def minimizeStructure( pdbOutPath, workDir, distanceRestraints, protein ):
	
	minimizeStructureHelper(
		pdbOutPath,
		f.minimize.EvaluatingMinimizer( workDir, distanceRestraints ),
		protein
	)


def minimizeSymmetricStructure( pdbOutPath, workDir, symmetryContext, distanceRestraintsContext, protein ):
	
	minimizeStructureHelper(
		pdbOutPath,
		f.minimize.EvaluatingMinimizer( workDir, symmetryContext, distanceRestraintsContext ),
		protein
	)
	

def minimizeStructureHelper( pdbOutPath, minimizer, protein ):

	print "Minimizing.."
	scores = minimizer.minimize( pdbOutPath, protein )
	print "Wrote minimized pdb:\n\t", pdbOutPath
	print "\tBefore:"
	print "\t\tenergy: %.3f" % scores.before.vdwEnergy
	print "\t\trestraints satisfied: %d" % scores.before.numSatisfied
	print "\t\tNOE RMSD: %.3f" % scores.before.restraintRmsd
	print "\tAfter:"
	print "\t\tenergy: %.3f" % scores.after.vdwEnergy
	print "\t\trestraints satisfied: %d" % scores.after.numSatisfied
	print "\t\tNOE RMSD: %.3f" % scores.after.restraintRmsd
	
	# write out the scores-format line
	print "\tScores:"
	print "\t\t0\t%f\t%f\t%d\t%f\t%f\t%d" % (
		scores.before.vdwEnergy,
		scores.before.restraintRmsd,
		scores.before.numSatisfied,
		scores.after.vdwEnergy,
		scores.after.restraintRmsd,
		scores.after.numSatisfied
	)


def writePoints( file, points ):
	
	writer = f.grid.PointWriter( file )
	for point in points:
		writer.writePoint( point )
	writer.close()
	
	print "Wrote %d points to:\n\t%s" % ( writer.getNumPointsWritten(), file )


def newSymmetryContext( symmetry, pathInMonomer, subunitOrder ):
	
	return f.context.SymmetryContext( symmetry, pathInMonomer, subunitOrder )


def newRdcsContext( symmetryContext, pathInRdcs ):
	
	return f.context.RdcsContext( symmetryContext, pathInRdcs )


def newDistanceRestraintsContext( symmetryContext, pathInDistanceRestraints ):
	
	return f.context.DistanceRestraintsContext( symmetryContext, pathInDistanceRestraints )

