#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import jvm, jpype, math
import jdshot, share
jdshot.getJvm().start() # debugAddress = 8000 )
import disco

dirInput = "/home/jeff/duke/donaldLab/dshot/input"

Subunit = share.f.protein.Subunit
Plotter = jdshot.f.disco.Plotter
OrientationCalculator = jdshot.f.disco.OrientationCalculator
AnnulusCalculator = jdshot.f.disco.AnnulusCalculator
PositionCalculator = jdshot.f.disco.PositionCalculator
AlignmentTensorAxis = share.f.nmr.AlignmentTensorAxis

def computeSampledOrientations( outDir, pathInEnsemble, numSubunits, proteinIndex, pathInRdcs, numSamples ):
    
    # load the inputs
    protein = share.loadProteins( pathInEnsemble ).get( proteinIndex )
    rdcsContext = jdshot.newRdcsContext( protein, pathInRdcs )
    
    # compute the optimal alignment tensor
    bestTensor = share.newAlignmentTensor( protein, rdcsContext.getInternalRdcs() )
    
    # estimate the distribution of alignment tensor axes
#    tensors = share.newAlignmentTensors( protein, rdcsContext.getInternalRdcs(), numSamples )
#    disco.writeChart(
#        jvm.newFile( outDir, "sampledTensorAxes.X.png" ),
#        Plotter.plotAlignmentTensorsAxis( tensors, AlignmentTensorAxis.X )
#    )
#    disco.writeChart(
#        jvm.newFile( outDir, "sampledTensorAxes.Y.png" ),
#        Plotter.plotAlignmentTensorsAxis( tensors, AlignmentTensorAxis.Y )
#    )
#    disco.writeChart(
#        jvm.newFile( outDir, "sampledTensorAxes.Z.png" ),
#        Plotter.plotAlignmentTensorsAxis( tensors, AlignmentTensorAxis.Z )
#    )
    

try:
    
    # MPER
    computeSampledOrientations(
        "/home/jeff/duke/donaldLab/mper/results",
        "/home/jeff/duke/donaldLab/mper/results/ensembleCyana.pdb",
        3,
        0,
        "/home/jeff/duke/donaldLab/mper/data/pag-hn.tbl",
        #"/home/jeff/duke/donaldLab/mper/data/gnuc-hn.tbl",
        10000
    )

except jpype.JavaException as ex:
    import sys
    print >> sys.stderr, "Java Exception: %s\n" % ex
    print >> sys.stderr, ex.stacktrace()
    raise
