#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import os
import shutil
import restraints
import splitRestraints


# settings
dirMatlabSrc = "/home/jeff/duke/donaldLab/noe+rdc/sdshurn/src"
dirMatlabIn = "/home/jeff/duke/donaldLab/noe+rdc/sdshurn/input"
dirMatlabOut = "/home/jeff/duke/donaldLab/noe+rdc/sdshurn/output"
pathMatlabTemplate = dirMatlabSrc + "/MainNOERDC.template"
pathMatlabMain = dirMatlabSrc + "/MainPython.m"
mainTag = "${params}"


def runMatlab( pathTemplate, params ):
	
	file = open( pathMatlabMain, "w" )
	for line in open( pathTemplate ):
		line = line.strip()
		if line == mainTag:
			file.write( params )
		else:
			file.write( line + "\n" )
	file.write( "exit;\n" )
	file.close()
	print "Matlab script written to " + pathMatlabMain
	
	# run matlab
	print "Running Matlab..."
	os.system( "cd ""%""s; matlab -nojvm -nodisplay -nosplash < ""%s""" % ( dirMatlabSrc, pathMatlabMain ) )
	print "Done!"
	

def run( pdbId, dirOut, pathOligomer, pathInRestraints, paddingPercent, sampleResolution, subunitAmbiguity, numTrustedRestraints ):
	
	# make the out dir if it doesn't exist already
	dirStage1 = dirOut + "/stage1"
	dirStage2 = dirOut + "/stage2"
	if not os.path.exists( dirStage1 ):
		os.makedirs( dirStage1 )
	if not os.path.exists( dirStage2 ):
		os.makedirs( dirStage2 )
	
	# generate the restraints file
	outRestraintsName = "%s-restraints.txt" % pdbId
	pathOutRestraints = dirStage1 + "/" + outRestraintsName
	restraints.generate(
		pathOutRestraints,
		pathOligomer,
		pathInRestraints,
		True,
		paddingPercent / 100.0
	)
	
	# run stage 1
	shutil.copy( pathOutRestraints, dirMatlabIn )
	params = """
ProteinName = '%s';
SampleResolution = %f;
SubunitAmbiguity = %d;
IsNHRDCFileInMRFormat = true;
NumTrustedRestraints = %d;
""" % ( pdbId, sampleResolution, subunitAmbiguity, numTrustedRestraints )
	runMatlab( pathMatlabTemplate, params )
	
	# copy the matlab outputs to the out dir
	os.system( "mv ""%s"" ""%s""" % ( dirMatlabOut + "/*", dirStage1 ) )
	
	# split restraints
	pathViolations = dirStage1 + "/untrustedViolations.txt"
	pathConsistentRestraints = dirStage1 + "/consistent.noe"
	splitRestraints.run(
		pathConsistentRestraints,
		dirStage1 + "/inconsistent.noe",
		pathViolations,
		pathOutRestraints
	)
	
	# generate the restraints file
	pathOutRestraints = dirStage2 + "/" + outRestraintsName
	restraints.generate(
		pathOutRestraints,
		pathOligomer,
		pathConsistentRestraints,
		True,
		0.0
	)
	
	# run stage 2
	shutil.copy( pathOutRestraints, dirMatlabIn )
	params = """
ProteinName = '%s';
SampleResolution = %f;
SubunitAmbiguity = %d;
IsNHRDCFileInMRFormat = true;
""" % ( pdbId, sampleResolution, subunitAmbiguity )
	runMatlab( pathMatlabTemplate, params )
	
	# copy the matlab outputs to the out dir
	os.system( "mv ""%s"" ""%s""" % ( dirMatlabOut + "/*", dirStage2 ) )
	
	
# set up paths
dirInput = "/home/jeff/duke/donaldLab/dshot/input"
dirResults = "/home/jeff/duke/donaldLab/noe+rdc/results"

# DAGK
dirOut = dirResults + "/DAGK/annuli/padding=3%"
run(
	pdbId = "2KDC",
	dirOut = dirOut,
	pathOligomer = dirInput + "/2KDC.oligomer.protein",
	pathInRestraints = dirInput + "/2KDC.experimental.noe",
	paddingPercent = 3.0,
	sampleResolution = 0.025,
	subunitAmbiguity = True,
	numTrustedRestraints = 24
)
