#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import sys
import share

share.getJvm().start()


# process the arguments
argproc = share.f.io.ArgumentsProcessor();
ArgumentType = share.f.io.ArgumentType
argproc.add( "pdbPath", ArgumentType.InFile, "path to the monomer protein" );
argproc.process( sys.argv[1:] );
file = argproc.getFile( "pdbPath" );	

# load the proteins and convert to backbones
proteins = share.loadProteins( file )
backbones = [protein.getBackbone() for protein in proteins]

print "avg all-atom variance: %f A^2 or %f A RMSD" % (
	share.getAverageVariance( proteins ),
	share.getAverageRmsd( proteins )
)
print "avg backbone variance: %f A^2 or %f A RMSD" % (
	share.getAverageVariance( backbones ),
	share.getAverageRmsd( backbones )
)
