/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.analyze;

import edu.duke.donaldLab.jdshot.grid.CellIterator;
import edu.duke.donaldLab.jdshot.grid.GridCell;
import edu.duke.donaldLab.jdshot.grid.GridPoint;
import edu.duke.donaldLab.jdshot.grid.GridPointAdapter;
import edu.duke.donaldLab.jdshot.grid.PointIterator;
import edu.duke.donaldLab.share.perf.Progress;

public class AnalysisProcessorSynchronizer
{
	/**************************
	 *   Data Members
	 **************************/
	
	private AnalysisMode m_mode;
	private CellIterator m_iterCell;
	private PointIterator m_iterPoint;
	private GridPointAdapter m_adapter;
	private Progress m_progress;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public AnalysisProcessorSynchronizer( AnalysisMode mode, CellIterator iterCell, PointIterator iterPoint, GridPointAdapter adapter, Progress progress )
	{
		m_mode = mode;
		m_iterCell = iterCell;
		m_iterPoint = iterPoint;
		m_adapter = adapter;
		m_progress = progress;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public AnalysisMode getMode( )
	{
		return m_mode;
	}
	
	public GridPointAdapter getAdapter( )
	{
		return m_adapter;
	}
	
	public synchronized GridCell getNextCell( )
	{
		if( m_iterCell.hasNext() )
		{
			return m_iterCell.next();
		}
		else
		{
			return null;
		}
	}
	
	public synchronized GridPoint getNextPoint( )
	{
		if( m_iterPoint.hasNext() )
		{
			return m_iterPoint.next();
		}
		else
		{
			return null;
		}
	}
	
	public synchronized void incrementProgress( )
	{
		m_progress.incrementProgress();
	}
}
