/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.disco;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import edu.duke.donaldLab.share.geom.Vector3;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;

public class ResultsWriter
{
	/**************************
	 *   Definitions
	 **************************/
	
	private static final Logger m_log = Logger.getLogger( ResultsWriter.class );
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public void writeMsrs( File file, List<FaceInfo> msrs )
	throws IOException
	{
		ObjectOutputStream out = new ObjectOutputStream( new BufferedOutputStream( new FileOutputStream( file ) ) );
		out.writeObject( msrs );
		out.close();
		m_log.info( "Wrote " + msrs.size() + " MSRs to:\n\t" + file.getAbsolutePath() );
	}
	
	public void writeOrientations( File file, List<Vector3> orientations )
	throws IOException
	{
		ObjectOutputStream out = new ObjectOutputStream( new BufferedOutputStream( new FileOutputStream( file ) ) );
		out.writeObject( orientations );
		out.close();
		m_log.info( "Wrote " + orientations.size() + " orientations to:\n\t" + file.getAbsolutePath() );
	}
	
	public void writeVariation( File file, Map<AtomAddressInternal,Double> variation )
	throws IOException
	{
		ObjectOutputStream out = new ObjectOutputStream( new BufferedOutputStream( new FileOutputStream( file ) ) );
		out.writeObject( variation );
		out.close();
		m_log.info( "Wrote " + variation.size() + " variations to:\n\t" + file.getAbsolutePath() );
	}
	
	public void writeScores( File file, StructureScores scores )
	throws IOException
	{
		ObjectOutputStream out = new ObjectOutputStream( new BufferedOutputStream( new FileOutputStream( file ) ) );
		out.writeObject( scores );
		out.close();
		m_log.info( "Wrote " + scores.getNumScores() + " minimized structure scores to:\n\t" + file.getAbsolutePath() );
	}
	
	public void writeAnnulusIndices( File file, List<AnnulusIndex> indices )
	throws IOException
	{
		ObjectOutputStream out = new ObjectOutputStream( new BufferedOutputStream( new FileOutputStream( file ) ) );
		out.writeObject( indices );
		out.close();
		m_log.info( "Wrote " + indices.size() + " annulus indices to:\n\t" + file.getAbsolutePath() );
	}
}
