/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.grid;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PointWriter
{
	/**************************
	 *   Data Members
	 **************************/
	
	private DataOutputStream m_out;
	private long m_numPointsWritten;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public PointWriter( String path )
	throws IOException
	{
		this( new File( path ) );
	}
	
	public PointWriter( File file )
	throws IOException
	{
		// make sure the path exists
		file.getParentFile().mkdirs();
		
		// open the file for writing
		m_out = new DataOutputStream( new BufferedOutputStream( new FileOutputStream( file ) ) );
		
		m_numPointsWritten = 0;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public long getNumPointsWritten( )
	{
		return m_numPointsWritten;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public void writePoint( GridPoint point )
	throws IOException
	{
		for( int i=0; i<point.getSymmetry().getNumDimensions(); i++ )
		{
			m_out.writeDouble( point.get( i ) );
		}
		m_numPointsWritten++;
	}
	
	public void close( )
	throws IOException
	{
		m_out.close();
		m_out = null;
	}
}
