/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.search;

import edu.duke.donaldLab.share.geom.Vector3;

public class BoundContext
{
	/**************************
	 *   Fields
	 **************************/
	
	public Vector3 q;
	public Vector3 a;
	public double alpha;
	public double epsilon;
	public Vector3[] corners = null;
	public SubunitType type;
	public double avgDiagonalSq;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public BoundContext( int numCorners )
	{
		q = new Vector3();
		a = new Vector3();
		alpha = 0.0;
		epsilon = 0.0;
		corners = new Vector3[numCorners];
		type = SubunitType.Unknown;
		avgDiagonalSq = 0.0;
		
		for( int i=0; i<numCorners; i++ )
		{
			corners[i] = new Vector3();
		}
	}
	
	public BoundContext( BoundContext other )
	{
		q = new Vector3( other.q );
		a = new Vector3( other.a );
		alpha = other.alpha;
		epsilon = other.epsilon;
		corners = new Vector3[other.corners.length];
		type = other.type;
		avgDiagonalSq = other.avgDiagonalSq;
		
		for( int i=0; i<other.corners.length; i++ )
		{
			corners[i] = new Vector3( other.corners[i] );
		}
	}
}
