/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.search.messages;

import java.util.ArrayList;
import java.util.List;

import edu.duke.donaldLab.jdshot.grid.GridCell;
import edu.duke.donaldLab.jdshot.grid.Symmetry;
import edu.duke.donaldLab.jdshot.search.Consistency;
import edu.duke.donaldLab.share.mpi.Message;
import edu.duke.donaldLab.share.nmr.DistanceRestraint;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;

public class CellsResult extends Message
{
	/**************************
	 *   Definitions
	 **************************/
	
	private static final long serialVersionUID = 7361125871508822458L;
	
	
	/**************************
	 *   Fields
	 **************************/
	
	public int numCellsRequested;
	public ArrayList<GridCell> cells;
	public int startIndex;
	public Consistency consistency;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public CellsResult( int batchSize, Symmetry symmetry, List<DistanceRestraint<AtomAddressInternal>> restraints )
	{
		// save parameters
		numCellsRequested = batchSize;
		consistency = new Consistency( batchSize * 2, restraints );
		
		// init defaults
		cells = null;
		startIndex = -1;
		
		resizeCells( batchSize * 2, symmetry );
	}
	
	public void resizeCells( int numCells, Symmetry symmetry )
	{
		cells = new ArrayList<GridCell>( numCells );
		for( int i=0; i<numCells; i++ )
		{
			cells.add( symmetry.newGridCell() );
		}
		
		consistency.resizeCells( numCells );
	}
}
