/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.test.grid;

import java.util.ArrayList;
import java.util.List;

import edu.duke.donaldLab.jdshot.grid.dn.DnNoeReplicator;
import edu.duke.donaldLab.share.nmr.DistanceRestraint;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;
import edu.duke.donaldLab.share.test.ExtendedTestCase;

public class TestDnDistanceRestraintReplicator extends ExtendedTestCase
{
	public void testReplicate( )
	{
		// intradimer
		check( new int[] { 0,1,2,3 }, new int[] { 0,1 }, 4 );
		check( new int[] { 0,1,2,3,4,5 }, new int[] { 0,1 }, 6 );
		
		// interdimer standard
		check( new int[] { 0,3,2,1 }, new int[] { 0,3 }, 4 );
		check( new int[] { 0,5,2,1,4,3 }, new int[] { 0,5 }, 6 );
		
		// interdimer goofy
		check( new int[] { 0,2,2,0 }, new int[] { 0,2 }, 4 );
		check( new int[] { 0,2,2,4,4,0 }, new int[] { 0,2 }, 6 );
	}
	
	private void check( int[] expectedSubunitIds, int[] subunitIds, int numSubunits )
	{
		assertEqualsNoes(
			expectedSubunitIds,
			new DnNoeReplicator().replicate( newDistanceRestraints( subunitIds ), numSubunits )
		);
	}
	
	private ArrayList<DistanceRestraint<AtomAddressInternal>> newDistanceRestraints( int[] subunitIds )
	{
		ArrayList<DistanceRestraint<AtomAddressInternal>> noes = new ArrayList<DistanceRestraint<AtomAddressInternal>>( 1 );
		noes.add( newDistanceRestraint( subunitIds[0], subunitIds[1] ) );
		return noes;
	}
	
	private DistanceRestraint<AtomAddressInternal> newDistanceRestraint( int left, int right )
	{
		DistanceRestraint<AtomAddressInternal> noe = new DistanceRestraint<AtomAddressInternal>();
		noe.setLefts( new AtomAddressInternal( left, 0, 0 ) );
		noe.setRights( new AtomAddressInternal( right, 0, 0 ) );
		return noe;
	}
	
	private void assertEqualsNoes( int[] expectedSubunitIds, List<DistanceRestraint<AtomAddressInternal>> noes )
	{
		int numNoes = expectedSubunitIds.length / 2;
		assertEquals( numNoes, noes.size() );
		
		for( int i=0; i<numNoes; i++ )
		{
			assertEquals(
				expectedSubunitIds[i*2],
				noes.get( i ).getLefts().iterator().next().getSubunitId()
			);
			assertEquals(
				expectedSubunitIds[i*2+1],
				noes.get( i ).getRights().iterator().next().getSubunitId()
			);
		}
	}
}
