/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.mapping;

import java.util.Iterator;
import java.util.List;

import edu.duke.donaldLab.share.nmr.Assignment;
import edu.duke.donaldLab.share.nmr.ChemicalShift;
import edu.duke.donaldLab.share.nmr.DistanceRestraint;
import edu.duke.donaldLab.share.nmr.Rdc;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;
import edu.duke.donaldLab.share.protein.Protein;
import edu.duke.donaldLab.share.protein.AtomAddressReadable;

public enum NameScheme
{
	/**************************
	 *   Values
	 **************************/
	
	Old,
	New;
	
	
	/**************************
	 *   Static Methods
	 **************************/
	
	public static NameScheme getSchemeForProtein( Protein protein )
	{
		/* Jeff: 12/28/2008 - NOTE:
			Here's the simplest way I've found to tell the difference between
			files using the old names and the new names. If a file references
			an HN atom, it's using the old names. Otherwise, it's using the new
			names.
		*/
		
		Iterator<AtomAddressInternal> iterAddress = protein.getAtomIndex();
		while( iterAddress.hasNext() )
		{
			if( protein.getAtom( iterAddress.next() ).getName().equalsIgnoreCase( "HN" ) )
			{
				return Old;
			}
		}
		
		return New;
	}
	
	public static NameScheme getSchemeForDistanceRestraints( List<DistanceRestraint<AtomAddressReadable>> restraints )
	{
		for( DistanceRestraint<AtomAddressReadable> restraint : restraints )
		{
			for( Assignment<AtomAddressReadable> assignment : restraint )
			{
				if( assignment.getLeft().getAtomName().equalsIgnoreCase( "HN" ) )
				{
					return Old;
				}
				if( assignment.getRight().getAtomName().equalsIgnoreCase( "HN" ) )
				{
					return Old;
				}
			}
		}
		
		return New;
	}
	
	public static NameScheme getSchemeForShifts( List<ChemicalShift> shifts )
	{
		for( ChemicalShift shift : shifts )
		{
			for( AtomAddressReadable address : shift.getAddresses() )
			{
				if( address.getAtomName().equalsIgnoreCase( "HN" ) )
				{
					return Old;
				}
			}
		}
		
		return New;
	}

	public static NameScheme getSchemeForRdcs( List<Rdc<AtomAddressReadable>> rdcs )
	{
		for( Rdc<AtomAddressReadable> rdc : rdcs )
		{
			if( rdc.getFrom().getAtomName().equalsIgnoreCase( "HN" ) )
			{
				return Old;
			}
			if( rdc.getTo().getAtomName().equalsIgnoreCase( "HN" ) )
			{
				return Old;
			}
		}
		
		return New;
	}
}
