/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.math;

public class MultiIntersect
{
	/**************************
	 *   Static Methods
	 **************************/
	
	public static boolean isOverlapping( MultiSphere sphere, MultiAxisAlignedBox box )
	{
		return CompareReal.lte( getSquaredDistanceFromPointTo( sphere.center, box ), sphere.radius * sphere.radius );
	}
	
	public static double getSquaredDistanceFromPointTo( MultiVector p, MultiAxisAlignedBox box )
	{
		double val = 0.0;
		double dist = 0.0;
		double totalDistSq = 0.0;
		
		for( int i=0; i<p.getDimension(); i++ )
		{
			val = p.get( i );
			if( CompareReal.lte( val, box.min.get( i ) ) )
			{
				dist = val - box.min.get( i );
				totalDistSq += dist * dist;
			}
			else if( CompareReal.gte( val, box.max.get( i ) ) )
			{
				dist = val - box.max.get( i );
				totalDistSq += dist * dist;
			}
		}
		
		return totalDistSq;
	}
}
