/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.test.bond;

import java.util.ArrayList;
import java.util.HashMap;

import edu.duke.donaldLab.share.bond.Bond;
import edu.duke.donaldLab.share.bond.BondReader;
import edu.duke.donaldLab.share.bond.BondStrength;
import edu.duke.donaldLab.share.test.ExtendedTestCase;

public class TestBondReader extends ExtendedTestCase
{
	public void testRead( )
	throws Exception
	{
		BondReader reader = new BondReader();
		HashMap<String,ArrayList<Bond>> bonds = reader.read( "src/resources/backbone.bonds" );
		
		assertEquals( 3, bonds.keySet().size() );
		
		// check N terminus
		ArrayList<Bond> bondList = bonds.get( "NTerminus" );
		assertEquals( 8, bondList.size() );
		assertEquals( new Bond( "N", "H1", BondStrength.Single ), bondList.get( 0 ) );
		assertEquals( new Bond( "C", "O", BondStrength.Double ), bondList.get( 6 ) );
		assertEquals( new Bond( "C", "+N", BondStrength.Single ), bondList.get( 7 ) );
		
		// check non-teminal
		bondList = bonds.get( "NonTerminal" );
		assertEquals( 6, bondList.size() );
		assertEquals( new Bond( "N", "H", BondStrength.Single ), bondList.get( 0 ) );
		assertEquals( new Bond( "C", "O", BondStrength.Double ), bondList.get( 4 ) );
		assertEquals( new Bond( "C", "+N", BondStrength.Single ), bondList.get( 5 ) );
		
		// chekc C terminus
		bondList = bonds.get( "CTerminus" );
		assertEquals( 6, bondList.size() );
		assertEquals( new Bond( "N", "H", BondStrength.Single ), bondList.get( 0 ) );
		assertEquals( new Bond( "C", "O", BondStrength.Double ), bondList.get( 4 ) );
		assertEquals( new Bond( "C", "OXT", BondStrength.Single ), bondList.get( 5 ) );
	}
}
