/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.test.math;

import edu.duke.donaldLab.share.math.Distribution;
import edu.duke.donaldLab.share.test.ExtendedTestCase;

public class TestDistribution extends ExtendedTestCase
{
	public void testMin( )
	{
		Distribution d = new Distribution();
		
		d.add( 1.0 );
		assertEquals( 1.0, d.getMin() );
		d.add( 2.0 );
		assertEquals( 1.0, d.getMin() );
		d.add( 0.4 );
		assertEquals( 0.4, d.getMin() );
	}
	
	public void testMax( )
	{
		Distribution d = new Distribution();
		
		d.add( 1.0 );
		assertEquals( 1.0, d.getMax() );
		d.add( 0.4 );
		assertEquals( 1.0, d.getMax() );
		d.add( 2.0 );
		assertEquals( 2.0, d.getMax() );
	}
	
	public void testSum( )
	{
		Distribution d = new Distribution();
		
		assertEquals( 0.0, d.getSum() );
		d.add( 1.0 );
		assertEquals( 1.0, d.getSum() );
		d.add( 2.0 );
		assertEquals( 3.0, d.getSum() );
		d.add( 3.0 );
		assertEquals( 6.0, d.getSum() );
	}
	
	public void testCount( )
	{
		Distribution d = new Distribution();
		
		assertEquals( 0, d.getCount() );
		d.add( 1.0 );
		assertEquals( 1, d.getCount() );
		d.add( 1.0 );
		assertEquals( 2, d.getCount() );
	}
	
	public void testMean( )
	{
		Distribution d = new Distribution();
		
		d.add( 10.0 );
		assertEquals( 10.0, d.getMean() );
		d.add( 10.0 );
		assertEquals( 10.0, d.getMean() );
		d.add( 40.0 );
		assertEquals( 20.0, d.getMean() );
		d.add( 40.0 );
		assertEquals( 25.0, d.getMean() );
	}
}
