/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.test.protein;

import edu.duke.donaldLab.share.protein.AtomAddressInternal;
import edu.duke.donaldLab.share.protein.AtomAddressResidueAtom;
import edu.duke.donaldLab.share.test.ExtendedTestCase;

public class TestAtomAddressResidueAtom extends ExtendedTestCase
{
	public void testConstructor( )
	{
		AtomAddressInternal address = new AtomAddressInternal( 1, 2, 3 );
		AtomAddressResidueAtom wrapper = new AtomAddressResidueAtom( address );
		
		assertEquals( address, wrapper );
		assertEquals( address, wrapper.getAtomAddress() );
	}
	
	public void testEquals( )
	{
		assertTrue( newAddress( 1, 2, 3 ).equals( newAddress( 1, 2, 3 ) ) );
		assertTrue( newAddress( 1, 2, 3 ).equals( newAddress( 2, 2, 3 ) ) );
		assertTrue( newAddress( 2, 2, 3 ).equals( newAddress( 1, 2, 3 ) ) );
		
		assertFalse( newAddress( 1, 2, 3 ).equals( newAddress( 1, 3, 3 ) ) );
		assertFalse( newAddress( 1, 2, 3 ).equals( newAddress( 2, 3, 3 ) ) );
		assertFalse( newAddress( 1, 2, 3 ).equals( newAddress( 1, 2, 4 ) ) );
		assertFalse( newAddress( 1, 2, 3 ).equals( newAddress( 2, 2, 4 ) ) );
	}
	
	public void testHashCode( )
	{
		assertTrue( newAddress( 1, 2, 3 ).hashCode() == newAddress( 1, 2, 3 ).hashCode() );
		assertTrue( newAddress( 1, 2, 3 ).hashCode() == newAddress( 2, 2, 3 ).hashCode() );
		
		assertFalse( newAddress( 1, 2, 3 ).hashCode() == newAddress( 1, 3, 3 ).hashCode() );
		assertFalse( newAddress( 1, 2, 3 ).hashCode() == newAddress( 2, 3, 3 ).hashCode() );
		assertFalse( newAddress( 1, 2, 3 ).hashCode() == newAddress( 1, 2, 4 ).hashCode() );
		assertFalse( newAddress( 1, 2, 3 ).hashCode() == newAddress( 2, 2, 4 ).hashCode() );
	}
	
	private AtomAddressResidueAtom newAddress( int subunitId, int residueId, int atomId )
	{
		return new AtomAddressResidueAtom( new AtomAddressInternal( subunitId, residueId, atomId ) );
	}
}
