/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


#ifndef GLOBAL_H_
#define GLOBAL_H_

// NOTE: we need two functions here to expand argument macros correctly
#define CLASSFN2( c, fn )		c##_##fn
#define CLASSFN( c, fn )		CLASSFN2( c, fn )

#define CGALCLASS( name )		"edu/duke/donaldLab/jdshot/disco/cgal/" name
#define GEOMCLASS( name )		"edu/duke/donaldLab/share/geom/" name

#define SAFE_DELETE( p )	{ if( (p) != NULL ) { delete (p); (p) = NULL; } }

// signal handling to give code an escape hatch back to Java
#define START_SIGNAL_HANDLING	try
#define STOP_SIGNAL_HANDLING	catch( AbortSignal s ) { s.doNothing(); }
class AbortSignal { public: void doNothing( ) { } };
extern AbortSignal g_abortSignal;

// global funcs
void checkException( JNIEnv *jvm );
void throwException( JNIEnv *jvm, const char *message );
void throwIllegalArgumentException( JNIEnv *jvm, const char *message );
int getId( JNIEnv *jvm, jobject self );
void setId( JNIEnv *jvm, jobject self, int id );
void *getPointer( JNIEnv *jvm, jobject self );
void setPointer( JNIEnv *jvm, jobject self, void *p );
jobject newVector2( JNIEnv *jvm, double x, double y );


#endif /* GLOBAL_H_ */
