/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


#ifndef TYPES_H_
#define TYPES_H_


// getters
Arrangement *getArrangement( JNIEnv *, jobject );
Circle_2 *getCircle( JNIEnv *, jobject );
Circular_k_root::Circle_2 *getCircleRoot( JNIEnv *, jobject );
Arrangement::Face *getFace( JNIEnv *, jobject );
Arrangement::Halfedge *getHalfedge( JNIEnv *, jobject );
Arrangement::Vertex *getVertex( JNIEnv *, jobject );
Bbox_2 *getBox( JNIEnv *, jobject );
Arrangement::Ccb_halfedge_circulator *getHole( JNIEnv *jvm, jobject self );

// constructors
jobject newCircle( JNIEnv *, const Circle_2 & );
jobject newFace( JNIEnv *, Arrangement::Face * );
jobject newHalfedge( JNIEnv *, Arrangement::Halfedge * );
jobject newVertex( JNIEnv *, Arrangement::Vertex * );
jobject newBox( JNIEnv *, const Bbox_2 & );
jobject newHole( JNIEnv *jvm, const Arrangement::Ccb_halfedge_circulator &circ );


#endif /* TYPES_H_ */
