#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


def parseLine( line ):
	
	line = line.strip()
	
	# split the line up by tabs
	parts = line.split( "\t" )
	index = 0
	
	# get the number of lefts
	numLefts = int( parts[index] )
	index += 1
	
	# get the lefts
	lefts = []
	for i in range( 0, numLefts ):
		lefts.append( "%s,%s,%s" % ( parts[index], parts[index+1], parts[index+2] ) )
		index += 3
		
	# get the number of rights
	numRights = int( parts[index] )
	index += 1
	
	# get the rights
	rights = []
	for i in range( 0, numRights ):
		rights.append( "%s,%s,%s" % ( parts[index], parts[index+1], parts[index+2] ) )
		index += 3
	
	min = parts[index]
	index += 1
	max = parts[index]
	index += 1
	
	return ( lefts, rights, min, max )


def checkSide( original, reassigned ):
	
	for atom in original:
		found = False
		for search in reassigned:
			if search == atom:
				found = True
				break
		
		if not found:
			print "Atom not found! %s" % atom



pathOriginal = "/home/jeff/duke/donaldLab/noe+rdc/results/GB1/normal/1Q10-restraints.txt"
pathReassigned = "/home/jeff/duke/donaldLab/noe+rdc/results/GB1/reassigned/1Q10-restraints.txt"

fileOriginal = open( pathOriginal )
fileReassigned = open( pathReassigned )

while True:
	
	# read the lines
	lineOriginal = fileOriginal.readline()
	lineReassigned = fileReassigned.readline()
	
	# are we out of lines yet?
	originalIsDone = lineOriginal == ""
	reassignedIsDone = lineReassigned == ""
	if originalIsDone != reassignedIsDone:
		print "Number of lines mismatch!"
		break
	elif originalIsDone and reassignedIsDone:
		break
	
	# parse the lines
	partsOriginal = parseLine( lineOriginal )
	partsReassigned = parseLine( lineReassigned )
	
	# check for the left
	checkSide( partsOriginal[0], partsReassigned[0] )
	checkSide( partsOriginal[1], partsReassigned[1] )
	if partsOriginal[2] != partsReassigned[2]:
		print "min not same!"
	if partsOriginal[3] != partsReassigned[3]:
		print "max not same!"

print "Done!"
