#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import share
import jpype

share.getJvm().start()

def run( pathOligomer, pathDistanceRestraints, padPercent ):
	
	# load the protein
	oligomer = share.loadProtein( pathOligomer )
	
	# load the restraints
	restraintsReadable = share.loadDistanceRestraints( pathDistanceRestraints )
	restraints = share.interpretDistanceRestraintsWithPseudoatoms( restraintsReadable, oligomer )
	restraints = share.mapDistanceRestraintsToProtein( restraintsReadable, oligomer )
	restraints = share.filterRestraintsIntersubunit( restraints )
	
	# pad the distances if needed
	if padPercent > 0:
		share.padRestraints( restraints, padPercent )
	
	restraintCalculator = share.f.analysis.RestraintCalculator()
	
	# list the violations
	numViolations = 0
	for restraint in restraints:
		violation = restraintCalculator.getViolation( oligomer, restraint );
		if violation > 0:
			numViolations += 1
			restraintReadable = share.f.nmr.DistanceRestraintMapper.mapInternalToReadable( restraint, oligomer )
			assignString = share.f.nmr.DistanceRestraintWriter().writeToString( restraintReadable )
			print "\tViolation: %f\t%s" % ( violation, assignString )
	print "Found %d/%d violations." % ( numViolations, restraints.size() )
	print "Number Satisfied: %d" % restraintCalculator.getNumSatisfied( oligomer, restraints )
	print "NOE RMSD: %f" % restraintCalculator.getRmsd( oligomer, restraints )

dirInput = "/home/jeff/duke/donaldLab/dshot/input"
dirResults = "/home/jeff/duke/donaldLab/noe+rdc/results"

# DAGK
#dirResultsDagk = dirResults + "/DAGK/annuli/padding=3%"
#run(
#	dirInput + "/2KDC.oligomer.protein",
#	#dirResultsDagk + "/stage1/inconsistent.disulfideBonds.noe"
#	dirInput + "/2KDC.experimental.onlyDisulfideBonds.noe",
#	0.03
#)

# GB1
dirResultsGb1 = dirResults + "/GB1/normal"
run(
	dirInput + "/1Q10.oligomer.protein",
	dirInput + "/1Q10.experimental.fixed.noe",
	0.0
)
