#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


import jvm, jdshot, share, jpype

jdshot.getJvm().start()

SubunitOrder = share.f.protein.SubunitOrder
PseudoatomBuilder = share.f.pseudoatoms.PseudoatomBuilder


def run( pdbOutPath, workDir, pdbInPath, pathInDistanceRestraints ):
	
	# load the inputs
	protein = share.loadProtein( pdbInPath )
	share.f.pseudoatoms.PseudoatomBuilder.getInstance().build( protein )
	distanceRestraints = share.loadDistanceRestraints( jvm.newFile( pathInDistanceRestraints ) )
	share.interpretDistanceRestraintsWithPseudoatoms( distanceRestraints, protein )
	
	# minimize it!
	jdshot.minimizeStructure(
		pdbOutPath,
		jvm.newFile( workDir ),
		distanceRestraints,
		protein
	)


dirResults = "/home/jeff/duke/donaldLab/workspace/jdshot/output"
dirInput = "/home/jeff/duke/donaldLab/dshot/input"
dirWork = "/home/jeff/duke/donaldLab/workspace/jdshot/work"

try:

	# GB1
#	dirResultsGB1 = dirResults + "/gb1/minimized" 
#	run(
#		dirResultsGB1 + "/minimizedReference.pdb",
#		dirWork,
#		dirInput + "/1Q10.oligomer.protein",
#		dirInput + "/1Q10.experimental.fixed.noe"
#	)
	
	# DAGK
	dirResultsDAGK = dirResults + "/dagk/minimized" 
	run(
		dirResultsDAGK + "/minimizedReferenceSubunit.pdb",
		dirWork,
		dirInput + "/2KDC.oligomer.protein",
		dirInput + "/2KDC.experimental.onlyDisulfideBonds.noe"
	)

	
except jpype.JavaException as ex:
	import sys
	print >> sys.stderr, "Java Exception: %s\n" % ex
	print >> sys.stderr, ex.stacktrace()
	raise
