/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot;

import java.io.File;

import edu.duke.donaldLab.jdshot.grid.Symmetry;
import edu.duke.donaldLab.share.io.ArgumentType;
import edu.duke.donaldLab.share.io.ArgumentsProcessor;

@SuppressWarnings( "unused" )
public class DistributedClustererMain
{
	/**************************
	 *   Static Methods
	 **************************/
	
	public static void main( String[] args )
	throws Exception
	{
		// process the arguments
		ArgumentsProcessor argproc = new ArgumentsProcessor();
		argproc.add( "alertPath", ArgumentType.OutFile, "path to output alert log" );
		argproc.add( "symmetry", ArgumentType.String, "symmetry type (e.g., Cn, Dn)" );
		argproc.add( "outPointsPath", ArgumentType.OutFile, "path to the output clutered points" );
		argproc.add( "inPath", ArgumentType.InFile, "path to input points/cells" );
		argproc.add( "inMatrixPath", ArgumentType.InFile, "path to distance matrix" );
		argproc.add( "minRmsd", ArgumentType.Double, "minimum RMSD between clusters" );
		argproc.process( args );
		
		// read in arguments
		File alertFile = argproc.getFile( "alertPath" );
		Symmetry symmetry = Symmetry.valueOf( argproc.getString( "symmetry" ) );
		File outPointsFile = argproc.getFile( "outPointsPath" );
		File inFile = argproc.getFile( "inPath" );
		File inMatrixFile = argproc.getFile( "inMatrixPath" );
		Double minRmsd = argproc.getDouble( "minRmsd" );
		
		// TEMP
		System.out.println( "Not implemented!" );
	}
}
