/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.grid;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CellIterator implements Iterator<GridCell>
{
	/**************************
	 *   Definitions
	 **************************/
	
	private enum Mode
	{
		Array,
		List,
		Reader
	}
	
	
	/**************************
	 *   Data Members
	 **************************/
	
	private Mode m_mode;
	private CellReader m_reader;
	private GridCell[] m_array;
	private List<? extends GridCell> m_list;
	private int m_index;
	private int m_numServed;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public CellIterator( GridCell[] cells )
	{
		m_mode = Mode.Array;
		m_array = cells;
		m_list = null;
		m_reader = null;
		m_index = 0;
		m_numServed = 0;
	}
	
	public CellIterator( List<? extends GridCell> cells )
	{
		m_mode = Mode.List;
		m_array = null;
		m_list = cells;
		m_reader = null;
		m_numServed = 0;
	}
	
	public CellIterator( CellReader reader )
	{
		m_mode = Mode.Reader;
		m_array = null;
		m_list = null;
		m_reader = reader;
		m_index = 0;
		m_numServed = 0;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public boolean hasNext( )
	{
		switch( m_mode )
		{
			case Array: return m_index < m_array.length;
			case List: return m_index < m_list.size();
			case Reader: return m_reader.hasNext();
		}
		
		assert( false ) : "CellIterator: Invalid mode!";

		// just to make the compiler happy
		return false;
	}
	
	public GridCell next( )
	{
		try
		{
			m_numServed++;
			
			switch( m_mode )
			{
				case Array: return m_array[m_index++];
				case List: return m_list.get( m_index++ );
				case Reader: return m_reader.readCell();
			}
		}
		catch( IOException ex )
		{
			m_numServed--;
			System.err.println( "WARNING: CellIterator.next() caught IOException!" );
			return null;
		}
				
		assert( false ) : "CellIterator: Invalid mode!";
		
		// just to make the compiler happy
		return null;
	}
	
	public void remove( )
	{
		throw new UnsupportedOperationException();
	}
	
	public int getNumServed( )
	{
		return m_numServed;
	}
	
	public long getNumCells( )
	{
		switch( m_mode )
		{
			case Array: return m_array.length;
			case List: return m_list.size();
			case Reader: return m_reader.getNumCells();
		}
		
		assert( false ) : "CellIterator: Invalid mode!";
		
		// just to make the compiler happy
		return -1;
	}
}
