/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.grid;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class PointReader
{
	/**************************
	 *   Data Members
	 **************************/
	
	private DataInputStream m_in;
	private long m_numPoints;
	private long m_numPointsRead;
	private Symmetry m_symmetry;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public PointReader( String path, Symmetry symmetry )
	throws IOException
	{
		this( new File( path ), symmetry );
	}
	
	public PointReader( File file, Symmetry symmetry )
	throws IOException
	{
		// save parameters
		m_symmetry = symmetry;
		
		// this is kind of a hack, but determine the number of cells by looking at how big the file is
		long fileLen = file.length();
		int bytesPerPoint = m_symmetry.getNumDimensions() * 8;
		assert( fileLen % bytesPerPoint == 0 );
		m_numPoints = fileLen / bytesPerPoint;
		
		// open the file for reading
		m_in = new DataInputStream( new BufferedInputStream( new FileInputStream( file ) ) );
		
		m_numPointsRead = 0;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public long getNumPoints( )
	{
		return m_numPoints;
	}
	
	public long getNumPointsRead( )
	{
		return m_numPointsRead;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public GridPoint readPoint( )
	throws IOException
	{
		GridPoint point = m_symmetry.newGridPoint();
		for( int i=0; i<m_symmetry.getNumDimensions(); i++ )
		{
			point.set( i, m_in.readDouble() );
		}
		
		m_numPointsRead++;
		
		return point;
	}
	
	public boolean hasNext( )
	{
		return m_numPointsRead < m_numPoints;
	}
	
	public void close( )
	throws IOException
	{
		m_in.close();
		m_in = null;
	}
}
