/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share;

import junit.framework.TestSuite;
import junit.textui.TestRunner;

import edu.duke.donaldLab.share.test.bond.*;
import edu.duke.donaldLab.share.test.clustering.*;
import edu.duke.donaldLab.share.test.dataStructures.*;
import edu.duke.donaldLab.share.test.math.*;
import edu.duke.donaldLab.share.test.nmr.*;
import edu.duke.donaldLab.share.test.protein.*;
import edu.duke.donaldLab.share.test.pdb.*;
import edu.duke.donaldLab.share.test.geom.*;
import edu.duke.donaldLab.share.test.analysis.*;
import edu.duke.donaldLab.share.test.atomType.*;
import edu.duke.donaldLab.share.test.util.*;
import edu.duke.donaldLab.share.test.mapping.*;
import edu.duke.donaldLab.share.test.pseudoatoms.*;

public class TestMain extends TestSuite
{
	public static void main( String[] args )
	{
		// start the tests
		System.out.println( "Testing starting..." );
		TestRunner.run( getSuite() );
		System.out.println( "Testing complete!" );
	}
	
	public static TestSuite getSuite( )
	{
		TestSuite suite = new TestSuite();
		
		// Jeff: 5/14/2008 - if we could automate this using reflection, that would be cool
		
		// math package
		suite.addTestSuite( TestCompareReal.class );
		suite.addTestSuite( TestMatrix4.class );
		suite.addTestSuite( TestMatrix3.class );
		suite.addTestSuite( TestPointIterator.class );
		suite.addTestSuite( TestDistribution.class );
		suite.addTestSuite( TestMultiVector.class );
		suite.addTestSuite( TestMultiVectorComparator.class );
		suite.addTestSuite( TestQuaternion.class );
		suite.addTestSuite( TestIndexPairIterator.class );
		
		// geom package
		suite.addTestSuite( TestVector.class );
		suite.addTestSuite( TestSphere.class );
		suite.addTestSuite( TestWelzlSphereSolver.class );
		suite.addTestSuite( TestAxisAlignedBox.class );
		suite.addTestSuite( TestOrientedBox.class );
		suite.addTestSuite( TestIntersect.class );
		
		// protein package
		suite.addTestSuite( TestCopyConstructors.class );
		suite.addTestSuite( TestAtomAddress.class );
		suite.addTestSuite( TestAtomAddressResidueAtom.class );
		suite.addTestSuite( TestReadableAtomAddress.class );
		suite.addTestSuite( TestSubunitOrder.class );
		suite.addTestSuite( TestProtein.class );
		
		// pdb package
		suite.addTestSuite( TestProteinReader.class );
		suite.addTestSuite( TestProteinWriter.class );
		
		// nmr package
		suite.addTestSuite( TestDistanceRestraint.class );
		suite.addTestSuite( TestDistanceRestraintResidueAtom.class );
		suite.addTestSuite( TestDistanceRestraintReader.class );
		suite.addTestSuite( TestDistanceRestraintMapper.class );
		suite.addTestSuite( TestAssignmentIterator.class );
		suite.addTestSuite( TestAssignReader.class );
		suite.addTestSuite( TestDistanceRestraintFilterer.class );
		suite.addTestSuite( TestChemicalShiftReader.class );
		suite.addTestSuite( TestChemicalShiftMapper.class );
		suite.addTestSuite( TestDistanceRestraintReassigner.class );
		suite.addTestSuite( TestRdcReader.class );
		suite.addTestSuite( TestAlignmentTensor.class );
		
		// bond package
		suite.addTestSuite( TestBond.class );
		suite.addTestSuite( TestBondStrength.class );
		suite.addTestSuite( TestBondGraph.class );
		suite.addTestSuite( TestBondReader.class );
		suite.addTestSuite( TestBondGraphBuilder.class );
		suite.addTestSuite( TestBreadthFirstIterator.class );
		suite.addTestSuite( TestBackboneAtomAddresserPairIterator.class );
		suite.addTestSuite( TestBreadthFirstBondIterator.class );
		
		// clustering package
		suite.addTestSuite( TestKDTree.class );
		suite.addTestSuite( TestKDTreeClusterIterator.class );
		suite.addTestSuite( TestClusterer.class );
		suite.addTestSuite( TestCluster.class );
		suite.addTestSuite( TestDistanceMatrix.class );
		suite.addTestSuite( TestDistanceCluster.class );
		suite.addTestSuite( TestDistanceClusterIterator.class );
		
		// atom types package
		suite.addTestSuite( TestAtomTypeReader.class );
		suite.addTestSuite( TestAtomTypeMap.class );
		
		// utilities package
		suite.addTestSuite( TestChainedIterator.class );
		
		// mapping package
		suite.addTestSuite( TestNameMapper.class );
		suite.addTestSuite( TestAddressMapper.class );
		
		// pseudoatom package
		suite.addTestSuite( TestPseudoatomReader.class );
		suite.addTestSuite( TestPseudoatomBuilder.class );
		suite.addTestSuite( TestNoeInterpretation.class );
		
		// data structures package
		suite.addTestSuite( TestMinHeap.class );
		
		// analysis
		suite.addTestSuite( TestVarianceCalculator.class );
		
		return suite;
	}
}
