/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.math;

import Jama.EigenvalueDecomposition;
import edu.duke.donaldLab.share.geom.Vector3;

public class EigPair implements Comparable<EigPair>
{
	/**************************
	 *   Data Members
	 **************************/
	
	private EigenvalueDecomposition m_eig;
	private int m_index;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public EigPair( EigenvalueDecomposition eig, int index )
	{
		m_eig = eig;
		m_index = index;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public double getEigenvalue( )
	{
		return m_eig.getD().get( m_index, m_index );
	}
	
	public Vector3 getEigenvector( )
	{
		Vector3 v = new Vector3(
			m_eig.getV().get( 0, m_index ),
			m_eig.getV().get( 1, m_index ),
			m_eig.getV().get( 2, m_index )
		);
		v.normalize();
		return v;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	@Override
	public int compareTo( EigPair other )
	{
		return Double.compare( Math.abs( getEigenvalue() ), Math.abs( other.getEigenvalue() ) );
	}
	
	@Override
	public String toString( )
	{
		return "" + getEigenvalue() + ", " + getEigenvector().toString();  
	}
}
