/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.test.clustering;

import java.util.LinkedList;

import edu.duke.donaldLab.share.clustering.distance.DistanceCluster;
import edu.duke.donaldLab.share.clustering.distance.DistanceMatrix;
import edu.duke.donaldLab.share.test.ExtendedTestCase;

public class TestDistanceCluster extends ExtendedTestCase
{
	public void testJoinLinkageChainTwo( )
	{
		DistanceMatrix distances = new DistanceMatrix( 2 );
		LinkedList<DistanceCluster> clusters = new LinkedList<DistanceCluster>();
		DistanceCluster a = new DistanceCluster( 0 );
		DistanceCluster b = new DistanceCluster( 1 );
		
		a.join( b, distances, clusters );
		
		assertSame( b, a.getChild() );
		assertNull( b.getChild() );
	}
	
	public void testJoinLinkageChainFour( )
	{
		DistanceMatrix distances = new DistanceMatrix( 4 );
		LinkedList<DistanceCluster> clusters = new LinkedList<DistanceCluster>();
		DistanceCluster a = new DistanceCluster( 0 );
		DistanceCluster b = new DistanceCluster( 1 );
		DistanceCluster c = new DistanceCluster( 2 );
		DistanceCluster d = new DistanceCluster( 3 );
		
		a.join( b, distances, clusters );
		a.join( c, distances, clusters );
		a.join( d, distances, clusters );
		
		assertSame( b, a.getChild() );
		assertSame( c, b.getChild() );
		assertSame( d, c.getChild() );
		assertNull( d.getChild() );
	}
	
	public void testJoinLinkageTreeFour( )
	{
		DistanceMatrix distances = new DistanceMatrix( 4 );
		LinkedList<DistanceCluster> clusters = new LinkedList<DistanceCluster>();
		DistanceCluster a = new DistanceCluster( 0 );
		DistanceCluster b = new DistanceCluster( 1 );
		DistanceCluster c = new DistanceCluster( 2 );
		DistanceCluster d = new DistanceCluster( 3 );
		
		a.join( b, distances, clusters );
		c.join( d, distances, clusters );
		a.join( c, distances, clusters );
		
		assertSame( b, a.getChild() );
		assertSame( c, b.getChild() );
		assertSame( d, c.getChild() );
		assertNull( d.getChild() );
	}
	
	public void testJoinLinkageBig( )
	{
		DistanceMatrix distances = new DistanceMatrix( 8 );
		LinkedList<DistanceCluster> clusters = new LinkedList<DistanceCluster>();
		DistanceCluster a = new DistanceCluster( 0 );
		DistanceCluster b = new DistanceCluster( 1 );
		DistanceCluster c = new DistanceCluster( 2 );
		DistanceCluster d = new DistanceCluster( 3 );
		DistanceCluster e = new DistanceCluster( 4 );
		DistanceCluster f = new DistanceCluster( 5 );
		DistanceCluster g = new DistanceCluster( 6 );
		DistanceCluster h = new DistanceCluster( 7 );
		
		g.join( h, distances, clusters );
		f.join( g, distances, clusters );
		e.join( f, distances, clusters );
		
		a.join( b, distances, clusters );
		c.join( d, distances, clusters );
		a.join( c, distances, clusters );
		
		a.join( e, distances, clusters );
		
		assertSame( b, a.getChild() );
		assertSame( c, b.getChild() );
		assertSame( d, c.getChild() );
		assertSame( e, d.getChild() );
		assertSame( f, e.getChild() );
		assertSame( g, f.getChild() );
		assertSame( h, g.getChild() );
		assertNull( h.getChild() );
	}
	
	public void testGetRepresentativeIndex( )
	{
		// need distances for this one
		DistanceMatrix distances = new DistanceMatrix( 4 );
		distances.set( 1, 0, 10.0 );
		distances.set( 2, 0, 2.0 );
		distances.set( 2, 1, 3.0 );
		distances.set( 3, 0, 4.0 );
		distances.set( 3, 1, 5.0 );
		distances.set( 3, 2, 6.0 );
		
		// just make a chain
		DistanceCluster a = new DistanceCluster( 0 );
		DistanceCluster b = new DistanceCluster( 1 );
		DistanceCluster c = new DistanceCluster( 2 );
		DistanceCluster d = new DistanceCluster( 3 );
		LinkedList<DistanceCluster> clusters = new LinkedList<DistanceCluster>();
		a.join( b, distances, clusters );
		a.join( c, distances, clusters );
		a.join( d, distances, clusters );
		
		int index = a.getReprepresentativeIndex( distances );
		assertEquals( 2, index );
	}
}
