/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


#include <jni.h>

#include "cgal.h"
#include "shotCgal.h"
#include "global.h"
#include "types.h"
#include "Storage.h"


#define CLASS                    Java_edu_duke_donaldLab_jdshot_disco_cgal_Hole
#define Hole_cleanup             CLASSFN( CLASS, cleanup )


static Storage<Arrangement::Ccb_halfedge_circulator> g_holes( CGALCLASS( "Hole" ), true );


void holesCleanup( JNIEnv *jvm )
{
	g_holes.cleanupAll( jvm );
}

Arrangement::Ccb_halfedge_circulator *getHole( JNIEnv *jvm, jobject self )
{
	return g_holes.get( jvm, self );
}

jobject newHole( JNIEnv *jvm, const Arrangement::Ccb_halfedge_circulator &circ )
{
	return g_holes.addNew( jvm, new Arrangement::Ccb_halfedge_circulator( circ ) );
}

JNIEXPORT void JNICALL Hole_cleanup( JNIEnv *jvm, jclass c, jint id )
{
	START_SIGNAL_HANDLING
	{
		if( !g_holes.cleanup( id ) )
		{
			throwException( jvm, "Hole cleanup failure!" );
		}
	}
	STOP_SIGNAL_HANDLING
}
