/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


#ifndef CGAL_H_
#define CGAL_H_

#include <CGAL/Cartesian.h>
#include <CGAL/point_generators_2.h>
#include <CGAL/MP_Float.h>
#include <CGAL/Algebraic_kernel_for_circles_2_2.h>
#include <CGAL/Circular_kernel_2.h>
#include <CGAL/Arr_circular_arc_traits_2.h>
#include <CGAL/Arr_extended_dcel.h>
#include <CGAL/Arrangement_2.h>

// for the arrangement (using quotient/float kernel)
typedef CGAL::Quotient<CGAL::MP_Float> FloatQuotient;
typedef CGAL::Cartesian<FloatQuotient> Linear_k;
typedef CGAL::Algebraic_kernel_for_circles_2_2<FloatQuotient> Algebraic_k;
typedef CGAL::Circular_kernel_2<Linear_k,Algebraic_k> Circular_k;
typedef Circular_k::Point_2 Point_2;
typedef Circular_k::Circle_2 Circle_2;
typedef Circular_k::Circular_arc_2 Circular_arc_2;
typedef Circular_k::Line_2 Line_2;
typedef CGAL::Bbox_2 Bbox_2;
typedef CGAL::Arr_circular_arc_traits_2<Circular_k> Traits;
typedef CGAL::Arr_face_extended_dcel<Traits, int> Dcel;
typedef CGAL::Arrangement_2<Traits,Dcel> Arrangement;

// for Root of 2 circles
typedef CGAL::Root_of_2<CGAL::MP_Float> FloatRoot;
typedef	CGAL::Cartesian<FloatRoot> Linear_k_root;
typedef CGAL::Algebraic_kernel_for_circles_2_2<FloatRoot> Algebraic_k_root;
typedef CGAL::Circular_kernel_2<Linear_k_root,Algebraic_k_root> Circular_k_root;

#endif /* CGAL_H_ */
