#-------------------------------------------------------------------------------
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
# 
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
# 
# Contact Info:
# 	Bruce Donald
# 	Duke University
# 	Department of Computer Science
# 	Levine Science Research Center (LSRC)
# 	Durham
# 	NC 27708-0129 
# 	USA
# 	brd@cs.duke.edu
# 
# Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
# 
# <signature of Bruce Donald>, April 2011
# Bruce Donald, Professor of Computer Science
#-------------------------------------------------------------------------------


def run( pathOutConsistentNOEs, pathOutInconsistentNOEs, pathInViolations, pathInNOEs ):
	
	# read the numbers from the file into an array
	violationLines = []
	for line in open( pathInViolations ):
		
		# skip blank lines
		line = line.strip()
		if line == "":
			continue;
		
		# parse the violation
		parts = line.split( "\t" )
		violationLines.append( int( parts[0] ) )
		
	print "Read %d violations from:\n\t%s" % ( len( violationLines ), pathInViolations )
	
	# open the the outfiles for writing
	fileConsistent = open( pathOutConsistentNOEs, "w" )
	fileInconsistent = open( pathOutInconsistentNOEs, "w" )
	
	# split the two files
	lineIndex = 0
	violationIndex = 0
	numConsistentWritten = 0
	numInconsistentWritten = 0
	for line in open( pathInNOEs ):
		
		# skip blank lines
		line = line.strip()
		if line == "":
			continue;
		
		# take only the comment
		line = line.split( "#" )[1]
		
		lineIndex += 1
		if violationIndex < len( violationLines ) and lineIndex == violationLines[violationIndex]:
			fileInconsistent.write( line + "\n" )
			violationIndex += 1
			numInconsistentWritten += 1
		else:
			fileConsistent.write( line + "\n" )
			numConsistentWritten += 1
	
	print "Read %d restraints from:\n\t%s" % ( lineIndex, pathInNOEs )
	print "Wrote %d consistent restraints to:\n\t%s" % ( numConsistentWritten, pathOutConsistentNOEs )
	print "Wrote %d inconsistent restraints to:\n\t%s" % ( numInconsistentWritten, pathOutInconsistentNOEs )
	
	# cleanup
	fileConsistent.close()
	fileInconsistent.close()


if __name__ == "__main__":
	
	# DAGK
#	dirResults = "/home/jeff/duke/donaldLab/noe+rdc/results/DAGK/trustedDisulfideBonds"
#	run(
#		dirResults + "/consistent.noe",
#		dirResults + "/inconsistent.noe",
#		dirResults + "/untrustedViolations.txt",
#		dirResults + "/2KDC-restraints.txt"
#	)
	
	# GB1
	dirResults = "/home/jeff/duke/donaldLab/noe+rdc/results/GB1/normal"
	run(
		dirResults + "/consistent.noe",
		dirResults + "/inconsistent.noe",
		dirResults + "/violations.txt",
		dirResults + "/1Q10-restraints.txt"
	)
