/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import edu.duke.donaldLab.jdshot.disco.AnnulusIndex;
import edu.duke.donaldLab.jdshot.disco.FaceInfo;
import edu.duke.donaldLab.jdshot.disco.PositionCalculator;
import edu.duke.donaldLab.jdshot.disco.ResultsReader;
import edu.duke.donaldLab.jdshot.disco.ResultsWriter;
import edu.duke.donaldLab.jdshot.disco.cgal.Arrangement;
import edu.duke.donaldLab.share.io.ArgumentType;
import edu.duke.donaldLab.share.io.ArgumentsProcessor;
import edu.duke.donaldLab.share.io.Logging;

public class DiscoMsrMain
{
	public static void main( String[] args )
	throws Exception
	{
		Logging.Normal.init();
		
		// process the arguments
		ArgumentsProcessor argproc = new ArgumentsProcessor();
		argproc.add( "msrsPath", ArgumentType.OutFile, "path to MSRs file to write" );
		argproc.add( "annulusIndicesPath", ArgumentType.InFile, "path to the list of annulus indices" );
		argproc.add( "orientationId", ArgumentType.Integer, "id of orientaiton to use" );
		argproc.add( "untrustedAnnulusIndicesPath", ArgumentType.InFile, "u", null, "path to the list of untrusted annulus indices" );
		argproc.process( args );
		
		// read the arguments
		File fileMsrs = argproc.getFile( "msrsPath" );
		File fileAnnulusIndices = argproc.getFile( "annulusIndicesPath" );
		File fileUntrustedAnnulusIndices = argproc.getFile( "untrustedAnnulusIndicesPath" );
		Integer orientationId = argproc.getInteger( "orientationId" );
		
		ResultsReader resultsReader = new ResultsReader();
		List<AnnulusIndex> indices = new ArrayList<AnnulusIndex>();
		
		// read the trusted annulus index
		indices.add( resultsReader.readAnnulusIndices( fileAnnulusIndices ).get( orientationId ) );
		
		// read the untrusted annulus index if needed
		if( fileUntrustedAnnulusIndices != null )
		{
			indices.add( resultsReader.readAnnulusIndices( fileUntrustedAnnulusIndices ).get( orientationId ) );
		}
		
		// compute the arrangement and MSRs
		Arrangement arrangement = PositionCalculator.computeArrangementIncremental( indices );
		List<FaceInfo> msrs = PositionCalculator.computeMsrs( arrangement, indices );
		new ResultsWriter().writeMsrs( fileMsrs, msrs );
	}
}
