/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.cluster;

import java.util.Iterator;

import edu.duke.donaldLab.share.clustering.distance.DistanceMatrix;
import edu.duke.donaldLab.share.math.IndexPair;
import edu.duke.donaldLab.share.math.IndexPairIterator;
import edu.duke.donaldLab.share.perf.Progress;

public class DistanceSynchronizer
{
	/**************************
	 *   Data Members
	 **************************/
	
	private Progress m_progress;
	private DistanceMatrix m_distances;
	private Iterator<IndexPair> m_iter;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public DistanceSynchronizer( Progress progress, DistanceMatrix distances )
	{
		// save parameters
		m_progress = progress;
		m_distances = distances;
		
		// init defaults
		m_iter = new IndexPairIterator( distances.getNumPoints() );
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public synchronized int getBatch( IndexPair[] pairs, int batchSize )
	{
		int numInBatch = 0;
		for( int i=0; i<batchSize; i++ )
		{
			if( m_iter.hasNext() )
			{
				pairs[numInBatch++] = m_iter.next();
			}
		}
		return numInBatch;
	}
	
	public synchronized void reportBatch( IndexPair[] pairs, double[] rmsds, int batchSize )
	{
		for( int i=0; i<batchSize; i++ )
		{
			m_distances.set( pairs[i], rmsds[i] );
		}
		
		m_progress.incrementProgress( batchSize );
	}
}
