/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.compute;

import java.util.Iterator;

import edu.duke.donaldLab.share.protein.AtomAddressInternal;
import edu.duke.donaldLab.share.protein.Protein;
import edu.duke.donaldLab.share.protein.Subunit;

public class StructureVisualizer
{
	private String[] m_materials;
	private String[] m_darkMaterials;
	
	public StructureVisualizer( )
	{
		m_materials = new String[] {
			"matRed",
			"matGreen",
			"matBlue",
			"matYellow"
		};
		m_darkMaterials = new String[] {
			"matDarkRed",
			"matDarkGreen",
			"matDarkBlue",
			"matDarkYellow"
		};
	}
	
	public void visualize( Protein protein )
	{
		visualize( protein, false );
	}
	
	public void visualize( Protein protein, boolean isDark )
	{
		for( int i=0; i<protein.getSubunits().size(); i++ )
		{
			System.out.println( "\tuseMaterial( " + ( isDark ? m_darkMaterials[i] : m_materials[i] ) + " )" );
			System.out.println( "\tatoms = [" );
			Subunit subunit = protein.getSubunit( i );
			Iterator<AtomAddressInternal> iterAtom = subunit.getBackboneAtomIndex().iterator();
			while( iterAtom.hasNext() )
			{
				System.out.print( "\t\tVector" + subunit.getAtom( iterAtom.next() ).getPosition() );
				if( iterAtom.hasNext() )
				{
					System.out.print( "," );
				}
				System.out.println( "" );
			}
			System.out.println( "\t]" );
			System.out.println( "\tputBackbone( atoms )" );
		}
	}
}
