/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.disco;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import edu.duke.donaldLab.share.geom.Vector3;
import edu.duke.donaldLab.share.protein.AtomAddressInternal;

public class ResultsReader
{
	/**************************
	 *   Definitions
	 **************************/
	
	private static final Logger m_log = Logger.getLogger( ResultsReader.class );
	
	
	/**************************
	 *   Methods
	 **************************/
	
	@SuppressWarnings( "unchecked" )
	public List<FaceInfo> readMsrs( File file )
	throws IOException, ClassNotFoundException
	{
		ObjectInputStream in = new ObjectInputStream( new BufferedInputStream( new FileInputStream( file ) ) );
		List<FaceInfo> msrs = (List<FaceInfo>)in.readObject();
		in.close();
		
		m_log.info( "Read " + msrs.size() + " MSRs from:\n\t" + file.getAbsolutePath() );
		
		return msrs;
	}
	
	@SuppressWarnings( "unchecked" )
	public ArrayList<Vector3> readOrientations( File file )
	throws IOException, ClassNotFoundException
	{
		ObjectInputStream in = new ObjectInputStream( new BufferedInputStream( new FileInputStream( file ) ) );
		ArrayList<Vector3> orientations = (ArrayList<Vector3>)in.readObject();
		in.close();
		
		m_log.info( "Read " + orientations.size() + " orientations from:\n\t" + file.getAbsolutePath() );
		
		return orientations;
	}
	
	@SuppressWarnings( "unchecked" )
	public Map<AtomAddressInternal,Double> readVariation( File file )
	throws IOException, ClassNotFoundException
	{
		ObjectInputStream in = new ObjectInputStream( new BufferedInputStream( new FileInputStream( file ) ) );
		Map<AtomAddressInternal,Double> variation = (Map<AtomAddressInternal,Double>)in.readObject();
		in.close();
		
		m_log.info( "Read " + variation.size() + " variations from:\n\t" + file.getAbsolutePath() );
		
		return variation;
	}
	
	public StructureScores readScores( File file )
	throws IOException, ClassNotFoundException
	{
		ObjectInputStream in = new ObjectInputStream( new BufferedInputStream( new FileInputStream( file ) ) );
		StructureScores scores = (StructureScores)in.readObject();
		in.close();
		
		m_log.info( "Read " + scores.getNumScores() + " minimized structure scores from:\n\t" + file.getAbsolutePath() );
		
		return scores;
	}
	
	public List<AnnulusIndex> readAnnulusIndices( File file )
	throws IOException, ClassNotFoundException
	{
		ObjectInputStream in = new ObjectInputStream( new BufferedInputStream( new FileInputStream( file ) ) );
		@SuppressWarnings("unchecked")
		List<AnnulusIndex> indices = (List<AnnulusIndex>)in.readObject();
		in.close();
		
		m_log.info( "Read " + indices.size() + " annulus indices from:\n\t" + file.getAbsolutePath() );
		
		return indices;
	}
}
