/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.jdshot.test.disco;

import edu.duke.donaldLab.jdshot.disco.ReferenceAnalyzer;
import edu.duke.donaldLab.jdshot.test.ExtendedTestCase;
import edu.duke.donaldLab.share.geom.Vector3;
import edu.duke.donaldLab.share.pdb.ProteinReader;
import edu.duke.donaldLab.share.protein.Protein;

public class TestReferenceAnalyzer extends ExtendedTestCase
{
	private static double Epsilon = 1e-4;
	
	public void testPositionDagk( )
	throws Exception
	{
		Protein protein = new ProteinReader().read( "src/resources/test/2KDC.oligomer.protein" );
		assertEquals( new Vector3( 24.222426, 87.405218, -171.411627 ), ReferenceAnalyzer.getSymmetryAxisPosition( protein ), Epsilon );
	}
	
	public void testPositionGb1( )
	throws Exception
	{
		Protein protein = new ProteinReader().read( "src/resources/test/1Q10.oligomer.protein" );
		assertEquals( new Vector3( 0.055652, 0.026077, 0.045438 ), ReferenceAnalyzer.getSymmetryAxisPosition( protein ), Epsilon );
	}
	
	public void testOrientationDagk( )
	throws Exception
	{
		Protein protein = new ProteinReader().read( "src/resources/test/2KDC.oligomer.protein" );
		assertEquals( new Vector3( -0.426137, -0.413806, 0.804470 ), ReferenceAnalyzer.getSymmetryAxisOrientation( protein ), Epsilon );
	}
	
	public void testOrientationGb1( )
	throws Exception
	{
		Protein protein = new ProteinReader().read( "src/resources/test/1Q10.oligomer.protein" );
		assertEquals( new Vector3( 0.999901, -0.012147, 0.007069 ), ReferenceAnalyzer.getSymmetryAxisOrientation( protein ), Epsilon );
	}
}
