/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.kinemage;

import java.util.HashMap;

public class ColorScheme
{
	/**************************
	 *   Definitions
	 **************************/
	
	public static final String[] DarkList;
	public static final String[] LightList;
	public static final String SatisfiedNoe;
	public static final String UnsatisfiedNoe;
	
	
	/**************************
	 *   Data Members
	 **************************/
	
	private static HashMap<String,String> m_colors;
	

	/**************************
	 *   Constructors
	 **************************/
	
	static
	{
		// set up color categories
		DarkList = new String[]
     	{
     		"dark01",
     		"dark02",
     		"dark03",
     		"dark04",
     		"dark05",
     		"dark06",
     		"dark07",
     		"dark08",
     		"dark09",
     		"dark10",
     		"dark11",
     		"dark12",
     	};
     	
     	LightList = new String[]
     	{
     		"light01",
     		"light02",
     		"light03",
     		"light04",
     		"light05",
     		"light06",
     		"light07",
     		"light08",
     		"light09",
     		"light10",
     		"light11",
     		"light12",
     	};
     	
    	SatisfiedNoe = "satisfiedNoe";
    	UnsatisfiedNoe = "unsatisfiedNoe";
    	
    	// set up color definitions
    	// UNDONE: some of these colors are wrong!
    	m_colors = new HashMap<String,String>();
		m_colors.put( "dark01", "209 100 52" );
		m_colors.put( "dark02", "13 95 99" );
		m_colors.put( "dark03", "48 88 99" );
		m_colors.put( "dark04", "93 83 61" );
		m_colors.put( "dark05", "345 100 49" ); // !!!
		m_colors.put( "dark06", "205 49 99" );
		m_colors.put( "dark07", "75 95 25" );
		m_colors.put( "dark08", "66 83 64" );
		m_colors.put( "dark09", "273 73 43" ); // !!!
		m_colors.put( "dark10", "34 95 99" );
		m_colors.put( "dark11", "345 78 58" ); // !!!
		m_colors.put( "dark12", "202 100 82" );
		m_colors.put( "light01", "209 50 52" );
		m_colors.put( "light02", "13 47 99" );
		m_colors.put( "light03", "48 44 99" );
		m_colors.put( "light04", "93 41 61" );
		m_colors.put( "light05", "345 50 49" ); // !!!
		m_colors.put( "light06", "205 24 99" );
		m_colors.put( "light07", "75 47 25" );
		m_colors.put( "light08", "66 41 64" );
		m_colors.put( "light09", "273 36 43" ); // !!!
		m_colors.put( "light10", "34 47 99" );
		m_colors.put( "light11", "345 37 58" ); // !!!
		m_colors.put( "light12", "202 50 82" );
		m_colors.put( "satisfiedNoe", "149 10 66 0 0 0" );
		m_colors.put( "unsatisfiedNoe", "32 90 80 32 100 100" );
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public static Node getColors( )
	{
		StringBuffer buf = new StringBuffer();
		
		for( String key : m_colors.keySet() )
		{
			buf.append( "@hsvcolor {" );
			buf.append( key );
			buf.append( "} " );
			buf.append( m_colors.get( key ) );
			buf.append( "\n" );
		}
		
		return new Node( buf.toString() );
	}
}
