/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.nmr;

import java.util.HashSet;
import java.util.Set;

import edu.duke.donaldLab.share.protein.AminoAcid;
import edu.duke.donaldLab.share.protein.Element;
import edu.duke.donaldLab.share.protein.AtomAddressReadable;

public class ChemicalShift
{
	/**************************
	 *   Data Members
	 **************************/
	
	private int m_number;
	private Set<AtomAddressReadable> m_addresses;
	private AminoAcid m_aminoAcid;
	private Element m_element;
	private double m_value;
	private double m_error;
	private int m_ambiguityCode;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public ChemicalShift( )
	{
		m_number = -1;
		m_addresses = null;
		m_aminoAcid = null;
		m_element = null;
		m_value = Double.NaN;
		m_error = Double.NaN;
		m_ambiguityCode = -1;
	}
	
	public ChemicalShift( ChemicalShift other )
	{
		m_number = other.m_number;
		m_addresses = new HashSet<AtomAddressReadable>( other.m_addresses.size() );
		for( AtomAddressReadable address : other.m_addresses )
		{
			m_addresses.add( new AtomAddressReadable( address ) );
		}
		m_aminoAcid = other.m_aminoAcid;
		m_element = other.m_element;
		m_value = other.m_value;
		m_error = other.m_error;
		m_ambiguityCode = other.m_ambiguityCode;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public int getNumber( )
	{
		return m_number;
	}
	public void setNumber( int val )
	{
		m_number = val;
	}
	
	public Set<AtomAddressReadable> getAddresses( )
	{
		return m_addresses;
	}
	public void setAddresses( Set<AtomAddressReadable> val )
	{
		m_addresses = val;
	}
	public void setAddresses( AtomAddressReadable ... vals )
	{
		m_addresses = new HashSet<AtomAddressReadable>( vals.length );
		for( AtomAddressReadable val : vals )
		{
			m_addresses.add( val );
		}
	}
	
	public AminoAcid getAminoAcid( )
	{
		return m_aminoAcid;
	}
	public void setAminoAcid( AminoAcid val )
	{
		m_aminoAcid = val;
	}
	
	public Element getElement( )
	{
		return m_element;
	}
	public void setElement( Element element )
	{
		m_element = element;
	}
	
	public double getValue( )
	{
		return m_value;
	}
	public void setValue( double val )
	{
		m_value = val;
	}
	
	public double getError( )
	{
		return m_error;
	}
	public void setError( double val )
	{
		m_error = val;
	}
	
	public int getAmbiguityCode( )
	{
		return m_ambiguityCode;
	}
	public void setAmbiguityCode( int val )
	{
		m_ambiguityCode = val;
	}
	
	
	/**************************
	 *   ChemicalShift
	 **************************/
	
	@Override
	public String toString( )
	{
		StringBuffer buf = new StringBuffer();
		
		buf.append( "[ChemicalShift] " );
		buf.append( m_value );
		buf.append( "," );
		buf.append( m_error );
		buf.append( "\t(" );
		
		boolean renderComma = false;
		for( AtomAddressReadable address : m_addresses )
		{
			if( renderComma )
			{
				buf.append( "," );
			}
			buf.append( address );
			renderComma = true;
		}
		buf.append( ")" );
		 
		
		return buf.toString();
	}
}
