/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/


package edu.duke.donaldLab.share.test.clustering;

import java.util.LinkedList;

import edu.duke.donaldLab.share.clustering.distance.DistanceCluster;
import edu.duke.donaldLab.share.clustering.distance.DistanceClusterIterator;
import edu.duke.donaldLab.share.clustering.distance.DistanceMatrix;
import edu.duke.donaldLab.share.test.ExtendedTestCase;

public class TestDistanceClusterIterator extends ExtendedTestCase
{
	public void testIteratorTwo( )
	{
		// make a chain of distance clusters
		DistanceMatrix distances = new DistanceMatrix( 2 );
		LinkedList<DistanceCluster> clusters = new LinkedList<DistanceCluster>();
		DistanceCluster a = new DistanceCluster( 0 );
		DistanceCluster b = new DistanceCluster( 1 );
		a.join( b, distances, clusters );
		
		DistanceClusterIterator iter = new DistanceClusterIterator( a );
		
		assertTrue( iter.hasNext() );
		assertSame( a, iter.next() );
		assertTrue( iter.hasNext() );
		assertSame( b, iter.next() );
		assertFalse( iter.hasNext() );
	}
	
	public void testIteratorFour( )
	{
		// make a chain of distance clusters
		DistanceMatrix distances = new DistanceMatrix( 4 );
		LinkedList<DistanceCluster> clusters = new LinkedList<DistanceCluster>();
		DistanceCluster a = new DistanceCluster( 0 );
		DistanceCluster b = new DistanceCluster( 1 );
		DistanceCluster c = new DistanceCluster( 2 );
		DistanceCluster d = new DistanceCluster( 3 );
		a.join( b, distances, clusters );
		a.join( c, distances, clusters );
		a.join( d, distances, clusters );
		
		DistanceClusterIterator iter = new DistanceClusterIterator( a );
		
		assertTrue( iter.hasNext() );
		assertSame( a, iter.next() );
		assertTrue( iter.hasNext() );
		assertSame( b, iter.next() );
		assertTrue( iter.hasNext() );
		assertSame( c, iter.next() );
		assertTrue( iter.hasNext() );
		assertSame( d, iter.next() );
		assertFalse( iter.hasNext() );
	}
}
