/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Cartcomm;
import mpi.Comm;
import mpi.Datatype;
import mpi.Graphcomm;
import mpi.Group;
import mpi.MPIException;
import mpi.Op;

public class Intracomm
extends Comm {
    private Comm shadow;

    Intracomm() {
    }

    @Override
    void setType(int n) {
        super.setType(n);
        this.shadow = new Comm(this.dup());
    }

    protected Intracomm(long l) throws MPIException {
        super(l);
        this.shadow = new Comm(this.dup());
    }

    @Override
    public Object clone() {
        try {
            return new Intracomm(this.dup());
        }
        catch (MPIException mPIException) {
            throw new RuntimeException(mPIException.getMessage());
        }
    }

    public Intracomm Split(int n, int n2) throws MPIException {
        long l = this.split(n, n2);
        if (l == nullHandle) {
            return null;
        }
        return new Intracomm(l);
    }

    private native long split(int var1, int var2);

    public Intracomm Creat(Group group) throws MPIException {
        long l = this.creat(group);
        if (l == nullHandle) {
            return null;
        }
        return new Intracomm(l);
    }

    private native long creat(Group var1);

    public native void Barrier() throws MPIException;

    private void copyBuffer(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) throws MPIException {
        if (datatype.isObject()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            int n5 = n3;
            int n6 = n;
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < datatype.displacements.length; ++j) {
                    objectArray2[n5 + datatype2.displacements[n7]] = objectArray[n6 + datatype.displacements[j]];
                }
                n6 += datatype.Extent();
                if (++n7 != datatype2.displacements.length) continue;
                n7 = 0;
                n5 += datatype2.Extent();
            }
        } else {
            byte[] byArray = new byte[this.Pack_size(n2, datatype)];
            this.Pack(object, n, n2, datatype, byArray, 0);
            this.Unpack(byArray, 0, object2, n3, n4, datatype2);
        }
    }

    private Object newBuffer(Object object) {
        if (object instanceof Object[]) {
            return new Object[((Object[])object).length];
        }
        if (object instanceof byte[]) {
            return new byte[((byte[])object).length];
        }
        if (object instanceof char[]) {
            return new char[((char[])object).length];
        }
        if (object instanceof short[]) {
            return new short[((short[])object).length];
        }
        if (object instanceof boolean[]) {
            return new boolean[((boolean[])object).length];
        }
        if (object instanceof int[]) {
            return new int[((int[])object).length];
        }
        if (object instanceof long[]) {
            return new long[((long[])object).length];
        }
        if (object instanceof float[]) {
            return new float[((float[])object).length];
        }
        if (object instanceof double[]) {
            return new double[((double[])object).length];
        }
        return null;
    }

    public void Bcast(Object object, int n, int n2, Datatype datatype, int n3) throws MPIException {
        if (datatype.isObject()) {
            if (this.Rank() == n3) {
                for (int i = 0; i < this.Size(); ++i) {
                    if (i == n3) continue;
                    this.shadow.Send(object, n, n2, datatype, i, 0);
                }
            } else {
                this.shadow.Recv(object, n, n2, datatype, n3, 0);
            }
        } else {
            this.bcast(object, n * datatype.Size(), n2, datatype, n3);
        }
    }

    private native void bcast(Object var1, int var2, int var3, Datatype var4, int var5);

    public void Gather(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) throws MPIException {
        if (datatype.isObject()) {
            if (this.Rank() == n5) {
                for (int i = 0; i < this.Size(); ++i) {
                    int n6 = n3 + n4 * datatype2.Extent() * i;
                    if (i == n5) {
                        this.copyBuffer(object, n, n2, datatype, object2, n6, n4, datatype2);
                        continue;
                    }
                    this.shadow.Recv(object2, n6, n4, datatype2, i, 0);
                }
            } else {
                this.shadow.Send(object, n, n2, datatype, n5, 0);
            }
        } else {
            this.gather(object, n * datatype.Size(), n2, datatype, object2, n3 * datatype2.Size(), n4, datatype2, n5);
        }
    }

    private native void gather(Object var1, int var2, int var3, Datatype var4, Object var5, int var6, int var7, Datatype var8, int var9);

    public void Gatherv(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2, int n4) throws MPIException {
        if (datatype.isObject()) {
            if (this.Rank() == n4) {
                for (int i = 0; i < this.Size(); ++i) {
                    int n5 = n3 + datatype.Extent() * nArray2[i];
                    if (i == n4) {
                        this.copyBuffer(object, n, n2, datatype, object2, n5, nArray[i], datatype2);
                        continue;
                    }
                    this.shadow.Recv(object2, n5, nArray[i], datatype2, i, 0);
                }
            } else {
                this.shadow.Send(object, n, n2, datatype, n4, 0);
            }
        } else {
            this.gatherv(object, n * datatype.Size(), n2, datatype, object2, n3 * datatype2.Size(), nArray, nArray2, datatype2, n4);
        }
    }

    private native void gatherv(Object var1, int var2, int var3, Datatype var4, Object var5, int var6, int[] var7, int[] var8, Datatype var9, int var10);

    public void Scatter(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2, int n5) throws MPIException {
        if (datatype.isObject()) {
            if (this.Rank() == n5) {
                for (int i = 0; i < this.Size(); ++i) {
                    int n6 = n + n2 * datatype.Extent() * i;
                    if (i == n5) {
                        this.copyBuffer(object, n6, n2, datatype, object2, n3, n4, datatype2);
                        continue;
                    }
                    this.shadow.Send(object, n6, n2, datatype, i, 0);
                }
            } else {
                this.shadow.Recv(object2, n3, n4, datatype2, n5, 0);
            }
        } else {
            this.scatter(object, n * datatype.Size(), n2, datatype, object2, n3 * datatype2.Size(), n4, datatype2, n5);
        }
    }

    private native void scatter(Object var1, int var2, int var3, Datatype var4, Object var5, int var6, int var7, Datatype var8, int var9);

    public void Scatterv(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int n3, Datatype datatype2, int n4) throws MPIException {
        if (datatype.isObject()) {
            if (this.Rank() == n4) {
                for (int i = 0; i < this.Size(); ++i) {
                    int n5 = n + datatype.Extent() * nArray2[i];
                    if (i == n4) {
                        this.copyBuffer(object, n5, nArray[i], datatype, object2, n2, n3, datatype2);
                        continue;
                    }
                    this.shadow.Send(object, n5, nArray[i], datatype, i, 0);
                }
            } else {
                this.shadow.Recv(object2, n2, n3, datatype2, n4, 0);
            }
        } else {
            this.scatterv(object, n * datatype.Size(), nArray, nArray2, datatype, object2, n2 * datatype2.Size(), n3, datatype2, n4);
        }
    }

    private native void scatterv(Object var1, int var2, int[] var3, int[] var4, Datatype var5, Object var6, int var7, int var8, Datatype var9, int var10);

    public void Allgather(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) throws MPIException {
        if (datatype.isObject()) {
            this.Gather(object, n, n2, datatype, object2, n3, n4, datatype2, 0);
            this.Bcast(object2, n3, this.Size() * n4, datatype2, 0);
        } else {
            this.allgather(object, n * datatype.Size(), n2, datatype, object2, n3 * datatype2.Size(), n4, datatype2);
        }
    }

    private native void allgather(Object var1, int var2, int var3, Datatype var4, Object var5, int var6, int var7, Datatype var8);

    public void Allgatherv(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int[] nArray, int[] nArray2, Datatype datatype2) throws MPIException {
        if (datatype.isObject()) {
            this.Gatherv(object, n, n2, datatype, object2, n3, nArray, nArray2, datatype2, 0);
            for (int i = 0; i < this.Size(); ++i) {
                int n4 = n3 + datatype.Extent() * nArray2[i];
                this.Bcast(object2, n4, nArray[i], datatype2, 0);
            }
        } else {
            this.allgatherv(object, n * datatype.Size(), n2, datatype, object2, n3 * datatype2.Size(), nArray, nArray2, datatype2);
        }
    }

    private native void allgatherv(Object var1, int var2, int var3, Datatype var4, Object var5, int var6, int[] var7, int[] var8, Datatype var9);

    public void Alltoall(Object object, int n, int n2, Datatype datatype, Object object2, int n3, int n4, Datatype datatype2) throws MPIException {
        if (datatype.isObject()) {
            for (int i = 0; i < this.Size(); ++i) {
                int n5 = n + n2 * datatype.Extent() * i;
                this.Gather(object, n5, n2, datatype, object2, n3, n4, datatype2, i);
            }
        } else {
            this.alltoall(object, n * datatype.Size(), n2, datatype, object2, n3 * datatype2.Size(), n4, datatype2);
        }
    }

    private native void alltoall(Object var1, int var2, int var3, Datatype var4, Object var5, int var6, int var7, Datatype var8);

    public void Alltoallv(Object object, int n, int[] nArray, int[] nArray2, Datatype datatype, Object object2, int n2, int[] nArray3, int[] nArray4, Datatype datatype2) throws MPIException {
        if (datatype.isObject()) {
            for (int i = 0; i < this.Size(); ++i) {
                int n3 = n + datatype.Extent() * nArray2[i];
                this.Gatherv(object, n3, nArray[i], datatype, object2, n2, nArray3, nArray4, datatype2, i);
            }
        } else {
            this.alltoallv(object, n * datatype.Size(), nArray, nArray2, datatype, object2, n2 * datatype2.Size(), nArray3, nArray4, datatype2);
        }
    }

    private native void alltoallv(Object var1, int var2, int[] var3, int[] var4, Datatype var5, Object var6, int var7, int[] var8, int[] var9, Datatype var10);

    public void Reduce(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op, int n4) throws MPIException {
        if (op.isUser()) {
            if (this.Rank() == n4) {
                this.copyBuffer(object, n, n3, datatype, object2, n2, n3, datatype);
                Object object3 = this.newBuffer(object2);
                for (int i = 0; i < this.Size(); ++i) {
                    if (i == n4) continue;
                    this.shadow.Recv(object3, 0, n3, datatype, i, 0);
                    op.Call(object3, 0, object2, n2, n3, datatype);
                }
            } else {
                this.shadow.Send(object, n, n3, datatype, n4, 0);
            }
        } else {
            this.reduce(object, n, object2, n2, n3, datatype, op, n4);
        }
    }

    private native void reduce(Object var1, int var2, Object var3, int var4, int var5, Datatype var6, Op var7, int var8);

    public void Allreduce(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) throws MPIException {
        if (op.isUser()) {
            this.Reduce(object, n, object2, n2, n3, datatype, op, 0);
            this.Bcast(object2, n2, n3, datatype, 0);
        } else {
            this.allreduce(object, n, object2, n2, n3, datatype, op);
        }
    }

    private native void allreduce(Object var1, int var2, Object var3, int var4, int var5, Datatype var6, Op var7);

    public void Reduce_scatter(Object object, int n, Object object2, int n2, int[] nArray, Datatype datatype, Op op) throws MPIException {
        if (op.isUser()) {
            int[] nArray2 = new int[nArray.length];
            int n3 = 0;
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = n3;
                n3 += nArray[i];
            }
            Object object3 = this.newBuffer(object);
            this.copyBuffer(object, n, n3, datatype, object3, n, n3, datatype);
            this.Reduce(object3, n, object, n, n3, datatype, op, 0);
            this.Scatterv(object3, n, nArray, nArray2, datatype, object2, n2, nArray[this.Rank()], datatype, 0);
        } else {
            this.reduce_scatter(object, n, object2, n2, nArray, datatype, op);
        }
    }

    private native void reduce_scatter(Object var1, int var2, Object var3, int var4, int[] var5, Datatype var6, Op var7);

    public void Scan(Object object, int n, Object object2, int n2, int n3, Datatype datatype, Op op) throws MPIException {
        if (op.isUser()) {
            if (this.Rank() == 0) {
                this.copyBuffer(object, n, n3, datatype, object2, n2, n3, datatype);
            } else {
                this.shadow.Recv(object2, n2, n3, datatype, this.Rank() - 1, 0);
                op.Call(object, n, object2, n2, n3, datatype);
            }
            if (this.Rank() < this.Size() - 1) {
                this.shadow.Send(object2, n2, n3, datatype, this.Rank() + 1, 0);
            }
        } else {
            this.scan(object, n, object2, n2, n3, datatype, op);
        }
    }

    private native void scan(Object var1, int var2, Object var3, int var4, int var5, Datatype var6, Op var7);

    public Cartcomm Create_cart(int[] nArray, boolean[] blArray, boolean bl) throws MPIException {
        long l = this.GetCart(nArray, blArray, bl);
        if (l == nullHandle) {
            return null;
        }
        return new Cartcomm(l);
    }

    private native long GetCart(int[] var1, boolean[] var2, boolean var3);

    public Graphcomm Create_graph(int[] nArray, int[] nArray2, boolean bl) throws MPIException {
        long l = this.GetGraph(nArray, nArray2, bl);
        if (l == nullHandle) {
            return null;
        }
        return new Graphcomm(l);
    }

    private native long GetGraph(int[] var1, int[] var2, boolean var3);
}

