/*
 * Decompiled with CFR 0.152.
 */
package mpi;

import mpi.Freeable;
import mpi.MPI;
import mpi.MPIException;

public class Datatype
extends Freeable {
    private static final int UNDEFINED = -1;
    private static final int NULL = 0;
    private static final int BYTE = 1;
    private static final int CHAR = 2;
    private static final int SHORT = 3;
    private static final int BOOLEAN = 4;
    private static final int INT = 5;
    private static final int LONG = 6;
    private static final int FLOAT = 7;
    private static final int DOUBLE = 8;
    private static final int PACKED = 9;
    private static final int LB = 10;
    private static final int UB = 11;
    private static final int OBJECT = 12;
    protected long handle;
    protected int baseType;
    protected int baseSize;
    protected int[] displacements;
    protected int lb;
    protected int ub;
    protected boolean ubSet;
    protected boolean lbSet;

    private static native void init();

    Datatype() {
    }

    Datatype(int n) {
        this.setBasic(n);
    }

    void setBasic(int n) {
        switch (n) {
            case 12: {
                this.baseType = 12;
                this.displacements = new int[1];
                this.lb = 0;
                this.ub = 1;
                this.lbSet = false;
                this.ubSet = false;
                break;
            }
            case 10: {
                this.baseType = -1;
                this.displacements = new int[0];
                this.lb = 0;
                this.ub = 0;
                this.lbSet = true;
                this.ubSet = false;
                break;
            }
            case 11: {
                this.baseType = -1;
                this.displacements = new int[0];
                this.lb = 0;
                this.ub = 0;
                this.lbSet = false;
                this.ubSet = true;
                break;
            }
            default: {
                this.baseType = n;
                this.GetDatatype(n);
                this.baseSize = this.size();
            }
        }
    }

    private native void GetDatatype(int var1);

    private Datatype(int n, Datatype datatype) throws MPIException {
        this.setContiguous(n, datatype);
    }

    void setContiguous(int n, Datatype datatype) throws MPIException {
        this.baseType = datatype.baseType;
        if (this.baseType == 12 || this.baseType == -1) {
            int n2 = datatype.Size();
            boolean bl = datatype.ubSet;
            boolean bl2 = datatype.lbSet;
            this.displacements = new int[n * n2];
            this.ubSet = n > 0 && bl;
            this.lbSet = n > 0 && bl2;
            this.lb = Integer.MAX_VALUE;
            this.ub = Integer.MIN_VALUE;
            if (n2 != 0 || bl2 || bl) {
                int n3 = datatype.Extent();
                if (n > 0) {
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8 = 0;
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = n7 * n3;
                        n5 = 0;
                        while (n5 < n2) {
                            this.displacements[n8] = n6 + datatype.displacements[n5];
                            ++n5;
                            ++n8;
                        }
                    }
                    n7 = n3 > 0 ? (n - 1) * n3 : 0;
                    n6 = n7 + datatype.ub;
                    if (n6 > this.ub) {
                        this.ub = n6;
                    }
                    if ((n4 = (n5 = n3 > 0 ? 0 : (n - 1) * n3) + datatype.lb) < this.lb) {
                        this.lb = n4;
                    }
                }
            } else if (n > 1) {
                System.out.println("Datatype.Contiguous: repeat-count specified for component with undefined extent");
                MPI.COMM_WORLD.Abort(1);
            }
        } else {
            this.baseSize = datatype.baseSize;
            this.GetContiguous(n, datatype);
        }
    }

    private native void GetContiguous(int var1, Datatype var2);

    private Datatype(int n, int n2, int n3, Datatype datatype, boolean bl) throws MPIException {
        this.baseType = datatype.baseType;
        if (this.baseType == 12 || this.baseType == -1) {
            int n4 = datatype.Size();
            boolean bl2 = datatype.ubSet;
            boolean bl3 = datatype.lbSet;
            int n5 = n * n2;
            this.displacements = new int[n5 * n4];
            this.ubSet = n5 > 0 && bl2;
            this.lbSet = n5 > 0 && bl3;
            this.lb = Integer.MAX_VALUE;
            this.ub = Integer.MIN_VALUE;
            if (n5 > 0) {
                if (n4 != 0 || bl3 || bl2) {
                    int n6 = datatype.Extent();
                    int n7 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        int n12 = n3 * i;
                        if (bl) {
                            n12 *= n6;
                        }
                        for (n11 = 0; n11 < n2; ++n11) {
                            n10 = n12 + n11 * n6;
                            n9 = 0;
                            while (n9 < n4) {
                                this.displacements[n7] = n10 + datatype.displacements[n9];
                                ++n9;
                                ++n7;
                            }
                        }
                        n11 = n6 > 0 ? n12 + (n2 - 1) * n6 : n12;
                        n10 = n11 + datatype.ub;
                        if (n10 > this.ub) {
                            this.ub = n10;
                        }
                        if ((n8 = (n9 = n6 > 0 ? n12 : n12 + (n2 - 1) * n6) + datatype.lb) >= this.lb) continue;
                        this.lb = n8;
                    }
                } else if (bl) {
                    System.out.println("Datatype.Vector: old type has undefined extent");
                    MPI.COMM_WORLD.Abort(1);
                } else if (n2 > 1) {
                    System.out.println("Datatype.Hvector: repeat-count specified for component with undefined extent");
                    MPI.COMM_WORLD.Abort(1);
                }
            }
        } else {
            this.baseSize = datatype.baseSize;
            if (bl) {
                this.GetVector(n, n2, n3, datatype);
            } else {
                this.GetHvector(n, n2, n3, datatype);
            }
        }
    }

    private native void GetVector(int var1, int var2, int var3, Datatype var4);

    private native void GetHvector(int var1, int var2, int var3, Datatype var4);

    private Datatype(int[] nArray, int[] nArray2, Datatype datatype, boolean bl) throws MPIException {
        this.baseType = datatype.baseType;
        if (this.baseType == 12 || this.baseType == -1) {
            int n;
            int n2 = datatype.Size();
            boolean bl2 = datatype.ubSet;
            boolean bl3 = datatype.lbSet;
            int n3 = 0;
            for (n = 0; n < nArray.length; ++n) {
                n3 += nArray[n];
            }
            this.displacements = new int[n3 * n2];
            this.ubSet = n3 > 0 && bl2;
            this.lbSet = n3 > 0 && bl3;
            this.lb = Integer.MAX_VALUE;
            this.ub = Integer.MIN_VALUE;
            if (n2 != 0 || bl3 || bl2) {
                n = datatype.Extent();
                int n4 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9 = nArray[i];
                    if (n9 <= 0) continue;
                    int n10 = nArray2[i];
                    if (bl) {
                        n10 *= n;
                    }
                    for (n8 = 0; n8 < n9; ++n8) {
                        n7 = n10 + n8 * n;
                        n6 = 0;
                        while (n6 < n2) {
                            this.displacements[n4] = n7 + datatype.displacements[n6];
                            ++n6;
                            ++n4;
                        }
                    }
                    n8 = n > 0 ? n10 + (n9 - 1) * n : n10;
                    n7 = n8 + datatype.ub;
                    if (n7 > this.ub) {
                        this.ub = n7;
                    }
                    if ((n5 = (n6 = n > 0 ? n10 : n10 + (n9 - 1) * n) + datatype.lb) >= this.lb) continue;
                    this.lb = n5;
                }
            } else if (bl) {
                System.out.println("Datatype.Indexed: old type has undefined extent");
                MPI.COMM_WORLD.Abort(1);
            } else {
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] <= 1) continue;
                    System.out.println("Datatype.Hindexed: repeat-count specified for component with undefined extent");
                    MPI.COMM_WORLD.Abort(1);
                }
            }
        } else {
            this.baseSize = datatype.baseSize;
            if (bl) {
                this.GetIndexed(nArray, nArray2, datatype);
            } else {
                this.GetHindexed(nArray, nArray2, datatype);
            }
        }
    }

    private native void GetIndexed(int[] var1, int[] var2, Datatype var3);

    private native void GetHindexed(int[] var1, int[] var2, Datatype var3);

    private Datatype(int[] nArray, int[] nArray2, Datatype[] datatypeArray) throws MPIException {
        int n;
        int n2;
        this.baseType = -1;
        for (n2 = 0; n2 < datatypeArray.length; ++n2) {
            n = datatypeArray[n2].baseType;
            if (n == this.baseType) continue;
            if (this.baseType == -1) {
                this.baseType = n;
                if (this.baseType == 12) continue;
                this.baseSize = datatypeArray[n2].baseSize;
                continue;
            }
            if (n == -1) continue;
            System.out.println("Datatype.Struct: All base types must agree...");
            MPI.COMM_WORLD.Abort(1);
        }
        if (this.baseType == 12 || this.baseType == -1) {
            n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                n2 += nArray[n] * datatypeArray[n].Size();
            }
            this.displacements = new int[n2];
        }
        this.ubSet = false;
        this.lbSet = false;
        this.lb = Integer.MAX_VALUE;
        this.ub = Integer.MIN_VALUE;
        n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray[n];
            if (n3 <= 0) continue;
            Datatype datatype = datatypeArray[n];
            int n4 = datatype.baseType;
            if (n4 != 12 && n4 != -1) continue;
            int n5 = datatype.Size();
            boolean bl = datatype.ubSet;
            boolean bl2 = datatype.lbSet;
            if (n5 != 0 || bl2 || bl) {
                int n6;
                int n7;
                int n8 = datatype.Extent();
                int n9 = nArray2[n];
                for (n7 = 0; n7 < n3; ++n7) {
                    n6 = n9 + n7 * n8;
                    int n10 = 0;
                    while (n10 < n5) {
                        this.displacements[n2] = n6 + datatype.displacements[n10];
                        ++n10;
                        ++n2;
                    }
                }
                if (bl == this.ubSet) {
                    n7 = n8 > 0 ? n9 + (n3 - 1) * n8 : n9;
                    n6 = n7 + datatype.ub;
                    if (n6 > this.ub) {
                        this.ub = n6;
                    }
                } else if (bl) {
                    n7 = n8 > 0 ? n9 + (n3 - 1) * n8 : n9;
                    this.ub = n7 + datatype.ub;
                    this.ubSet = true;
                }
                if (bl2 == this.lbSet) {
                    n7 = n8 > 0 ? n9 : n9 + (n3 - 1) * n8;
                    n6 = n7 + datatype.lb;
                    if (n6 >= this.lb) continue;
                    this.lb = n6;
                    continue;
                }
                if (!bl2) continue;
                n7 = n8 > 0 ? n9 : n9 + (n3 - 1) * n8;
                this.lb = n7 + datatype.lb;
                this.lbSet = true;
                continue;
            }
            if (n3 <= 1) continue;
            System.out.println("Datatype.Struct: repeat-count specified for component with undefined extent");
            MPI.COMM_WORLD.Abort(1);
        }
        if (this.baseType != 12 && this.baseType != -1) {
            this.GetStruct(nArray, nArray2, datatypeArray, this.lbSet, this.lb, this.ubSet, this.ub);
        }
    }

    private native void GetStruct(int[] var1, int[] var2, Datatype[] var3, boolean var4, int var5, boolean var6, int var7);

    protected boolean isObject() {
        return this.baseType == 12 || this.baseType == -1;
    }

    public int Extent() throws MPIException {
        if (this.baseType == 12 || this.baseType == -1) {
            return this.ub - this.lb;
        }
        return this.extent() / this.baseSize;
    }

    private native int extent();

    public int Size() throws MPIException {
        if (this.baseType == 12 || this.baseType == -1) {
            return this.displacements.length;
        }
        return this.size() / this.baseSize;
    }

    private native int size();

    public int Lb() throws MPIException {
        if (this.baseType == 12 || this.baseType == -1) {
            return this.lb;
        }
        return this.lB() / this.baseSize;
    }

    private native int lB();

    public int Ub() throws MPIException {
        if (this.baseType == 12 || this.baseType == -1) {
            return this.ub;
        }
        return this.uB() / this.baseSize;
    }

    private native int uB();

    public void Commit() throws MPIException {
        if (this.baseType != 12 && this.baseType != -1) {
            this.commit();
        }
    }

    private native void commit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws MPIException {
        Class<MPI> clazz = MPI.class;
        synchronized (MPI.class) {
            MPI.freeList.addFirst(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    native void free();

    public static Datatype Contiguous(int n, Datatype datatype) throws MPIException {
        return new Datatype(n, datatype);
    }

    public static Datatype Vector(int n, int n2, int n3, Datatype datatype) throws MPIException {
        return new Datatype(n, n2, n3, datatype, true);
    }

    public static Datatype Hvector(int n, int n2, int n3, Datatype datatype) throws MPIException {
        return new Datatype(n, n2, n3, datatype, false);
    }

    public static Datatype Indexed(int[] nArray, int[] nArray2, Datatype datatype) throws MPIException {
        return new Datatype(nArray, nArray2, datatype, true);
    }

    public static Datatype Hindexed(int[] nArray, int[] nArray2, Datatype datatype) throws MPIException {
        return new Datatype(nArray, nArray2, datatype, false);
    }

    public static Datatype Struct(int[] nArray, int[] nArray2, Datatype[] datatypeArray) throws MPIException {
        return new Datatype(nArray, nArray2, datatypeArray);
    }

    static {
        Datatype.init();
    }
}

