

#ifndef GLOBAL_H_
#define GLOBAL_H_

// NOTE: we need two functions here to expand argument macros correctly
#define CLASSFN2( c, fn )		c##_##fn
#define CLASSFN( c, fn )		CLASSFN2( c, fn )

#define SPHERICALCLASS( name )  "libprotnmr/cgal/spherical/" name
#define CGALCLASS( name )       "libprotnmr/cgal/" name
#define GEOMCLASS( name )       "libprotnmr/geom/" name

#define SAFE_DELETE( p )	{ if( (p) != NULL ) { delete (p); (p) = NULL; } }

// signal handling to give code an escape hatch back to Java
#define START_SIGNAL_HANDLING	try
#define STOP_SIGNAL_HANDLING	catch( AbortSignal &s ) { s.doNothing(); }
class AbortSignal { public: void doNothing( ) { } };
extern AbortSignal g_abortSignal;

// global funcs
void checkException( JNIEnv *jvm );
void throwException( JNIEnv *jvm, const char *message );
void throwIllegalArgumentException( JNIEnv *jvm, const char *message );
int getId( JNIEnv *jvm, jobject self );
void setId( JNIEnv *jvm, jobject self, int id );
void *getPointer( JNIEnv *jvm, jobject self );
void setPointer( JNIEnv *jvm, jobject self, void *p );
jobject newVector3( JNIEnv *jvm, double x, double y, double z );
double getVectorX( JNIEnv *jvm, jobject vector );
double getVectorY( JNIEnv *jvm, jobject vector );
double getVectorZ( JNIEnv *jvm, jobject vector );

#endif /* GLOBAL_H_ */
