/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/
package libprotnmr.nmr;

import java.io.Serializable;

import libprotnmr.io.HashCalculator;
import libprotnmr.protein.AtomAddress;


public class Assignment<T extends AtomAddress<T>> implements Serializable
{
	/**************************
	 *   Definitions
	 **************************/
	
	private static final long serialVersionUID = -5512426021726265727L;
	
	
	/**************************
	 *   Data Members
	 **************************/
	
	private T m_left;
	private T m_right;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public Assignment( )
	{
		m_left = null;
		m_right = null;
	}
	
	public Assignment( T left, T right )
	{
		m_left = left;
		m_right = right;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public T getLeft( )
	{
		return m_left;
	}
	public void setLeft( T value )
	{
		m_left = value;
	}

	public T getRight( )
	{
		return m_right;
	}
	public void setRight( T value )
	{
		m_right = value;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public void swap( )
	{
		T swap = m_left;
		m_left = m_right;
		m_right = swap;
	}
	
	public boolean isIntermolecular( )
	{
		return !m_left.isSameSubunit( m_right );
	}
	
	@Override
	public String toString( )
	{
		return "[Assignment] " + m_left + "\t" + m_right;
	}
	
	@Override
	public int hashCode( )
	{
		return HashCalculator.combineHashes( m_left.hashCode(), m_right.hashCode() );
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public boolean equals( Object other )
	{
		if( other instanceof Assignment<?> )
		{
			return equals( (Assignment<T>)other );
		}
		return false;
	}
	
	public boolean equals( Assignment<T> other )
	{
		return m_left.equals( other.m_left ) && m_right.equals( other.m_right );
	}
}
