/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/
package libprotnmr.optimization;

public abstract class DifferentiableMultiPartFunction
{
	/**************************
	 *   Data Members
	 **************************/
	
	private int m_numParts;
	private int m_maxNumOptima;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	protected DifferentiableMultiPartFunction( int numParts, int maxNumOptima )
	{
		m_numParts = numParts;
		m_maxNumOptima = maxNumOptima;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public int getNumParts( )
	{
		return m_numParts;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public abstract double getValue( double t, int part );
	public abstract double getDerivative( double t, int part );
	
	public DifferentiableFunction getPart( final int part )
	{
		return new DifferentiableFunction( )
		{
			@Override
			public double getValue( double t )
			{
				return DifferentiableMultiPartFunction.this.getValue( t, part );
			}
			
			@Override
			public double getDerivative( double t )
			{
				return DifferentiableMultiPartFunction.this.getDerivative( t, part );
			}
			
			@Override
			public int getMaxNumOptima( )
			{
				return DifferentiableMultiPartFunction.this.m_maxNumOptima;
			}
		};
	}
}
