/*******************************************************************************
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * 
 * Contact Info:
 * 	Bruce Donald
 * 	Duke University
 * 	Department of Computer Science
 * 	Levine Science Research Center (LSRC)
 * 	Durham
 * 	NC 27708-0129 
 * 	USA
 * 	brd@cs.duke.edu
 * 
 * Copyright (C) 2011 Jeffrey W. Martin and Bruce R. Donald
 * 
 * <signature of Bruce Donald>, April 2011
 * Bruce Donald, Professor of Computer Science
 ******************************************************************************/
package libprotnmr.clustering;

public class KDTreeInteriorNode implements KDTreeNode
{
	/**************************
	 *   Data Members
	 **************************/
	
	private double m_median;
	private int m_axis;
	private KDTreeNode m_left;
	private KDTreeNode m_right;
	
	
	/**************************
	 *   Constructors
	 **************************/
	
	public KDTreeInteriorNode( )
	{
		m_median = Double.NaN;
		m_axis = -1;
		m_left = null;
		m_right = null;
	}
	
	
	/**************************
	 *   Accessors
	 **************************/
	
	public double getMedian( )
	{
		return m_median;
	}
	public void setMedian( double value )
	{
		m_median = value;
	}
	
	public int getAxis( )
	{
		return m_axis;
	}
	public void setAxis( int value )
	{
		m_axis = value;
	}
	
	public void setLeft( KDTreeNode value )
	{
		m_left = value;
	}
	
	public void setRight( KDTreeNode value )
	{
		m_right = value;
	}
	
	
	/**************************
	 *   Methods
	 **************************/
	
	public String toString( )
	{
		return "(" + m_median + "," + m_axis + ")";
	}
	
	public boolean isLeaf( )
	{
		return false;
	}
	
	public KDTreeInteriorNode getInteriorNode( )
	{
		return this;
	}
	
	public KDTreeLeafNode getLeafNode( )
	{
		return null;
	}
	
	public KDTreeNode getLeft( )
	{
		return m_left;
	}
	
	public KDTreeNode getRight( )
	{
		return m_right;
	}
}
