/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class HnNoe {
    private int residueNo;
    private String residue;
    private double csHN;
    private double csN15;
    private double csH1;
    private double intensity;
    private double uncertainty = 0.0;
    private int label;
    private Map noeMap = new TreeMap();
    private Map assignMap = new TreeMap();

    public HnNoe() {
        this.residueNo = 0;
        this.residue = null;
        this.csHN = 0.0;
        this.csN15 = 0.0;
        this.csH1 = 0.0;
        this.intensity = 0.0;
        this.assignMap = new TreeMap();
        this.noeMap = new TreeMap();
    }

    public HnNoe(int no) {
        this.residueNo = no;
        this.residue = null;
        this.csHN = 0.0;
        this.csN15 = 0.0;
        this.csH1 = 0.0;
        this.intensity = 0.0;
        this.label = 0;
        this.assignMap = new TreeMap();
        this.noeMap = new TreeMap();
    }

    public HnNoe(int no, String resid, double HN, double N15, double H1, double inten) {
        this.residueNo = no;
        this.residue = resid;
        this.csHN = HN;
        this.csN15 = N15;
        this.csH1 = H1;
        this.intensity = inten;
        this.label = 0;
        this.assignMap = new TreeMap();
        this.noeMap = new TreeMap();
    }

    public HnNoe(int no, String resid, double HN, double N15, double H1, double inten, double uncn) {
        this.residueNo = no;
        this.residue = resid;
        this.csHN = HN;
        this.csN15 = N15;
        this.csH1 = H1;
        this.intensity = inten;
        this.label = 0;
        this.assignMap = new TreeMap();
        this.noeMap = new TreeMap();
        this.uncertainty = uncn;
    }

    public HnNoe(int no, String resid, double HN, double N15, double H1, int labelType) {
        this.residueNo = no;
        this.residue = resid;
        this.csHN = HN;
        this.csN15 = N15;
        this.csH1 = H1;
        this.label = labelType;
        this.intensity = 0.0;
        this.assignMap = new TreeMap();
        this.noeMap = new TreeMap();
    }

    public HnNoe(int no, String resid, double HN, double N15, double H1, double inten, Map aMap) {
        this.residueNo = no;
        this.residue = resid;
        this.csHN = HN;
        this.csN15 = N15;
        this.csH1 = H1;
        this.intensity = inten;
        this.label = 0;
        this.assignMap = aMap;
        this.noeMap = new TreeMap();
    }

    public HnNoe(double HN, double N15, double H1) {
        this.residueNo = 0;
        this.residue = "";
        this.csHN = HN;
        this.csN15 = N15;
        this.csH1 = H1;
        this.intensity = 0.0;
        this.label = 0;
        this.assignMap = new TreeMap();
        this.noeMap = new TreeMap();
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public int getLabel() {
        return this.label;
    }

    public String getResidueType() {
        return this.residue;
    }

    public double getHN() {
        return this.csHN;
    }

    public double getN15() {
        return this.csN15;
    }

    public double getH1() {
        return this.csH1;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public Map getAssignMap() {
        return this.assignMap;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public void setResidueType(String R) {
        this.residue = R;
    }

    public void setAssignMap(Map aMap) {
        this.assignMap = aMap;
    }

    public String toString() {
        String desc = "";
        String str = String.valueOf(String.valueOf(this.residueNo)) + " " + this.residue + "\n";
        double csValue = 0.0;
        if (!this.assignMap.isEmpty()) {
            for (Map.Entry e : this.assignMap.entrySet()) {
                csValue = (Double)e.getValue();
                if (!(Math.abs(csValue + 999.99) > 0.01)) continue;
                str = String.valueOf(str) + (String)e.getKey() + " = " + (Double)e.getValue() + "\n";
            }
            desc = String.valueOf(desc) + str + "\n";
            desc = String.valueOf(desc) + String.valueOf(this.csHN) + "  " + String.valueOf(this.csN15) + "   " + String.valueOf(this.csH1) + "  " + String.valueOf(this.intensity);
        } else {
            desc = String.valueOf(String.valueOf(this.csHN)) + "  " + String.valueOf(this.csN15) + "   " + String.valueOf(this.csH1) + "  " + String.valueOf(this.intensity);
        }
        return desc;
    }

    public Vector hnNoeReader(String filename) {
        Vector<HnNoe> inputs = new Vector<HnNoe>();
        double csHN = 0.0;
        double csN15 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        int index1 = 0;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        int no = 0;
        String aaType = "";
        String ss = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            ss = in.readLine();
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csHN = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    csN15 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    str = st.nextToken();
                    index1 = str.indexOf("e");
                    order = str.substring(index1 + 1);
                    value = new Double(str.substring(0, index1));
                    if (order.equals("+10")) {
                        intensity = value * 10000.0;
                    }
                    if (order.equals("+09")) {
                        intensity = value * 1000.0;
                    } else if (order.equals("+08")) {
                        intensity = value * 100.0;
                    } else if (order.equals("+07")) {
                        intensity = value * 10.0;
                    } else if (order.equals("+06")) {
                        intensity = value;
                    } else if (order.equals("+05")) {
                        intensity = value * 0.1;
                    } else {
                        System.out.println("Intensity Error");
                    }
                }
                inputs.add(new HnNoe(no, aaType, csHN, csN15, csH1, intensity));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector NoesyReader(String filename) {
        inputs = new Vector<HnNoe>();
        csHN = 0.0;
        csN15 = 0.0;
        csH1 = 0.0;
        intensity = 0.0;
        uncertainty = 0.0;
        csVec = new Vector<E>();
        st = new StringTokenizer("");
        str = "";
        strTemp = "";
        csID = 0.0;
        index1 = false;
        index2 = false;
        order = "";
        value = 0.0;
        no = false;
        aaType = "";
        ss = "";
        counter = 0;
        index = -1;
        try {
            in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do lbl-1000:
            // 3 sources

            {
                block13: {
                    if ((index = ss.trim().indexOf("#")) != 0) break block13;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    csID = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csN15 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csHN = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    uncertainty = new Double(st.nextToken());
                }
                ++counter;
                inputs.add(new HnNoe(0, "", csHN, csN15, csH1, intensity, uncertainty));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        System.out.println("The total number of HN-NOE frequency triples is: " + counter);
        return inputs;
    }

    public Vector hnNoeReader2(String filename) {
        Vector<HnNoe> inputs = new Vector<HnNoe>();
        double csHN = 0.0;
        double csN15 = 0.0;
        double csH1 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        boolean no = false;
        String aaType = "";
        String ss = "";
        int counter = 0;
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            ss = in.readLine();
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    csHN = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csN15 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                    if (intensity < 1.0) {
                        intensity *= 10.0;
                    }
                } else {
                    intensity = 3.0;
                }
                ++counter;
                inputs.add(new HnNoe(0, "", csHN, csN15, csH1, intensity));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        System.out.println("The total number of HN-NOE frequency triples is: " + counter);
        return inputs;
    }

    public Vector rangeSearch(String nucType, double a, double b, Vector pkVec) {
        Vector outVec = new Vector();
        double csValue = 0.0;
        int i = 0;
        while (i < pkVec.size()) {
            if (nucType.equals("H1")) {
                csValue = ((HnNoe)pkVec.elementAt(i)).getHN();
            } else if (nucType.equals("N15")) {
                csValue = ((HnNoe)pkVec.elementAt(i)).getN15();
            }
            if (csValue >= a && csValue <= b) {
                outVec.add(pkVec.elementAt(i));
            }
            ++i;
        }
        return outVec;
    }

    public Vector mergeHnNoe(Vector pkVec, double epsH, double epsN) {
        double csHN = 0.0;
        double csN15 = 0.0;
        double csHNTmp = 0.0;
        double csN15Tmp = 0.0;
        Vector<HnNoe> outVec = new Vector<HnNoe>();
        Vector<Vector<HnNoe>> allVec = new Vector<Vector<HnNoe>>();
        double csValue = 0.0;
        HnNoe hncc = new HnNoe();
        int i = 0;
        int j = 0;
        Collections.sort(pkVec, new n15Comparator());
        boolean count = false;
        int cnt1 = 0;
        int cnt2 = 0;
        int N = pkVec.size();
        while (!pkVec.isEmpty()) {
            hncc = (HnNoe)pkVec.elementAt(0);
            csHN = hncc.getHN();
            csN15 = hncc.getN15();
            outVec.add(hncc);
            cnt1 = 0;
            i = 1;
            while (i < pkVec.size()) {
                hncc = (HnNoe)pkVec.elementAt(i);
                csHNTmp = hncc.getHN();
                csN15Tmp = hncc.getN15();
                if (Math.abs(csHNTmp - csHN) < epsH && Math.abs(csN15Tmp - csN15) < epsN) {
                    outVec.add(hncc);
                    ++cnt1;
                }
                ++i;
            }
            allVec.add(outVec);
            outVec = new Vector();
            cnt2 = 0;
            j = 0;
            while (j < pkVec.size()) {
                hncc = (HnNoe)pkVec.elementAt(j);
                csHNTmp = hncc.getHN();
                csN15Tmp = hncc.getN15();
                if (Math.abs(csHNTmp - csHN) < epsH && Math.abs(csN15Tmp - csN15) < epsN) {
                    pkVec.removeElementAt(j);
                    ++cnt2;
                    continue;
                }
                ++j;
            }
            pkVec.trimToSize();
            N = pkVec.size();
        }
        return allVec;
    }

    public static class h1Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HnNoe n1 = (HnNoe)o1;
            HnNoe n2 = (HnNoe)o2;
            double d1 = n1.getH1();
            if (d1 < (d2 = n2.getH1())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class hnComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HnNoe n1 = (HnNoe)o1;
            HnNoe n2 = (HnNoe)o2;
            double d1 = n1.getHN();
            if (d1 < (d2 = n2.getHN())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class n15Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HnNoe n1 = (HnNoe)o1;
            HnNoe n2 = (HnNoe)o2;
            double d1 = n1.getN15();
            if (d1 < (d2 = n2.getN15())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class resNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            HnNoe n1 = (HnNoe)o1;
            HnNoe n2 = (HnNoe)o2;
            double d1 = n1.getResidueNo();
            if (d1 < (d2 = (double)n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

