/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.Dipolar;
import rdcPanda.EigenvalueDecomposition;
import rdcPanda.Maths;
import rdcPanda.Matrix;
import rdcPanda.ModelRdc;
import rdcPanda.Pdb;
import rdcPanda.PdbRdc;
import rdcPanda.Peak;
import rdcPanda.ppGlobal;

public class PhiPsi
implements Cloneable {
    private int residueNo;
    private String residue;
    private double phi;
    private double psi;
    private double rama_score = 0.0;
    static final double[] dirCosCH = Const.dirCosCHcnt;
    static final double[] dirCosNH = Const.dirCosNHcnt;
    private double phiLower = 0.0;
    private double phiUpper = 0.0;
    private double psiLower = 0.0;
    private double psiUpper = 0.0;

    public PhiPsi(double phiT, double psiT, double r_score) {
        this.residueNo = 0;
        this.residue = null;
        this.phi = phiT;
        this.psi = psiT;
        this.rama_score = r_score;
        this.phiLower = 0.0;
        this.phiUpper = 0.0;
        this.psiLower = 0.0;
        this.psiUpper = 0.0;
    }

    public PhiPsi() {
        this.residueNo = 0;
        this.residue = null;
        this.phi = 0.0;
        this.psi = 0.0;
        this.phiLower = 0.0;
        this.phiUpper = 0.0;
        this.psiLower = 0.0;
        this.psiUpper = 0.0;
    }

    public PhiPsi(int No) {
        this.residueNo = No;
        this.residue = "";
        this.phi = 0.0;
        this.psi = 0.0;
        this.phiLower = 0.0;
        this.phiUpper = 0.0;
        this.psiLower = 0.0;
        this.psiUpper = 0.0;
    }

    public PhiPsi(int no, String re, double x, double y) {
        this.residueNo = no;
        this.residue = re;
        this.phi = x;
        this.psi = y;
        this.phiLower = 0.0;
        this.phiUpper = 0.0;
        this.psiLower = 0.0;
        this.psiUpper = 0.0;
    }

    public PhiPsi(int no, String re, double x, double y, double phi_lo, double phi_up, double psi_lo, double psi_up) {
        this.residueNo = no;
        this.residue = re;
        this.phi = x;
        this.psi = y;
        this.phiLower = phi_lo;
        this.phiUpper = phi_up;
        this.psiLower = psi_lo;
        this.psiUpper = psi_up;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidue() {
        return this.residue;
    }

    public double getPhi() {
        return this.phi;
    }

    public void setPhi(double f1) {
        this.phi = f1;
    }

    public double getPsi() {
        return this.psi;
    }

    public void setPsi(double f1) {
        this.psi = f1;
    }

    public double getRamaScore() {
        return this.rama_score;
    }

    public double getPhiLower() {
        return this.phiLower;
    }

    public double getPhiUpper() {
        return this.phiUpper;
    }

    public double getPsiLower() {
        return this.psiLower;
    }

    public double getPsiUpper() {
        return this.psiUpper;
    }

    public String toString() {
        String desc = String.valueOf(String.valueOf(this.residueNo)) + "  " + this.residue + "  " + String.valueOf(this.phi * 180.0 / Math.PI) + "  " + String.valueOf(this.psi * 180.0 / Math.PI);
        return desc;
    }

    public void printArray(double[] n1) {
        int i = 0;
        while (i < n1.length) {
            System.out.print(String.valueOf(n1[i]) + "  ");
            ++i;
        }
        System.out.println();
    }

    public double length(double[] v1) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        return v1Len;
    }

    public double interAngle(double[] v1, double[] v2) {
        double v2Len;
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        double c = (v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2]) / (v1Len * (v2Len = Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2])));
        if (c > 0.0 && Math.abs(c - 1.0) < 1.0E-4) {
            return 0.0;
        }
        if (c < 0.0 && Math.abs(c + 1.0) < 1.0E-4) {
            return Math.PI;
        }
        return Math.acos(c);
    }

    public double[] dirCos(double[] vec) {
        double len = 0.0;
        double[] dirs = new double[vec.length];
        int i = 0;
        while (i < vec.length) {
            len += vec[i] * vec[i];
            ++i;
        }
        int j = 0;
        while (j < vec.length) {
            dirs[j] = vec[j] / Math.sqrt(len);
            ++j;
        }
        return dirs;
    }

    public double[] internuclearVec(double[] n1, double[] n2) {
        return new double[]{n2[0] - n1[0], n2[1] - n1[1], n2[2] - n1[2]};
    }

    public double internuclearDistance(double[] n1, double[] n2) {
        return Math.sqrt((n2[0] - n1[0]) * (n2[0] - n1[0]) + (n2[1] - n1[1]) * (n2[1] - n1[1]) + (n2[2] - n1[2]) * (n2[2] - n1[2]));
    }

    public double[] addCoords(double[] n1, double[] n2) {
        return new double[]{n2[0] + n1[0], n2[1] + n1[1], n2[2] + n1[2]};
    }

    public Matrix RgCal(double[] nToh, double[] nToca) {
        double[] n2h = this.dirCos(nToh);
        double[] n2ca = this.dirCos(nToca);
        double theta = Math.PI - this.interAngle(nToh, nToca);
        double xNH = n2h[0];
        double yNH = n2h[1];
        double zNH = n2h[2];
        double xNCA = n2ca[0];
        double yNCA = n2ca[1];
        double zNCA = n2ca[2];
        double[][] mat = new double[3][3];
        Matrix A = new Matrix(3, 3);
        double sinTheta = 9.99;
        double alpha1 = 9.99;
        double beta1 = 9.99;
        double gamma1 = 9.99;
        if (Math.abs(zNH - 1.0) < 1.0E-4) {
            if (Math.abs(zNCA - 1.0) > 1.0E-4 && Math.abs(zNCA + 1.0) > 1.0E-4) {
                sinTheta = Math.sqrt(1.0 - zNCA * zNCA);
                mat[0][0] = yNCA / sinTheta;
                mat[0][1] = xNCA / sinTheta;
                mat[0][2] = 0.0;
                mat[1][0] = -xNCA / sinTheta;
                mat[1][1] = yNCA / sinTheta;
                mat[1][2] = 0.0;
                mat[2][0] = 0.0;
                mat[2][1] = 0.0;
                mat[2][2] = 1.0;
                return new Matrix(mat).transpose();
            }
            System.out.println("zNCA is 1 or -1");
            System.exit(0);
        } else if (Math.abs(zNH + 1.0) < 1.0E-4) {
            if (Math.abs(zNCA - 1.0) > 1.0E-4 && Math.abs(zNCA + 1.0) > 1.0E-4) {
                sinTheta = Math.sqrt(1.0 - zNCA * zNCA);
                mat[0][0] = yNCA / sinTheta;
                mat[0][1] = xNCA / sinTheta;
                mat[0][2] = 0.0;
                mat[1][0] = xNCA / sinTheta;
                mat[1][1] = yNCA / sinTheta;
                mat[1][2] = 0.0;
                mat[2][0] = 0.0;
                mat[2][1] = 0.0;
                mat[2][2] = 1.0;
                return new Matrix(mat).transpose();
            }
            System.out.println("zNCA is 1 or -1");
            System.exit(0);
        } else {
            beta1 = Math.acos(zNH);
            double sinAlpha = yNH / Math.sin(beta1);
            double cosAlpha = xNH / Math.sin(beta1);
            alpha1 = cosAlpha >= 0.0 ? Math.asin(sinAlpha) : Math.PI - Math.asin(sinAlpha);
            double sinGamma = (zNCA + Math.cos(beta1) * Math.cos(theta)) / (Math.sin(theta) * Math.sin(beta1));
            double cosGamma = (yNCA * Math.cos(alpha1) - xNCA * Math.sin(alpha1)) / Math.sin(theta);
            gamma1 = cosGamma >= 0.0 ? Math.asin(sinGamma) : Math.PI - Math.asin(sinGamma);
        }
        Matrix mm = A.eulerMat(alpha1, beta1, gamma1);
        Matrix MM = A.rotationMat(Math.PI, "+y");
        return MM.times(mm);
    }

    public Matrix RgCal(double[] nToh, double[] nToca, boolean rightHand) {
        double[] n2h = this.dirCos(nToh);
        double[] n2ca = this.dirCos(nToca);
        double theta = Math.PI - this.interAngle(nToh, nToca);
        double xNH = n2h[0];
        double yNH = n2h[1];
        double zNH = n2h[2];
        double xNCA = n2ca[0];
        double yNCA = n2ca[1];
        double zNCA = n2ca[2];
        double[][] mat = new double[3][3];
        double sinTheta = 9.99;
        Matrix A = new Matrix(3, 3);
        double alpha1 = 9.99;
        double beta1 = 9.99;
        double gamma1 = 9.99;
        if (Math.abs(zNH - 1.0) < 1.0E-4) {
            if (Math.abs(zNCA - 1.0) > 1.0E-4 && Math.abs(zNCA + 1.0) > 1.0E-4) {
                sinTheta = Math.sqrt(1.0 - zNCA * zNCA);
                mat[0][0] = yNCA / sinTheta;
                mat[0][1] = xNCA / sinTheta;
                mat[0][2] = 0.0;
                mat[1][0] = -xNCA / sinTheta;
                mat[1][1] = yNCA / sinTheta;
                mat[1][2] = 0.0;
                mat[2][0] = 0.0;
                mat[2][1] = 0.0;
                mat[2][2] = 1.0;
                return new Matrix(mat).transpose();
            }
            System.out.println("zNCA is 1 or -1");
            System.exit(0);
        } else {
            if (Math.abs(zNH + 1.0) < 1.0E-4) {
                mat[0][0] = -yNCA / sinTheta;
                mat[0][1] = xNCA / sinTheta;
                mat[0][2] = 0.0;
                mat[1][0] = xNCA / sinTheta;
                mat[1][1] = yNCA / sinTheta;
                mat[1][2] = 0.0;
                mat[2][0] = 0.0;
                mat[2][1] = 0.0;
                mat[2][2] = 1.0;
                return new Matrix(mat).transpose();
            }
            beta1 = Math.acos(zNH);
            double sinAlpha = yNH / Math.sin(beta1);
            double cosAlpha = xNH / Math.sin(beta1);
            if (cosAlpha > 0.0 || cosAlpha == 0.0) {
                alpha1 = Math.asin(sinAlpha);
            } else if (cosAlpha < 0.0) {
                alpha1 = Math.PI - Math.asin(sinAlpha);
            }
            double sinGamma = (zNCA + Math.cos(beta1) * Math.cos(theta)) / (Math.sin(theta) * Math.sin(beta1));
            double cosGamma = (yNCA * Math.cos(alpha1) - xNCA * Math.sin(alpha1)) / Math.sin(theta);
            if (cosGamma > 0.0 || cosGamma == 0.0) {
                gamma1 = Math.asin(sinGamma);
            } else if (cosGamma < 0.0) {
                gamma1 = Math.PI - Math.asin(sinGamma);
            }
        }
        Matrix MM = A.rotationMat(Math.PI, "+y");
        Matrix mm = A.eulerMat(alpha1, beta1, gamma1);
        if (rightHand) {
            return MM.times(mm);
        }
        return Const.mLeftHand.times(MM.times(mm));
    }

    public boolean quadraticSolve(double[] coefs, double[] solutions) {
        double b = coefs[1];
        double a = coefs[2];
        double c = coefs[0];
        if (b * b - 4.0 * a * c < 0.0) {
            return false;
        }
        if (a != 0.0) {
            solutions[0] = 0.5 * (-b + Math.sqrt(b * b - 4.0 * a * c)) / a;
            solutions[1] = 0.5 * (-b - Math.sqrt(b * b - 4.0 * a * c)) / a;
            return true;
        }
        if (b == 0.0) {
            return false;
        }
        solutions[0] = -c / b;
        solutions[1] = -c / b;
        return true;
    }

    public Vector phiCalNoe(double d) {
        double e0 = Const.e0 - d * d;
        double[] coefs = new double[]{Const.e1 + e0, 2.0 * Const.e2, e0 - Const.e1};
        double[] solutions = new double[2];
        boolean hasSln = this.quadraticSolve(coefs, solutions);
        Vector<Double> phiVec = new Vector<Double>();
        if (hasSln) {
            double t = 0.0;
            double sinPhi = 0.0;
            double cosPhi = 0.0;
            double phi = 0.0;
            int i = 0;
            while (i < solutions.length) {
                t = solutions[i];
                sinPhi = 2.0 * t / (1.0 + t * t);
                cosPhi = (1.0 - t * t) / (1.0 + t * t);
                phi = cosPhi >= 0.0 ? Math.asin(sinPhi) : Math.PI - Math.asin(sinPhi);
                while (phi > Math.PI) {
                    phi -= Math.PI * 2;
                }
                phiVec.add(new Double(phi));
                ++i;
            }
        }
        return phiVec;
    }

    public Vector psiCalNoe(double d) {
        double e0 = Const.ee0 - d * d;
        double[] coefs = new double[]{Const.ee1 + e0, 2.0 * Const.ee2, e0 - Const.ee1};
        double[] solutions = new double[2];
        boolean hasSln = this.quadraticSolve(coefs, solutions);
        Vector<Double> psiVec = new Vector<Double>();
        if (hasSln) {
            double t = 0.0;
            double sinPhi = 0.0;
            double cosPhi = 0.0;
            double psi = 0.0;
            int i = 0;
            while (i < solutions.length) {
                t = solutions[i];
                sinPhi = 2.0 * t / (1.0 + t * t);
                cosPhi = (1.0 - t * t) / (1.0 + t * t);
                psi = cosPhi >= 0.0 ? Math.asin(sinPhi) : Math.PI - Math.asin(sinPhi);
                while (psi > Math.PI) {
                    psi -= Math.PI * 2;
                }
                psiVec.add(new Double(psi));
                ++i;
            }
        }
        return psiVec;
    }

    public void testNOEs() {
        int i = 0;
        boolean j = false;
        boolean k = false;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Vector phiPsiVec = new Vector();
        int resolution = 2;
        Matrix rg = Matrix.identity(3, 3);
        double d = 2.5328777490734073;
        Vector phiVec = this.phiCalNoe(d);
        System.out.println("# Solutions for Phi: " + phiVec.size());
        if (phiVec.isEmpty()) {
            System.out.println("No Solutions for Phi");
        } else {
            i = 0;
            while (i < phiVec.size()) {
                System.out.println(String.valueOf((Double)phiVec.elementAt(i)) + "  " + (Double)phiVec.elementAt(i) / (Math.PI / 180));
                ++i;
            }
        }
        double phi = 0.0;
        d = 3.2679550115635974;
        Vector psiVec = this.psiCalNoe(d);
        System.out.println("# Solutions for Psi: " + psiVec.size());
        if (psiVec.isEmpty()) {
            System.out.println("No Solutions for Psi");
        } else {
            i = 0;
            while (i < psiVec.size()) {
                System.out.println(String.valueOf((Double)psiVec.elementAt(i)) + "  " + (Double)psiVec.elementAt(i) / (Math.PI / 180));
                ++i;
            }
        }
    }

    public void noeDisVsPhi() {
        Matrix r2yInv = new Matrix(3, 3);
        Matrix matT = new Matrix(3, 3);
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Matrix rg = Matrix.identity(3, 3);
        Matrix rgInv = rg.transpose();
        double[] coordHA = new double[]{0.0, 0.0, 1.09};
        double[] cntVec = Const.rHA2HA1Inv.times(coordHA);
        double phi = 0.0;
        double psi = 0.0;
        double[] caToHAVec = new double[3];
        double[] interNucVec = new double[3];
        double noeDis = 0.0;
        int i = 0;
        while (i < 360) {
            phi = (double)i * Math.PI / 180.0 - Math.PI;
            r2yInv = rg.rotationMat(phi, "-y");
            matT = rgInv.times(Const.r1x9yInv.times(r2yInv));
            caToHAVec = matT.times(cntVec);
            coordHA = this.addCoords(caToHAVec, ca1);
            interNucVec = this.internuclearVec(nh1, coordHA);
            noeDis = this.length(interNucVec);
            System.out.println(String.valueOf(phi) + "  " + noeDis);
            ++i;
        }
    }

    public double dnaIntra(double phi) {
        Matrix mat = Matrix.identity(3, 3);
        double[] ca = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Matrix r2yInv = mat.rotationMat(phi, "-y");
        double[] caToHAVec = Const.r1x9yInv.times(r2yInv.times(Const.cntHAVec));
        double[] coordHA = this.addCoords(caToHAVec, ca);
        double[] interNucVec = new double[]{coordHA[0], coordHA[1], coordHA[2] + 1.02};
        return this.length(interNucVec);
    }

    public double danSeq(double[] ha, double[] co, double psi) {
        Matrix mat = new Matrix(3, 3);
        Matrix r4zInv = mat.rotationMat(psi + Math.PI, "-z");
        mat = Const.r1x9y3xInv.times(r4zInv.times(Const.r5xInv));
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        double[] co1ToNVec = mat.times(coordN);
        coordN = this.addCoords(co, co1ToNVec);
        double[] nh = new double[]{0.0, 0.0, -1.02};
        mat = mat.times(Const.r7x6yInv);
        double[] nToNHVec2 = mat.times(nh);
        nh = this.addCoords(coordN, nToNHVec2);
        double[] interNucVec = new double[]{-ha[0], -ha[1], -1.02 - ha[2]};
        return this.length(interNucVec);
    }

    public double dNNseq(double phi, double psi) {
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Matrix rg = Matrix.identity(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        Matrix matT = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv));
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = matT.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca1);
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        matT = matT.times(r4zInv.times(Const.r5xInv));
        double[] co1ToNVec = matT.times(coordN);
        coordN = this.addCoords(coordCO, co1ToNVec);
        double[] coordNH = new double[]{0.0, 0.0, -1.02};
        matT = matT.times(Const.r7x6yInv);
        double[] nToNHVec2 = matT.times(coordNH);
        coordNH = this.addCoords(coordN, nToNHVec2);
        double dnn = this.length(this.internuclearVec(nh1, coordNH));
        return dnn;
    }

    public void noeDisVsPsi() {
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Matrix rg = Matrix.identity(3, 3);
        Matrix rgInv = rg.transpose();
        double phi = 0.0;
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix matT = rgInv.times(Const.r1x9yInv.times(r2yInv));
        double[] coordHA = new double[]{0.0, 0.0, 1.09};
        double[] cntVec = Const.rHA2HA1Inv.times(coordHA);
        double[] caToHAVec = matT.times(cntVec);
        coordHA = this.addCoords(caToHAVec, ca1);
        Matrix matCnt = matT.times(Const.r3xInv);
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = matCnt.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca1);
        double psi = 0.0;
        Matrix r4zInv = new Matrix(3, 3);
        double[] interNucVec = new double[3];
        double noeDis = 0.0;
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        double[] coordCA = new double[]{0.0, 1.458, 0.0};
        double[] coordN2 = new double[]{0.0, 1.329, 0.0};
        double[] coordCA2 = new double[]{0.0, 1.458, 0.0};
        double[] co1ToNVec = new double[3];
        double[] nToNHVec2 = new double[3];
        double[] nToCAVec = new double[3];
        double[] coordNH = new double[3];
        int i = 0;
        while (i < 720) {
            psi = (double)i * Math.PI / 360.0 - Math.PI;
            r4zInv = rg.rotationMat(psi + Math.PI, "-z");
            matT = matCnt.times(r4zInv.times(Const.r5xInv));
            co1ToNVec = matT.times(coordN);
            coordN2 = this.addCoords(coordCO, co1ToNVec);
            matT = matT.times(Const.r6yInv.times(Const.r7xInv));
            nToNHVec2 = matT.times(nh1);
            coordNH = this.addCoords(coordN2, nToNHVec2);
            interNucVec = this.internuclearVec(coordHA, coordNH);
            noeDis = this.length(interNucVec);
            System.out.println(String.valueOf(psi) + "  " + noeDis);
            ++i;
        }
    }

    public double dCaCa(double phi, double psi) {
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Matrix rg = Matrix.identity(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        Matrix matT = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv));
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = matT.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca1);
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        matT = matT.times(r4zInv.times(Const.r5xInv));
        double[] co1ToNVec = matT.times(coordN);
        coordN = this.addCoords(coordCO, co1ToNVec);
        double[] coordCA = new double[]{0.0, 1.458, 0.0};
        double[] nToCAVec = matT.times(Const.r8zInv.times(Const.r1xInv.times(coordCA)));
        coordCA = this.addCoords(coordN, nToCAVec);
        double dnn = this.length(this.internuclearVec(ca1, coordCA));
        return dnn;
    }

    public boolean dirCaCa(double[] ca1, double[] ca3, double theta2, double[][] solutions) {
        double c1 = (ca3[0] - ca1[0]) / 3.8100448409449443;
        double c2 = (ca3[1] - ca1[1]) / 3.8100448409449443;
        double c3 = (ca3[2] - ca1[2]) / 3.8100448409449443;
        double cosTheta2 = Math.cos(theta2);
        double sinTheta2 = Math.sin(theta2);
        if (Math.abs(c3 - cosTheta2) > 1.0) {
            return false;
        }
        double theta3 = Math.acos(c3 - cosTheta2);
        double sinTheta3 = Math.sin(theta3);
        if (sinTheta2 == 0.0 || sinTheta3 == 0.0) {
            return false;
        }
        double[] phi0Arr = new double[2];
        double[] phi1Arr = new double[2];
        double sinPhi1 = 0.0;
        double cosPhi1 = 0.0;
        double phiCnt = 0.0;
        double sinPhiCnt = 0.0;
        double cosPhiCnt = 0.0;
        double c = 1.0;
        double sinPhi0 = 0.0;
        double cosPhi0 = 0.5 * (c1 * c1 + c2 * c2 - sinTheta2 * sinTheta2 - sinTheta3 * sinTheta3) / (sinTheta2 * sinTheta3);
        double c1Cal = 0.0;
        double c2Cal = 0.0;
        double phi2 = 0.0;
        double phi3 = 0.0;
        if (Math.abs(cosPhi0) > 1.0) {
            return false;
        }
        phi0Arr[0] = Math.acos(cosPhi0);
        phi0Arr[1] = -phi0Arr[0];
        int j = 0;
        while (j < 2) {
            sinPhi0 = Math.sin(phi0Arr[j]);
            c = Math.sqrt((sinTheta2 * cosPhi0 + sinTheta3) * (sinTheta2 * cosPhi0 + sinTheta3) + sinTheta2 * sinTheta2 * sinPhi0 * sinPhi0);
            if (c == 0.0 || Math.abs(c1 / c) > 1.0) {
                System.out.println("kk04");
                return false;
            }
            sinPhiCnt = (sinTheta2 * cosPhi0 + sinTheta3) / c;
            cosPhiCnt = sinTheta2 * sinPhi0 / c;
            if (cosPhiCnt >= 0.0) {
                phiCnt = Math.asin(sinPhiCnt);
            } else if (cosPhiCnt < 0.0) {
                phiCnt = Math.PI - Math.asin(sinPhiCnt);
            }
            phi1Arr[0] = Math.asin(c1 / c);
            phi1Arr[1] = Math.PI - phi1Arr[0];
            int k = 0;
            while (k < 2) {
                phi2 = phiCnt - phi1Arr[k] + phi0Arr[j];
                phi3 = phiCnt - phi1Arr[k];
                if (phi2 < 0.0) {
                    phi2 += Math.PI * 2;
                }
                if (phi3 < 0.0) {
                    phi3 += Math.PI * 2;
                }
                if (Math.abs((c2Cal = sinTheta2 * Math.sin(phi2) + sinTheta3 * Math.sin(phi3)) - c2) < 1.0E-4) {
                    solutions[j][0] = phi2;
                    solutions[j][1] = theta3;
                    solutions[j][2] = phi3;
                }
                ++k;
            }
            ++j;
        }
        return true;
    }

    public double[] caByNextPeptidePlane(double[] n1, Matrix rg) {
        Matrix rgInv = rg.transpose();
        double[] n2coCnt = new double[]{0.0, 0.0, 1.329};
        double[] n2co = rgInv.times(Const.r9z1xAlphaInv.times(n2coCnt));
        double[] coCal = this.addCoords(n1, n2co);
        double[] co2caCnt = new double[]{0.0, 0.0, 1.525};
        Matrix mat = rgInv.times(Const.r9z1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv)));
        double[] co2ca = mat.times(co2caCnt);
        return this.addCoords(coCal, co2ca);
    }

    public void testDirCaCa() {
        int i = 0;
        int j = 0;
        double[] n = new double[]{0.0, 0.0, 0.0};
        double[] nh = new double[]{0.0, 0.0, -1.02};
        double[] ca = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        ModelRdc mdc = new ModelRdc();
        int firstResidueNo = 1;
        int lastResidueNo = 11;
        int N = lastResidueNo - firstResidueNo;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", -1.1397000015522971, -0.6876597252857658));
            ++i;
        }
        Vector pdbVec = mdc.modelBuild(phiPsiVec, n, nh, ca);
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] co1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        double[] amide3 = new double[3];
        double[] nh3 = new double[3];
        double[] ca3 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = (Pdb)pdbVec.elementAt(1);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide1, nh1);
        double[] nToCAVec = this.internuclearVec(amide1, ca1);
        Matrix rg = this.RgCal(nToNHVec, nToCAVec);
        pp = (Pdb)pdbVec.elementAt(2);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh2 = cc.getXYZ();
            }
            ++j;
        }
        pp = (Pdb)pdbVec.elementAt(3);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide3 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca3 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh3 = cc.getXYZ();
            }
            ++j;
        }
        double[] ca2caVec = this.internuclearVec(ca1, ca2);
        double theta2 = Math.acos(ca2caVec[2] / 3.8100448409449443);
        double sinPhiCnt = ca2caVec[1] / (3.8100448409449443 * Math.sin(theta2));
        double cosPhiCnt = ca2caVec[0] / (3.8100448409449443 * Math.sin(theta2));
        double phiCnt = 0.0;
        if (cosPhiCnt >= 0.0) {
            phiCnt = Math.asin(sinPhiCnt);
        } else if (cosPhiCnt < 0.0) {
            phiCnt = Math.PI - Math.asin(sinPhiCnt);
        }
        if (phiCnt < 0.0) {
            phiCnt += Math.PI * 2;
        }
        ca2caVec = this.internuclearVec(ca2, ca3);
        double theta3 = Math.acos(ca2caVec[2] / 3.8100448409449443);
        double[][] solutions = new double[2][3];
        boolean hasSolutions = this.dirCaCa(ca1, ca3, theta2, solutions);
        double[] ca2Cal = new double[3];
        double[] ca3Cal = new double[3];
        double[] ca2caDir = new double[3];
        i = 0;
        while (i < 2) {
            double phi2 = solutions[i][0];
            theta3 = solutions[i][1];
            double phi3 = solutions[i][2];
            ca2caDir[0] = 3.8100448409449443 * Math.sin(theta2) * Math.cos(phi2);
            ca2caDir[1] = 3.8100448409449443 * Math.sin(theta2) * Math.sin(phi2);
            ca2caDir[2] = 3.8100448409449443 * Math.cos(theta2);
            ca2Cal = this.addCoords(ca1, ca2caDir);
            ca2caDir[0] = 3.8100448409449443 * Math.sin(theta3) * Math.cos(phi3);
            ca2caDir[1] = 3.8100448409449443 * Math.sin(theta3) * Math.sin(phi3);
            ca2caDir[2] = 3.8100448409449443 * Math.cos(theta3);
            ca3Cal = this.addCoords(ca2Cal, ca2caDir);
            ++i;
        }
    }

    public boolean phiPsiByCa(Matrix rg, double[] cacaVec, double[][] solutions) {
        double sinTheta3 = Math.sin(-0.36538467890501286);
        double cosTheta3 = Math.cos(-0.36538467890501286);
        double[] dirC = Const.r9y1x.times(rg.times(cacaVec));
        double cx = dirC[0];
        double cy = dirC[1];
        double cz = dirC[2];
        double ax = Const.dirA[0];
        double ay = Const.dirA[1];
        double az = Const.dirA[2];
        double bx = Const.dirB[0];
        double by = Const.dirB[1];
        double bz = Const.dirB[2];
        double cyCal = ay - bz * sinTheta3 - bx * cosTheta3 * Math.sin(-0.6876597252857658) - by * cosTheta3 * Math.cos(-0.6876597252857658);
        double d = cosTheta3 * Math.sqrt(bx * bx + by * by);
        if (Math.abs((ay - bz * sinTheta3 - cy) / d) > 1.0) {
            return false;
        }
        double psi1 = Math.asin((ay - bz * sinTheta3 - cy) / d) - Const.psiC;
        if (psi1 < -Math.PI) {
            psi1 += Math.PI * 2;
        } else if (psi1 > Math.PI) {
            psi1 -= Math.PI * 2;
        }
        double psi2 = Math.PI - Math.asin((ay - bz * sinTheta3 - cy) / d) - Const.psiC;
        if (psi2 < -Math.PI) {
            psi2 += Math.PI * 2;
        } else if (psi2 > Math.PI) {
            psi2 -= Math.PI * 2;
        }
        double[] psiArr = new double[]{psi1, psi2};
        double psi = 0.0;
        double phi0 = 0.0;
        double[] phi1Arr = new double[2];
        double[] phiArr = new double[2];
        double phi = 0.0;
        double czCal = 0.0;
        int i = 0;
        while (i < 2) {
            double b;
            psi = psiArr[i];
            double a = ax - bx * Math.cos(psi) + by * Math.sin(psi);
            d = Math.sqrt(a * a + (b = az - bx * sinTheta3 * Math.sin(psi) - by * sinTheta3 * Math.cos(psi) + bz * cosTheta3) * b);
            if (d == 0.0 || Math.abs(cx / d) > 1.0) {
                return false;
            }
            double sinPhi0 = a / d;
            double cosPhi0 = b / d;
            if (cosPhi0 >= 0.0) {
                phi0 = Math.asin(sinPhi0);
            } else if (cosPhi0 < 0.0) {
                phi0 = Math.PI - Math.asin(sinPhi0);
            }
            phi1Arr[0] = Math.asin(cx / d);
            phi1Arr[1] = Math.PI - phi1Arr[0];
            double phi1 = phi1Arr[0] - phi0;
            if (phi1 < -Math.PI) {
                phi1 += Math.PI * 2;
            } else if (phi1 > Math.PI) {
                phi1 -= Math.PI * 2;
            }
            double phi2 = phi1Arr[1] - phi0;
            if (phi2 < -Math.PI) {
                phi2 += Math.PI * 2;
            } else if (phi2 > Math.PI) {
                phi2 -= Math.PI * 2;
            }
            phiArr[0] = phi1;
            phiArr[1] = phi2;
            int j = 0;
            while (j < 2) {
                phi = phiArr[j];
                czCal = -ax * Math.sin(phi) + az * Math.cos(phi) + bx * (Math.sin(phi) * Math.cos(psi) - sinTheta3 * Math.cos(phi) * Math.sin(psi)) - by * (Math.sin(phi) * Math.sin(psi) + sinTheta3 * Math.cos(phi) * Math.cos(psi)) + bz * cosTheta3 * Math.cos(phi);
                if (Math.abs(czCal - cz) < 1.0E-4) {
                    solutions[i][0] = phi;
                    solutions[i][1] = psi;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public Vector turnByCaCa(Vector h1Vec, Vector asgVec, Vector pdbVec1, Vector pdbVec2, Vector rdcVec1, Vector rdcVec2, double Syy, double Szz, int no1, int no2, double a1, double a2) {
        boolean i = false;
        int j = 0;
        int k = 0;
        PhiPsi ff = new PhiPsi();
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        double[] amide3 = new double[3];
        double[] nh3 = new double[3];
        double[] ca3 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        int index = Collections.binarySearch(pdbVec1, new Pdb(no1), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("Error in the PDB file 1");
            return new Vector();
        }
        Pdb pp = (Pdb)pdbVec1.elementAt(index);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide1, nh1);
        double[] nToCAVec = this.internuclearVec(amide1, ca1);
        Matrix rg = this.RgCal(nToNHVec, nToCAVec);
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        phiPsiVec.add(new PhiPsi(no1, "ALA", -1.8690487073077084, 1.19895573617919));
        phiPsiVec.add(new PhiPsi(++no1, "ALA", 0.4860507350995962, -0.35489809607846956));
        phiPsiVec.add(new PhiPsi(++no1, "ALA", -1.9907688476363932, -1.1374529481996267));
        ModelRdc mdc = new ModelRdc();
        boolean isLink = true;
        Vector pdbVecN = mdc.modelBuild(phiPsiVec, amide1, nh1, ca1, isLink);
        Collections.sort(pdbVec1, new Pdb.PdbComparator());
        Matrix rgInv = rg.transpose();
        index = Collections.binarySearch(pdbVec2, new Pdb(no2), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("Error in the PDB file 2");
            return new Vector();
        }
        pp = (Pdb)pdbVec2.elementAt(index);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide3 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca3 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh3 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec4 = this.internuclearVec(amide3, nh3);
        double[] nToCAVec4 = this.internuclearVec(amide3, ca3);
        Matrix rg2 = this.RgCal(nToNHVec4, nToCAVec4);
        double[] ca3CalCnt = this.caByNextPeptidePlane(amide3, rg2);
        double[] ca3Toca4DirT = this.internuclearVec(ca3CalCnt, ca3);
        double dd = this.length(ca3Toca4DirT);
        double[] ca3Toca4Dir = new double[]{ca3Toca4DirT[0] * 3.8100448409449443 / dd, ca3Toca4DirT[1] * 3.8100448409449443 / dd, ca3Toca4DirT[2] * 3.8100448409449443 / dd};
        System.out.println(dd);
        double resolution = 0.5;
        double theta1 = 0.0;
        double phi1 = 0.0;
        double theta2 = 0.0;
        double phi2 = 0.0;
        double theta3 = 0.0;
        double phi3 = 0.0;
        double[] ca1Cal = new double[3];
        double[] ca1Dir = new double[3];
        double[] ca2Cal = new double[3];
        double[] ca4Cal = new double[3];
        double[] ca2Dir = new double[3];
        double[] ca3Cal = new double[3];
        double[] ca3Dir = new double[3];
        double[][] solutions = new double[2][3];
        double[][] phiPsiSolutions1 = new double[2][2];
        double[][] phiPsiSolutions2 = new double[2][2];
        double[][] phiPsiSolutions3 = new double[2][2];
        int ss = 0;
        double phi1BB = 0.0;
        double psi1BB = 0.0;
        double[] nh2Dir = new double[3];
        double[] nh3Dir = new double[3];
        double[] nh4Dir = new double[3];
        double[] nh2Coord = new double[3];
        double[] nh3Coord = new double[3];
        double[] nh4Coord = new double[3];
        double[] ha1Dir = new double[3];
        double[] ha2Dir = new double[3];
        double[] ha3Dir = new double[3];
        double[] ha1Coord = new double[3];
        double[] ha2Coord = new double[3];
        double[] ha3Coord = new double[3];
        double phi2BB = 0.0;
        double psi2BB = 0.0;
        double phi3BB = 0.0;
        double psi3BB = 0.0;
        Matrix mat1 = new Matrix(3, 3);
        Matrix mat2 = new Matrix(3, 3);
        Matrix r2yInv1 = new Matrix(3, 3);
        Matrix r4zInv1 = new Matrix(3, 3);
        Matrix r2yInv2 = new Matrix(3, 3);
        Matrix r4zInv2 = new Matrix(3, 3);
        Matrix r2yInv3 = new Matrix(3, 3);
        Matrix r4zInv3 = new Matrix(3, 3);
        k = 0;
        while ((double)k < 180.0 / resolution) {
            theta2 = (double)k * resolution * Math.PI / 180.0;
            boolean hasSolutions = this.dirCaCa(ca1, ca3CalCnt, theta2, solutions);
            if (hasSolutions) {
                ss = 0;
                while (ss < 2) {
                    phi2 = solutions[ss][0];
                    ca2Dir[0] = 3.8100448409449443 * Math.sin(theta2) * Math.cos(phi2);
                    ca2Dir[1] = 3.8100448409449443 * Math.sin(theta2) * Math.sin(phi2);
                    ca2Dir[2] = 3.8100448409449443 * Math.cos(theta2);
                    boolean hasPhiPsi = this.phiPsiByCa(rg, ca2Dir, phiPsiSolutions1);
                    if (hasPhiPsi) {
                        ca2Cal = this.addCoords(ca1, ca2Dir);
                        theta3 = solutions[ss][1];
                        phi3 = solutions[ss][2];
                        ca3Dir[0] = 3.8100448409449443 * Math.sin(theta3) * Math.cos(phi3);
                        ca3Dir[1] = 3.8100448409449443 * Math.sin(theta3) * Math.sin(phi3);
                        ca3Dir[2] = 3.8100448409449443 * Math.cos(theta3);
                        ca3Cal = this.addCoords(ca2Cal, ca3Dir);
                        ca4Cal = this.addCoords(ca3Cal, ca3Toca4Dir);
                        int tt = 0;
                        while (tt < 2) {
                            phi1BB = phiPsiSolutions1[tt][0];
                            psi1BB = phiPsiSolutions1[tt][1];
                            mat1 = this.newRG(phi1BB, psi1BB, rg);
                            hasPhiPsi = this.phiPsiByCa(mat1, ca3Dir, phiPsiSolutions2);
                            if (hasPhiPsi) {
                                int qq = 0;
                                while (qq < 2) {
                                    phi2BB = phiPsiSolutions2[qq][0];
                                    psi2BB = phiPsiSolutions2[qq][1];
                                    mat2 = this.newRG(phi2BB, psi2BB, mat1);
                                    hasPhiPsi = this.phiPsiByCa(mat2, ca3Toca4Dir, phiPsiSolutions3);
                                    if (hasPhiPsi) {
                                        int u = 0;
                                        while (u < 2) {
                                            phi3BB = phiPsiSolutions3[u][0];
                                            psi3BB = phiPsiSolutions3[u][1];
                                            r2yInv3 = rg.rotationMat(phi3BB, "-y");
                                            r4zInv3 = rg.rotationMat(psi3BB + Math.PI, "-z");
                                            nh4Dir = mat2.transpose().times(Const.r1x9yInv.times(r2yInv3.times(Const.r3xInv.times(r4zInv3.times(Const.matRNH)))));
                                            if (this.interAngle(nh4Dir, nToNHVec4) < Math.PI / 360) {
                                                System.out.println(String.valueOf(phi1BB) + "  " + psi1BB);
                                                System.out.println(String.valueOf(phi2BB) + "  " + psi2BB);
                                                System.out.println(String.valueOf(phi3BB) + "  " + psi3BB);
                                                System.out.println(this.interAngle(nh4Dir, nToNHVec4) / (Math.PI / 180));
                                            }
                                            ++u;
                                        }
                                    }
                                    ++qq;
                                }
                            }
                            ++tt;
                        }
                    }
                    ++ss;
                }
            }
            ++k;
        }
        return new Vector();
    }

    public Vector longTurn(Vector h1Vec, Vector asgVec, Vector pdbVec1, Vector pdbVec2, Vector rdcVec1, Vector rdcVec2, double Syy, double Szz, int no1, int no2, double a1, double a2) {
        int i = 0;
        int j = 0;
        boolean k = false;
        PhiPsi ff = new PhiPsi();
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] amide3 = new double[3];
        double[] nh3 = new double[3];
        double[] ca3 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        int index = Collections.binarySearch(pdbVec1, new Pdb(no1), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("Error in the PDB file 1");
            return new Vector();
        }
        Pdb pp = (Pdb)pdbVec1.elementAt(index);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        phiPsiVec.add(new PhiPsi(no1, "ALA", -2.3459797068036274, -1.0074042391114535));
        phiPsiVec.add(new PhiPsi(++no1, "ALA", -1.1344640137963142, -2.896526774209493));
        phiPsiVec.add(new PhiPsi(++no1, "ALA", -0.6536351104162039, -1.8651676752987254));
        phiPsiVec.add(new PhiPsi(++no1, "ALA", -2.827096526295202, -1.541907976458233));
        phiPsiVec.add(new PhiPsi(++no1, "ALA", 1.4819369120738939, 1.896621252342314));
        ModelRdc mdc = new ModelRdc();
        boolean isLink = true;
        Vector pdbVecN = mdc.modelBuild(phiPsiVec, amide1, nh1, ca1, isLink);
        pp.print(pdbVecN);
        pp.print(pdbVec1);
        double[] nToNHVec = this.internuclearVec(amide1, nh1);
        double[] nToCAVec = this.internuclearVec(amide1, ca1);
        Matrix rg = this.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv = rg.transpose();
        index = Collections.binarySearch(pdbVec2, new Pdb(no2), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("Error in the PDB file 2");
            return new Vector();
        }
        pp = (Pdb)pdbVec2.elementAt(index);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide3 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca3 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh3 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec4 = this.internuclearVec(amide3, nh3);
        double[] nToCAVec4 = this.internuclearVec(amide3, ca3);
        double ca18To23 = this.length(this.internuclearVec(ca1, ca3));
        Matrix rg3 = this.RgCal(nToNHVec4, nToCAVec4);
        double[] caCal = this.caByNextPeptidePlane(amide3, rg3);
        double[] caTocaDirT = this.internuclearVec(caCal, ca3);
        double dd = this.length(caTocaDirT);
        double[] ca3Toca4Dir = new double[]{caTocaDirT[0] * 3.8100448409449443 / dd, caTocaDirT[1] * 3.8100448409449443 / dd, caTocaDirT[2] * 3.8100448409449443 / dd};
        double[] ca22Cal = new double[]{ca3[0] - ca3Toca4Dir[0], ca3[1] - ca3Toca4Dir[1], ca3[2] - ca3Toca4Dir[2]};
        double ca18To22 = this.length(this.internuclearVec(ca1, ca22Cal));
        System.out.println(String.valueOf(ca18To23) + " CA DIS  " + ca18To22);
        double theta1 = 0.0;
        double phi1 = 0.0;
        double theta2 = 0.0;
        double phi2 = 0.0;
        double theta3 = 0.0;
        double phi3 = 0.0;
        double[] ca1Cal = new double[3];
        double[] ca1Dir = new double[3];
        double[] ca2Cal = new double[3];
        double[] ca4Cal = new double[3];
        double[] ca2Dir = new double[3];
        double[] ca3Cal = new double[3];
        double[] ca3Dir = new double[3];
        double[][] solutions = new double[2][3];
        double[][] phiPsiSolutions = new double[2][2];
        double[][] phiPsiSolutions1 = new double[2][2];
        double[][] phiPsiSolutions2 = new double[2][2];
        double[][] phiPsiSolutions3 = new double[2][2];
        int ss = 0;
        double phiBB = 0.0;
        double psiBB = 0.0;
        double phi1BB = 0.0;
        double psi1BB = 0.0;
        double[] nh2Dir = new double[3];
        double[] nh3Dir = new double[3];
        double[] nh4Dir = new double[3];
        double[] nh2Coord = new double[3];
        double[] nh3Coord = new double[3];
        double[] nh4Coord = new double[3];
        double[] ha1Dir = new double[3];
        double[] ha2Dir = new double[3];
        double[] ha3Dir = new double[3];
        double[] ha1Coord = new double[3];
        double[] ha2Coord = new double[3];
        double[] ha3Coord = new double[3];
        double phi2BB = 0.0;
        double psi2BB = 0.0;
        double phi3BB = 0.0;
        double psi3BB = 0.0;
        Matrix mat1 = new Matrix(3, 3);
        Matrix mat2 = new Matrix(3, 3);
        Matrix r2yInv1 = new Matrix(3, 3);
        Matrix r4zInv1 = new Matrix(3, 3);
        Matrix r2yInv2 = new Matrix(3, 3);
        Matrix r4zInv2 = new Matrix(3, 3);
        Matrix r2yInv3 = new Matrix(3, 3);
        Matrix r4zInv3 = new Matrix(3, 3);
        Matrix rg19 = new Matrix(3, 3);
        Matrix rg20 = new Matrix(3, 3);
        double[] ca19 = new double[3];
        double[] ca20 = new double[3];
        double[] caDir20 = new double[3];
        long seed = 738578932L;
        Random rr = new Random(seed);
        int nCycle = 1;
        double[] ca2caTmp = new double[3];
        i = 0;
        while (i < nCycle) {
            double theta19 = Math.PI * rr.nextDouble();
            double phi19 = Math.PI * 2 * rr.nextDouble();
            ca19[0] = ca1[0] + 3.8100448409449443 * Math.sin(theta19) * Math.cos(phi19);
            ca19[1] = ca1[1] + 3.8100448409449443 * Math.sin(theta19) * Math.sin(phi19);
            ca19[2] = ca1[2] + 3.8100448409449443 * Math.cos(theta19);
            ca2caTmp = this.internuclearVec(ca19, ca22Cal);
            double ca2caDis = this.length(ca2caTmp);
            boolean hasPhiPsi = this.phiPsiByCa(rg, this.internuclearVec(ca1, ca19), phiPsiSolutions);
            if (hasPhiPsi) {
                int ii = 0;
                while (ii < 2) {
                    phiBB = phiPsiSolutions[ii][0];
                    psiBB = phiPsiSolutions[ii][1];
                    rg19 = this.newRG(phiBB, psiBB, rg);
                    double bbPhi19 = -1.1344640137963142;
                    double bbPsi19 = -Math.PI + Math.PI * 2 * rr.nextDouble();
                    caDir20 = this.ca2caDirCal(bbPhi19, bbPsi19, ca19, rg19);
                    ca20 = this.addCoords(ca19, caDir20);
                    ca2caTmp = this.internuclearVec(ca20, ca22Cal);
                    ca2caDis = this.length(ca2caTmp);
                    rg20 = this.newRG(bbPhi19, bbPsi19, rg19);
                    theta2 = Math.PI * rr.nextDouble();
                    boolean hasSolutions = this.dirCaCa(ca20, ca22Cal, theta2, solutions);
                    if (hasSolutions) {
                        ss = 0;
                        while (ss < 2) {
                            phi2 = solutions[ss][0];
                            ca2Dir[0] = 3.8100448409449443 * Math.sin(theta2) * Math.cos(phi2);
                            ca2Dir[1] = 3.8100448409449443 * Math.sin(theta2) * Math.sin(phi2);
                            ca2Dir[2] = 3.8100448409449443 * Math.cos(theta2);
                            hasPhiPsi = this.phiPsiByCa(rg20, ca2Dir, phiPsiSolutions1);
                            if (hasPhiPsi) {
                                ca2Cal = this.addCoords(ca1, ca2Dir);
                                theta3 = solutions[ss][1];
                                phi3 = solutions[ss][2];
                                ca3Dir[0] = 3.8100448409449443 * Math.sin(theta3) * Math.cos(phi3);
                                ca3Dir[1] = 3.8100448409449443 * Math.sin(theta3) * Math.sin(phi3);
                                ca3Dir[2] = 3.8100448409449443 * Math.cos(theta3);
                                ca3Cal = this.addCoords(ca2Cal, ca3Dir);
                                ca4Cal = this.addCoords(ca3Cal, ca3Toca4Dir);
                                int tt = 0;
                                while (tt < 2) {
                                    phi1BB = phiPsiSolutions1[tt][0];
                                    psi1BB = phiPsiSolutions1[tt][1];
                                    mat1 = this.newRG(phi1BB, psi1BB, rg20);
                                    hasPhiPsi = this.phiPsiByCa(mat1, ca3Dir, phiPsiSolutions2);
                                    if (hasPhiPsi) {
                                        int qq = 0;
                                        while (qq < 2) {
                                            phi2BB = phiPsiSolutions2[qq][0];
                                            psi2BB = phiPsiSolutions2[qq][1];
                                            mat2 = this.newRG(phi2BB, psi2BB, mat1);
                                            hasPhiPsi = this.phiPsiByCa(mat2, ca3Toca4Dir, phiPsiSolutions3);
                                            if (hasPhiPsi) {
                                                int u = 0;
                                                while (u < 2) {
                                                    phi3BB = phiPsiSolutions3[u][0];
                                                    psi3BB = phiPsiSolutions3[u][1];
                                                    r2yInv3 = rg.rotationMat(phi3BB, "-y");
                                                    r4zInv3 = rg.rotationMat(psi3BB + Math.PI, "-z");
                                                    nh4Dir = mat2.transpose().times(Const.r1x9yInv.times(r2yInv3.times(Const.r3xInv.times(r4zInv3.times(Const.matRNH)))));
                                                    if (this.interAngle(nh4Dir, nToNHVec4) < Math.PI / 180) {
                                                        System.out.println(String.valueOf(phiBB) + "  " + psiBB);
                                                        System.out.println(String.valueOf(bbPhi19) + "  " + bbPsi19);
                                                        System.out.println(String.valueOf(phi1BB) + "  " + psi1BB);
                                                        System.out.println(String.valueOf(phi2BB) + "  " + psi2BB);
                                                        System.out.println(String.valueOf(phi3BB) + "  " + psi3BB);
                                                        System.out.println(this.interAngle(nh4Dir, nToNHVec4) / (Math.PI / 180));
                                                    }
                                                    ++u;
                                                }
                                            }
                                            ++qq;
                                        }
                                    }
                                    ++tt;
                                }
                            }
                            ++ss;
                        }
                    }
                    ++ii;
                }
            }
            ++i;
        }
        return new Vector();
    }

    public double[] ca2caDirCal(double phi, double psi, double[] ca1, Matrix rg) {
        Matrix rgInv = rg.transpose();
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        Matrix matT = rgInv.times(Const.r1x9yInv.times(r2yInv.times(Const.r3xInv)));
        double[] caToCOVec = matT.times(Const.ca2coVec);
        double[] coordCO = this.addCoords(caToCOVec, ca1);
        matT = matT.times(r4zInv.times(Const.r5xInv));
        double[] co1ToNVec = matT.times(Const.co2nVec);
        double[] coordN = this.addCoords(coordCO, co1ToNVec);
        double[] nToCAVec = matT.times(Const.r6y7x8z1xInv.times(Const.coordCA));
        double[] coordCA = this.addCoords(coordN, nToCAVec);
        double[] ca2ca = this.internuclearVec(ca1, coordCA);
        return ca2ca;
    }

    public void dNNtest() {
        double dnn = 0.0;
        double phi = 0.0;
        double psi = 0.0;
        int i = 0;
        while (i < 360) {
            phi = (double)i * Math.PI / 360.0 - Math.PI;
            int j = 0;
            while (j < 360) {
                psi = (double)j * Math.PI / 360.0 - Math.PI;
                dnn = this.dCaCa(phi, psi);
                System.out.println(String.valueOf(phi) + "  " + psi + "  " + dnn);
                ++j;
            }
            ++i;
        }
    }

    public void testPhiPsiByCa(Vector pdbVec) {
        int i = 0;
        int j = 0;
        double[] n = new double[]{0.0, 0.0, 0.0};
        double[] nh = new double[]{0.0, 0.0, -1.02};
        double[] ca = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        ModelRdc mdc = new ModelRdc();
        int firstResidueNo = 1;
        int lastResidueNo = 11;
        int N = lastResidueNo - firstResidueNo;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", -1.1397000015522971, 2.4085543677521746));
            ++i;
        }
        pdbVec = mdc.modelBuild(phiPsiVec, n, nh, ca);
        double phi = -1.1397000015522971;
        double psi = -0.6876597252857658;
        Matrix mat = new Matrix(3, 3);
        Matrix r2yInv = mat.rotationMat(phi, "-y");
        Matrix r4zInv = mat.rotationMat(psi + Math.PI, "-z");
        double[] dirA = r2yInv.times(Const.dirA);
        double[] dirB = r2yInv.times(Const.r3xInv.times(r4zInv.times(Const.dirB)));
        double[] ca2co = Const.r1x9yInv.times(dirA);
        double[] coCal = this.addCoords(ca, ca2co);
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] co1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = (Pdb)pdbVec.elementAt(1);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        pp = (Pdb)pdbVec.elementAt(2);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh2 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide2, nh2);
        double[] nToCAVec = this.internuclearVec(amide2, ca2);
        Matrix rg = this.RgCal(nToNHVec, nToCAVec);
    }

    public void nh2ca2Cal() {
        int i = 0;
        int j = 0;
        double[] n = new double[]{0.0, 0.0, 0.0};
        double[] nh = new double[]{0.0, 0.0, -1.02};
        double[] ca = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        ModelRdc mdc = new ModelRdc();
        int firstResidueNo = 1;
        int lastResidueNo = 11;
        int N = lastResidueNo - firstResidueNo;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", -1.1397000015522971, 2.4085543677521746));
            ++i;
        }
        double phi1 = 1.5707963267948966;
        double psi1 = -0.5759586531581288;
        double phi2 = 1.239183768915974;
        double psi2 = -1.0878637227680656;
        double phi3 = -3.325724889675195;
        double psi3 = 1.0471975511965976;
        phiPsiVec.setElementAt(new PhiPsi(firstResidueNo + 1, "ALA", phi1, psi1), 1);
        phiPsiVec.setElementAt(new PhiPsi(firstResidueNo + 2, "ALA", phi2, psi2), 2);
        phiPsiVec.setElementAt(new PhiPsi(firstResidueNo + 3, "ALA", phi3, psi3), 3);
        Vector pdbVec = mdc.modelBuild(phiPsiVec, n, nh, ca);
        Pdb pp = new Pdb();
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] ha1 = new double[3];
        double[] o1 = new double[3];
        double[] co1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        double[] ha2 = new double[3];
        double[] co2 = new double[3];
        double[] o2 = new double[3];
        double[] cb2 = new double[3];
        double[] amide3 = new double[3];
        double[] nh3 = new double[3];
        double[] ca3 = new double[3];
        double[] amide4 = new double[3];
        double[] nh4 = new double[3];
        double[] ca4 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        pp = (Pdb)pdbVec.elementAt(1);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha1 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co1 = cc.getXYZ();
            } else if (atom.equals("O")) {
                o1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide1, nh1);
        double[] nToCAVec = this.internuclearVec(amide1, ca1);
        Matrix rg1 = this.RgCal(nToNHVec, nToCAVec);
        Matrix rg1Inv = rg1.transpose();
        pp = (Pdb)pdbVec.elementAt(2);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("CB")) {
                cb2 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha2 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co2 = cc.getXYZ();
            } else if (atom.equals("O")) {
                o2 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh2 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec2 = this.internuclearVec(amide2, nh2);
        double[] nToCAVec2 = this.internuclearVec(amide2, ca2);
        Matrix rg2 = this.RgCal(nToNHVec2, nToCAVec2);
        double[] n2nhCnt = new double[]{0.0, 0.0, -1.02};
        double[] n2caCnt = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Matrix r2y = rg1.rotationMat(phi1, "+y");
        Matrix r4z = rg1.rotationMat(psi1, "+z");
        Matrix r2yInv = rg1.rotationMat(phi1, "-y");
        Matrix r4zInv = rg1.rotationMat(psi1, "-z");
        Matrix rg2Cal = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg1))));
        double[] n2nhCal2 = rg2Cal.transpose().times(n2nhCnt);
        double[] n2caCal2 = rg2Cal.transpose().times(n2caCnt);
        Matrix rg1Cal = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg2))));
        Matrix L1 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv));
        nToNHVec2 = rg1Inv.times(L1.times(r4zInv.times(Const.Cv)));
        double[] n2nh = this.dirCos(this.internuclearVec(amide2, nh2));
        double[] n2ca = this.dirCos(this.internuclearVec(amide2, ca2));
        double[] coordCA = new double[]{0.0, 1.0, 0.0};
        double[] n2CAVec = rg1Inv.times(L1.times(r4zInv.times(Const.Cu)));
        pp = (Pdb)pdbVec.elementAt(3);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide3 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca3 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh3 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec3 = this.internuclearVec(amide3, nh3);
        double[] nToCAVec3 = this.internuclearVec(amide3, ca3);
        Matrix rg3 = this.RgCal(nToNHVec3, nToCAVec3);
        Matrix rg3Inv = rg3.transpose();
        pp = (Pdb)pdbVec.elementAt(4);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide4 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca4 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh4 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec4 = this.internuclearVec(amide4, nh4);
        double[] nToCAVec4 = this.internuclearVec(amide4, ca4);
        Matrix rg4 = this.RgCal(nToNHVec4, nToCAVec4);
        Matrix rg4Inv = rg4.transpose();
        Vector solutionVec = new Vector();
        boolean hasSolution = this.phiPsiByPP14(ca1, amide4, ca4, nh4, rg1, rg4, solutionVec);
        int slnNo = solutionVec.size() / 3;
        double[] solution1 = new double[2];
        double[] solution2 = new double[2];
        double[] solution3 = new double[2];
        i = 0;
        while (i < slnNo) {
            solution1 = (double[])solutionVec.elementAt(i);
            solution2 = (double[])solutionVec.elementAt(i + 1);
            solution3 = (double[])solutionVec.elementAt(i + 2);
            this.printArray(solution1);
            System.out.println(String.valueOf(phi1) + "  " + psi1);
            this.printArray(solution2);
            System.out.println(String.valueOf(phi2) + "  " + psi2);
            this.printArray(solution3);
            System.out.println(String.valueOf(phi3) + "  " + psi3);
            i += 3;
        }
    }

    public Vector phiPsiByPP13(double[] u1, double[] v1, double[] n2ca3, double[] n2nh3, double phi1) {
        double sinTheta3 = Math.sin(-0.36538467890501286);
        double cosTheta3 = Math.cos(-0.36538467890501286);
        Matrix rg1 = this.RgCal(v1, u1);
        Matrix rg1Inv = rg1.transpose();
        Matrix r2yInv = rg1.rotationMat(phi1, "-y");
        Matrix L1 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv));
        double[] u3 = L1.transpose().times(rg1.times(n2ca3));
        double[] v3 = L1.transpose().times(rg1.times(n2nh3));
        Matrix rot3 = this.RgCal(v3, u3);
        Matrix rot1 = this.RgCal(Const.Cv, Const.Cu);
        Matrix rot = rot3.transpose().times(rot1);
        double[][] r = rot.getArray();
        double[][] a = Const.matA.getArray();
        double[] psi1All = new double[2];
        double[] psi2All = new double[2];
        double a1 = a[2][0] * cosTheta3;
        double b1 = a[2][2] * cosTheta3;
        double c1 = r[2][2] + a[2][1] * sinTheta3;
        double[] phi2All = new double[2];
        if (!Maths.sinAngles(a1, b1, c1, phi2All)) {
            return new Vector();
        }
        double psi2 = 0.0;
        double phi2 = 0.0;
        double psi1 = 0.0;
        double r22Cal = 0.0;
        double r01Cal = 0.0;
        double r21Cal = 0.0;
        Vector<double[]> solutionVec = new Vector<double[]>();
        int i = 0;
        while (i < phi2All.length) {
            phi2 = phi2All[i];
            a1 = a[2][0] * sinTheta3 * Math.sin(phi2) + a[2][1] * cosTheta3 + a[2][2] * sinTheta3 * Math.cos(phi2);
            if (!Maths.sinAngles(a1, b1 = a[2][0] * Math.cos(phi2) - a[2][2] * Math.sin(phi2), c1 = r[2][0], psi2All)) {
                return new Vector();
            }
            int j = 0;
            while (j < psi2All.length) {
                double b21;
                psi2 = psi2All[j];
                double b11 = cosTheta3 * Math.cos(psi2);
                double b01 = sinTheta3 * Math.sin(phi2) * Math.cos(psi2) - Math.cos(phi2) * Math.sin(psi2);
                r21Cal = a[2][0] * b01 + a[2][1] * b11 + a[2][2] * (b21 = sinTheta3 * Math.cos(phi2) * Math.cos(psi2) + Math.sin(phi2) * Math.sin(psi2));
                if (Math.abs(r21Cal - r[2][1]) < 1.0E-4) {
                    double c2;
                    double b2;
                    double a2 = a[0][0] * cosTheta3 * Math.sin(phi2) - a[0][1] * sinTheta3 + a[0][2] * cosTheta3 * Math.cos(phi2);
                    if (!Maths.sinAngles(a2, b2 = a[1][0] * cosTheta3 * Math.sin(phi2) - a[1][1] * sinTheta3 + a[1][2] * cosTheta3 * Math.cos(phi2), c2 = r[1][2], psi1All)) {
                        return new Vector();
                    }
                    int k = 0;
                    while (k < psi1All.length) {
                        psi1 = psi1All[k];
                        r01Cal = b01 * (a[0][0] * Math.cos(psi1) - a[1][0] * Math.sin(psi1)) + b11 * (a[0][1] * Math.cos(psi1) - a[1][1] * Math.sin(psi1)) + b21 * (a[0][2] * Math.cos(psi1) - a[1][2] * Math.sin(psi1));
                        if (Math.abs(r01Cal - r[0][1]) < 1.0E-4) {
                            solutionVec.add(new double[]{psi1, phi2, psi2});
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return solutionVec;
    }

    public boolean quarticCoefPhi(double Syy, double Szz, double rdc, double[][] mat, double[] coefs) {
        double a = -Syy - 2.0 * Szz;
        double b = Syy - Szz;
        double r = rdc - Szz;
        double ca = 0.0;
        double cb = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        double c4 = 0.0;
        double e0 = 0.0;
        double e1 = 0.0;
        if (mat[1][2] == 0.0) {
            System.out.println("mat[1][2] == 0.0");
            return false;
        }
        ca = dirCosCH[1] * mat[0][2] / mat[1][2];
        cb = dirCosCH[1] * mat[2][2] / mat[1][2];
        c1 = mat[0][0] - mat[0][2] * mat[1][0] / mat[1][2];
        c2 = mat[0][1] - mat[0][2] * mat[1][1] / mat[1][2];
        c3 = mat[2][0] - mat[2][2] * mat[1][0] / mat[1][2];
        c4 = mat[2][1] - mat[2][2] * mat[1][1] / mat[1][2];
        double c0 = dirCosCH[0] * dirCosCH[0] + dirCosCH[2] * dirCosCH[2];
        double d5 = 2.0 * c2 * ca + 2.0 * c4 * cb;
        double d4 = 2.0 * c1 * ca + 2.0 * c3 * cb;
        double d3 = 2.0 * c1 * c2 + 2.0 * c3 * c4;
        double d2 = c2 * c2 + c4 * c4;
        double d1 = c1 * c1 + c3 * c3;
        double d0 = ca * ca + cb * cb - c0;
        if (b == 0.0) {
            System.out.println(" Syy == Szz !!");
            return false;
        }
        e0 = d0 + d2 * r / b;
        e1 = d1 - d2 * a / b;
        coefs[0] = e1 * e1 + a * d3 * d3 / b;
        coefs[1] = 2.0 * e1 * d4 + 2.0 * a * d3 * d5 / b;
        coefs[2] = d4 * d4 + 2.0 * e1 * e0 + (a * d5 * d5 - r * d3 * d3) / b;
        coefs[3] = 2.0 * d4 * e0 - 2.0 * r * d3 * d5 / b;
        coefs[4] = e0 * e0 - r * d5 * d5 / b;
        coefs[5] = a;
        coefs[6] = b;
        coefs[7] = r;
        coefs[8] = d0;
        coefs[9] = d1;
        coefs[10] = d2;
        coefs[11] = d3;
        coefs[12] = d4;
        coefs[13] = d5;
        return true;
    }

    public boolean quarticCoefPsi(double Syy, double Szz, double rdc, double[][] mat, double[] coefs) {
        double a = -Syy - 2.0 * Szz;
        double b = Syy - Szz;
        double r = rdc - Szz;
        double ca = 0.0;
        double cb = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        double c4 = 0.0;
        double e0 = 0.0;
        double e1 = 0.0;
        if (mat[2][2] == 0.0) {
            System.out.println(" mat[2][2] = 0.0");
            return false;
        }
        ca = dirCosNH[2] * mat[0][2] / mat[2][2];
        cb = dirCosNH[2] * mat[1][2] / mat[2][2];
        c1 = mat[0][0] - mat[0][2] * mat[2][0] / mat[2][2];
        c2 = mat[0][1] - mat[0][2] * mat[2][1] / mat[2][2];
        c3 = mat[1][0] - mat[1][2] * mat[2][0] / mat[2][2];
        c4 = mat[1][1] - mat[1][2] * mat[2][1] / mat[2][2];
        double c0 = dirCosNH[0] * dirCosNH[0] + dirCosNH[1] * dirCosNH[1];
        double d5 = 2.0 * c2 * ca + 2.0 * c4 * cb;
        double d4 = 2.0 * c1 * ca + 2.0 * c3 * cb;
        double d3 = 2.0 * c1 * c2 + 2.0 * c3 * c4;
        double d2 = c2 * c2 + c4 * c4;
        double d1 = c1 * c1 + c3 * c3;
        double d0 = ca * ca + cb * cb - c0;
        if (b == 0.0) {
            System.out.println(" Syy == Szz !!");
            return false;
        }
        e0 = d0 + d2 * r / b;
        e1 = d1 - d2 * a / b;
        coefs[0] = e1 * e1 + a * d3 * d3 / b;
        coefs[1] = 2.0 * e1 * d4 + 2.0 * a * d3 * d5 / b;
        coefs[2] = d4 * d4 + 2.0 * e1 * e0 + (a * d5 * d5 - r * d3 * d3) / b;
        coefs[3] = 2.0 * d4 * e0 - 2.0 * r * d3 * d5 / b;
        coefs[4] = e0 * e0 - r * d5 * d5 / b;
        coefs[5] = a;
        coefs[6] = b;
        coefs[7] = r;
        coefs[8] = d0;
        coefs[9] = d1;
        coefs[10] = d2;
        coefs[11] = d3;
        coefs[12] = d4;
        coefs[13] = d5;
        return true;
    }

    public Vector quarticSolve(double[] coefs) {
        double c1 = coefs[0];
        double c2 = coefs[1];
        double c3 = coefs[2];
        double c4 = coefs[3];
        double c0 = coefs[4];
        double a = coefs[5];
        double b = coefs[6];
        double r = coefs[7];
        double d0 = coefs[8];
        double d1 = coefs[9];
        double d2 = coefs[10];
        double d3 = coefs[11];
        double d4 = coefs[12];
        double d5 = coefs[13];
        if (b == 0.0) {
            System.out.println(" b == 0!!");
            System.exit(0);
        }
        double xr = 0.0;
        double yr = 0.0;
        double zr = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double r1Cal = 0.0;
        double r2Cal = 0.0;
        int[] indexI = new int[]{1, 1, 1, -1, -1, 1, -1, -1};
        int fourFold = 8;
        double eps1 = 1.0E-8;
        double eps = 1.0E-7;
        Vector<double[]> rootVec = new Vector<double[]>();
        Vector<Double> realVec = new Vector<Double>();
        if (c1 != 0.0) {
            double[][] mArr = new double[][]{{-c2 / c1, -c3 / c1, -c4 / c1, -c0 / c1}, {1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}};
            Matrix mm = new Matrix(mArr);
            EigenvalueDecomposition eigs = new EigenvalueDecomposition(mm, false);
            double[] realValues = eigs.getRealEigenvalues();
            double[] imageValues = eigs.getImagEigenvalues();
            int k = 0;
            while (k < imageValues.length) {
                if (Math.abs(imageValues[k] - 0.0) < 1.0E-8) {
                    realVec.add(new Double(realValues[k]));
                }
                ++k;
            }
            int i = 0;
            while (i < realVec.size()) {
                xr = (Double)realVec.elementAt(i);
                yr = (r - a * xr * xr) / b;
                if (yr < 0.0) {
                    return rootVec;
                }
                if (xr * xr + (yr = Math.sqrt(yr)) * yr <= 1.0) {
                    zr = Math.sqrt(1.0 - xr * xr - yr * yr);
                    int m = 0;
                    while (m < 8) {
                        x = xr;
                        y = (double)indexI[m] * yr;
                        z = (double)indexI[m + 1] * zr;
                        r2Cal = d1 * x * x + d2 * y * y + d3 * x * y + d4 * x + d5 * y;
                        r1Cal = a * x * x + b * y * y;
                        if (Math.abs(r1Cal - r) < 1.0E-7 && Math.abs(r2Cal + d0) < 1.0E-7) {
                            rootVec.add(new double[]{x, y, z});
                        }
                        m += 2;
                    }
                }
                ++i;
            }
        }
        return rootVec;
    }

    public Vector phiCal(double Syy, double Szz, double rdc, Matrix rg) {
        Matrix M = Const.r9y1x.times(rg);
        double[][] mat = M.getArray();
        Matrix r2y = new Matrix(3, 3);
        Vector<Double> phiVec = new Vector<Double>();
        double[] coefs = new double[14];
        boolean coefFlag = this.quarticCoefPhi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            return phiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return phiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPhi = 0.0;
        double cosPhi = 0.0;
        double phi = 0.0;
        double cSquare = dirCosCH[0] * dirCosCH[0] + dirCosCH[2] * dirCosCH[2];
        double[] bondDir = new double[3];
        double eps = 1.0E-7;
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosCH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosCH[2] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            tmp2 = dirCosCH[2] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosCH[0] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            if (cSquare != 0.0) {
                cosPhi = tmp1 / cSquare;
                sinPhi = tmp2 / cSquare;
                if (cosPhi >= 0.0) {
                    phi = Math.asin(sinPhi);
                } else if (cosPhi < 0.0) {
                    phi = Math.PI - Math.asin(sinPhi);
                }
            } else {
                System.out.println("both Cx and Cz are zero");
                System.exit(1);
            }
            if (phi > Math.PI) {
                phi -= Math.PI * 2;
            }
            if (Math.abs((bondDir = Const.rHA2HA1.times((r2y = M.rotationMat(phi, "+y")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] - 1.0) < 1.0E-7) {
                phiVec.add(new Double(phi));
            }
            ++i;
        }
        return phiVec;
    }

    public Vector phiCal(double Syy, double Szz, double rdc, Matrix Rg, boolean isHelix) {
        Matrix M = Const.r9y1x.times(Rg);
        double[][] mat = M.getArray();
        Matrix r2y = new Matrix(3, 3);
        Vector<Double> phiVec = new Vector<Double>();
        double phiHigh = 0.0;
        double phiLow = 0.0;
        if (isHelix) {
            phiHigh = -0.5235987755982988;
            phiLow = -1.7453292519943295;
        } else {
            phiHigh = -1.2217304763960306;
            phiLow = -2.9670597283903604;
        }
        double[] coefs = new double[14];
        boolean coefFlag = this.quarticCoefPhi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            return phiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return phiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPhi = 0.0;
        double cosPhi = 0.0;
        double phi = 0.0;
        double cSquare = dirCosCH[0] * dirCosCH[0] + dirCosCH[2] * dirCosCH[2];
        double[] bondDir = new double[3];
        double eps = 1.0E-7;
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosCH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosCH[2] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            tmp2 = dirCosCH[2] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosCH[0] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            if (cSquare != 0.0) {
                cosPhi = tmp1 / cSquare;
                sinPhi = tmp2 / cSquare;
                if (cosPhi >= 0.0) {
                    phi = Math.asin(sinPhi);
                } else if (cosPhi < 0.0) {
                    phi = Math.PI - Math.asin(sinPhi);
                }
            } else {
                System.out.println("both Cx and Cz are zero");
                System.exit(1);
            }
            if (phi > Math.PI) {
                phi -= Math.PI * 2;
            }
            if (phi < phiHigh && phi > phiLow && Math.abs((bondDir = Const.rHA2HA1.times((r2y = M.rotationMat(phi, "+y")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] - 1.0) < 1.0E-7) {
                phiVec.add(new Double(phi));
            }
            ++i;
        }
        return phiVec;
    }

    public Vector phiCalLoop(double Syy, double Szz, double rdc, Matrix Rg) {
        Matrix M = Const.r9y1x.times(Rg);
        double[][] mat = M.getArray();
        Matrix r2y = new Matrix(3, 3);
        Vector<Double> phiVec = new Vector<Double>();
        double phiHigh = 360.0;
        double phiLow = -360.0;
        double[] coefs = new double[14];
        boolean coefFlag = this.quarticCoefPhi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            return phiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return phiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPhi = 0.0;
        double cosPhi = 0.0;
        double phi = 0.0;
        double cSquare = dirCosCH[0] * dirCosCH[0] + dirCosCH[2] * dirCosCH[2];
        double[] bondDir = new double[3];
        double eps = 1.0E-7;
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosCH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosCH[2] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            tmp2 = dirCosCH[2] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosCH[0] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            if (cSquare != 0.0) {
                cosPhi = tmp1 / cSquare;
                sinPhi = tmp2 / cSquare;
                if (cosPhi >= 0.0) {
                    phi = Math.asin(sinPhi);
                } else if (cosPhi < 0.0) {
                    phi = Math.PI - Math.asin(sinPhi);
                }
            } else {
                System.out.println("both Cx and Cz are zero");
                System.exit(1);
            }
            if (phi > Math.PI) {
                phi -= Math.PI * 2;
            }
            if (phi < phiHigh && phi > phiLow && Math.abs((bondDir = Const.rHA2HA1.times((r2y = M.rotationMat(phi, "+y")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] - 1.0) < 1.0E-7) {
                phiVec.add(new Double(phi));
            }
            ++i;
        }
        return phiVec;
    }

    public Vector phiCal(double Syy, double Szz, double rdc, Matrix Rg, boolean isHelix, int curResNo, Vector vecTalos) {
        double[] coefs;
        boolean coefFlag;
        Matrix M = Const.r9y1x.times(Rg);
        double[][] mat = M.getArray();
        Matrix r2y = new Matrix(3, 3);
        Vector<Double> phiVec = new Vector<Double>();
        double phiHigh = 0.0;
        double phiLow = 0.0;
        double phiRamHigh = 0.0;
        double phiRamLower = 0.0;
        if (isHelix) {
            phiRamHigh = -0.5235987755982988;
            phiRamLower = -1.7453292519943295;
        } else {
            phiRamHigh = -1.2217304763960306;
            phiRamLower = -2.9670597283903604;
        }
        boolean isInTalos = false;
        int i = 0;
        while (i < vecTalos.size()) {
            PhiPsi phipsi = (PhiPsi)vecTalos.elementAt(i);
            int resNo_temp = phipsi.getResidueNo();
            if (resNo_temp == curResNo) {
                phiHigh = Math.min(phipsi.getPhiUpper() * (Math.PI / 180), phiRamHigh);
                phiLow = Math.max(phipsi.getPhiLower() * (Math.PI / 180), phiRamLower);
                isInTalos = true;
                break;
            }
            ++i;
        }
        if (!isInTalos) {
            phiHigh = phiRamHigh;
            phiLow = phiRamLower;
        }
        if (!(coefFlag = this.quarticCoefPhi(Syy, Szz, rdc, mat, coefs = new double[14]))) {
            return phiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return phiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPhi = 0.0;
        double cosPhi = 0.0;
        double phi = 0.0;
        double cSquare = dirCosCH[0] * dirCosCH[0] + dirCosCH[2] * dirCosCH[2];
        double[] bondDir = new double[3];
        double eps = 1.0E-7;
        int i2 = 0;
        while (i2 < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i2);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosCH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosCH[2] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            tmp2 = dirCosCH[2] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosCH[0] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            if (cSquare != 0.0) {
                cosPhi = tmp1 / cSquare;
                sinPhi = tmp2 / cSquare;
                if (cosPhi >= 0.0) {
                    phi = Math.asin(sinPhi);
                } else if (cosPhi < 0.0) {
                    phi = Math.PI - Math.asin(sinPhi);
                }
            } else {
                System.out.println("both Cx and Cz are zero");
                System.exit(1);
            }
            if (phi > Math.PI) {
                phi -= Math.PI * 2;
            }
            if (phi < phiHigh && phi > phiLow && Math.abs((bondDir = Const.rHA2HA1.times((r2y = M.rotationMat(phi, "+y")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] - 1.0) < 1.0E-7) {
                phiVec.add(new Double(phi));
            }
            ++i2;
        }
        return phiVec;
    }

    public Vector psiCal(double Syy, double Szz, double rdc, double phi, Matrix rg) {
        Matrix r2y = rg.rotationMat(phi, "+y");
        Matrix M = Const.r3x.times(r2y.times(Const.r9y1x.times(rg)));
        double[][] mat = M.getArray();
        double[] coefs = new double[14];
        Vector<Double> psiVec = new Vector<Double>();
        double eps = 1.0E-7;
        boolean coefFlag = this.quarticCoefPsi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            System.out.println("can not compute coefficients for the quartic equation");
            return psiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return psiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPsi = 0.0;
        double cosPsi = 0.0;
        double psi = 0.0;
        double cSquare = dirCosNH[0] * dirCosNH[0] + dirCosNH[1] * dirCosNH[1];
        Matrix rPsiz = new Matrix(3, 3);
        double[] bondDir = new double[3];
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosNH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosNH[1] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            tmp2 = dirCosNH[1] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosNH[0] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            if (cSquare != 0.0) {
                sinPsi = tmp2 / cSquare;
                cosPsi = -tmp1 / cSquare;
                if (cosPsi >= 0.0) {
                    psi = Math.asin(sinPsi);
                } else if (cosPsi < 0.0) {
                    psi = Math.PI - Math.asin(sinPsi);
                }
            } else {
                System.out.println("Both Cx or Cz are zero");
                System.exit(1);
            }
            if (psi < -Math.PI) {
                psi += Math.PI * 2;
            }
            if (Math.abs((bondDir = Const.r7x6y5x.times((rPsiz = M.rotationMat(psi + Math.PI, "+z")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] + 1.0) < 1.0E-7) {
                psiVec.add(new Double(psi));
            }
            ++i;
        }
        return psiVec;
    }

    public Vector psiCal(double Syy, double Szz, double rdc, double phi, Matrix rg, boolean isHelix) {
        Matrix r2y = rg.rotationMat(phi, "+y");
        Matrix M = Const.r3x.times(r2y.times(Const.r9y1x.times(rg)));
        double[][] mat = M.getArray();
        double[] coefs = new double[14];
        Vector<Double> psiVec = new Vector<Double>();
        double eps = 1.0E-7;
        double psiHigh = 0.0;
        double psiLow = 0.0;
        if (isHelix) {
            psiHigh = -0.2617993877991494;
            psiLow = -1.5707963267948966;
        } else {
            psiHigh = Math.PI;
            psiLow = 1.3962634015954636;
        }
        boolean coefFlag = this.quarticCoefPsi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            System.out.println("can not compute coefficients for the quartic equation");
            return psiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return psiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPsi = 0.0;
        double cosPsi = 0.0;
        double psi = 0.0;
        double cSquare = dirCosNH[0] * dirCosNH[0] + dirCosNH[1] * dirCosNH[1];
        Matrix rPsiz = new Matrix(3, 3);
        double[] bondDir = new double[3];
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosNH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosNH[1] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            tmp2 = dirCosNH[1] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosNH[0] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            if (cSquare != 0.0) {
                sinPsi = tmp2 / cSquare;
                cosPsi = -tmp1 / cSquare;
                if (cosPsi >= 0.0) {
                    psi = Math.asin(sinPsi);
                } else if (cosPsi < 0.0) {
                    psi = Math.PI - Math.asin(sinPsi);
                }
            } else {
                System.out.println("Both Cx or Cz are zero");
                System.exit(1);
            }
            if (psi < -Math.PI) {
                psi += Math.PI * 2;
            }
            if (psi < psiHigh && psi > psiLow && Math.abs((bondDir = Const.r7x6y5x.times((rPsiz = M.rotationMat(psi + Math.PI, "+z")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] + 1.0) < 1.0E-7) {
                psiVec.add(new Double(psi));
            }
            ++i;
        }
        return psiVec;
    }

    public Vector psiCalLoop(double Syy, double Szz, double rdc, double phi, Matrix rg) {
        Matrix r2y = rg.rotationMat(phi, "+y");
        Matrix M = Const.r3x.times(r2y.times(Const.r9y1x.times(rg)));
        double[][] mat = M.getArray();
        double[] coefs = new double[14];
        Vector<Double> psiVec = new Vector<Double>();
        double eps = 1.0E-7;
        double psiHigh = 360.0;
        double psiLow = -360.0;
        boolean coefFlag = this.quarticCoefPsi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            System.out.println("can not compute coefficients for the quartic equation");
            return psiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return psiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPsi = 0.0;
        double cosPsi = 0.0;
        double psi = 0.0;
        double cSquare = dirCosNH[0] * dirCosNH[0] + dirCosNH[1] * dirCosNH[1];
        Matrix rPsiz = new Matrix(3, 3);
        double[] bondDir = new double[3];
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosNH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosNH[1] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            tmp2 = dirCosNH[1] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosNH[0] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            if (cSquare != 0.0) {
                sinPsi = tmp2 / cSquare;
                cosPsi = -tmp1 / cSquare;
                if (cosPsi >= 0.0) {
                    psi = Math.asin(sinPsi);
                } else if (cosPsi < 0.0) {
                    psi = Math.PI - Math.asin(sinPsi);
                }
            } else {
                System.out.println("Both Cx or Cz are zero");
                System.exit(1);
            }
            if (psi < -Math.PI) {
                psi += Math.PI * 2;
            }
            if (psi < psiHigh && psi > psiLow && Math.abs((bondDir = Const.r7x6y5x.times((rPsiz = M.rotationMat(psi + Math.PI, "+z")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] + 1.0) < 1.0E-7) {
                psiVec.add(new Double(psi));
            }
            ++i;
        }
        return psiVec;
    }

    public Vector psiCal(double Syy, double Szz, double rdc, double phi, Matrix rg, boolean isHelix, int curResNo, Vector vecTalos) {
        boolean coefFlag;
        Matrix r2y = rg.rotationMat(phi, "+y");
        Matrix M = Const.r3x.times(r2y.times(Const.r9y1x.times(rg)));
        double[][] mat = M.getArray();
        double[] coefs = new double[14];
        Vector<Double> psiVec = new Vector<Double>();
        double eps = 1.0E-7;
        double psiHigh = 0.0;
        double psiLow = 0.0;
        double psiRamHigh = 0.0;
        double psiRamLower = 0.0;
        if (isHelix) {
            psiRamHigh = -0.2617993877991494;
            psiRamLower = -1.5707963267948966;
        } else {
            psiRamHigh = Math.PI;
            psiRamLower = 1.3962634015954636;
        }
        boolean isInTalos = false;
        int i = 0;
        while (i < vecTalos.size()) {
            PhiPsi phipsi = (PhiPsi)vecTalos.elementAt(i);
            int resNo_temp = phipsi.getResidueNo();
            if (resNo_temp == curResNo) {
                psiHigh = Math.min((phipsi.getPsiUpper() + 0.0) * (Math.PI / 180), psiRamHigh);
                psiLow = Math.max((phipsi.getPsiLower() - 0.0) * (Math.PI / 180), psiRamLower);
                isInTalos = true;
                break;
            }
            ++i;
        }
        if (!isInTalos) {
            psiHigh = psiRamHigh;
            psiLow = psiRamLower;
        }
        if (!(coefFlag = this.quarticCoefPsi(Syy, Szz, rdc, mat, coefs))) {
            System.out.println("can not compute coefficients for the quartic equation");
            return psiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return psiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPsi = 0.0;
        double cosPsi = 0.0;
        double psi = 0.0;
        double cSquare = dirCosNH[0] * dirCosNH[0] + dirCosNH[1] * dirCosNH[1];
        Matrix rPsiz = new Matrix(3, 3);
        double[] bondDir = new double[3];
        int i2 = 0;
        while (i2 < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i2);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = dirCosNH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + dirCosNH[1] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            tmp2 = dirCosNH[1] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - dirCosNH[0] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            if (cSquare != 0.0) {
                sinPsi = tmp2 / cSquare;
                cosPsi = -tmp1 / cSquare;
                if (cosPsi >= 0.0) {
                    psi = Math.asin(sinPsi);
                } else if (cosPsi < 0.0) {
                    psi = Math.PI - Math.asin(sinPsi);
                }
            } else {
                System.out.println("Both Cx or Cz are zero");
                System.exit(1);
            }
            if (psi < -Math.PI) {
                psi += Math.PI * 2;
            }
            if (psi < psiHigh && psi > psiLow && Math.abs((bondDir = Const.r7x6y5x.times((rPsiz = M.rotationMat(psi + Math.PI, "+z")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] + 1.0) < 1.0E-7) {
                psiVec.add(new Double(psi));
            }
            ++i2;
        }
        return psiVec;
    }

    public boolean coefPhiBackward(double Syy, double Szz, double rdc, double[][] mat, double[] coefs) {
        double a = -Syy - 2.0 * Szz;
        double b = Syy - Szz;
        double r = rdc - Szz;
        double ca = 0.0;
        double cb = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        double c4 = 0.0;
        double e0 = 0.0;
        double e1 = 0.0;
        double cy = Const.phiCnt[1];
        double cz = Const.phiCnt[2];
        double x = 0.3913496747972713;
        double y = -0.44891450738046385;
        double z = -0.8033188639011445;
        if (mat[1][2] == 0.0) {
            System.out.println("mat[1][2] == 0.0");
            return false;
        }
        ca = cy * mat[0][2] / mat[1][2];
        cb = cy * mat[2][2] / mat[1][2];
        c1 = mat[0][0] - mat[0][2] * mat[1][0] / mat[1][2];
        c2 = mat[0][1] - mat[0][2] * mat[1][1] / mat[1][2];
        c3 = mat[2][0] - mat[2][2] * mat[1][0] / mat[1][2];
        c4 = mat[2][1] - mat[2][2] * mat[1][1] / mat[1][2];
        double c0 = cz * cz;
        double d5 = 2.0 * c2 * ca + 2.0 * c4 * cb;
        double d4 = 2.0 * c1 * ca + 2.0 * c3 * cb;
        double d3 = 2.0 * c1 * c2 + 2.0 * c3 * c4;
        double d2 = c2 * c2 + c4 * c4;
        double d1 = c1 * c1 + c3 * c3;
        double d0 = ca * ca + cb * cb - c0;
        if (b == 0.0) {
            System.out.println(" Syy == Szz !!");
            return false;
        }
        e0 = d0 + d2 * r / b;
        e1 = d1 - d2 * a / b;
        coefs[0] = e1 * e1 + a * d3 * d3 / b;
        coefs[1] = 2.0 * e1 * d4 + 2.0 * a * d3 * d5 / b;
        coefs[2] = d4 * d4 + 2.0 * e1 * e0 + (a * d5 * d5 - r * d3 * d3) / b;
        coefs[3] = 2.0 * d4 * e0 - 2.0 * r * d3 * d5 / b;
        coefs[4] = e0 * e0 - r * d5 * d5 / b;
        coefs[5] = a;
        coefs[6] = b;
        coefs[7] = r;
        coefs[8] = d0;
        coefs[9] = d1;
        coefs[10] = d2;
        coefs[11] = d3;
        coefs[12] = d4;
        coefs[13] = d5;
        return true;
    }

    public boolean coefPsiBackward(double Syy, double Szz, double rdc, double[][] mat, double[] coefs) {
        double a = -Syy - 2.0 * Szz;
        double b = Syy - Szz;
        double r = rdc - Szz;
        double ca = 0.0;
        double cb = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        double c3 = 0.0;
        double c4 = 0.0;
        double e0 = 0.0;
        double e1 = 0.0;
        if (mat[2][2] == 0.0) {
            System.out.println(" mat[2][2] = 0.0");
            return false;
        }
        ca = Const.psiCntUnit[2] * mat[0][2] / mat[2][2];
        cb = Const.psiCntUnit[2] * mat[1][2] / mat[2][2];
        c1 = mat[0][0] - mat[0][2] * mat[2][0] / mat[2][2];
        c2 = mat[0][1] - mat[0][2] * mat[2][1] / mat[2][2];
        c3 = mat[1][0] - mat[1][2] * mat[2][0] / mat[2][2];
        c4 = mat[1][1] - mat[1][2] * mat[2][1] / mat[2][2];
        double c0 = Const.psiCntUnit[0] * Const.psiCntUnit[0] + Const.psiCntUnit[1] * Const.psiCntUnit[1];
        double d5 = 2.0 * c2 * ca + 2.0 * c4 * cb;
        double d4 = 2.0 * c1 * ca + 2.0 * c3 * cb;
        double d3 = 2.0 * c1 * c2 + 2.0 * c3 * c4;
        double d2 = c2 * c2 + c4 * c4;
        double d1 = c1 * c1 + c3 * c3;
        double d0 = ca * ca + cb * cb - c0;
        if (b == 0.0) {
            System.out.println(" Syy == Szz !!");
            return false;
        }
        e0 = d0 + d2 * r / b;
        e1 = d1 - d2 * a / b;
        coefs[0] = e1 * e1 + a * d3 * d3 / b;
        coefs[1] = 2.0 * e1 * d4 + 2.0 * a * d3 * d5 / b;
        coefs[2] = d4 * d4 + 2.0 * e1 * e0 + (a * d5 * d5 - r * d3 * d3) / b;
        coefs[3] = 2.0 * d4 * e0 - 2.0 * r * d3 * d5 / b;
        coefs[4] = e0 * e0 - r * d5 * d5 / b;
        coefs[5] = a;
        coefs[6] = b;
        coefs[7] = r;
        coefs[8] = d0;
        coefs[9] = d1;
        coefs[10] = d2;
        coefs[11] = d3;
        coefs[12] = d4;
        coefs[13] = d5;
        return true;
    }

    public Vector psiCalBackward(double Syy, double Szz, double rdc, Matrix rg) {
        Matrix M = Const.r2x6z1x9zAlpha.times(rg);
        double[][] mat = M.getArray();
        Vector<Double> psiVec = new Vector<Double>();
        double[] coefs = new double[14];
        boolean coefFlag = this.coefPsiBackward(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            System.out.println("can not compute coefficients for the quartic equation");
            return psiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return psiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPsi = 0.0;
        double cosPsi = 0.0;
        double psi = 0.0;
        double cSquare = Const.psiCntUnit[0] * Const.psiCntUnit[0] + Const.psiCntUnit[1] * Const.psiCntUnit[1];
        Matrix rPsiz = new Matrix(3, 3);
        double[] bondDirCal = new double[3];
        double[] bondDir = new double[3];
        double eps = 1.0E-8;
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = Const.psiCntUnit[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + Const.psiCntUnit[1] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            tmp2 = Const.psiCntUnit[1] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - Const.psiCntUnit[0] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            if (cSquare != 0.0) {
                sinPsi = tmp2 / cSquare;
                cosPsi = -tmp1 / cSquare;
                if (cosPsi >= 0.0) {
                    psi = Math.asin(sinPsi);
                } else if (cosPsi < 0.0) {
                    psi = Math.PI - Math.asin(sinPsi);
                }
            } else {
                System.out.println("Both Cx or Cz are zero");
                System.exit(1);
            }
            if (psi <= -Math.PI) {
                psi += Math.PI * 2;
            }
            if (psi > Math.PI) {
                psi -= Math.PI * 2;
            }
            rPsiz = M.rotationMat(psi + Math.PI, "-z");
            bondDirCal = rPsiz.times(Const.psiCntUnit);
            bondDir = M.times(bondVector);
            if (Math.abs(bondDir[0] - bondDirCal[0]) < 1.0E-8 && Math.abs(bondDir[1] - bondDirCal[1]) < 1.0E-8 && Math.abs(bondDir[2] - bondDirCal[2]) < 1.0E-8) {
                psiVec.add(new Double(psi));
            }
            ++i;
        }
        return psiVec;
    }

    public Vector phiCalBackward(double Syy, double Szz, double rdc, double psi, Matrix rg) {
        Matrix r2z = rg.rotationMat(psi + Math.PI, "+z");
        Matrix M = Const.r8y3xAlpha.times(r2z.times(Const.r2x6z1x9zAlpha.times(rg)));
        double[][] mat = M.getArray();
        double[] coefs = new double[14];
        Vector<Double> phiVec = new Vector<Double>();
        double eps = 1.0E-7;
        boolean coefFlag = this.coefPhiBackward(Syy, Szz, rdc, mat, coefs);
        double cz = Const.phiCnt[2];
        Matrix r2y = new Matrix(3, 3);
        if (!coefFlag) {
            System.out.println("can not compute coefficients for the quartic equation");
            return phiVec;
        }
        Vector rootVec = this.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return phiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPhi = 0.0;
        double cosPhi = 0.0;
        double phi = 0.0;
        double[] bondDir = new double[3];
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = mat[2][0] * x + mat[2][1] * y + mat[2][2] * z;
            tmp2 = mat[0][0] * x + mat[0][1] * y + mat[0][2] * z;
            cosPhi = tmp1 / cz;
            sinPhi = tmp2 / cz;
            if (cosPhi >= 0.0) {
                phi = Math.asin(sinPhi);
            } else if (cosPhi < 0.0) {
                phi = Math.PI - Math.asin(sinPhi);
            }
            if (phi <= -Math.PI) {
                phi += Math.PI * 2;
            }
            if (phi > Math.PI) {
                phi -= Math.PI * 2;
            }
            if (Math.abs((bondDir = (r2y = M.rotationMat(phi, "+y")).times(M.times(bondVector)))[0] - Const.phiCnt[0]) < 1.0E-7 && Math.abs(bondDir[1] - Const.phiCnt[1]) < 1.0E-7 && Math.abs(bondDir[2] - Const.phiCnt[2]) < 1.0E-7) {
                phiVec.add(new Double(phi));
            }
            ++i;
        }
        return phiVec;
    }

    public void phiPsiBackwardTest(Vector rdcNH, Vector rdcCH) {
        int i = 0;
        int j = 0;
        double[] n = new double[]{0.0, 0.0, 0.0};
        double[] nh = new double[]{0.0, 0.0, -1.02};
        double[] ca = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        ModelRdc mdc = new ModelRdc();
        int firstResidueNo = 25;
        int lastResidueNo = 35;
        Vector<Dipolar> helixChRdc = new Vector<Dipolar>();
        Vector<Dipolar> helixNhRdc = new Vector<Dipolar>();
        Dipolar dd = new Dipolar();
        int residueNo = 0;
        i = 0;
        while (i < rdcCH.size()) {
            dd = (Dipolar)rdcCH.elementAt(i);
            residueNo = dd.getResidueNo();
            if (residueNo > 24 && residueNo < 34) {
                helixChRdc.add(dd);
            }
            ++i;
        }
        i = 0;
        while (i < rdcNH.size()) {
            dd = (Dipolar)rdcNH.elementAt(i);
            residueNo = dd.getResidueNo();
            if (residueNo > 24 && residueNo < 34) {
                helixNhRdc.add(dd);
            }
            ++i;
        }
        Collections.sort(helixChRdc, new Dipolar.rdcComparator());
        Collections.sort(helixNhRdc, new Dipolar.rdcComparator());
        int N = lastResidueNo - firstResidueNo;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", -1.1397000015522971, -0.6876597252857658));
            ++i;
        }
        double phi1 = 1.5707963267948966;
        double psi1 = -0.5759586531581288;
        double phi2 = 1.239183768915974;
        double psi2 = 1.0878637227680656;
        double phi3 = 1.912008195559788;
        double psi3 = -1.0471975511965976;
        phiPsiVec.setElementAt(new PhiPsi(firstResidueNo + 2, "ALA", phi1, psi1), 2);
        phiPsiVec.setElementAt(new PhiPsi(firstResidueNo + 3, "ALA", phi2, psi2), 3);
        phiPsiVec.setElementAt(new PhiPsi(firstResidueNo + 4, "ALA", phi3, psi3), 4);
        Vector pdbVec1 = mdc.modelBuild(phiPsiVec, n, nh, ca);
        double[] saupe = new double[4];
        PdbRdc pdr = new PdbRdc();
        double[] rdc1Cal = new double[pdbVec1.size() - 1];
        double[] rdc2Cal = new double[pdbVec1.size() - 1];
        Matrix mm = pdr.bestFit((Vector<Pdb>)pdbVec1, helixNhRdc, helixChRdc, rdc1Cal, rdc2Cal, saupe);
        Pdb pp = new Pdb();
        Vector<Pdb> pdbVec = pp.newPdb(pdbVec1, mm);
        this.printArray(saupe);
        double Syy = saupe[0];
        double Szz = saupe[1];
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] ha1 = new double[3];
        double[] co1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        double[] ha2 = new double[3];
        double[] co2 = new double[3];
        double[] cb2 = new double[3];
        double[] amide3 = new double[3];
        double[] nh3 = new double[3];
        double[] ca3 = new double[3];
        double[] ha3 = new double[3];
        double[] co3 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        pp = pdbVec.elementAt(5);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha1 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide1, nh1);
        double[] nToCAVec = this.internuclearVec(amide1, ca1);
        Matrix rg = this.RgCal(nToNHVec, nToCAVec);
        pp = pdbVec.elementAt(4);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("CB")) {
                cb2 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha2 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co2 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh2 = cc.getXYZ();
            }
            ++j;
        }
        double[] ca2ha = this.dirCos(this.internuclearVec(ca2, ha2));
        double[] n2nh = this.dirCos(this.internuclearVec(amide2, nh2));
        double rdcNHCal = n2nh[0] * n2nh[0] * (-Syy - Szz) + n2nh[1] * n2nh[1] * Syy + n2nh[2] * n2nh[2] * Szz;
        double rdcCal = ca2ha[0] * ca2ha[0] * (-Syy - Szz) + ca2ha[1] * ca2ha[1] * Syy + ca2ha[2] * ca2ha[2] * Szz;
        System.out.println(" RDC = " + rdcCal + "  " + rdcNHCal + "  " + rdcNHCal * 1.0);
        double[] CsCal = Const.r2x6z1x9zAlpha.times(rg.times(ca2ha));
        Matrix rzPsiInv = rg.rotationMat(2.4539329283040274, "-z");
        double[] c2Cal = rzPsiInv.times(Const.psiCntUnit);
        double rdcNhVal = rdcNHCal;
        double rdcChVal = rdcCal;
        System.out.println(" psi = " + psi3);
        Vector psiVec = this.psiCalBackward(Syy, Szz, rdcChVal, rg);
        if (psiVec.isEmpty()) {
            System.out.println("No Solution");
        }
        i = 0;
        while (i < psiVec.size()) {
            System.out.println((Double)psiVec.elementAt(i));
            ++i;
        }
        System.out.println(" phi = " + phi3);
        Vector phiVec = this.phiCalBackward(Syy, Szz, rdcNhVal, psi3, rg);
        if (phiVec.isEmpty()) {
            System.out.println("No Solution");
        }
        System.out.println();
        i = 0;
        while (i < phiVec.size()) {
            System.out.println((Double)phiVec.elementAt(i) / (Math.PI / 180));
            ++i;
        }
        double[] nhVec2 = this.dirCos(this.internuclearVec(amide2, nh2));
        this.printArray(nhVec2);
    }

    public void backwardCoords(Vector pdbVec2) {
        int i = 0;
        int j = 0;
        double[] n = new double[]{0.0, 0.0, 0.0};
        double[] nh = new double[]{0.0, 0.0, -1.02};
        double[] ca = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        ModelRdc mdc = new ModelRdc();
        int firstResidueNo = 1;
        int lastResidueNo = 11;
        int N = lastResidueNo - firstResidueNo;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", -1.1397000015522971, 2.4085543677521746));
            ++i;
        }
        Vector pdbVec = mdc.modelBuild(phiPsiVec, n, nh, ca);
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] ha1 = new double[3];
        double[] o1 = new double[3];
        double[] co1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        double[] ha2 = new double[3];
        double[] co2 = new double[3];
        double[] o2 = new double[3];
        double[] cb2 = new double[3];
        double[] amide3 = new double[3];
        double[] nh3 = new double[3];
        double[] ca3 = new double[3];
        double[] ha3 = new double[3];
        double[] co3 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = (Pdb)pdbVec.elementAt(10);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha1 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co1 = cc.getXYZ();
            } else if (atom.equals("O")) {
                o1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        pp = (Pdb)pdbVec.elementAt(9);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("CB")) {
                cb2 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha2 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co2 = cc.getXYZ();
            } else if (atom.equals("O")) {
                o2 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh2 = cc.getXYZ();
            }
            ++j;
        }
        double[][] nNhCaHaNext = mdc.nNhCaHaByBackward(-1.1397000015522971, 2.4085543677521746, amide1, nh1, ca1);
        this.printArray(amide2);
        this.printArray(nNhCaHaNext[0]);
        this.printArray(nh2);
        this.printArray(nNhCaHaNext[1]);
        this.printArray(ca2);
        this.printArray(nNhCaHaNext[2]);
        this.printArray(ha2);
        this.printArray(nNhCaHaNext[3]);
        pp = (Pdb)pdbVec.elementAt(8);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide3 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca3 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha3 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co3 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh3 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide1, nh1);
        double[] nToCAVec = this.internuclearVec(amide1, ca1);
        Matrix rg = this.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv = rg.transpose();
        double[] coToNVec = this.internuclearVec(co2, amide1);
        double[] coToOVec = this.internuclearVec(co2, o2);
        double[] nToCOVec = this.internuclearVec(amide1, co2);
        double alpha9 = pp.PhiPsiCalPDB(coToNVec, nToNHVec, nToCAVec);
        System.out.println(" alpha9 = " + alpha9 / (Math.PI / 180) + "  " + 60.89560000000001);
        Matrix ra9zInv = rg.rotationMat(alpha9, "-z");
        double[] n2coCnt = new double[]{0.0, 0.0, 1.329};
        double[] n2co = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(n2coCnt)));
        double[] coCal = this.addCoords(amide1, n2co);
        this.printArray(co2);
        this.printArray(coCal);
        double[] co2oCnt = new double[]{0.0, 1.231, 0.0};
        double[] co2o = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.matOInv.times(co2oCnt))));
        double[] o2Cal = this.addCoords(coCal, co2o);
        this.printArray(o2);
        this.printArray(o2Cal);
        double[] co2caCnt = new double[]{0.0, 0.0, 1.525};
        Matrix mat = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv))));
        double[] co2ca = mat.times(co2caCnt);
        double[] caCal = this.addCoords(coCal, co2ca);
        this.printArray(ca2);
        this.printArray(caCal);
        Matrix rzPsiInv = mat.rotationMat(5.550147021341967, "-z");
        mat = mat.times(rzPsiInv.times(Const.r3xAlphaInv));
        double[] ca2nCnt = new double[]{0.0, 1.458, 0.0};
        double[] ca2n = mat.times(ca2nCnt);
        double[] nCal = this.addCoords(caCal, ca2n);
        this.printArray(amide2);
        this.printArray(nCal);
        double[] haCnt = new double[]{0.0, 0.0, 1.09};
        Matrix matHA = mat.times(Const.matHAInv);
        double[] ha2Cal = this.addCoords(caCal, matHA.times(haCnt));
        this.printArray(ha2);
        this.printArray(ha2Cal);
        double[] cbCnt = new double[]{0.0, 0.0, 1.531};
        Matrix matCB = mat.times(Const.matCBInv);
        double[] cb2Cal = this.addCoords(caCal, matCB.times(cbCnt));
        this.printArray(cb2);
        this.printArray(cb2Cal);
        Matrix ryPhiInv = mat.rotationMat(-1.1397000015522971, "-y");
        Matrix ra10Inv = rg.rotationMat(Math.PI, "-y");
        mat = mat.times(Const.r8yAlphaInv.times(ryPhiInv.times(ra10Inv.times(Const.r5xAlphaInv))));
        double[] n2nhCnt = new double[]{0.0, 0.0, -1.02};
        double[] n2nh = mat.times(n2nhCnt);
        double[] nhCal = this.addCoords(nCal, n2nh);
        this.printArray(nh2);
        this.printArray(nhCal);
        int no = 24;
        int index = Collections.binarySearch(pdbVec2, new Pdb(no), new Pdb.PdbComparator());
        Pdb pp24 = (Pdb)pdbVec2.elementAt(index);
        resid = pp24.getResidue();
        atomVec = pp24.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA")) {
                ha1 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co1 = cc.getXYZ();
            } else if (atom.equals("O")) {
                o1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        Pdb ppCal = mdc.coordByBackward(-1.1397000015522971, -0.6876597252857658, amide1, nh1, ca1, no - 1, "ALA");
        pdbVec2.add(ppCal);
    }

    public boolean phiPsiChain(double[] rdcArr1, double[] rdcArr2, Matrix rg, double Syy, double Szz, int i, int N, double[] ppS, Vector ppVec, boolean rightHand, boolean isHelix) {
        Vector phiVec = new Vector();
        Vector psiVec = new Vector();
        double phi = 0.0;
        double psi = 0.0;
        Matrix mat = new Matrix(3, 3);
        double ratio = 1.0;
        if (i > N - 1) {
            double u = rdcArr1[i];
            phiVec = this.phiCal(Syy, Szz, u, rg, isHelix);
            if (!phiVec.isEmpty()) {
                int m = 0;
                while (m < phiVec.size()) {
                    int j = 0;
                    while (j < 2 * N) {
                        ppVec.addElement(new Double(ppS[j]));
                        ++j;
                    }
                    ppVec.addElement(phiVec.elementAt(m));
                    if (isHelix) {
                        ppVec.addElement(new Double(-0.6876597252857658));
                    } else {
                        ppVec.addElement(new Double(2.4085543677521746));
                    }
                    ++m;
                }
                return true;
            }
            return false;
        }
        double u = rdcArr1[i];
        phiVec = this.phiCal(Syy, Szz, u, rg, isHelix);
        if (!phiVec.isEmpty()) {
            int j = 0;
            while (j < phiVec.size()) {
                double v = rdcArr2[i + 1] / 1.0;
                phi = (Double)phiVec.elementAt(j);
                psiVec = this.psiCal(Syy, Szz, v, phi, rg, isHelix);
                if (!psiVec.isEmpty()) {
                    int k = 0;
                    while (k < psiVec.size()) {
                        psi = (Double)psiVec.elementAt(k);
                        ppS[2 * i] = phi;
                        ppS[2 * i + 1] = psi;
                        mat = this.newRG(phi, psi, rg, rightHand);
                        this.phiPsiChain(rdcArr1, rdcArr2, mat, Syy, Szz, i + 1, N, ppS, ppVec, rightHand, isHelix);
                        ++k;
                    }
                }
                ++j;
            }
        }
        return false;
    }

    public boolean phiPsiChainTalos(double[] rdcArr1, double[] rdcArr2, Matrix rg, double Syy, double Szz, int i, int N, double[] ppS, Vector ppVec, boolean rightHand, boolean isHelix, int firstResNo, Vector vecTalos) {
        Vector phiVec = new Vector();
        Vector psiVec = new Vector();
        double phi = 0.0;
        double psi = 0.0;
        Matrix mat = new Matrix(3, 3);
        int curResNo = firstResNo + i;
        double ratio = 1.0;
        if (i > N - 1) {
            double u = rdcArr1[i];
            phiVec = this.phiCal(Syy, Szz, u, rg, isHelix, curResNo, vecTalos);
            if (!phiVec.isEmpty()) {
                int m = 0;
                while (m < phiVec.size()) {
                    int j = 0;
                    while (j < 2 * N) {
                        ppVec.addElement(new Double(ppS[j]));
                        ++j;
                    }
                    ppVec.addElement(phiVec.elementAt(m));
                    if (isHelix) {
                        ppVec.addElement(new Double(-0.6876597252857658));
                    } else {
                        ppVec.addElement(new Double(2.4085543677521746));
                    }
                    ++m;
                }
                return true;
            }
            return false;
        }
        double u = rdcArr1[i];
        phiVec = this.phiCal(Syy, Szz, u, rg, isHelix, curResNo, vecTalos);
        if (!phiVec.isEmpty()) {
            int j = 0;
            while (j < phiVec.size()) {
                double v = rdcArr2[i + 1] / 1.0;
                phi = (Double)phiVec.elementAt(j);
                psiVec = this.psiCal(Syy, Szz, v, phi, rg, isHelix, curResNo, vecTalos);
                if (!psiVec.isEmpty()) {
                    int k = 0;
                    while (k < psiVec.size()) {
                        psi = (Double)psiVec.elementAt(k);
                        ppS[2 * i] = phi;
                        ppS[2 * i + 1] = psi;
                        mat = this.newRG(phi, psi, rg, rightHand);
                        this.phiPsiChainTalos(rdcArr1, rdcArr2, mat, Syy, Szz, i + 1, N, ppS, ppVec, rightHand, isHelix, firstResNo, vecTalos);
                        ++k;
                    }
                }
                ++j;
            }
        }
        return false;
    }

    public double[][] extractRestraints(int begin, int end, Vector h1Vec, Vector asgVec, Vector rdcVec1, Vector rdcVec2, double a1, double a2) {
        int i = 0;
        int j = 0;
        int lastNo = end + 2;
        int index = -1;
        double chRdc = -999.9;
        double nhRdc = -999.9;
        double intensity = -1.0;
        double dna = 0.0;
        double dan = 0.0;
        double dnn = 0.0;
        Peak pk = new Peak();
        int numberOfResidues = end - begin + 2;
        double[][] restraints = new double[numberOfResidues][5];
        i = 0;
        while (i < numberOfResidues) {
            j = 0;
            while (j < 5) {
                restraints[i][j] = -999.9;
                ++j;
            }
            ++i;
        }
        int cnt = 0;
        String resid = "";
        Assign asg = new Assign();
        double[] noe = new double[1];
        boolean hasNOE = false;
        i = begin;
        while (i < lastNo) {
            index = Collections.binarySearch(asgVec, new Assign(i), new Assign.assignComparator());
            if (index > -1) {
                asg = (Assign)asgVec.elementAt(index);
                resid = asg.getResidueType();
                index = Collections.binarySearch(rdcVec1, new Dipolar(i), new Dipolar.rdcComparator());
                chRdc = index > -1 ? ((Dipolar)rdcVec1.elementAt(index)).getRdc() : -999.9;
                hasNOE = resid.equalsIgnoreCase("GLY") ? pk.noeSearch(h1Vec, asgVec, i, "HN", i, "HA2", noe) : pk.noeSearch(h1Vec, asgVec, i, "HN", i, "HA", noe);
                if (hasNOE) {
                    dna = Math.pow(a2 / (noe[0] - a1), 0.25);
                    if (dna < 1.9) {
                        dna = 1.9;
                    } else if (dna > 3.0) {
                        dna = 3.0;
                    }
                } else {
                    dna = -999.9;
                }
                index = Collections.binarySearch(rdcVec2, new Dipolar(i + 1), new Dipolar.rdcComparator());
                nhRdc = index > -1 ? ((Dipolar)rdcVec2.elementAt(index)).getRdc() : -999.9;
                hasNOE = false;
                hasNOE = resid.equalsIgnoreCase("GLY") ? pk.noeSearch(h1Vec, asgVec, i + 1, "HN", i, "HA2", noe) : pk.noeSearch(h1Vec, asgVec, i + 1, "HN", i, "HA", noe);
                if (hasNOE) {
                    dan = Math.pow(a2 / (noe[0] - a1), 0.25);
                    if (dan < 1.9) {
                        dan = 1.9;
                    } else if (dan > 3.59122) {
                        dan = 3.59122;
                    }
                } else {
                    dan = -999.9;
                }
                hasNOE = pk.noeSearch(h1Vec, asgVec, i, "HN", i + 1, "HN", noe);
                if (hasNOE) {
                    dnn = Math.pow(a2 / (noe[0] - a1), 0.25);
                    if (dnn < 1.9) {
                        dnn = 1.9;
                    } else if (dnn > 5.01) {
                        dnn = 5.01;
                    }
                } else {
                    dnn = -999.9;
                }
                restraints[cnt][0] = chRdc;
                restraints[cnt][1] = nhRdc;
                restraints[cnt][2] = dna;
                restraints[cnt][3] = dan;
                restraints[cnt][4] = dnn;
                ++cnt;
            }
            ++i;
        }
        return restraints;
    }

    public double[][] restraintsBackward(int begin, int end, Vector h1Vec, Vector asgVec, Vector rdcVec1, Vector rdcVec2, double a1, double a2) {
        int i = 0;
        int j = 0;
        int previousNo = begin;
        int lastNo = end - 1;
        int index = -1;
        double chRdc = -999.9;
        double nhRdc = -999.9;
        double dna = 0.0;
        double dan = 0.0;
        double dnn = 0.0;
        Peak pk = new Peak();
        int numberOfResidues = begin - end + 1;
        double[][] restraints = new double[numberOfResidues][5];
        i = 0;
        while (i < numberOfResidues) {
            j = 0;
            while (j < 5) {
                restraints[i][j] = -999.9;
                ++j;
            }
            ++i;
        }
        int cnt = 0;
        String resid = "";
        Assign asg = new Assign();
        boolean hasNOE = false;
        double[] noe = new double[1];
        i = previousNo;
        while (i > lastNo) {
            index = Collections.binarySearch(asgVec, new Assign(i), new Assign.assignComparator());
            if (index > -1) {
                asg = (Assign)asgVec.elementAt(index);
                resid = asg.getResidueType();
                index = Collections.binarySearch(rdcVec1, new Dipolar(i), new Dipolar.rdcComparator());
                chRdc = index > -1 ? ((Dipolar)rdcVec1.elementAt(index)).getRdc() : -999.9;
                hasNOE = resid.equalsIgnoreCase("GLY") ? pk.noeSearch(h1Vec, asgVec, i, "HN", i, "HA2", noe) : pk.noeSearch(h1Vec, asgVec, i, "HN", i, "HA", noe);
                if (hasNOE) {
                    dna = Math.pow(a2 / (noe[0] - a1), 0.25);
                    if (dna < 1.9) {
                        dna = 1.9;
                    } else if (dna > 3.0) {
                        dna = 3.0;
                    }
                } else {
                    dna = -999.9;
                }
                index = Collections.binarySearch(rdcVec2, new Dipolar(i), new Dipolar.rdcComparator());
                nhRdc = index > -1 ? ((Dipolar)rdcVec2.elementAt(index)).getRdc() : -999.9;
                hasNOE = resid.equalsIgnoreCase("GLY") ? pk.noeSearch(h1Vec, asgVec, i + 1, "HN", i, "HA2", noe) : pk.noeSearch(h1Vec, asgVec, i + 1, "HN", i, "HA", noe);
                if (hasNOE) {
                    dan = Math.pow(a2 / (noe[0] - a1), 0.25);
                    if (dan < 1.9) {
                        dan = 1.9;
                    } else if (dan > 3.59122) {
                        dan = 3.59122;
                    }
                } else {
                    dan = -999.9;
                }
                hasNOE = pk.noeSearch(h1Vec, asgVec, i + 1, "HN", i, "HN", noe);
                if (hasNOE) {
                    dnn = Math.pow(a2 / (noe[0] - a1), 0.25);
                    if (dnn < 1.9) {
                        dnn = 1.9;
                    } else if (dnn > 5.01) {
                        dnn = 5.01;
                    }
                } else {
                    dnn = -999.9;
                }
                restraints[cnt][0] = chRdc;
                restraints[cnt][1] = nhRdc;
                restraints[cnt][2] = dna;
                restraints[cnt][3] = dan;
                restraints[cnt][4] = dnn;
                ++cnt;
            }
            --i;
        }
        return restraints;
    }

    public boolean phiPsiByRdcNoe(Vector asgVec, double[][] restraints, double Syy, double Szz, double[] n0, double[] nh0, double[] ca0, Matrix rg, int depth, int N, double[] ppS, Vector ppVec, double[] nToNHVec2, double[] nToCAVec2, double[] ca2) {
        double[] n = new double[]{n0[0], n0[1], n0[2]};
        double[] nh = new double[]{nh0[0], nh0[1], nh0[2]};
        double[] ca = new double[]{ca0[0], ca0[1], ca0[2]};
        double[] n2nh = new double[]{nh0[0] - n0[0], nh0[1] - n0[1], nh0[2] - n0[2]};
        double[] n2ca = new double[]{ca0[0] - n0[0], ca0[1] - n0[1], ca0[2] - n0[2]};
        if (depth == N) {
            n = new double[]{n0[0], n0[1], n0[2]};
            nh = new double[]{nh0[0], nh0[1], nh0[2]};
            ca = new double[]{ca0[0], ca0[1], ca0[2]};
            int j = 0;
            while (j < 2 * N) {
                System.out.println(ppS[j] / (Math.PI / 180));
                ppVec.addElement(new Double(ppS[j]));
                ++j;
            }
            System.out.println();
            return true;
        }
        ModelRdc mdc = new ModelRdc();
        Vector phiVec = new Vector();
        Vector psiVec = new Vector();
        double phi = 0.0;
        double psi = 0.0;
        Matrix mat = new Matrix(3, 3);
        int resolution = 10;
        double chRdc = restraints[depth][0];
        double nhRdc = restraints[depth][1];
        double dna = restraints[depth][2];
        double dan = restraints[depth][3];
        double dnn = restraints[depth][4];
        double dnnCal = 0.0;
        if (Math.abs(chRdc - -999.9) > 1.0E-4) {
            phiVec = this.phiCal(Syy, Szz, chRdc, rg);
            System.out.println(" phi by Rdc " + depth + "  " + phiVec.size());
        } else if (Math.abs(dna - -999.9) > 1.0E-4) {
            phiVec = this.phiCalNoe(dna);
        }
        double[][] haco = new double[2][3];
        double[] ha = new double[3];
        double[] co = new double[3];
        double disToCa2 = 0.0;
        double[][] nNhCaCoords = new double[3][3];
        if (depth == 1) {
            phi = -1.1344640137963142;
            if (Math.abs(nhRdc - -999.9) > 1.0E-4) {
                psiVec = this.psiCal(Syy, Szz, nhRdc / 1.0, phi, rg);
            } else if (Math.abs(dan - -999.9) > 1.0E-4) {
                haco = mdc.haCoCoords(phi, n, nh, ca);
                ha = haco[0];
                co = haco[1];
                psiVec = this.psiCalNoe(dan);
            } else {
                psiVec = new Vector();
            }
            if (!psiVec.isEmpty()) {
                int k = 0;
                while (k < psiVec.size()) {
                    psi = (Double)psiVec.elementAt(k);
                    ppS[2 * depth] = phi;
                    ppS[2 * depth + 1] = psi;
                    nNhCaCoords = mdc.nNhCaCal(phi, psi, n, nh, ca);
                    dnnCal = this.internuclearDistance(nNhCaCoords[2], nh);
                    disToCa2 = this.internuclearDistance(ca, ca2);
                    System.out.println(String.valueOf(depth) + " ****  " + dnnCal + "  " + dnn + "   " + disToCa2);
                    if (disToCa2 < (double)(N - depth) * 3.8100448409449443 && Math.abs(dnn - dnnCal) < 1.8) {
                        this.phiPsiByRdcNoe(asgVec, restraints, Syy, Szz, nNhCaCoords[0], nNhCaCoords[2], nNhCaCoords[1], mat, depth + 1, N, ppS, ppVec, nToNHVec2, nToCAVec2, ca2);
                        mat = this.newRG(phi, psi, rg, true);
                    }
                    ++k;
                }
            } else {
                int k = 0;
                while (k < 360 / resolution) {
                    psi = (double)(k * resolution) * Math.PI / 360.0 - Math.PI;
                    ppS[2 * depth] = phi;
                    ppS[2 * depth + 1] = psi;
                    nNhCaCoords = mdc.nNhCaCal(phi, psi, n, nh, ca);
                    dnnCal = this.internuclearDistance(nNhCaCoords[2], nh);
                    disToCa2 = this.internuclearDistance(ca, ca2);
                    System.out.println(String.valueOf(depth) + " *****  " + dnnCal + "  " + dnn + "   " + disToCa2);
                    if (disToCa2 < (double)(N - depth) * 3.8100448409449443 && Math.abs(dnn - dnnCal) < 1.8) {
                        mat = this.newRG(phi, psi, rg, true);
                        this.phiPsiByRdcNoe(asgVec, restraints, Syy, Szz, nNhCaCoords[0], nNhCaCoords[2], nNhCaCoords[1], mat, depth + 1, N, ppS, ppVec, nToNHVec2, nToCAVec2, ca2);
                    }
                    ++k;
                }
            }
        } else if (!phiVec.isEmpty()) {
            int j = 0;
            while (j < phiVec.size()) {
                int k;
                phi = (Double)phiVec.elementAt(j);
                System.out.println(String.valueOf(depth) + ":  " + phi / (Math.PI / 180));
                if (Math.abs(nhRdc - -999.9) > 1.0E-4) {
                    psiVec = this.psiCal(Syy, Szz, nhRdc / 1.0, phi, rg);
                } else if (Math.abs(dan - -999.9) > 1.0E-4) {
                    haco = mdc.haCoCoords(phi, n, nh, ca);
                    ha = haco[0];
                    co = haco[1];
                    psiVec = this.psiCalNoe(dan);
                }
                if (!psiVec.isEmpty()) {
                    k = 0;
                    while (k < psiVec.size()) {
                        psi = (Double)psiVec.elementAt(k);
                        ppS[2 * depth] = phi;
                        ppS[2 * depth + 1] = psi;
                        nNhCaCoords = mdc.nNhCaCal(phi, psi, n, nh, ca);
                        dnnCal = this.internuclearDistance(nNhCaCoords[2], nh);
                        disToCa2 = this.internuclearDistance(nNhCaCoords[1], ca2);
                        System.out.println(String.valueOf(depth) + " *  " + dnnCal + "  " + dnn + "   " + disToCa2);
                        if (disToCa2 < (double)(N - depth) * 3.8100448409449443 && Math.abs(dnn - dnnCal) < 1.8) {
                            mat = this.newRG(phi, psi, rg, true);
                            this.phiPsiByRdcNoe(asgVec, restraints, Syy, Szz, nNhCaCoords[0], nNhCaCoords[2], nNhCaCoords[1], mat, depth + 1, N, ppS, ppVec, nToNHVec2, nToCAVec2, ca2);
                        }
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < 360 / resolution) {
                        psi = (double)(k * resolution) * Math.PI / 360.0 - Math.PI;
                        ppS[2 * depth] = phi;
                        ppS[2 * depth + 1] = psi;
                        nNhCaCoords = mdc.nNhCaCal(phi, psi, n, nh, ca);
                        dnnCal = this.internuclearDistance(nNhCaCoords[2], nh);
                        disToCa2 = this.internuclearDistance(ca, ca2);
                        System.out.println(String.valueOf(depth) + " **  " + dnnCal + "  " + dnn + "   " + disToCa2);
                        if (disToCa2 < (double)(N - depth) * 3.8100448409449443 && Math.abs(dnn - dnnCal) < 1.8) {
                            mat = this.newRG(phi, psi, rg, true);
                            this.phiPsiByRdcNoe(asgVec, restraints, Syy, Szz, nNhCaCoords[0], nNhCaCoords[2], nNhCaCoords[1], mat, depth + 1, N, ppS, ppVec, nToNHVec2, nToCAVec2, ca2);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        } else {
            int j = 0;
            while (j < 360 / resolution) {
                int k;
                phi = (double)(j * resolution) * Math.PI / 360.0 - Math.PI;
                if (Math.abs(nhRdc - -999.9) > 1.0E-4) {
                    psiVec = this.psiCal(Syy, Szz, nhRdc, phi, rg);
                } else if (Math.abs(dan - -999.9) > 1.0E-4) {
                    haco = mdc.haCoCoords(phi, n, nh, ca, false);
                    ha = haco[0];
                    co = haco[1];
                    psiVec = this.psiCalNoe(dan);
                }
                if (!psiVec.isEmpty()) {
                    k = 0;
                    while (k < psiVec.size()) {
                        psi = (Double)psiVec.elementAt(k);
                        ppS[2 * depth] = phi;
                        ppS[2 * depth + 1] = psi;
                        nNhCaCoords = mdc.nNhCaCal(phi, psi, n, nh, ca);
                        dnnCal = this.internuclearDistance(nNhCaCoords[2], nh);
                        disToCa2 = this.internuclearDistance(ca, ca2);
                        System.out.println(String.valueOf(depth) + " ***  " + dnnCal + "  " + dnn + "   " + disToCa2);
                        if (disToCa2 < (double)(N - depth) * 3.8100448409449443 && Math.abs(dnn - dnnCal) < 1.8) {
                            mat = this.newRG(phi, psi, rg, true);
                            this.phiPsiByRdcNoe(asgVec, restraints, Syy, Szz, nNhCaCoords[0], nNhCaCoords[2], nNhCaCoords[1], mat, depth + 1, N, ppS, ppVec, nToNHVec2, nToCAVec2, ca2);
                        }
                        ++k;
                    }
                } else {
                    k = 0;
                    while (k < 360 / resolution) {
                        psi = (double)(k * resolution) * Math.PI / 360.0 - Math.PI;
                        ppS[2 * depth] = phi;
                        ppS[2 * depth + 1] = psi;
                        nNhCaCoords = mdc.nNhCaCal(phi, psi, n, nh, ca);
                        dnnCal = this.internuclearDistance(nNhCaCoords[2], nh);
                        disToCa2 = this.internuclearDistance(ca, ca2);
                        System.out.println(String.valueOf(depth) + " ****  " + dnnCal + "  " + dnn + "   " + disToCa2);
                        if (disToCa2 < (double)(N - depth) * 3.8100448409449443 && Math.abs(dnn - dnnCal) < 1.8) {
                            mat = this.newRG(phi, psi, rg, true);
                            this.phiPsiByRdcNoe(asgVec, restraints, Syy, Szz, nNhCaCoords[0], nNhCaCoords[2], nNhCaCoords[1], mat, depth + 1, N, ppS, ppVec, nToNHVec2, nToCAVec2, ca2);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        return false;
    }

    public boolean loop34To41(double[][] restraints, double Syy, double Szz, int no1, int no2, double[] n, double[] nh, double[] ca, double[] n2, double[] nh2, double[] ca2, Vector phiPsiVec, double[] rdcRmsd) {
        ModelRdc mdc = new ModelRdc();
        int N = no2 - no1 + 1;
        double[] nToNHVec = this.internuclearVec(n, nh);
        double[] nToCAVec = this.internuclearVec(n, ca);
        Matrix rg34 = this.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv34 = rg34.transpose();
        double[] nToNHVec2 = this.internuclearVec(n2, nh2);
        double[] nToCAVec2 = this.internuclearVec(n2, ca2);
        Matrix rg41 = this.RgCal(nToNHVec2, nToCAVec2);
        double disCa2Ca = this.length(this.internuclearVec(ca, ca2));
        double chRdc40 = restraints[0][0];
        double nhRdc40 = restraints[0][1] / 1.0;
        double chRdc39 = restraints[1][0];
        double nhRdc39 = restraints[1][1] / 1.0;
        double chRdc38 = restraints[2][0];
        double nhRdc38 = restraints[2][1] / 1.0;
        double chRdc37 = restraints[3][0];
        double nhRdc37 = restraints[3][1] / 1.0;
        double chRdc36 = restraints[4][0];
        double nhRdc36 = restraints[4][1] / 1.0;
        double chRdc35 = restraints[5][0];
        double nhRdc35 = restraints[5][1] / 1.0;
        double chRdc34 = restraints[6][0];
        double nhRdc34 = restraints[6][1] / 1.0;
        Vector phiVec40 = new Vector();
        Vector psiVec40 = new Vector();
        Vector phiVec39 = new Vector();
        Vector psiVec39 = new Vector();
        Vector psiVec38 = new Vector();
        Vector psiVec37 = new Vector();
        Vector phiVec36 = new Vector();
        Vector psiVec36 = new Vector();
        Vector phiVec35 = new Vector();
        Vector psiVec35 = new Vector();
        Vector phiVec34 = new Vector();
        Vector psiVec34 = new Vector();
        Matrix r2yInv = new Matrix(3, 3);
        Matrix r4zInv = new Matrix(3, 3);
        Matrix rg40 = new Matrix(3, 3);
        Matrix rg39 = new Matrix(3, 3);
        Matrix rg38 = new Matrix(3, 3);
        Matrix rg37 = new Matrix(3, 3);
        Matrix rg36 = new Matrix(3, 3);
        Matrix rg35 = new Matrix(3, 3);
        Matrix r2y = new Matrix(3, 3);
        Matrix r4z = new Matrix(3, 3);
        Matrix mat = new Matrix(3, 3);
        double phi40 = 0.0;
        double psi40 = 0.0;
        double phi39 = 0.0;
        double psi39 = 0.0;
        double phi38 = -1.1344640137963142;
        double psi38 = 0.0;
        double phi37 = -1.1344640137963142;
        double psi37 = 0.0;
        double phi36 = 0.0;
        double psi36 = 0.0;
        double phi35 = 0.0;
        double psi35 = 0.0;
        double phi34 = 0.0;
        double psi34 = 0.0;
        double[] solutions = new double[3];
        double[] chVec34 = new double[3];
        double[] nhVec34 = new double[3];
        double[] chVec35 = new double[3];
        double[] nhVec35 = new double[3];
        double[] chVec36 = new double[3];
        double[] nhVec36 = new double[3];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[][] nNhCaHa40 = new double[4][3];
        double[][] nNhCaHa39 = new double[4][3];
        double[][] nNhCaHa38 = new double[4][3];
        double[][] nNhCaHa37 = new double[4][3];
        long seed = 74851987L;
        Random rr = new Random(seed);
        int nCycle = 512;
        double sigma = 8.0;
        double[] rdcRms = new double[2 * N];
        int i = 0;
        while (i < 2 * N) {
            rdcRms[i] = 0.0;
            ++i;
        }
        double score = 0.0;
        double rmsCal = 100.0;
        double rT = 100.0;
        boolean count = true;
        double dis2LastCA = 0.0;
        int slnNo = 0;
        double[] solution1 = new double[2];
        double[] solution2 = new double[2];
        double[] solution3 = new double[2];
        Vector solutionVec = new Vector();
        boolean hasSolution = false;
        boolean hasPhiPsi = false;
        int mm = 0;
        while (mm < nCycle) {
            score = 0.0;
            int iii = 0;
            while (iii < 2 * N) {
                rdcRms[iii] = 0.0;
                ++iii;
            }
            chRdc40 = restraints[0][0] + sigma * rr.nextGaussian();
            rdcRms[0] = (chRdc40 - restraints[0][0]) * (chRdc40 - restraints[0][0]);
            psiVec40 = this.psiCalBackward(Syy, Szz, chRdc40, rg41);
            i = 0;
            while (i < psiVec40.size()) {
                psi40 = (Double)psiVec40.elementAt(i);
                nhRdc40 = (restraints[0][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                rdcRms[1] = (nhRdc40 * 1.0 - restraints[0][1]) * (nhRdc40 * 1.0 - restraints[0][1]);
                phiVec40 = this.phiCalBackward(Syy, Szz, nhRdc40, psi40, rg41);
                int j = 0;
                while (j < phiVec40.size()) {
                    phi40 = (Double)phiVec40.elementAt(j);
                    nNhCaHa40 = mdc.nNhCaHaByBackward(phi40, psi40, n2, nh2, ca2);
                    r2yInv = mat.rotationMat(phi40, "-y");
                    r4zInv = mat.rotationMat(psi40, "-z");
                    rg40 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg41))));
                    chRdc39 = restraints[1][0] + sigma * rr.nextGaussian();
                    rdcRms[2] = (chRdc39 - restraints[1][0]) * (chRdc39 - restraints[1][0]);
                    psiVec39 = this.psiCalBackward(Syy, Szz, chRdc39, rg40);
                    int k = 0;
                    while (k < psiVec39.size()) {
                        nhRdc39 = (restraints[1][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                        rdcRms[3] = (nhRdc39 * 1.0 - restraints[1][1]) * (nhRdc39 * 1.0 - restraints[1][1]);
                        psi39 = (Double)psiVec39.elementAt(k);
                        phiVec39 = this.phiCalBackward(Syy, Szz, nhRdc39, psi39, rg40);
                        int jj = 0;
                        while (jj < phiVec39.size()) {
                            phi39 = (Double)phiVec39.elementAt(jj);
                            nNhCaHa39 = mdc.nNhCaHaByBackward(phi39, psi39, nNhCaHa40[0], nNhCaHa40[1], nNhCaHa40[2]);
                            r2yInv = mat.rotationMat(phi39, "-y");
                            r4zInv = mat.rotationMat(psi39, "-z");
                            rg39 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg40))));
                            chRdc38 = restraints[2][0] + sigma * rr.nextGaussian();
                            rdcRms[4] = (chRdc38 - restraints[2][0]) * (chRdc38 - restraints[2][0]);
                            rdcRms[5] = 0.0;
                            psiVec38 = this.psiCalBackward(Syy, Szz, chRdc38, rg39);
                            int kk = 0;
                            while (kk < psiVec38.size()) {
                                psi38 = (Double)psiVec38.elementAt(kk);
                                nNhCaHa38 = mdc.nNhCaHaByBackward(phi38, psi38, nNhCaHa39[0], nNhCaHa39[1], nNhCaHa39[2]);
                                r4zInv = mat.rotationMat(psi38, "-z");
                                rg38 = Const.r1x9yInv.times(Const.r2yInvPro.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg39))));
                                chRdc37 = restraints[3][0] + sigma * rr.nextGaussian();
                                rdcRms[6] = (chRdc37 - restraints[3][0]) * (chRdc37 - restraints[3][0]);
                                rdcRms[7] = 0.0;
                                psiVec37 = this.psiCalBackward(Syy, Szz, chRdc37, rg38);
                                int qq = 0;
                                while (qq < psiVec37.size()) {
                                    psi37 = (Double)psiVec37.elementAt(qq);
                                    nNhCaHa37 = mdc.nNhCaHaByBackward(phi37, psi37, nNhCaHa38[0], nNhCaHa38[1], nNhCaHa38[2]);
                                    r4zInv = mat.rotationMat(psi37, "-z");
                                    rg37 = Const.r1x9yInv.times(Const.r2yInvPro.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg38))));
                                    disCa2Ca = this.length(this.internuclearVec(ca, nNhCaHa37[2]));
                                    if (disCa2Ca < 11.0) {
                                        hasSolution = this.phiPsiByPP14(ca, nNhCaHa37[0], nNhCaHa37[2], nNhCaHa37[1], rg34, rg37, solutionVec);
                                        if (hasSolution) {
                                            slnNo = solutionVec.size() / 3;
                                            int ww = 0;
                                            while (ww < slnNo) {
                                                solution1 = (double[])solutionVec.elementAt(ww);
                                                phi34 = solution1[0];
                                                psi34 = solution1[1];
                                                r2y = mat.rotationMat(phi34, "+y");
                                                r4z = mat.rotationMat(psi34, "+z");
                                                chVec34 = rgInv34.times(Const.r1x9yInv.times(r2y.transpose().times(Const.dirCosCHcnt)));
                                                chRdc34 = (-Syy - Szz) * chVec34[0] * chVec34[0] + Syy * chVec34[1] * chVec34[1] + Szz * chVec34[2] * chVec34[2];
                                                rdcRms[12] = (chRdc34 - restraints[6][0]) * (chRdc34 - restraints[6][0]);
                                                rg35 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg34))));
                                                rdcRms[13] = 0.0;
                                                solution2 = (double[])solutionVec.elementAt(ww + 1);
                                                phi35 = solution2[0];
                                                psi35 = solution2[1];
                                                r2y = mat.rotationMat(phi35, "+y");
                                                r4z = mat.rotationMat(psi35, "+z");
                                                rg36 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg35))));
                                                rdcRms[10] = 0.0;
                                                nhVec35 = rg35.transpose().times(Const.unitMinusZ);
                                                nhRdc35 = (-Syy - Szz) * nhVec35[0] * nhVec35[0] + Syy * nhVec35[1] * nhVec35[1] + Szz * nhVec35[2] * nhVec35[2];
                                                rdcRms[11] = (nhRdc35 * 1.0 - restraints[5][1]) * (nhRdc35 * 1.0 - restraints[5][1]);
                                                solution3 = (double[])solutionVec.elementAt(ww + 2);
                                                phi36 = solution3[0];
                                                psi36 = solution3[1];
                                                r2y = mat.rotationMat(phi36, "+y");
                                                r4z = mat.rotationMat(psi36, "+z");
                                                chVec36 = rg36.transpose().times(Const.r1x9yInv.times(r2y.transpose().times(Const.dirCosCHcnt)));
                                                chRdc36 = (-Syy - Szz) * chVec36[0] * chVec36[0] + Syy * chVec36[1] * chVec36[1] + Szz * chVec36[2] * chVec36[2];
                                                rdcRms[8] = (chRdc36 - restraints[4][0]) * (chRdc36 - restraints[4][0]);
                                                nhVec36 = rg36.transpose().times(Const.unitMinusZ);
                                                nhRdc36 = (-Syy - Szz) * nhVec36[0] * nhVec36[0] + Syy * nhVec36[1] * nhVec36[1] + Szz * nhVec36[2] * nhVec36[2];
                                                rdcRms[9] = (nhRdc36 * 1.0 - restraints[4][1]) * (nhRdc36 * 1.0 - restraints[4][1]);
                                                score = 0.0;
                                                int kkk = 0;
                                                while (kkk < 2 * N) {
                                                    score += rdcRms[kkk];
                                                    ++kkk;
                                                }
                                                rmsCal = Math.sqrt(0.5 * score / (double)N);
                                                if (rmsCal < 8.0 && rmsCal < rT) {
                                                    rT = rmsCal;
                                                    phiS[0] = phi34;
                                                    psiS[0] = psi34;
                                                    phiS[1] = phi35;
                                                    psiS[1] = psi35;
                                                    phiS[2] = phi36;
                                                    psiS[2] = psi36;
                                                    phiS[3] = phi37;
                                                    psiS[3] = psi37;
                                                    phiS[4] = phi38;
                                                    psiS[4] = psi38;
                                                    phiS[5] = phi39;
                                                    psiS[5] = psi39;
                                                    phiS[6] = phi40;
                                                    psiS[6] = psi40;
                                                    hasPhiPsi = true;
                                                }
                                                score = 0.0;
                                                ww += 3;
                                            }
                                        }
                                        solutionVec = new Vector();
                                    }
                                    ++qq;
                                }
                                ++kk;
                            }
                            ++jj;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++mm;
        }
        if (hasPhiPsi) {
            phiPsiVec.add(phiS);
            phiPsiVec.add(psiS);
            rdcRmsd[0] = rT;
        }
        return hasPhiPsi;
    }

    public boolean phiPsiByPP14(double[] ca1, double[] n4, double[] ca4, double[] nh4, Matrix rg1, Matrix rg4, Vector solutionVec) {
        double[] n2nhVec4 = this.internuclearVec(n4, nh4);
        double[] ca3 = this.caByNextPeptidePlane(n4, rg4);
        double[] ca3Toca4Dir = this.internuclearVec(ca3, ca4);
        double[] ca4Cal = new double[3];
        double c1 = (ca3[0] - ca1[0]) / 3.8100448409449443;
        double c2 = (ca3[1] - ca1[1]) / 3.8100448409449443;
        double c3 = (ca3[2] - ca1[2]) / 3.8100448409449443;
        double cosTheta2 = 0.0;
        double sinTheta2 = 0.0;
        double[] phi0Arr = new double[2];
        double[] phi1Arr = new double[2];
        double sinPhi1 = 0.0;
        double cosPhi1 = 0.0;
        double phiCnt = 0.0;
        double sinPhiCnt = 0.0;
        double cosPhiCnt = 0.0;
        double c = 1.0;
        double sinPhi0 = 0.0;
        double cosPhi0 = 0.0;
        double c1Cal = 0.0;
        double c2Cal = 0.0;
        double phi2 = 0.0;
        double phi3 = 0.0;
        boolean hasSolution = false;
        boolean hasPhiPsi = false;
        double[][] phiPsiSolution1 = new double[2][3];
        double[][] phiPsiSolution2 = new double[2][3];
        double[][] phiPsiSolution3 = new double[2][3];
        Matrix rg35 = new Matrix(3, 3);
        Matrix rg36 = new Matrix(3, 3);
        Matrix rg37 = new Matrix(3, 3);
        Matrix mat = new Matrix(3, 3);
        Matrix r2y = new Matrix(3, 3);
        Matrix r4z = new Matrix(3, 3);
        double[] ca2Dir = new double[3];
        double[] ca3Dir = new double[3];
        double[] nh4Dir = new double[3];
        double[] ca2Cal = new double[3];
        double[] ca3Cal = new double[3];
        int i = 0;
        while (i < 360) {
            double theta2 = (double)i * Math.PI / 360.0;
            sinTheta2 = Math.sin(theta2);
            cosTheta2 = Math.cos(theta2);
            if (Math.abs(c3 - cosTheta2) <= 1.0) {
                double theta3 = Math.acos(c3 - cosTheta2);
                double sinTheta3 = Math.sin(theta3);
                if (sinTheta2 != 0.0 && sinTheta3 != 0.0 && Math.abs(cosPhi0 = 0.5 * (c1 * c1 + c2 * c2 - sinTheta2 * sinTheta2 - sinTheta3 * sinTheta3) / (sinTheta2 * sinTheta3)) <= 1.0) {
                    phi0Arr[0] = Math.acos(cosPhi0);
                    phi0Arr[1] = -phi0Arr[0];
                    int j = 0;
                    while (j < 2) {
                        sinPhi0 = Math.sin(phi0Arr[j]);
                        c = Math.sqrt((sinTheta2 * cosPhi0 + sinTheta3) * (sinTheta2 * cosPhi0 + sinTheta3) + sinTheta2 * sinTheta2 * sinPhi0 * sinPhi0);
                        if (c != 0.0 && Math.abs(c1 / c) <= 1.0) {
                            sinPhiCnt = (sinTheta2 * cosPhi0 + sinTheta3) / c;
                            cosPhiCnt = sinTheta2 * sinPhi0 / c;
                            if (cosPhiCnt >= 0.0) {
                                phiCnt = Math.asin(sinPhiCnt);
                            } else if (cosPhiCnt < 0.0) {
                                phiCnt = Math.PI - Math.asin(sinPhiCnt);
                            }
                            phi1Arr[0] = Math.asin(c1 / c);
                            phi1Arr[1] = Math.PI - phi1Arr[0];
                            int k = 0;
                            while (k < 2) {
                                phi2 = phiCnt - phi1Arr[k] + phi0Arr[j];
                                phi3 = phiCnt - phi1Arr[k];
                                if (phi2 < 0.0) {
                                    phi2 += Math.PI * 2;
                                }
                                if (phi3 < 0.0) {
                                    phi3 += Math.PI * 2;
                                }
                                if (Math.abs((c2Cal = sinTheta2 * Math.sin(phi2) + sinTheta3 * Math.sin(phi3)) - c2) < 1.0E-4) {
                                    ca2Dir[0] = 3.8100448409449443 * Math.sin(theta2) * Math.cos(phi2);
                                    ca2Dir[1] = 3.8100448409449443 * Math.sin(theta2) * Math.sin(phi2);
                                    ca2Dir[2] = 3.8100448409449443 * Math.cos(theta2);
                                    hasPhiPsi = this.phiPsiByCa(rg1, ca2Dir, phiPsiSolution1);
                                    if (hasPhiPsi) {
                                        ca2Cal = this.addCoords(ca1, ca2Dir);
                                        ca3Dir[0] = 3.8100448409449443 * Math.sin(theta3) * Math.cos(phi3);
                                        ca3Dir[1] = 3.8100448409449443 * Math.sin(theta3) * Math.sin(phi3);
                                        ca3Dir[2] = 3.8100448409449443 * Math.cos(theta3);
                                        ca3Cal = this.addCoords(ca2Cal, ca3Dir);
                                        ca4Cal = this.addCoords(ca3Cal, ca3Toca4Dir);
                                        int tt = 0;
                                        while (tt < 2) {
                                            double phi34BB = phiPsiSolution1[tt][0];
                                            double psi34BB = phiPsiSolution1[tt][1];
                                            r2y = mat.rotationMat(phi34BB, "+y");
                                            r4z = mat.rotationMat(psi34BB, "+z");
                                            rg35 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg1))));
                                            hasPhiPsi = this.phiPsiByCa(rg35, ca3Dir, phiPsiSolution2);
                                            if (hasPhiPsi) {
                                                int qq = 0;
                                                while (qq < 2) {
                                                    double phi35BB = phiPsiSolution2[qq][0];
                                                    double psi35BB = phiPsiSolution2[qq][1];
                                                    r2y = mat.rotationMat(phi35BB, "+y");
                                                    r4z = mat.rotationMat(psi35BB, "+z");
                                                    rg36 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg35))));
                                                    hasPhiPsi = this.phiPsiByCa(rg36, ca3Toca4Dir, phiPsiSolution3);
                                                    if (hasPhiPsi) {
                                                        int uu = 0;
                                                        while (uu < 2) {
                                                            double phi36BB = phiPsiSolution3[uu][0];
                                                            double psi36BB = phiPsiSolution3[uu][1];
                                                            r2y = mat.rotationMat(phi36BB, "+y");
                                                            r4z = mat.rotationMat(psi36BB, "+z");
                                                            rg37 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg36))));
                                                            nh4Dir = rg37.transpose().times(Const.coordNH);
                                                            if (this.interAngle(nh4Dir, n2nhVec4) < 0.00874409955249159) {
                                                                solutionVec.add(new double[]{phi34BB, psi34BB});
                                                                solutionVec.add(new double[]{phi35BB, psi35BB});
                                                                solutionVec.add(new double[]{phi36BB, psi36BB});
                                                                hasSolution = true;
                                                            }
                                                            ++uu;
                                                        }
                                                    }
                                                    ++qq;
                                                }
                                            }
                                            ++tt;
                                        }
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return hasSolution;
    }

    public double[] newNCA(double phi, double psi, Matrix rg) {
        Matrix rgInv = rg.transpose();
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        double[] n2CA = rgInv.times(Const.matL.times(r2yInv.times(Const.r3xInv.times(r4zInv.times(Const.matR)))));
        return n2CA;
    }

    public Matrix newRG(double phi, double psi, Matrix rg) {
        Matrix rgInv = rg.transpose();
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        Matrix mat = rgInv.times(Const.matL.times(r2yInv.times(Const.r3xInv.times(r4zInv))));
        double[] nhDir = mat.times(dirCosNH);
        double[] n2CA = mat.times(Const.matR);
        ppGlobal ppg = new ppGlobal();
        return ppg.RgCal(nhDir, n2CA);
    }

    public Matrix newRG(double phi, double psi, Matrix rg, boolean rightHand) {
        Matrix rgInv = rg.transpose();
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        Matrix mat = rgInv.times(Const.matL.times(r2yInv.times(Const.r3xInv.times(r4zInv))));
        double[] nhDir = mat.times(dirCosNH);
        double[] n2CA = mat.times(Const.matR);
        ppGlobal ppg = new ppGlobal();
        return ppg.RgCal(nhDir, n2CA, rightHand);
    }

    public double vdwEnergy(Vector pdbVec1, Vector pdbVec2, int[] count) {
        Cartesian cc = new Cartesian();
        String atom1 = "";
        String atom2 = "";
        Pdb pp1 = new Pdb();
        Pdb pp2 = new Pdb();
        Vector<Object> atomVec1 = new Vector();
        Vector<Object> atomVec2 = new Vector();
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        double score = 0.0;
        double vdwDis = 0.0;
        int cnt = 0;
        double vdwRadio = 1.9;
        int i = 0;
        while (i < pdbVec2.size()) {
            pp2 = (Pdb)pdbVec2.elementAt(i);
            atomVec2 = pp2.getAtomVec();
            int no2 = pp2.getResidueNo();
            int j = 0;
            while (j < atomVec2.size()) {
                cc = (Cartesian)atomVec2.elementAt(j);
                atom2 = cc.getAtom();
                coord2 = cc.getXYZ();
                int m = 0;
                while (m < pdbVec1.size()) {
                    pp1 = (Pdb)pdbVec1.elementAt(m);
                    int no1 = pp1.getResidueNo();
                    atomVec1 = pp1.getAtomVec();
                    int k = 0;
                    while (k < atomVec1.size()) {
                        cc = (Cartesian)atomVec1.elementAt(k);
                        atom1 = cc.getAtom();
                        coord1 = cc.getXYZ();
                        vdwDis = this.length(this.internuclearVec(coord1, coord2));
                        if (vdwDis < vdwRadio && no1 != no2 && Math.abs(no1 - no2) != 1) {
                            score += (vdwDis - vdwRadio) * (vdwDis - vdwRadio);
                            ++cnt;
                            System.out.println(String.valueOf(no2) + " " + atom2 + "<---> " + no1 + " " + atom1 + "  " + Math.sqrt(vdwDis));
                        }
                        ++k;
                    }
                    ++m;
                }
                ++j;
            }
            ++i;
        }
        count[0] = cnt;
        if (cnt > 0) {
            return Math.sqrt(score / (double)cnt);
        }
        return 0.0;
    }

    public Vector<PhiPsi> talosAngleReader(String talosFile) {
        Vector<PhiPsi> inputs = new Vector<PhiPsi>();
        double phi_lo = 0.0;
        double phi_up = 0.0;
        double psi_lo = 0.0;
        double psi_up = 0.0;
        double lower = 0.0;
        double upper = 0.0;
        int preNo = -1;
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(talosFile));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int no = (int)in.nval;
                in.nextToken();
                String resName = in.sval;
                in.nextToken();
                String dih = in.sval;
                in.nextToken();
                lower = in.nval;
                in.nextToken();
                upper = in.nval;
                if (dih.equalsIgnoreCase("PHI")) {
                    phi_lo = lower;
                    phi_up = upper;
                } else {
                    psi_lo = lower;
                    psi_up = upper;
                }
                if (no == preNo) {
                    inputs.add(new PhiPsi(no, resName, 0.0, 0.0, phi_lo, phi_up, psi_lo, psi_up));
                }
                preNo = no;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + talosFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public void loop50To56(Vector h1Vec, Vector asgVec2, Vector pdbVec, Vector h56To59Pdb, Vector chRdcVec, Vector nhRdcVec, double Syy, double Szz, int no1, int no2, double a1, double a2) {
        ModelRdc mdc = new ModelRdc();
        Vector phiPsiVec = new Vector();
        double[][] restraints = this.restraintsBackward(no2 - 1, no1, h1Vec, asgVec2, chRdcVec, nhRdcVec, a1, a2);
        double[][] restraints2 = this.restraintsBackward(64, 59, h1Vec, asgVec2, chRdcVec, nhRdcVec, a1, a2);
        double[] n = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        int index = Collections.binarySearch(pdbVec, new Pdb(no1 - 1), new Pdb.PdbComparator());
        Pdb pp = (Pdb)pdbVec.elementAt(index);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        int j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                n = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(n, nh);
        double[] nToCAVec = this.internuclearVec(n, ca);
        Matrix rg49 = this.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv49 = rg49.transpose();
        double[] n22 = new double[]{-5.491, -6.452, 1.94};
        double[] ha19 = new double[]{-14.351, -2.019, 3.524};
        double[] hn23 = new double[]{-2.334, -7.568, 4.014};
        double disHn23Ha55 = 0.0;
        double hn23Ha55Noe = 4.0;
        double disN22N55 = 0.0;
        double[] n2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        index = Collections.binarySearch(h56To59Pdb, new Pdb(no2), new Pdb.PdbComparator());
        pp = (Pdb)h56To59Pdb.elementAt(index);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                n2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh2 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec2 = this.internuclearVec(n2, nh2);
        double[] nToCAVec2 = this.internuclearVec(n2, ca2);
        Matrix rg56 = this.RgCal(nToNHVec2, nToCAVec2);
        double[] n56Rot = new double[3];
        Vector phiVec55 = new Vector();
        Vector psiVec55 = new Vector();
        Vector phiVec54 = new Vector();
        Vector psiVec54 = new Vector();
        Vector phiVec50 = new Vector();
        Vector psiVec50 = new Vector();
        Vector phiVec51 = new Vector();
        Vector psiVec51 = new Vector();
        Vector phiVec52 = new Vector();
        Matrix r2yInv = new Matrix(3, 3);
        Matrix r4zInv = new Matrix(3, 3);
        Matrix rg50 = new Matrix(3, 3);
        Matrix rg51 = new Matrix(3, 3);
        Matrix rg52 = new Matrix(3, 3);
        Matrix rg53 = new Matrix(3, 3);
        Matrix rg54 = new Matrix(3, 3);
        Matrix rg55 = new Matrix(3, 3);
        Matrix rg56N = new Matrix(3, 3);
        Matrix r2y = new Matrix(3, 3);
        Matrix r4z = new Matrix(3, 3);
        Matrix mat = new Matrix(3, 3);
        double phi55 = 0.0;
        double psi55 = 0.0;
        double phi54 = 0.0;
        double psi54 = 0.0;
        double phi53 = 0.0;
        double psi53 = 0.0;
        double phi52 = 0.0;
        double psi52 = 0.0;
        double phi51 = 0.0;
        double psi51 = 0.0;
        double phi50 = 0.0;
        double psi50 = 0.0;
        double phi49 = 0.0;
        double psi49 = 0.0;
        Vector solutionVec = new Vector();
        double[] solutions = new double[3];
        double[] n55Cal = new double[3];
        double[] nh55Cal = new double[3];
        double[] ha55Cal = new double[3];
        double[] ca55Cal = new double[3];
        double[] n56Cal = new double[3];
        double[] nh56Cal = new double[3];
        double[] ca56Cal = new double[3];
        double[] n59 = new double[3];
        double[] nh59 = new double[3];
        double[] ca59 = new double[3];
        double[] n2nh52 = new double[3];
        double[] n2ca52 = new double[3];
        double[] n2nh54 = new double[3];
        double[] n2ca54 = new double[3];
        int lengthOf2ndLoop = 6;
        double[] phiArray = new double[lengthOf2ndLoop];
        double[] psiArray = new double[lengthOf2ndLoop];
        int no3 = 65;
        double[] n65 = new double[3];
        double[] nh65 = new double[3];
        double[] ca65 = new double[3];
        index = Collections.binarySearch(pdbVec, new Pdb(no3), new Pdb.PdbComparator());
        pp = (Pdb)pdbVec.elementAt(index);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                n65 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca65 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh65 = cc.getXYZ();
            }
            ++j;
        }
        Vector ppVec = new Vector();
        int N = no2 - no1 + 1;
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        long seed = 74851987L;
        Random rr = new Random(seed);
        int nCycle = 131072;
        double sigma = 8.0;
        double[] rdcRms = new double[2 * N];
        int i = 0;
        while (i < 2 * N) {
            rdcRms[i] = 0.0;
            ++i;
        }
        double score = 0.0;
        double rmsCal = 100.0;
        double rT = 100.0;
        Vector pdbVec2To50 = pp.extractFragment(pdbVec, 2, 49);
        Vector pdbVec65To71 = pp.extractFragment(pdbVec, 65, 71);
        Vector helixPdb = pp.extractFragment(h56To59Pdb, 56, 59);
        Vector pdbVec2 = new Vector();
        pdbVec2.addAll(pdbVec2To50);
        Vector helixPdbN = new Vector();
        Vector pdbVec50To56 = new Vector();
        Vector pdbVec59To64 = new Vector();
        int count = 1;
        double dis2LastCA = 0.0;
        double dis19Ha56Nh = 0.0;
        double[] n2nh23 = new double[3];
        double[] rdcRmsd = new double[1];
        int noSln = 0;
        boolean hasLoop59To65 = false;
        double vdwScore = 0.0;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        Matrix eulerMat = new Matrix(3, 3);
        double[] h56To59Phi = new double[3];
        double[] h56To59Psi = new double[3];
        i = 0;
        while (i < 3) {
            h56To59Phi[i] = -1.1397000015522971;
            h56To59Psi[i] = -0.5131268000863328;
            ++i;
        }
        int[] cnt = new int[1];
        int mm = 0;
        while (mm < nCycle) {
            int uuu = 0;
            while (uuu < 2 * N) {
                rdcRms[uuu] = 0.0;
                ++uuu;
            }
            phi49 = Math.PI - Math.PI * 2 * rr.nextDouble();
            psi49 = Math.PI - Math.PI * 2 * rr.nextDouble();
            r2y = mat.rotationMat(phi49, "+y");
            r4z = mat.rotationMat(psi49, "+z");
            rg50 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg49))));
            double chRdc = restraints[5][0] + sigma * rr.nextGaussian();
            phiVec50 = this.phiCal(Syy, Szz, chRdc, rg50);
            rdcRms[0] = (chRdc - restraints[5][0]) * (chRdc - restraints[5][0]);
            rdcRms[1] = 0.0;
            int nn = 0;
            while (nn < phiVec50.size()) {
                phi50 = (Double)phiVec50.elementAt(nn);
                double nhRdc = (restraints[4][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                rdcRms[3] = (nhRdc * 1.0 - restraints[4][1]) * (nhRdc * 1.0 - restraints[4][1]);
                psiVec50 = this.psiCal(Syy, Szz, nhRdc, phi50, rg50);
                int nnn = 0;
                while (nnn < psiVec50.size()) {
                    psi50 = (Double)psiVec50.elementAt(nnn);
                    r2y = mat.rotationMat(phi50, "+y");
                    r4z = mat.rotationMat(psi50, "+z");
                    rg51 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg50))));
                    chRdc = restraints[4][0] + sigma * rr.nextGaussian();
                    rdcRms[2] = (chRdc - restraints[4][0]) * (chRdc - restraints[4][0]);
                    phiVec51 = this.phiCal(Syy, Szz, chRdc, rg51);
                    int ii = 0;
                    while (ii < phiVec51.size()) {
                        phi51 = (Double)phiVec51.elementAt(ii);
                        nhRdc = (restraints[3][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                        rdcRms[5] = (nhRdc * 1.0 - restraints[3][1]) * (nhRdc * 1.0 - restraints[3][1]);
                        psiVec51 = this.psiCal(Syy, Szz, nhRdc, phi51, rg51);
                        int iii = 0;
                        while (iii < psiVec51.size()) {
                            psi51 = (Double)psiVec51.elementAt(iii);
                            r2y = mat.rotationMat(phi51, "+y");
                            r4z = mat.rotationMat(psi51, "+z");
                            rg52 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg51))));
                            n2nh52 = rg52.transpose().times(Const.unitMinusZ);
                            n2ca52 = rg52.transpose().times(Const.n2caUnit);
                            chRdc = restraints[3][0] + sigma * rr.nextGaussian();
                            rdcRms[4] = (chRdc - restraints[3][0]) * (chRdc - restraints[3][0]);
                            rdcRms[7] = 0.0;
                            rdcRms[6] = 0.0;
                            phiVec52 = this.phiCal(Syy, Szz, chRdc, rg52);
                            int jj = 0;
                            while (jj < phiVec52.size()) {
                                phi52 = (Double)phiVec52.elementAt(jj);
                                chRdc = restraints[0][0] + sigma * rr.nextGaussian();
                                rdcRms[10] = (chRdc - restraints[0][0]) * (chRdc - restraints[0][0]);
                                alpha = rr.nextDouble() * Math.PI / 4.0;
                                beta = rr.nextDouble() * Math.PI / 8.0;
                                gamma = rr.nextDouble() * Math.PI / 4.0;
                                eulerMat = mat.eulerMat(alpha, beta, gamma);
                                rg56N = rg56.times(eulerMat);
                                psiVec55 = this.psiCalBackward(Syy, Szz, chRdc, rg56N);
                                i = 0;
                                while (i < psiVec55.size()) {
                                    psi55 = (Double)psiVec55.elementAt(i);
                                    nhRdc = (restraints[0][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                                    rdcRms[11] = (nhRdc * 1.0 - restraints[0][1]) * (nhRdc * 1.0 - restraints[0][1]);
                                    phiVec55 = this.phiCalBackward(Syy, Szz, nhRdc, psi55, rg56N);
                                    j = 0;
                                    while (j < phiVec55.size()) {
                                        phi55 = (Double)phiVec55.elementAt(j);
                                        r2yInv = mat.rotationMat(phi55, "-y");
                                        r4zInv = mat.rotationMat(psi55, "-z");
                                        rg55 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg56N))));
                                        chRdc = restraints[1][0] + sigma * rr.nextGaussian();
                                        rdcRms[8] = (chRdc - restraints[1][0]) * (chRdc - restraints[1][0]);
                                        psiVec54 = this.psiCalBackward(Syy, Szz, chRdc, rg55);
                                        int k = 0;
                                        while (k < psiVec54.size()) {
                                            psi54 = (Double)psiVec54.elementAt(k);
                                            nhRdc = (restraints[1][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                                            rdcRms[9] = (nhRdc * 1.0 - restraints[1][1]) * (nhRdc * 1.0 - restraints[1][1]);
                                            phiVec54 = this.phiCalBackward(Syy, Szz, nhRdc, psi54, rg55);
                                            int jjj = 0;
                                            while (jjj < phiVec54.size()) {
                                                phi54 = (Double)phiVec54.elementAt(jjj);
                                                r2yInv = mat.rotationMat(phi54, "-y");
                                                r4zInv = mat.rotationMat(psi54, "-z");
                                                rg54 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg55))));
                                                n2nh54 = rg54.transpose().times(Const.unitMinusZ);
                                                n2ca54 = rg54.transpose().times(Const.n2caUnit);
                                                solutionVec = this.phiPsiByPP13(n2ca52, n2nh52, n2ca54, n2nh54, phi52);
                                                if (!solutionVec.isEmpty()) {
                                                    int tt = 0;
                                                    while (tt < solutionVec.size()) {
                                                        solutions = (double[])solutionVec.elementAt(tt);
                                                        score = 0.0;
                                                        int kk = 0;
                                                        while (kk < 2 * N) {
                                                            score += rdcRms[kk];
                                                            ++kk;
                                                        }
                                                        rmsCal = Math.sqrt(0.5 * score / (double)N);
                                                        if (rmsCal < 8.0) {
                                                            phiS[0] = phi49;
                                                            psiS[0] = psi49;
                                                            phiS[1] = phi50;
                                                            psiS[1] = psi50;
                                                            phiS[2] = phi51;
                                                            psiS[2] = psi51;
                                                            phiS[3] = phi52;
                                                            psiS[3] = solutions[0];
                                                            phiS[4] = solutions[1];
                                                            psiS[4] = solutions[2];
                                                            phiS[5] = phi54;
                                                            psiS[5] = psi54;
                                                            phiS[6] = phi55;
                                                            psiS[6] = psi55;
                                                            pdbVec50To56 = mdc.modelBuild(phiS, psiS, n, nh, ca, no1 - 1, false);
                                                            pp = (Pdb)pdbVec50To56.elementAt(6);
                                                            atomVec = pp.getAtomVec();
                                                            int uu = 0;
                                                            while (uu < atomVec.size()) {
                                                                cc = atomVec.elementAt(uu);
                                                                atom = cc.getAtom();
                                                                if (atom.equals("N")) {
                                                                    n55Cal = cc.getXYZ();
                                                                } else if (atom.equals("H")) {
                                                                    nh55Cal = cc.getXYZ();
                                                                } else if (atom.equals("CA")) {
                                                                    ca55Cal = cc.getXYZ();
                                                                } else if (atom.equals("HA")) {
                                                                    ha55Cal = cc.getXYZ();
                                                                }
                                                                ++uu;
                                                            }
                                                            pp = (Pdb)pdbVec50To56.lastElement();
                                                            atomVec = pp.getAtomVec();
                                                            uu = 0;
                                                            while (uu < atomVec.size()) {
                                                                cc = atomVec.elementAt(uu);
                                                                atom = cc.getAtom();
                                                                if (atom.equals("N")) {
                                                                    n56Cal = cc.getXYZ();
                                                                } else if (atom.equals("H")) {
                                                                    nh56Cal = cc.getXYZ();
                                                                } else if (atom.equals("CA")) {
                                                                    ca56Cal = cc.getXYZ();
                                                                }
                                                                ++uu;
                                                            }
                                                            dis19Ha56Nh = this.length(this.internuclearVec(ha19, nh56Cal));
                                                            disN22N55 = this.length(this.internuclearVec(n22, n55Cal));
                                                            disHn23Ha55 = this.length(this.internuclearVec(hn23, ha55Cal));
                                                            helixPdbN = mdc.modelBuild(h56To59Phi, h56To59Psi, n56Cal, nh56Cal, ca56Cal, 56, false);
                                                            if (disN22N55 > 4.0 && disN22N55 < 6.0 && dis19Ha56Nh < 8.0 && dis19Ha56Nh > 2.0 && disHn23Ha55 < 6.0) {
                                                                System.out.println("Dis to ha19 " + dis19Ha56Nh + "  " + disN22N55 + "  " + disHn23Ha55 + "   " + rmsCal);
                                                                System.out.println("Angles:   " + alpha / (Math.PI / 180) + "  " + beta / (Math.PI / 180) + "  " + gamma / (Math.PI / 180));
                                                                pp = (Pdb)helixPdbN.elementAt(3);
                                                                atomVec = pp.getAtomVec();
                                                                int vv = 0;
                                                                while (vv < atomVec.size()) {
                                                                    cc = atomVec.elementAt(vv);
                                                                    atom = cc.getAtom();
                                                                    if (atom.equals("N")) {
                                                                        n59 = cc.getXYZ();
                                                                    } else if (atom.equals("H")) {
                                                                        nh59 = cc.getXYZ();
                                                                    } else if (atom.equals("CA")) {
                                                                        ca59 = cc.getXYZ();
                                                                    }
                                                                    ++vv;
                                                                }
                                                                dis2LastCA = this.length(this.internuclearVec(ca59, ca65));
                                                                System.out.println("disCa2Ca = " + dis2LastCA);
                                                                if (dis2LastCA > 8.5 && dis2LastCA < 13.0) {
                                                                    System.out.println("disCa2Ca == " + dis2LastCA);
                                                                    phiPsiVec = new Vector();
                                                                    pdbVec2.addAll(pdbVec50To56);
                                                                    pdbVec2.addAll(helixPdbN);
                                                                    pdbVec2.addAll(pdbVec65To71);
                                                                    vdwScore = this.vdwEnergy(pdbVec50To56, pdbVec2, cnt);
                                                                    pdbVec2 = new Vector();
                                                                    pdbVec2.addAll(pdbVec2To50);
                                                                    System.out.println("vdw " + vdwScore);
                                                                    if (vdwScore < 0.5 && cnt[0] < 9 || vdwScore < 0.75 && cnt[0] < 5 || vdwScore < 1.0 && cnt[0] < 3) {
                                                                        hasLoop59To65 = this.loop59To65(restraints2, Syy, Szz, 59, 64, n59, nh59, ca59, n65, nh65, ca65, phiPsiVec, rdcRmsd);
                                                                        if (!phiPsiVec.isEmpty()) {
                                                                            rT = rdcRmsd[0] + rmsCal;
                                                                            noSln = phiPsiVec.size() / 2;
                                                                            System.out.println(String.valueOf(noSln) + "  " + dis2LastCA + "  " + rmsCal + "  Score= " + rT + "  " + rdcRmsd[0] + "  " + vdwScore);
                                                                            int ww = 0;
                                                                            while (ww < noSln) {
                                                                                phiArray = (double[])phiPsiVec.elementAt(ww);
                                                                                psiArray = (double[])phiPsiVec.elementAt(ww + 1);
                                                                                pdbVec59To64 = mdc.modelBuild(phiArray, psiArray, n59, nh59, ca59, 59, false);
                                                                                System.out.println("MODEL      " + count);
                                                                                pp.print(pdbVec2To50);
                                                                                pp.print(pdbVec50To56);
                                                                                pp.print(helixPdbN);
                                                                                pp.print(pdbVec59To64);
                                                                                pp.print(pdbVec65To71);
                                                                                System.out.println("TER");
                                                                                System.out.println("ENDMODEL");
                                                                                System.out.println();
                                                                                ++count;
                                                                                ww += 2;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        ++tt;
                                                    }
                                                }
                                                ++jjj;
                                            }
                                            ++k;
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                                ++jj;
                            }
                            ++iii;
                        }
                        ++ii;
                    }
                    ++nnn;
                }
                ++nn;
            }
            ++mm;
        }
    }

    public boolean loop59To65(double[][] restraints, double Syy, double Szz, int no1, int no2, double[] n, double[] nh, double[] ca, double[] n2, double[] nh2, double[] ca2, Vector phiPsiVec, double[] rdcRmsd) {
        ModelRdc mdc = new ModelRdc();
        int N = no2 - no1 + 1;
        double[] nToNHVec = this.internuclearVec(n, nh);
        double[] nToCAVec = this.internuclearVec(n, ca);
        Matrix rg59 = this.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv59 = rg59.transpose();
        double[] nToNHVec2 = this.internuclearVec(n2, nh2);
        double[] nToCAVec2 = this.internuclearVec(n2, ca2);
        Matrix rg65 = this.RgCal(nToNHVec2, nToCAVec2);
        double disCa2Ca = this.length(this.internuclearVec(ca, ca2));
        Vector phiVec64 = new Vector();
        Vector psiVec64 = new Vector();
        Vector phiVec63 = new Vector();
        Vector psiVec63 = new Vector();
        Vector phiVec62 = new Vector();
        Vector psiVec62 = new Vector();
        Matrix r2yInv = new Matrix(3, 3);
        Matrix r4zInv = new Matrix(3, 3);
        Matrix rg64 = new Matrix(3, 3);
        Matrix rg63 = new Matrix(3, 3);
        Matrix rg62 = new Matrix(3, 3);
        Matrix rg61 = new Matrix(3, 3);
        Matrix rg60 = new Matrix(3, 3);
        Matrix r2y = new Matrix(3, 3);
        Matrix r4z = new Matrix(3, 3);
        Matrix mat = new Matrix(3, 3);
        double phi64 = 0.0;
        double psi64 = 0.0;
        double phi63 = 0.0;
        double psi63 = 0.0;
        double phi62 = 0.0;
        double psi62 = 0.0;
        double phi61 = 0.0;
        double psi61 = 0.0;
        double phi60 = 0.0;
        double psi60 = 0.0;
        double phi59 = 0.0;
        double psi59 = 0.0;
        double[] chVec59 = new double[3];
        double[] chVec60 = new double[3];
        double[] nhVec60 = new double[3];
        double[] chVec61 = new double[3];
        double[] nhVec61 = new double[3];
        double[] solutions = new double[3];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[][] nNhCaHa64 = new double[4][3];
        double[][] nNhCaHa63 = new double[4][3];
        double[][] nNhCaHa62 = new double[4][3];
        double[][] nNhCaHa61 = new double[4][3];
        double[][] nNhCaHa60 = new double[4][3];
        long seed = 74851987L;
        Random rr = new Random(seed);
        int nCycle = 1024;
        double sigma = 8.0;
        double[] rdcRms = new double[2 * N];
        int i = 0;
        while (i < 2 * N) {
            rdcRms[i] = 0.0;
            ++i;
        }
        double score = 0.0;
        double rmsCal = 100.0;
        double rT = 100.0;
        boolean count = true;
        double dis2LastCA = 0.0;
        int slnNo = 0;
        double[] solution1 = new double[2];
        double[] solution2 = new double[2];
        double[] solution3 = new double[2];
        Vector solutionVec = new Vector();
        boolean hasSolution = false;
        boolean hasPhiPsi = false;
        int mm = 0;
        while (mm < nCycle) {
            score = 0.0;
            int iii = 0;
            while (iii < 2 * N) {
                rdcRms[iii] = 0.0;
                ++iii;
            }
            double chRdc = restraints[0][0] + sigma * rr.nextGaussian();
            rdcRms[0] = (chRdc - restraints[0][0]) * (chRdc - restraints[0][0]);
            psiVec64 = this.psiCalBackward(Syy, Szz, chRdc, rg65);
            i = 0;
            while (i < psiVec64.size()) {
                psi64 = (Double)psiVec64.elementAt(i);
                double nhRdc = (restraints[0][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                rdcRms[1] = (nhRdc * 1.0 - restraints[0][1]) * (nhRdc * 1.0 - restraints[0][1]);
                phiVec64 = this.phiCalBackward(Syy, Szz, nhRdc, psi64, rg65);
                int uu = 0;
                while (uu < phiVec64.size()) {
                    phi64 = (Double)phiVec64.elementAt(uu);
                    nNhCaHa64 = mdc.nNhCaHaByBackward(phi64, psi64, n2, nh2, ca2);
                    r2yInv = mat.rotationMat(phi64, "-y");
                    r4zInv = mat.rotationMat(psi64, "-z");
                    rg64 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg65))));
                    chRdc = restraints[1][0] + sigma * rr.nextGaussian();
                    rdcRms[2] = (chRdc - restraints[1][0]) * (chRdc - restraints[1][0]);
                    psiVec63 = this.psiCalBackward(Syy, Szz, chRdc, rg64);
                    int ii = 0;
                    while (ii < psiVec63.size()) {
                        psi63 = (Double)psiVec63.elementAt(ii);
                        nhRdc = (restraints[1][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                        rdcRms[3] = (nhRdc * 1.0 - restraints[1][1]) * (nhRdc * 1.0 - restraints[1][1]);
                        phiVec63 = this.phiCalBackward(Syy, Szz, nhRdc, psi63, rg64);
                        int j = 0;
                        while (j < phiVec63.size()) {
                            phi63 = (Double)phiVec63.elementAt(j);
                            nNhCaHa63 = mdc.nNhCaHaByBackward(phi63, psi63, nNhCaHa64[0], nNhCaHa64[1], nNhCaHa64[2]);
                            r2yInv = mat.rotationMat(phi63, "-y");
                            r4zInv = mat.rotationMat(psi63, "-z");
                            rg63 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg64))));
                            chRdc = restraints[2][0] + sigma * rr.nextGaussian();
                            rdcRms[4] = (chRdc - restraints[2][0]) * (chRdc - restraints[2][0]);
                            psiVec62 = this.psiCalBackward(Syy, Szz, chRdc, rg63);
                            int k = 0;
                            while (k < psiVec62.size()) {
                                psi62 = (Double)psiVec62.elementAt(k);
                                nhRdc = (restraints[2][1] + 0.5 * sigma * rr.nextGaussian()) / 1.0;
                                rdcRms[5] = (nhRdc * 1.0 - restraints[2][1]) * (nhRdc * 1.0 - restraints[2][1]);
                                phiVec62 = this.phiCalBackward(Syy, Szz, nhRdc, psi62, rg63);
                                int jj = 0;
                                while (jj < phiVec62.size()) {
                                    phi62 = (Double)phiVec62.elementAt(jj);
                                    nNhCaHa62 = mdc.nNhCaHaByBackward(phi62, psi62, nNhCaHa63[0], nNhCaHa63[1], nNhCaHa63[2]);
                                    r2yInv = mat.rotationMat(phi62, "-y");
                                    r4zInv = mat.rotationMat(psi62, "-z");
                                    rg62 = Const.r1x9yInv.times(r2yInv.times(Const.r3xInv).times(r4zInv.times(Const.rot1.times(rg63))));
                                    disCa2Ca = this.length(this.internuclearVec(ca, nNhCaHa62[2]));
                                    if (disCa2Ca < 11.0 && disCa2Ca > 8.0) {
                                        hasSolution = this.phiPsiByPP14(ca, nNhCaHa62[0], nNhCaHa62[2], nNhCaHa62[1], rg59, rg62, solutionVec);
                                        if (hasSolution) {
                                            slnNo = solutionVec.size() / 3;
                                            int ww = 0;
                                            while (ww < slnNo) {
                                                solution1 = (double[])solutionVec.elementAt(ww);
                                                phi59 = solution1[0];
                                                psi59 = solution1[1];
                                                r2y = mat.rotationMat(phi59, "+y");
                                                r4z = mat.rotationMat(psi59, "+z");
                                                chVec59 = rgInv59.times(Const.r1x9yInv.times(r2y.transpose().times(Const.dirCosCHcnt)));
                                                double chRdc59 = (-Syy - Szz) * chVec59[0] * chVec59[0] + Syy * chVec59[1] * chVec59[1] + Szz * chVec59[2] * chVec59[2];
                                                rdcRms[10] = (chRdc59 - restraints[5][0]) * (chRdc59 - restraints[5][0]);
                                                rdcRms[11] = 0.0;
                                                rg60 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg59))));
                                                nhVec60 = rg60.transpose().times(Const.unitMinusZ);
                                                double nhRdc60 = (-Syy - Szz) * nhVec60[0] * nhVec60[0] + Syy * nhVec60[1] * nhVec60[1] + Szz * nhVec60[2] * nhVec60[2];
                                                rdcRms[9] = (nhRdc60 * 1.0 - restraints[4][1]) * (nhRdc60 * 1.0 - restraints[4][1]);
                                                solution2 = (double[])solutionVec.elementAt(ww + 1);
                                                phi60 = solution2[0];
                                                psi60 = solution2[1];
                                                r2y = mat.rotationMat(phi60, "+y");
                                                r4z = mat.rotationMat(psi60, "+z");
                                                chVec60 = rg60.transpose().times(Const.r1x9yInv.times(r2y.transpose().times(Const.dirCosCHcnt)));
                                                double chRdc60 = (-Syy - Szz) * chVec60[0] * chVec60[0] + Syy * chVec60[1] * chVec60[1] + Szz * chVec60[2] * chVec60[2];
                                                rdcRms[8] = (chRdc60 - restraints[4][0]) * (chRdc60 - restraints[4][0]);
                                                rg61 = Const.rot1Inv.times(r4z.times(Const.r3x).times(r2y.times(Const.r9y1x.times(rg60))));
                                                nhVec61 = rg61.transpose().times(Const.unitMinusZ);
                                                double nhRdc61 = (-Syy - Szz) * nhVec61[0] * nhVec61[0] + Syy * nhVec61[1] * nhVec61[1] + Szz * nhVec61[2] * nhVec61[2];
                                                rdcRms[7] = (nhRdc61 * 1.0 - restraints[3][1]) * (nhRdc61 * 1.0 - restraints[3][1]);
                                                solution3 = (double[])solutionVec.elementAt(ww + 2);
                                                phi61 = solution3[0];
                                                psi61 = solution3[1];
                                                r2y = mat.rotationMat(phi61, "+y");
                                                r4z = mat.rotationMat(psi61, "+z");
                                                chVec61 = rg61.transpose().times(Const.r1x9yInv.times(r2y.transpose().times(Const.dirCosCHcnt)));
                                                double chRdc61 = (-Syy - Szz) * chVec61[0] * chVec61[0] + Syy * chVec61[1] * chVec61[1] + Szz * chVec61[2] * chVec61[2];
                                                rdcRms[6] = (chRdc61 - restraints[3][0]) * (chRdc61 - restraints[3][0]);
                                                score = 0.0;
                                                int kkk = 0;
                                                while (kkk < 2 * N) {
                                                    score += rdcRms[kkk];
                                                    ++kkk;
                                                }
                                                rmsCal = Math.sqrt(0.5 * score / (double)N);
                                                if (rmsCal < 8.0 && rmsCal < rT) {
                                                    System.out.println("RMSd= " + rmsCal);
                                                    System.out.println(" dis =" + disCa2Ca);
                                                    rT = rmsCal;
                                                    phiS[0] = phi59;
                                                    psiS[0] = psi59;
                                                    phiS[1] = phi60;
                                                    psiS[1] = psi60;
                                                    phiS[2] = phi61;
                                                    psiS[2] = psi61;
                                                    phiS[3] = phi62;
                                                    psiS[3] = psi62;
                                                    phiS[4] = phi63;
                                                    psiS[4] = psi63;
                                                    phiS[5] = phi64;
                                                    psiS[5] = psi64;
                                                    hasPhiPsi = true;
                                                }
                                                score = 0.0;
                                                ww += 3;
                                            }
                                        }
                                        solutionVec = new Vector();
                                    }
                                    ++jj;
                                }
                                ++k;
                            }
                            ++j;
                        }
                        ++ii;
                    }
                    ++uu;
                }
                ++i;
            }
            ++mm;
        }
        if (hasPhiPsi) {
            phiPsiVec.add(phiS);
            phiPsiVec.add(psiS);
            rdcRmsd[0] = rT;
        }
        return hasPhiPsi;
    }

    protected Object clone() {
        try {
            Object s = super.clone();
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class PPComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            PhiPsi n1 = (PhiPsi)o1;
            PhiPsi n2 = (PhiPsi)o2;
            int d1 = n1.getResidueNo();
            if (d1 < (d2 = n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

