/*
 * Decompiled with CFR 0.152.
 */
package NascaGUI;

import NascaGUI.Global;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import rdcPanda.Assign;

public class ParametersJFrame
extends JFrame {
    private double haErrDefault = 0.03;
    private double h1ErrDefault = 0.03;
    private double c13ErrDefault = 0.3;
    private double hnErrDefault = 0.03;
    private double nErrDefault = 0.3;
    private double noeDistLimitDefault = 5.0;
    private String strInputDefault = String.valueOf(System.getProperty("user.dir")) + "/inputFiles/";
    private String strOutDefault = String.valueOf(System.getProperty("user.dir")) + "/inputFiles/";
    private JButton jButtonApply;
    private JButton jButtonCancel;
    private JButton jButtonDefaultInputPath;
    private JButton jButtonDefaultOutputPath;
    private JButton jButtonDefaultSetting;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSpinner jSpinnerErrCa;
    private JSpinner jSpinnerErrH1;
    private JSpinner jSpinnerErrHa;
    private JSpinner jSpinnerErrHn;
    private JSpinner jSpinnerErrN;
    private JSpinner jSpinnerErrNoeLimit;
    private JTextField jTextFieldDefaultInputPath;
    private JTextField jTextFieldDefaultOutputPath;

    public ParametersJFrame() {
        this.createNumberSpinner();
        this.initComponents();
        String userDir = System.getProperty("user.dir");
        String srcNascaSystemDefault = String.valueOf(userDir) + "/system/nasca/nasca_system_default.input";
        this.readDefaultSystemParameters(srcNascaSystemDefault);
    }

    private void createNumberSpinner() {
        Double current = new Double(0.03);
        Double min = new Double(0.0);
        Double max = new Double(1.0);
        Double step = new Double(0.01);
        SpinnerNumberModel m_numberSpinnerModel = new SpinnerNumberModel(current, min, max, step);
        this.jSpinnerErrHa = new JSpinner(m_numberSpinnerModel);
    }

    private void readDefaultSystemParameters(String srcNascaSystemDefault) {
        Assign asg = new Assign();
        Vector<Map<String, String>> paraVec = asg.ParamReader(srcNascaSystemDefault);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                this.haErrDefault = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                this.h1ErrDefault = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                this.c13ErrDefault = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                this.hnErrDefault = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                this.nErrDefault = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("NOELIMIT")) {
                this.noeDistLimitDefault = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("INPUT_DIRECTORY")) {
                this.strInputDefault = Global.getCorrectFilePathAndName(paraMap.get("INPUT_DIRECTORY"));
            }
            if (paraMap.containsKey("OUTPUT_DIRECTORY")) {
                this.strOutDefault = Global.getCorrectFilePathAndName(paraMap.get("OUTPUT_DIRECTORY"));
            }
            ++i;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSpinnerErrHa = new JSpinner(new SpinnerNumberModel(Global.haErr, 0.0, 0.5, 0.01));
        this.jLabel2 = new JLabel();
        this.jSpinnerErrHn = new JSpinner(new SpinnerNumberModel(Global.hnErr, 0.0, 0.5, 0.01));
        this.jLabel3 = new JLabel();
        this.jSpinnerErrH1 = new JSpinner(new SpinnerNumberModel(Global.h1Err, 0.0, 0.5, 0.01));
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSpinnerErrCa = new JSpinner(new SpinnerNumberModel(Global.c13Err, 0.0, 5.0, 0.05));
        this.jSpinnerErrN = new JSpinner(new SpinnerNumberModel(Global.nErr, 0.0, 5.0, 0.05));
        this.jSpinnerErrNoeLimit = new JSpinner(new SpinnerNumberModel(Global.noeDistLimit, 0.0, 7.5, 0.5));
        this.jLabel6 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jTextFieldDefaultInputPath = new JTextField(Global.getInputFilePath());
        this.jLabel8 = new JLabel();
        this.jTextFieldDefaultOutputPath = new JTextField(Global.getOutputFilePath());
        this.jButtonDefaultOutputPath = new JButton();
        this.jButtonDefaultInputPath = new JButton();
        this.jButtonDefaultSetting = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonApply = new JButton();
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Error Windows (in ppm)", 2, 0, new Font("Tahoma", 1, 11)));
        this.jPanel1.setToolTipText("Error windows for constructing the NOESY graph");
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Ha:");
        this.jSpinnerErrHa.setToolTipText("Error window for Ha");
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Hn:");
        this.jSpinnerErrHn.setToolTipText("Error window for Hn");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("H1:");
        this.jSpinnerErrH1.setToolTipText("Error window for H1");
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("Ca:");
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("N:");
        this.jSpinnerErrCa.setToolTipText("Error window for Ca");
        this.jSpinnerErrN.setToolTipText("Error window for N");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, 24, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -1, 30, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerErrCa, -2, 60, -2).addComponent(this.jSpinnerErrHa, -2, 60, -2)).addGap(66, 66, 66).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel2, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jSpinnerErrHn, -2, 60, -2).addGap(61, 61, 61).addComponent(this.jLabel3, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addComponent(this.jSpinnerErrH1, -2, 60, -2)).addComponent(this.jSpinnerErrN, -2, 60, -2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jSpinnerErrH1, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jSpinnerErrHn, -2, -1, -2).addComponent(this.jSpinnerErrHa, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jSpinnerErrCa, -2, -1, -2))).addGroup(jPanel1Layout.createSequentialGroup().addGap(38, 38, 38).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerErrN, -2, -1, -2).addComponent(this.jLabel5)))).addContainerGap(19, Short.MAX_VALUE)));
        this.jSpinnerErrNoeLimit.setToolTipText("NOE distance threashold for contructing edges between proton labels");
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText("NOE Distance Threshold (in angstrom):");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder(""), "Default File Paths", 2, 0, new Font("Tahoma", 1, 11)));
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText("Input File Directory:");
        this.jLabel7.setToolTipText("Backbone coordinate file");
        this.jTextFieldDefaultInputPath.setToolTipText("Default input file directory");
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText("Output File Directory:");
        this.jLabel8.setToolTipText("Backbone coordinate file");
        this.jTextFieldDefaultOutputPath.setToolTipText("Default output file directory");
        this.jButtonDefaultOutputPath.setFont(new Font("Tahoma", 1, 11));
        this.jButtonDefaultOutputPath.setText("Browse...");
        this.jButtonDefaultOutputPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersJFrame.this.jButtonDefaultOutputPathActionPerformed(evt);
            }
        });
        this.jButtonDefaultInputPath.setFont(new Font("Tahoma", 1, 11));
        this.jButtonDefaultInputPath.setText("Browse...");
        this.jButtonDefaultInputPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersJFrame.this.jButtonDefaultInputPathActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldDefaultOutputPath, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldDefaultInputPath, GroupLayout.Alignment.TRAILING, -1, 266, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonDefaultOutputPath).addComponent(this.jButtonDefaultInputPath)).addContainerGap(20, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jTextFieldDefaultInputPath, -2, 22, -2).addComponent(this.jButtonDefaultInputPath)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldDefaultOutputPath, -2, 22, -2).addComponent(this.jButtonDefaultOutputPath).addComponent(this.jLabel8)).addContainerGap(21, Short.MAX_VALUE)));
        this.jButtonDefaultSetting.setFont(new Font("Tahoma", 1, 11));
        this.jButtonDefaultSetting.setText("Default");
        this.jButtonDefaultSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersJFrame.this.jButtonDefaultSettingActionPerformed(evt);
            }
        });
        this.jButtonCancel.setFont(new Font("Tahoma", 1, 11));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersJFrame.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonApply.setFont(new Font("Tahoma", 1, 11));
        this.jButtonApply.setText("Apply");
        this.jButtonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersJFrame.this.jButtonApplyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(117, Short.MAX_VALUE).addComponent(this.jButtonDefaultSetting).addGap(63, 63, 63).addComponent(this.jButtonApply).addGap(56, 56, 56).addComponent(this.jButtonCancel).addGap(128, 128, 128)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addContainerGap(24, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(59, 59, 59).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerErrNoeLimit, -2, 66, -2).addGap(202, 202, 202)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(79, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerErrNoeLimit, -2, -1, -2).addComponent(this.jLabel6)).addGap(26, 26, 26).addComponent(this.jPanel2, -2, -1, -2).addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonApply).addComponent(this.jButtonDefaultSetting)).addContainerGap(33, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonDefaultOutputPathActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(sourceFile);
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextFieldDefaultOutputPath.setText(chooser.getCurrentDirectory() + File.separator + sourceFile.getName());
        }
    }

    private void jButtonDefaultSettingActionPerformed(ActionEvent evt) {
        this.jSpinnerErrHa.setValue(this.haErrDefault);
        this.jSpinnerErrHn.setValue(this.hnErrDefault);
        this.jSpinnerErrH1.setValue(this.h1ErrDefault);
        this.jSpinnerErrCa.setValue(this.c13ErrDefault);
        this.jSpinnerErrN.setValue(this.nErrDefault);
        this.jSpinnerErrNoeLimit.setValue(this.noeDistLimitDefault);
        this.jTextFieldDefaultInputPath.setText(this.strInputDefault);
        this.jTextFieldDefaultOutputPath.setText(this.strOutDefault);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonApplyActionPerformed(ActionEvent evt) {
        Global.haErr = (Double)this.jSpinnerErrHa.getValue();
        Global.hnErr = (Double)this.jSpinnerErrHn.getValue();
        Global.h1Err = (Double)this.jSpinnerErrH1.getValue();
        Global.c13Err = (Double)this.jSpinnerErrCa.getValue();
        Global.nErr = (Double)this.jSpinnerErrN.getValue();
        Global.noeDistLimit = (Double)this.jSpinnerErrNoeLimit.getValue();
        Global.strInput = this.jTextFieldDefaultInputPath.getText();
        Global.strOut = this.jTextFieldDefaultOutputPath.getText();
        String userDir = System.getProperty("user.dir");
        String srcNascaSystem = String.valueOf(userDir) + "/system/nasca/nasca_system.input";
        this.writeSystemParametersToFile(srcNascaSystem);
        this.dispose();
    }

    private void writeSystemParametersToFile(String strOutputFileName) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(strOutputFileName)));
            out.println("//error windows (in the ppm unit) in each dimension,");
            out.println("//for constructing the NOESY graph");
            out.println("haErr    = " + String.format("%.3f", Global.haErr) + ";");
            out.println("hnErr    = " + String.format("%.3f", Global.hnErr) + ";");
            out.println("h1Err    = " + String.format("%.3f", Global.h1Err) + ";");
            out.println("c13Err   = " + String.format("%.3f", Global.c13Err) + ";");
            out.println("nErr     = " + String.format("%.3f", Global.nErr) + ";");
            out.println();
            out.println();
            out.println("//distance threashold for constructing edges between proton labels");
            out.println("noeLimit = " + String.format("%.2f", Global.noeDistLimit) + ";");
            out.println();
            out.println();
            out.println("//default input file directory");
            out.println("input_directory = " + Global.strInput + ";");
            out.println();
            out.println();
            out.println("//default output file directory");
            out.println("output_directory = " + Global.strOut + ";");
            out.println();
            out.println();
            out.println("//default input session file name");
            out.println("input_session_file=/inputFiles/Nasca.input;");
            out.println();
            out.println();
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + strOutputFileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    private void jButtonDefaultInputPathActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(sourceFile);
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextFieldDefaultInputPath.setText(chooser.getCurrentDirectory() + File.separator + sourceFile.getName());
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ParametersJFrame().setVisible(true);
            }
        });
    }
}

