/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.Dipolar;
import rdcPanda.Hbond;
import rdcPanda.Matrix;
import rdcPanda.Pdb;
import rdcPanda.PdbRdc;
import rdcPanda.PdbRmsd;
import rdcPanda.PhiPsi;
import rdcPanda.ppGlobal;
import rdcPanda.vdw;

public class ModelRdc
implements Cloneable {
    private int residueNo;
    private String residue;
    private double phi;
    private double psi;

    public ModelRdc() {
        this.residueNo = 0;
        this.residue = null;
        this.phi = 0.0;
        this.psi = 0.0;
    }

    public ModelRdc(int No) {
        this.residueNo = No;
        this.residue = "";
        this.phi = 0.0;
        this.psi = 0.0;
    }

    public ModelRdc(int no, String re, double x, double y) {
        this.residueNo = no;
        this.residue = re;
        this.phi = x;
        this.psi = y;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidue() {
        return this.residue;
    }

    public double getPhi() {
        return this.phi;
    }

    public double getPsi() {
        return this.psi;
    }

    public String toString() {
        String desc = String.valueOf(String.valueOf(this.residueNo)) + "  " + this.residue + "  " + String.valueOf(this.phi * 180.0 / Math.PI) + "  " + String.valueOf(this.psi * 180.0 / Math.PI);
        return desc;
    }

    public double length(double[] v1) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        return v1Len;
    }

    public double interAngle(double[] v1, double[] v2) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        double v2Len = Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2]);
        double c = (v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2]) / (v1Len * v2Len);
        return Math.acos(c);
    }

    public double[] dirCos(double[] vec) {
        double len = 0.0;
        double[] dirs = new double[vec.length];
        int i = 0;
        while (i < vec.length) {
            len += vec[i] * vec[i];
            ++i;
        }
        int j = 0;
        while (j < vec.length) {
            dirs[j] = vec[j] / Math.sqrt(len);
            ++j;
        }
        return dirs;
    }

    public double[] internuclearVec(double[] n1, double[] n2) {
        return new double[]{n2[0] - n1[0], n2[1] - n1[1], n2[2] - n1[2]};
    }

    public double[] addCoords(double[] n1, double[] n2) {
        return new double[]{n2[0] + n1[0], n2[1] + n1[1], n2[2] + n1[2]};
    }

    public double[][] haCoCoords(double phi, double[] n1, double[] nh1, double[] ca1) {
        Matrix rg = Matrix.identity(3, 3);
        Matrix rgInv = new Matrix(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        PhiPsi ff = new PhiPsi();
        double[] nToNHVec = this.internuclearVec(n1, nh1);
        double[] nToCAVec = this.internuclearVec(n1, ca1);
        rg = ff.RgCal(nToNHVec, nToCAVec);
        rgInv = rg.transpose();
        Matrix matT = rgInv.times(Const.r1x9yInv.times(r2yInv));
        double[] coordHA = new double[]{0.0, 0.0, 1.09};
        double[] caToHAVec = matT.times(Const.rHA2HA1Inv.times(coordHA));
        coordHA = this.addCoords(caToHAVec, ca1);
        matT = matT.times(Const.r3xInv);
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = matT.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca1);
        double[][] haco = new double[2][3];
        haco[0] = coordHA;
        haco[1] = coordCO;
        return haco;
    }

    public double[][] haCoCoords(double phi, double[] n1, double[] nh1, double[] ca1, boolean first) {
        Matrix rg = Matrix.identity(3, 3);
        Matrix rgInv = new Matrix(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        if (!first) {
            PhiPsi ff = new PhiPsi();
            double[] nToNHVec = this.internuclearVec(n1, nh1);
            double[] nToCAVec = this.internuclearVec(n1, ca1);
            rg = ff.RgCal(nToNHVec, nToCAVec);
        }
        rgInv = rg.transpose();
        Matrix matT = rgInv.times(Const.r1x9yInv.times(r2yInv));
        double[] coordHA = new double[]{0.0, 0.0, 1.09};
        double[] caToHAVec = matT.times(Const.rHA2HA1Inv.times(coordHA));
        coordHA = this.addCoords(caToHAVec, ca1);
        matT = matT.times(Const.r3xInv);
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = matT.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca1);
        double[][] haco = new double[2][3];
        haco[0] = coordHA;
        haco[1] = coordCO;
        return haco;
    }

    public void PrintAllByGridSearch(Vector vecHelixBB, Vector<Dipolar> rdc1Vec, Vector<Dipolar> rdc2Vec, double Syy, double Szz, double resolution, double rdcRmsdThreshold) {
        PdbRdc pdr = new PdbRdc();
        Pdb pp = new Pdb();
        double[] rmsds = new double[2];
        boolean debugEulerFit = true;
        Matrix[] mm = new Matrix[4];
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        rdc1Rms = rmsds[0];
        rdc2Rms = rmsds[1];
        Vector<Pdb> helixVecN = new Vector();
        Matrix[] mm_temp = new Matrix[4];
        int i = 3;
        helixVecN = pp.newPdb(vecHelixBB, Const.mat4ThreeDirs[i - 1]);
        mm_temp[0] = pdr.eulerFitPrintEnsemble(helixVecN, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit, rdcRmsdThreshold);
        rdc1Rms = rmsds[0];
        rdc2Rms = rmsds[1];
        Vector<Pdb> vecPdbOptimal = pp.newPdb(vecHelixBB, mm_temp[0]);
    }

    public double[][] nNhCaCal(double phi, double psi, double[] n, double[] nh, double[] ca) {
        Matrix rg = Matrix.identity(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        double[] nToNHVec = this.internuclearVec(n, nh);
        double[] nToCAVec = this.internuclearVec(n, ca);
        PhiPsi ff = new PhiPsi();
        rg = ff.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv = rg.transpose();
        Matrix mat = rgInv.times(Const.r1x9yInv.times(r2yInv.times(Const.r3xInv)));
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = mat.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca);
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        mat = mat.times(r4zInv.times(Const.r5xInv));
        double[] co1ToNVec = mat.times(coordN);
        coordN = this.addCoords(coordCO, co1ToNVec);
        nToCAVec = mat.times(Const.dirCAcnt);
        double[] coordCA = this.addCoords(coordN, nToCAVec);
        nToNHVec = mat.times(Const.dirNHcnt);
        double[] coordNH = this.addCoords(coordN, nToNHVec);
        double[][] nHnCaCoords = new double[3][3];
        nHnCaCoords[0] = coordN;
        nHnCaCoords[1] = coordCA;
        nHnCaCoords[2] = coordNH;
        return nHnCaCoords;
    }

    public double[][] nNhCaCal(double phi, double psi, double[] n, double[] nh, double[] ca, boolean first) {
        Matrix rg = Matrix.identity(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        double[] nToNHVec = this.internuclearVec(n, nh);
        double[] nToCAVec = this.internuclearVec(n, ca);
        PhiPsi ff = new PhiPsi();
        if (!first) {
            rg = ff.RgCal(nToNHVec, nToCAVec);
        }
        Matrix rgInv = rg.transpose();
        Matrix mat = rgInv.times(Const.r1x9yInv.times(r2yInv.times(Const.r3xInv)));
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = mat.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca);
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        mat = mat.times(r4zInv.times(Const.r5xInv));
        double[] co1ToNVec = mat.times(coordN);
        coordN = this.addCoords(coordCO, co1ToNVec);
        nToCAVec = mat.times(Const.dirCAcnt);
        double[] coordCA = this.addCoords(coordN, nToCAVec);
        nToNHVec = mat.times(Const.dirNHcnt);
        double[] coordNH = this.addCoords(coordN, nToNHVec);
        double[][] nHnCaCoords = new double[3][3];
        nHnCaCoords[0] = coordN;
        nHnCaCoords[1] = coordCA;
        nHnCaCoords[2] = coordNH;
        return nHnCaCoords;
    }

    public double[][] nNhCaHaByBackward(double phi, double psi, double[] n1, double[] nh1, double[] ca1) {
        double[] nToNHVec = this.internuclearVec(n1, nh1);
        double[] nToCAVec = this.internuclearVec(n1, ca1);
        PhiPsi ff = new PhiPsi();
        Matrix rg = ff.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv = rg.transpose();
        double[] n2coCnt = new double[]{0.0, 0.0, 1.329};
        Matrix mat = rgInv.times(Const.r9z1xAlphaInv);
        double[] n2co = mat.times(n2coCnt);
        double[] coCal = this.addCoords(n1, n2co);
        double[] co2caCnt = new double[]{0.0, 0.0, 1.525};
        mat = mat.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv));
        double[] co2ca = mat.times(co2caCnt);
        double[] caCal = this.addCoords(coCal, co2ca);
        Matrix rzPsiInv = mat.rotationMat(psi + Math.PI, "-z");
        mat = mat.times(rzPsiInv.times(Const.r3xAlphaInv));
        double[] ca2n = mat.times(Const.coordCA);
        double[] nCal = this.addCoords(caCal, ca2n);
        Matrix matHA = mat.times(Const.matHAInv);
        double[] haCal = this.addCoords(caCal, matHA.times(Const.coordHA));
        Matrix ryPhiInv = mat.rotationMat(phi, "-y");
        Matrix ra10Inv = rg.rotationMat(Math.PI, "-y");
        mat = mat.times(Const.r8yAlphaInv.times(ryPhiInv.times(ra10Inv.times(Const.r5xAlphaInv))));
        double[] n2nh = mat.times(Const.coordNH);
        double[] nhCal = this.addCoords(nCal, n2nh);
        double[][] nNhCaHaCoords = new double[4][3];
        nNhCaHaCoords[0] = nCal;
        nNhCaHaCoords[1] = nhCal;
        nNhCaHaCoords[2] = caCal;
        nNhCaHaCoords[3] = haCal;
        return nNhCaHaCoords;
    }

    public Pdb coordByBackward(double phi, double psi, double[] n1, double[] nh1, double[] ca1, int residueNo, String resid1) {
        double[] nToNHVec = this.internuclearVec(n1, nh1);
        double[] nToCAVec = this.internuclearVec(n1, ca1);
        PhiPsi ff = new PhiPsi();
        Matrix rg = ff.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv = rg.transpose();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        double[] n2coCnt = new double[]{0.0, 0.0, 1.329};
        double[] n2co = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(n2coCnt)));
        double[] coCal = this.addCoords(n1, n2co);
        double[] co2oCnt = new double[]{0.0, 1.231, 0.0};
        double[] co2o = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.matOInv.times(co2oCnt))));
        double[] o2Cal = this.addCoords(coCal, co2o);
        double[] co2caCnt = new double[]{0.0, 0.0, 1.525};
        Matrix mat = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv))));
        double[] co2ca = mat.times(co2caCnt);
        double[] caCal = this.addCoords(coCal, co2ca);
        Matrix rzPsiInv = mat.rotationMat(psi + Math.PI, "-z");
        mat = mat.times(rzPsiInv.times(Const.r3xAlphaInv));
        double[] ca2nCnt = new double[]{0.0, 1.458, 0.0};
        double[] ca2n = mat.times(ca2nCnt);
        double[] nCal = this.addCoords(caCal, ca2n);
        double[] haCnt = new double[]{0.0, 0.0, 1.09};
        Matrix matHA = mat.times(Const.matHAInv);
        double[] haCal = this.addCoords(caCal, matHA.times(haCnt));
        double[] cbCnt = new double[]{0.0, 0.0, 1.531};
        Matrix matCB = mat.times(Const.matCBInv);
        double[] cbCal = this.addCoords(caCal, matCB.times(cbCnt));
        Matrix ryPhiInv = mat.rotationMat(phi, "-y");
        Matrix ra10Inv = rg.rotationMat(Math.PI, "-y");
        mat = mat.times(Const.r8yAlphaInv.times(ryPhiInv.times(ra10Inv.times(Const.r5xAlphaInv))));
        double[] n2nhCnt = new double[]{0.0, 0.0, -1.02};
        double[] n2nh = mat.times(n2nhCnt);
        double[] nhCal = this.addCoords(nCal, n2nh);
        atomVec.add(new Cartesian("N", nCal));
        atomVec.add(new Cartesian("HN", nhCal));
        atomVec.add(new Cartesian("CA", caCal));
        atomVec.add(new Cartesian("HA", haCal));
        atomVec.add(new Cartesian("CB", cbCal));
        atomVec.add(new Cartesian("C", coCal));
        atomVec.add(new Cartesian("O", o2Cal));
        return new Pdb(residueNo, resid1, atomVec);
    }

    public Vector coordByBackwardNew(double phi, double psi, double[] n1, double[] nh1, double[] ca1, int residueNo) {
        double[] nToNHVec = this.internuclearVec(n1, nh1);
        double[] nToCAVec = this.internuclearVec(n1, ca1);
        PhiPsi ff = new PhiPsi();
        Matrix rg = ff.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv = rg.transpose();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        double[] n2coCnt = new double[]{0.0, 0.0, 1.329};
        double[] n2co = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(n2coCnt)));
        double[] coCal = this.addCoords(n1, n2co);
        double[] co2oCnt = new double[]{0.0, 1.231, 0.0};
        double[] co2o = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.matOInv.times(co2oCnt))));
        double[] o2Cal = this.addCoords(coCal, co2o);
        double[] co2caCnt = new double[]{0.0, 0.0, 1.525};
        Matrix mat = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv))));
        double[] co2ca = mat.times(co2caCnt);
        double[] caCal = this.addCoords(coCal, co2ca);
        Matrix rzPsiInv = mat.rotationMat(psi + Math.PI, "-z");
        mat = mat.times(rzPsiInv.times(Const.r3xAlphaInv));
        double[] ca2nCnt = new double[]{0.0, 1.458, 0.0};
        double[] ca2n = mat.times(ca2nCnt);
        double[] nCal = this.addCoords(caCal, ca2n);
        double[] haCnt = new double[]{0.0, 0.0, 1.09};
        Matrix matHA = mat.times(Const.matHAInv);
        double[] haCal = this.addCoords(caCal, matHA.times(haCnt));
        double[] cbCnt = new double[]{0.0, 0.0, 1.531};
        Matrix matCB = mat.times(Const.matCBInv);
        double[] cbCal = this.addCoords(caCal, matCB.times(cbCnt));
        Matrix ryPhiInv = mat.rotationMat(phi, "-y");
        Matrix ra10Inv = rg.rotationMat(Math.PI, "-y");
        mat = mat.times(Const.r8yAlphaInv.times(ryPhiInv.times(ra10Inv.times(Const.r5xAlphaInv))));
        double[] n2nhCnt = new double[]{0.0, 0.0, -1.02};
        double[] n2nh = mat.times(n2nhCnt);
        double[] nhCal = this.addCoords(nCal, n2nh);
        atomVec.add(new Cartesian("N", nCal));
        atomVec.add(new Cartesian("HN", nhCal));
        atomVec.add(new Cartesian("CA", caCal));
        atomVec.add(new Cartesian("HA", haCal));
        atomVec.add(new Cartesian("CB", cbCal));
        atomVec.add(new Cartesian("C", coCal));
        atomVec.add(new Cartesian("O", o2Cal));
        Vector<Pdb> vecPdb = new Vector<Pdb>();
        vecPdb.add(new Pdb(residueNo, "ALA", atomVec));
        nToNHVec = this.internuclearVec(nCal, nhCal);
        nToCAVec = this.internuclearVec(nCal, caCal);
        rg = ff.RgCal(nToNHVec, nToCAVec);
        rgInv = rg.transpose();
        atomVec = new Vector();
        n2co = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(n2coCnt)));
        coCal = this.addCoords(nCal, n2co);
        co2o = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.matOInv.times(co2oCnt))));
        o2Cal = this.addCoords(coCal, co2o);
        mat = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv))));
        co2ca = mat.times(co2caCnt);
        caCal = this.addCoords(coCal, co2ca);
        atomVec.add(new Cartesian("CA", caCal));
        atomVec.add(new Cartesian("C", coCal));
        atomVec.add(new Cartesian("O", o2Cal));
        vecPdb.add(new Pdb(residueNo - 1, "ALA", atomVec));
        Collections.sort(vecPdb, new Pdb.PdbComparator());
        return vecPdb;
    }

    public Pdb coordByResidue(double phi, double psi, double[] n1, double[] nh1, double[] ca1, int residueNo, String resid1, boolean first) {
        Matrix rg = Matrix.identity(3, 3);
        Matrix rgInv = new Matrix(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        double[] nToCO1Vec = new double[3];
        double[] coToCAVec = new double[3];
        double[] caToNVec = new double[3];
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        double[] nToNHVec = this.internuclearVec(n1, nh1);
        double[] nToCAVec = this.internuclearVec(n1, ca1);
        PhiPsi ff = new PhiPsi();
        if (!first) {
            rg = ff.RgCal(nToNHVec, nToCAVec);
        }
        rgInv = rg.transpose();
        Matrix matT = rgInv.times(Const.r1x9yInv.times(r2yInv));
        double[] coordHA = new double[]{0.0, 0.0, 1.09};
        double[] caToHAVec = matT.times(Const.rHA2HA1Inv.times(coordHA));
        coordHA = this.addCoords(caToHAVec, ca1);
        atomVec.add(new Cartesian("HA", coordHA[0], coordHA[1], coordHA[2]));
        double[] coordCb = new double[]{0.0, 0.0, 1.531};
        double[] caToCbVec = matT.times(Const.rCb2Cb1Inv.times(coordCb));
        coordCb = this.addCoords(caToCbVec, ca1);
        atomVec.add(new Cartesian("CB", coordCb[0], coordCb[1], coordCb[2]));
        matT = matT.times(Const.r3xInv);
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = matT.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca1);
        atomVec.add(new Cartesian("C", coordCO[0], coordCO[1], coordCO[2]));
        double[] coordO = new double[]{0.0, 0.0, 1.231};
        double[] coToOVec = matT.times(r4zInv.times(Const.rOInv.times(coordO)));
        coordO = this.addCoords(coToOVec, coordCO);
        atomVec.add(new Cartesian("O", coordO[0], coordO[1], coordO[2]));
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        matT = matT.times(r4zInv.times(Const.r5xInv));
        double[] co1ToNVec = matT.times(coordN);
        coordN = this.addCoords(coordCO, co1ToNVec);
        n1[0] = coordN[0];
        n1[1] = coordN[1];
        n1[2] = coordN[2];
        double[] coordCA = new double[]{0.0, 1.458, 0.0};
        matT = matT.times(Const.r6yInv.times(Const.r7xInv));
        nToCAVec = matT.times(Const.r8zInv.times(Const.r1xInv.times(coordCA)));
        coordCA = this.addCoords(coordN, nToCAVec);
        ca1[0] = coordCA[0];
        ca1[1] = coordCA[1];
        ca1[2] = coordCA[2];
        double[] coordNH = new double[]{0.0, 0.0, -1.02};
        double[] nToNHVec2 = matT.times(coordNH);
        coordNH = this.addCoords(coordN, nToNHVec2);
        nh1[0] = coordNH[0];
        nh1[1] = coordNH[1];
        nh1[2] = coordNH[2];
        return new Pdb(residueNo, resid1, atomVec);
    }

    public Pdb coordByResidueFull(double phi, double psi, double[] n1, double[] nh1, double[] ca1, int residueNo, String resid1, boolean first) {
        Matrix rg = Matrix.identity(3, 3);
        Matrix rgInv = new Matrix(3, 3);
        Matrix r2yInv = rg.rotationMat(phi, "-y");
        Matrix r4zInv = rg.rotationMat(psi + Math.PI, "-z");
        double[] nToCO1Vec = new double[3];
        double[] coToCAVec = new double[3];
        double[] caToNVec = new double[3];
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        atomVec.add(new Cartesian("N", n1[0], n1[1], n1[2]));
        atomVec.add(new Cartesian("HN", nh1[0], nh1[1], nh1[2]));
        atomVec.add(new Cartesian("CA", ca1[0], ca1[1], ca1[2]));
        double[] nToNHVec = this.internuclearVec(n1, nh1);
        double[] nToCAVec = this.internuclearVec(n1, ca1);
        PhiPsi ff = new PhiPsi();
        if (!first) {
            rg = ff.RgCal(nToNHVec, nToCAVec);
        }
        rgInv = rg.transpose();
        Matrix matT = rgInv.times(Const.r1x9yInv.times(r2yInv));
        double[] coordHA = new double[]{0.0, 0.0, 1.09};
        double[] caToHAVec = matT.times(Const.rHA2HA1Inv.times(coordHA));
        coordHA = this.addCoords(caToHAVec, ca1);
        atomVec.add(new Cartesian("HA", coordHA[0], coordHA[1], coordHA[2]));
        double[] coordCb = new double[]{0.0, 0.0, 1.531};
        double[] caToCbVec = matT.times(Const.rCb2Cb1Inv.times(coordCb));
        coordCb = this.addCoords(caToCbVec, ca1);
        atomVec.add(new Cartesian("CB", coordCb[0], coordCb[1], coordCb[2]));
        matT = matT.times(Const.r3xInv);
        double[] coordCO = new double[]{0.0, 0.0, 1.525};
        double[] caToCOVec = matT.times(coordCO);
        coordCO = this.addCoords(caToCOVec, ca1);
        atomVec.add(new Cartesian("C", coordCO[0], coordCO[1], coordCO[2]));
        double[] coordO = new double[]{0.0, 0.0, 1.231};
        double[] coToOVec = matT.times(r4zInv.times(Const.rOInv.times(coordO)));
        coordO = this.addCoords(coToOVec, coordCO);
        atomVec.add(new Cartesian("O", coordO[0], coordO[1], coordO[2]));
        double[] coordN = new double[]{0.0, 1.329, 0.0};
        matT = matT.times(r4zInv.times(Const.r5xInv));
        double[] co1ToNVec = matT.times(coordN);
        coordN = this.addCoords(coordCO, co1ToNVec);
        double[] coordCA = new double[]{0.0, 1.458, 0.0};
        matT = matT.times(Const.r6yInv.times(Const.r7xInv));
        nToCAVec = matT.times(Const.r8zInv.times(Const.r1xInv.times(coordCA)));
        coordCA = this.addCoords(coordN, nToCAVec);
        double[] coordNH = new double[]{0.0, 0.0, -1.02};
        double[] nToNHVec2 = matT.times(coordNH);
        coordNH = this.addCoords(coordN, nToNHVec2);
        return new Pdb(residueNo, resid1, atomVec);
    }

    public Vector modelBuild(Vector phiPsiVec, double[] n1, double[] nh1, double[] ca1) {
        Vector tmpVec = new Vector();
        int i = 0;
        int j = 0;
        double[] coordN = new double[3];
        System.arraycopy(n1, 0, coordN, 0, 3);
        double[] coordNH = new double[3];
        System.arraycopy(nh1, 0, coordNH, 0, 3);
        double[] coordCA = new double[3];
        System.arraycopy(ca1, 0, coordCA, 0, 3);
        double[] nhVec1 = new double[3];
        double[] n2CA = new double[3];
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVec = new Vector<Pdb>();
        Cartesian cc = new Cartesian();
        atomVec.add(new Cartesian("N", n1));
        atomVec.add(new Cartesian("H", nh1));
        atomVec.add(new Cartesian("CA", ca1));
        nhVec1 = this.internuclearVec(n1, nh1);
        Matrix rg = Matrix.identity(3, 3);
        PhiPsi ff = (PhiPsi)phiPsiVec.elementAt(0);
        int no = ff.getResidueNo();
        String resid1 = ff.getResidue();
        double phi = ff.getPhi();
        double psi = ff.getPsi();
        Pdb pp = this.coordByResidue(phi, psi, coordN, coordNH, coordCA, no, resid1, true);
        atomVec.addAll(pp.getAtomVec());
        pdbVec.add(new Pdb(no, resid1, atomVec));
        atomVec = new Vector();
        atomVec.add(new Cartesian("N", coordN));
        atomVec.add(new Cartesian("H", coordNH));
        atomVec.add(new Cartesian("CA", coordCA));
        nhVec1 = this.internuclearVec(coordN, coordNH);
        n2CA = this.internuclearVec(coordN, coordCA);
        rg = ff.RgCal(nhVec1, n2CA);
        double[] co1ToN = new double[3];
        double[] co1 = new double[3];
        String atom = "";
        i = 1;
        while (i < phiPsiVec.size()) {
            ff = (PhiPsi)phiPsiVec.elementAt(i);
            no = ff.getResidueNo();
            resid1 = ff.getResidue();
            phi = ff.getPhi();
            psi = ff.getPsi();
            pp = this.coordByResidue(phi, psi, coordN, coordNH, coordCA, no, resid1, false);
            atomVec.addAll(pp.getAtomVec());
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("C")) {
                    co1 = cc.getXYZ();
                }
                ++j;
            }
            pdbVec.add(new Pdb(no, resid1, atomVec));
            atomVec = new Vector();
            atomVec.add(new Cartesian("N", coordN));
            atomVec.add(new Cartesian("H", coordNH));
            atomVec.add(new Cartesian("CA", coordCA));
            nhVec1 = this.internuclearVec(coordN, coordNH);
            co1ToN = this.internuclearVec(coordN, co1);
            n2CA = this.internuclearVec(coordN, coordCA);
            if (i == phiPsiVec.size() - 1) {
                pdbVec.add(new Pdb(no + 1, resid1, atomVec));
            }
            rg = ff.RgCal(nhVec1, n2CA);
            ++i;
        }
        Vector<Pdb> vecPdbNew = new Vector<Pdb>();
        i = 0;
        while (i < pdbVec.size() - 1) {
            Pdb ppT = (Pdb)pdbVec.elementAt(i);
            vecPdbNew.add(ppT);
            ++i;
        }
        return vecPdbNew;
    }

    public Vector modelBuild(Vector phiPsiVec, double[] n1, double[] nh1, double[] ca1, boolean isLink) {
        Vector tmpVec = new Vector();
        int i = 0;
        int j = 0;
        double[] coordN = new double[3];
        System.arraycopy(n1, 0, coordN, 0, 3);
        double[] coordNH = new double[3];
        System.arraycopy(nh1, 0, coordNH, 0, 3);
        double[] coordCA = new double[3];
        System.arraycopy(ca1, 0, coordCA, 0, 3);
        double[] nhVec1 = new double[3];
        double[] n2CA = new double[3];
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVec = new Vector<Pdb>();
        Cartesian cc = new Cartesian();
        atomVec.add(new Cartesian("N", n1));
        atomVec.add(new Cartesian("H", nh1));
        atomVec.add(new Cartesian("CA", ca1));
        nhVec1 = this.internuclearVec(n1, nh1);
        Matrix rg = Matrix.identity(3, 3);
        PhiPsi ff = (PhiPsi)phiPsiVec.elementAt(0);
        int no = ff.getResidueNo();
        String resid1 = ff.getResidue();
        double phi = ff.getPhi();
        double psi = ff.getPsi();
        Pdb pp = this.coordByResidue(phi, psi, coordN, coordNH, coordCA, no, resid1, !isLink);
        atomVec.addAll(pp.getAtomVec());
        pdbVec.add(new Pdb(no, resid1, atomVec));
        atomVec = new Vector();
        atomVec.add(new Cartesian("N", coordN));
        atomVec.add(new Cartesian("H", coordNH));
        atomVec.add(new Cartesian("CA", coordCA));
        nhVec1 = this.internuclearVec(coordN, coordNH);
        n2CA = this.internuclearVec(coordN, coordCA);
        rg = ff.RgCal(nhVec1, n2CA);
        double[] co1ToN = new double[3];
        double[] co1 = new double[3];
        String atom = "";
        i = 1;
        while (i < phiPsiVec.size()) {
            ff = (PhiPsi)phiPsiVec.elementAt(i);
            no = ff.getResidueNo();
            resid1 = ff.getResidue();
            phi = ff.getPhi();
            psi = ff.getPsi();
            pp = this.coordByResidue(phi, psi, coordN, coordNH, coordCA, no, resid1, false);
            atomVec.addAll(pp.getAtomVec());
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("C")) {
                    co1 = cc.getXYZ();
                }
                ++j;
            }
            pdbVec.add(new Pdb(no, resid1, atomVec));
            atomVec = new Vector();
            atomVec.add(new Cartesian("N", coordN));
            atomVec.add(new Cartesian("H", coordNH));
            atomVec.add(new Cartesian("CA", coordCA));
            nhVec1 = this.internuclearVec(coordN, coordNH);
            co1ToN = this.internuclearVec(coordN, co1);
            n2CA = this.internuclearVec(coordN, coordCA);
            if (i == phiPsiVec.size() - 1) {
                pdbVec.add(new Pdb(no + 1, resid1, atomVec));
            }
            rg = ff.RgCal(nhVec1, n2CA);
            ++i;
        }
        Vector<Pdb> vecPdbNew = new Vector<Pdb>();
        i = 0;
        while (i < pdbVec.size() - 1) {
            Pdb ppT = (Pdb)pdbVec.elementAt(i);
            vecPdbNew.add(ppT);
            ++i;
        }
        return vecPdbNew;
    }

    public Vector modelBuildLoopBackward(Vector phiPsiVec, double[] nCoord, double[] nhCoord, double[] caCoord, int startNo, int endNo) {
        double[] n1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        n1[0] = nCoord[0];
        n1[1] = nCoord[1];
        n1[2] = nCoord[2];
        nh1[0] = nhCoord[0];
        nh1[1] = nhCoord[1];
        nh1[2] = nhCoord[2];
        ca1[0] = caCoord[0];
        ca1[1] = caCoord[1];
        ca1[2] = caCoord[2];
        PhiPsi ff = new PhiPsi();
        Vector<Pdb> vecPdb = new Vector<Pdb>();
        double[] nToNHVec = this.internuclearVec(n1, nh1);
        double[] nToCAVec = this.internuclearVec(n1, ca1);
        Matrix rg = ff.RgCal(nToNHVec, nToCAVec);
        Matrix rgInv = rg.transpose();
        Matrix mat = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv))));
        double[] n2coCnt = new double[]{0.0, 0.0, 1.329};
        double[] co2oCnt = new double[]{0.0, 1.231, 0.0};
        double[] co2caCnt = new double[]{0.0, 0.0, 1.525};
        double[] co2ca = new double[3];
        double[] n2co = new double[3];
        double[] nCal = new double[3];
        double[] co2o = new double[3];
        double[] caCal = new double[3];
        double[] coCal = new double[3];
        double[] o2Cal = new double[3];
        int curNo = endNo;
        while (curNo >= startNo) {
            int ind = Collections.binarySearch(phiPsiVec, new PhiPsi(curNo), new PhiPsi.PPComparator());
            ff = (PhiPsi)phiPsiVec.elementAt(ind);
            int no = ff.getResidueNo();
            String resid1 = ff.getResidue();
            double phiValue = ff.getPhi();
            double psiValue = ff.getPsi();
            nToNHVec = this.internuclearVec(n1, nh1);
            nToCAVec = this.internuclearVec(n1, ca1);
            rg = ff.RgCal(nToNHVec, nToCAVec);
            rgInv = rg.transpose();
            Vector<Cartesian> atomVec = new Vector<Cartesian>();
            n2co = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(n2coCnt)));
            coCal = this.addCoords(n1, n2co);
            co2o = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.matOInv.times(co2oCnt))));
            o2Cal = this.addCoords(coCal, co2o);
            mat = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv))));
            co2ca = mat.times(co2caCnt);
            caCal = this.addCoords(coCal, co2ca);
            Matrix rzPsiInv = mat.rotationMat(psiValue + Math.PI, "-z");
            mat = mat.times(rzPsiInv.times(Const.r3xAlphaInv));
            double[] ca2nCnt = new double[]{0.0, 1.458, 0.0};
            double[] ca2n = mat.times(ca2nCnt);
            nCal = this.addCoords(caCal, ca2n);
            double[] haCnt = new double[]{0.0, 0.0, 1.09};
            Matrix matHA = mat.times(Const.matHAInv);
            double[] haCal = this.addCoords(caCal, matHA.times(haCnt));
            double[] cbCnt = new double[]{0.0, 0.0, 1.531};
            Matrix matCB = mat.times(Const.matCBInv);
            double[] cbCal = this.addCoords(caCal, matCB.times(cbCnt));
            Matrix ryPhiInv = mat.rotationMat(phiValue, "-y");
            Matrix ra10Inv = rg.rotationMat(Math.PI, "-y");
            mat = mat.times(Const.r8yAlphaInv.times(ryPhiInv.times(ra10Inv.times(Const.r5xAlphaInv))));
            double[] n2nhCnt = new double[]{0.0, 0.0, -1.02};
            double[] n2nh = mat.times(n2nhCnt);
            double[] nhCal = this.addCoords(nCal, n2nh);
            atomVec.add(new Cartesian("N", nCal));
            atomVec.add(new Cartesian("HN", nhCal));
            atomVec.add(new Cartesian("CA", caCal));
            atomVec.add(new Cartesian("HA", haCal));
            atomVec.add(new Cartesian("CB", cbCal));
            atomVec.add(new Cartesian("C", coCal));
            atomVec.add(new Cartesian("O", o2Cal));
            vecPdb.add(new Pdb(curNo, "ALA", atomVec));
            nToNHVec = this.internuclearVec(nCal, nhCal);
            nToCAVec = this.internuclearVec(nCal, caCal);
            rg = ff.RgCal(nToNHVec, nToCAVec);
            rgInv = rg.transpose();
            n1[0] = nCal[0];
            n1[1] = nCal[1];
            n1[2] = nCal[2];
            nh1[0] = nhCal[0];
            nh1[1] = nhCal[1];
            nh1[2] = nhCal[2];
            ca1[0] = caCal[0];
            ca1[1] = caCal[1];
            ca1[2] = caCal[2];
            --curNo;
        }
        n2co = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(n2coCnt)));
        coCal = this.addCoords(nCal, n2co);
        co2o = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.matOInv.times(co2oCnt))));
        o2Cal = this.addCoords(coCal, co2o);
        mat = rgInv.times(Const.r9zAlphaInv.times(Const.r1xAlphaInv.times(Const.r6zAlphaInv.times(Const.r2xAlphaInv))));
        co2ca = mat.times(co2caCnt);
        caCal = this.addCoords(coCal, co2ca);
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        atomVec.add(new Cartesian("CA", caCal));
        atomVec.add(new Cartesian("C", coCal));
        atomVec.add(new Cartesian("O", o2Cal));
        vecPdb.add(new Pdb(startNo - 1, "ALA", atomVec));
        Collections.sort(vecPdb, new Pdb.PdbComparator());
        return vecPdb;
    }

    public Vector modelBuild(double[] phiArr, double[] psiArr, double[] n1, double[] nh1, double[] ca1, int no1, boolean first) {
        Vector tmpVec = new Vector();
        int i = 0;
        int j = 0;
        double[] coordN = new double[3];
        System.arraycopy(n1, 0, coordN, 0, 3);
        double[] coordNH = new double[3];
        System.arraycopy(nh1, 0, coordNH, 0, 3);
        double[] coordCA = new double[3];
        System.arraycopy(ca1, 0, coordCA, 0, 3);
        int no = no1;
        String resid = "ALA";
        PhiPsi ff = new PhiPsi();
        double[] n2CA = new double[3];
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVec = new Vector<Pdb>();
        Cartesian cc = new Cartesian();
        atomVec.add(new Cartesian("N", n1));
        atomVec.add(new Cartesian("H", nh1));
        atomVec.add(new Cartesian("CA", ca1));
        double[] nhVec1 = this.internuclearVec(n1, nh1);
        Matrix rg = Matrix.identity(3, 3);
        Pdb pp = this.coordByResidue(phiArr[0], psiArr[0], coordN, coordNH, coordCA, no, resid, first);
        atomVec.addAll(pp.getAtomVec());
        pdbVec.add(new Pdb(no, resid, atomVec));
        atomVec = new Vector();
        atomVec.add(new Cartesian("N", coordN));
        atomVec.add(new Cartesian("H", coordNH));
        atomVec.add(new Cartesian("CA", coordCA));
        nhVec1 = this.internuclearVec(coordN, coordNH);
        n2CA = this.internuclearVec(coordN, coordCA);
        rg = ff.RgCal(nhVec1, n2CA);
        double[] co1ToN = new double[3];
        double[] co1 = new double[3];
        String atom = "";
        i = 1;
        while (i < phiArr.length) {
            pp = this.coordByResidue(phiArr[i], psiArr[i], coordN, coordNH, coordCA, ++no, resid, false);
            atomVec.addAll(pp.getAtomVec());
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("C")) {
                    co1 = cc.getXYZ();
                }
                ++j;
            }
            pdbVec.add(new Pdb(no, resid, atomVec));
            atomVec = new Vector();
            atomVec.add(new Cartesian("N", coordN));
            atomVec.add(new Cartesian("H", coordNH));
            atomVec.add(new Cartesian("CA", coordCA));
            nhVec1 = this.internuclearVec(coordN, coordNH);
            co1ToN = this.internuclearVec(coordN, co1);
            n2CA = this.internuclearVec(coordN, coordCA);
            rg = ff.RgCal(nhVec1, n2CA);
            ++i;
        }
        pdbVec.add(new Pdb(no + 1, resid, atomVec));
        Vector<Pdb> vecPdbNew = new Vector<Pdb>();
        i = 0;
        while (i < pdbVec.size()) {
            Pdb ppT = (Pdb)pdbVec.elementAt(i);
            vecPdbNew.add(ppT);
            ++i;
        }
        return vecPdbNew;
    }

    public Vector<Pdb> refineHelixW4RDCs(Vector vecBB, Vector<Dipolar> rdc1Vec, Vector<Dipolar> rdc2Vec, Vector<Dipolar> helixRdcCaCoVec, Vector<Dipolar> helixRdcCoNVec, double Syy, double Szz, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int initialCycle, double w4Angles, double resolution, boolean debugDFS, boolean printResults, Vector vecTalos) throws JampackException {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Dipolar dd1 = rdc1Vec.elementAt(0);
        Dipolar dd2 = rdc2Vec.elementAt(0);
        dd1 = rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = rdc2Vec.elementAt(rdc2Vec.size() - 1);
        Pdb pp1 = (Pdb)vecBB.elementAt(0);
        int firstResidueNo = pp1.getResidueNo();
        Pdb pp2 = (Pdb)vecBB.elementAt(vecBB.size() - 1);
        int lastResidueNo = pp2.getResidueNo();
        Vector<Pdb> pdbStrand = new Vector<Pdb>();
        pdbStrand.addAll(vecBB);
        PdbRdc pdr = new PdbRdc();
        double[] rmsds = new double[4];
        Vector<Object> pdbStrandN = new Vector();
        Matrix[] mm = new Matrix[4];
        double[] rdc1Rmsd = new double[4];
        double[] rdc2Rmsd = new double[4];
        int N = lastResidueNo - firstResidueNo;
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        double[] rdcCaCoCal = new double[N];
        double[] rdcCoNCal = new double[N];
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        double rdcRms_caco = 0.0;
        double rdcRms_con = 0.0;
        Matrix[] mm_temp = new Matrix[4];
        double[] temp1 = new double[1];
        int[] temp2 = new int[1];
        double[][] ss = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix ssMat = new Matrix(ss);
        boolean debugEulerFit = false;
        mm[0] = pdr.eulerFit(pdbStrand, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
        rdc1Rms = rmsds[0];
        rdc2Rms = rmsds[1];
        mm[0].print(14, 14);
        if (printResults) {
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            mm[0].print(14, 14);
        }
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        double rms_save = rdc1Rms + rdc2Rms;
        int i_save = 0;
        Vector<Pdb> helixVecN = new Vector();
        i = 1;
        while (i < 4) {
            mm[i] = Const.mat4ThreeDirs[i - 1].times(mm[0]);
            rdc1Rmsd[i] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
            rdc2Rmsd[i] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
            System.out.println("i=" + i);
            helixVecN = pp.newPdb(pdbStrand, Const.mat4ThreeDirs[i - 1]);
            mm_temp[0] = pdr.eulerFit(helixVecN, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
            rdc1Rms = rmsds[0];
            rdc2Rms = rmsds[1];
            if (rdc1Rms + rdc2Rms < rms_save) {
                rms_save = rdc1Rms + rdc2Rms;
                i_save = i;
            }
            mm_temp[0].print(14, 14);
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            ++i;
        }
        System.out.println("i_save=" + i_save);
        pdbStrandN = pp.newPdb(pdbStrand, mm[i_save]);
        Matrix mm2 = new Matrix(3, 3);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        boolean isHelix = true;
        Matrix iMat = Matrix.identity(3, 3);
        double[] saupe = new double[5];
        Vector<Pdb> pdbS2 = new Vector();
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = initialCycle;
            pdbS2 = this.minHelix4RDCs(rdc2Vec, rdc1Vec, helixRdcCaCoVec, helixRdcCoNVec, rdc2Cal, rdc1Cal, pdbStrandN, Syy, Szz, rdc2Rms, rdc1Rms, nCycle, w4Angles, debugDFS, printResults, isHelix, vecTalos, 1.0, 1.0);
            mm2 = pdr.bestFit(pdbS2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
            rdc1Rms = saupe[2];
            rdc2Rms = saupe[3];
            pdbStrandN = new Vector();
            pdbStrandN.addAll(pdbS2);
            System.out.println("refinecycle=" + i + ": ");
            pp.print(pdbStrandN);
            ++i;
        }
        System.out.println("====================================");
        return pdbStrandN;
    }

    public Vector<Pdb> refineHelixW4RDCs(Vector vecPreBB, Vector vecBB, Vector<Dipolar> rdc1Vec, Vector<Dipolar> rdc2Vec, Vector<Dipolar> helixRdcCaCoVec, Vector<Dipolar> helixRdcCoNVec, double Syy, double Szz, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int initialCycle, double w4Angles, double resolution, boolean debugDFS, boolean printResults, Vector vecTalos, double wtCoCa, double wtCoN, int starNo, int endNo, Vector vecSeq) throws JampackException {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<Pdb> pdbStrand = new Vector<Pdb>();
        pdbStrand.addAll(vecBB);
        PdbRdc pdr = new PdbRdc();
        double[] rmsds = new double[4];
        Vector<Object> pdbStrandN = new Vector();
        Matrix[] mm = new Matrix[4];
        double[] rdc1Rmsd = new double[4];
        double[] rdc2Rmsd = new double[4];
        int N = vecBB.size();
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        double[] rdcCaCoCal = new double[N];
        double[] rdcCoNCal = new double[N];
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        double rdcRms_caco = 0.0;
        double rdcRms_con = 0.0;
        Matrix[] mm_temp = new Matrix[4];
        double[] temp1 = new double[1];
        int[] temp2 = new int[1];
        double[][] ss = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix ssMat = new Matrix(ss);
        boolean debugEulerFit = false;
        mm[0] = pdr.eulerFit(pdbStrand, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
        rdc1Rms = rmsds[0];
        rdc2Rms = rmsds[1];
        mm[0].print(14, 14);
        if (printResults) {
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            mm[0].print(14, 14);
        }
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        double rms_save = rdc1Rms + rdc2Rms;
        int i_save = 0;
        Vector helixVecN = new Vector();
        System.out.println("i_save=" + i_save);
        pdbStrandN = pp.newPdb(pdbStrand, mm[i_save]);
        Matrix mm2 = new Matrix(3, 3);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        boolean isHelix = true;
        Matrix iMat = Matrix.identity(3, 3);
        double[] saupe = new double[5];
        Vector<Pdb> pdbS2 = new Vector();
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = initialCycle;
            pdbS2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, helixRdcCaCoVec, helixRdcCoNVec, rdc2Cal, rdc1Cal, pdbStrandN, Syy, Szz, rdc2Rms, rdc1Rms, nCycle, w4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
            mm2 = pdr.bestFit(pdbS2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
            rdc1Rms = saupe[2];
            rdc2Rms = saupe[3];
            pdbStrandN = new Vector();
            pdbStrandN.addAll(pdbS2);
            System.out.println("refinecycle=" + i + ": ");
            pp.print(pdbStrandN);
            ++i;
        }
        System.out.println("====================================");
        return pdbStrandN;
    }

    public Vector<Pdb> refineHelix22(Vector vecBB, Vector<Dipolar> rdc1Vec, Vector<Dipolar> rdc2Vec, double Syy, double Szz, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int initialCycle, double w4Angles, double resolution, boolean debugDFS, boolean printResults, Vector vecTalos) throws JampackException {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Dipolar dd1 = rdc1Vec.elementAt(0);
        Dipolar dd2 = rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector<Pdb> pdbStrand = new Vector<Pdb>();
        pdbStrand.addAll(vecBB);
        PdbRdc pdr = new PdbRdc();
        double[] rmsds = new double[2];
        Vector<Object> pdbStrandN = new Vector();
        Matrix[] mm = new Matrix[4];
        double[] rdc1Rmsd = new double[4];
        double[] rdc2Rmsd = new double[4];
        int N = lastResidueNo - firstResidueNo;
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        Matrix[] mm_temp = new Matrix[4];
        double[] temp1 = new double[1];
        int[] temp2 = new int[1];
        double[][] ss = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix ssMat = new Matrix(ss);
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", ssMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", ssMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        boolean debugEulerFit = false;
        mm[0] = pdr.eulerFit(pdbStrand, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
        rdc1Rms = rmsds[0];
        rdc2Rms = rmsds[1];
        mm[0].print(14, 14);
        if (printResults) {
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            mm[0].print(14, 14);
        }
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        double rms_save = rdc1Rms + rdc2Rms;
        int i_save = 0;
        Vector<Pdb> helixVecN = new Vector();
        i = 1;
        while (i < 4) {
            mm[i] = Const.mat4ThreeDirs[i - 1].times(mm[0]);
            rdc1Rmsd[i] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
            rdc2Rmsd[i] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
            System.out.println("i=" + i);
            helixVecN = pp.newPdb(pdbStrand, Const.mat4ThreeDirs[i - 1]);
            mm_temp[0] = pdr.eulerFit(helixVecN, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
            rdc1Rms = rmsds[0];
            rdc2Rms = rmsds[1];
            if (rdc1Rms + rdc2Rms < rms_save) {
                rms_save = rdc1Rms + rdc2Rms;
                i_save = i;
            }
            mm_temp[0].print(14, 14);
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            ++i;
        }
        System.out.println("i_save=" + i_save);
        pdbStrandN = pp.newPdb(pdbStrand, mm[i_save]);
        pp.print(pdbStrandN);
        Matrix mm2 = new Matrix(3, 3);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        boolean isHelix = true;
        Matrix iMat = Matrix.identity(3, 3);
        double[] saupe = new double[5];
        Vector<Pdb> pdbS2 = new Vector();
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = initialCycle;
            pdbS2 = this.minHelix(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbStrandN, Syy, Szz, rdc2Rms, rdc1Rms, nCycle, w4Angles, debugDFS, printResults, isHelix, vecTalos);
            mm2 = pdr.bestFit(pdbS2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
            rdc1Rms = saupe[2];
            rdc2Rms = saupe[3];
            pdbStrandN = new Vector();
            pdbStrandN.addAll(pdbS2);
            System.out.println("refinecycle=" + i + ": ");
            pp.print(pdbStrandN);
            ++i;
        }
        System.out.println("====================================");
        return pdbStrandN;
    }

    public Vector<Pdb> minHelix(Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, double[] rdc1Cal, double[] rdc2Cal, Vector<Pdb> pdbVec, double Syy, double Szz, double rmsd1, double rmsd2, int nCycle, double weightAngles, boolean debugDFS, boolean printResults, boolean isHelix) {
        int k;
        int N = pdbVec.size() - 1;
        Dipolar dd1 = rdcVec1.elementAt(0);
        Dipolar dd2 = rdcVec2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcErr1 = new double[N];
        double[] rdcErr2 = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int no = 0;
        int index = -1;
        int j = 0;
        while (j < N) {
            no = firstResidueNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = rdcVec1.elementAt(index).getRdc();
                rdcErr1[j] = rdcVec1.elementAt(index).getErr();
                seqNos1[j] = 1;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
                rdcErr1[j] = rmsd1;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = rdcVec2.elementAt(index).getRdc();
                seqNos2[j] = 1;
                rdcErr2[j] = rdcVec2.elementAt(index).getErr();
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
                rdcErr2[j] = rmsd2;
            }
            ++j;
        }
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        Pdb pp = pdbVec.elementAt(0);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc11 = 10000.0;
        double rRdc12 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        Vector depthVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        int noOfSln = 0;
        int n = 0;
        int N11 = rdcVec1.size();
        int N22 = rdcVec2.size();
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        long startTime = System.currentTimeMillis();
        boolean depthFlag = true;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        double phiAve = 0.0;
        double psiAve = 0.0;
        if (isHelix) {
            phiAve = -1.1397000015522971;
            psiAve = -0.6876597252857658;
        } else {
            phiAve = -2.0943951023931953;
            psiAve = 2.4085543677521746;
        }
        boolean isChanged = false;
        long seed = 10051L;
        Random rr = new Random(seed);
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc11 = 0.0;
                rRdc12 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc11 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc12 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc11 > rRdcFinal1) && !(rRdc12 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = false;
            depthFlag = ff.phiPsiChain(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, isHelix);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    rT = Math.sqrt(rRdc11 / (double)N11) + Math.sqrt(rRdc12 / (double)(N22 - 1)) + weightAngles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N));
                    if (rT < rTotal) {
                        isChanged = true;
                        rTotal = rT;
                        System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc11 / (double)N11) + "  " + Math.sqrt(rRdc12 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + ", RT = " + rTotal);
                        System.arraycopy(phiS, 0, phiSave, 0, N);
                        System.arraycopy(psiS, 0, psiSave, 0, N);
                        System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                        System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = new Vector();
        if (isChanged) {
            pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, firstResidueNo, false);
        } else {
            pdbHelixN.addAll(pdbVec);
            System.out.println("no better solution is found....");
        }
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector<Pdb> minHelix(Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, double[] rdc1Cal, double[] rdc2Cal, Vector<Pdb> pdbVec, double Syy, double Szz, double rmsd1, double rmsd2, int nCycle, double weightAngles, boolean debugDFS, boolean printResults, boolean isHelix, Vector vecTalos) throws JampackException {
        int i;
        int k;
        int N = pdbVec.size() - 1;
        Dipolar dd1 = rdcVec1.elementAt(0);
        Dipolar dd2 = rdcVec2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcErr1 = new double[N];
        double[] rdcErr2 = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int no = 0;
        int index = -1;
        int j = 0;
        while (j < N) {
            no = firstResidueNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = rdcVec1.elementAt(index).getRdc();
                rdcErr1[j] = rdcVec1.elementAt(index).getErr();
                seqNos1[j] = 1;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
                rdcErr1[j] = rmsd1;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = rdcVec2.elementAt(index).getRdc();
                seqNos2[j] = 1;
                rdcErr2[j] = rdcVec2.elementAt(index).getErr();
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
                rdcErr2[j] = rmsd2;
            }
            ++j;
        }
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        Pdb pp = pdbVec.elementAt(0);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc11 = 10000.0;
        double rRdc12 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        Vector depthVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        int noOfSln = 0;
        int n = 0;
        int N11 = rdcVec1.size();
        int N22 = rdcVec2.size();
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        long startTime = System.currentTimeMillis();
        boolean depthFlag = true;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        double phiAve = 0.0;
        double psiAve = 0.0;
        if (isHelix) {
            phiAve = -1.1397000015522971;
            psiAve = -0.6876597252857658;
        } else {
            phiAve = -2.0943951023931953;
            psiAve = 2.4085543677521746;
        }
        boolean isChanged = false;
        long seed = 99933L;
        Random rr = new Random(seed);
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc11 = 0.0;
                rRdc12 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc11 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc12 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc11 > rRdcFinal1) && !(rRdc12 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = false;
            depthFlag = ff.phiPsiChainTalos(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, isHelix, firstResidueNo, vecTalos);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    rT = Math.sqrt(rRdc11 / (double)N11) + Math.sqrt(rRdc12 / (double)N22) + weightAngles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N));
                    if (rT < rTotal) {
                        Vector<PhiPsi> phiPsiVec_temp = new Vector<PhiPsi>();
                        i = 0;
                        while (i < N) {
                            phiPsiVec_temp.add(new PhiPsi(i, "ALA", phiS[i], psiS[i]));
                            ++i;
                        }
                        Vector pdbHelixTemp = new Vector();
                        pdbHelixTemp = this.modelBuild(phiS, psiS, amide, nh, ca, firstResidueNo, false);
                        boolean[] resIndex = new boolean[pdbHelixTemp.size()];
                        int kk = 0;
                        while (kk < resIndex.length) {
                            resIndex[kk] = false;
                            ++kk;
                        }
                        Vector vecPdbSseRot2 = new Vector();
                        String rotSrc = String.valueOf(src) + "rotasamp-small/";
                        vecPdbSseRot2 = pp.AlaninizeStructure(pdbHelixTemp, resIndex, rotSrc);
                        double[] vdwValue = new double[1];
                        double vdwLevel = 0.05;
                        boolean printVDWViolation = false;
                        int[] clashResNo = new int[2];
                        vdwVec = vander.convert2VDW(vecPdbSseRot2);
                        boolean isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 1.0, 1, clashResNo);
                        if (isStericClash) {
                            System.out.println("here we have one steric clash...");
                        } else {
                            isChanged = true;
                            rTotal = rT;
                            System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc11 / (double)N11) + "  " + Math.sqrt(rRdc12 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + ", RT = " + rTotal);
                            System.arraycopy(phiS, 0, phiSave, 0, N);
                            System.arraycopy(psiS, 0, psiSave, 0, N);
                            System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                            System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                        }
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = new Vector();
        if (isChanged) {
            pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, firstResidueNo, false);
        } else {
            pdbHelixN.addAll(pdbVec);
            System.out.println("no better solution is found....");
        }
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector<Pdb> minHelix4RDCs(Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, Vector<Dipolar> helixRdcCaCoVec, Vector<Dipolar> helixRdcCoNVec, double[] rdc1Cal, double[] rdc2Cal, Vector<Pdb> pdbVec, double Syy, double Szz, double rmsd1, double rmsd2, int nCycle, double weightAngles, boolean debugDFS, boolean printResults, boolean isHelix, Vector vecTalos, double wtCoCa, double wtCoN) throws JampackException {
        int i;
        int k;
        int N = pdbVec.size() - 1;
        Dipolar dd1 = rdcVec1.elementAt(0);
        Dipolar dd2 = rdcVec2.elementAt(0);
        Pdb pdbTemp = pdbVec.elementAt(0);
        int firstResidueNo = pdbTemp.getResidueNo();
        PdbRdc pdr = new PdbRdc();
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcExpCaCo = new double[N];
        double[] rdcExpCoN = new double[N];
        double[] rdcErr1 = new double[N];
        double[] rdcErr2 = new double[N];
        double[] rdcErrCaCo = new double[N];
        double[] rdcErrCoN = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int[] seqNosCaCo = new int[N];
        int[] seqNosCoN = new int[N];
        int no = 0;
        int index = -1;
        int j = 0;
        while (j < N) {
            no = firstResidueNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = rdcVec1.elementAt(index).getRdc();
                rdcErr1[j] = rdcVec1.elementAt(index).getErr();
                seqNos1[j] = 1;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
                rdcErr1[j] = rmsd1;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = rdcVec2.elementAt(index).getRdc();
                seqNos2[j] = 1;
                rdcErr2[j] = rdcVec2.elementAt(index).getErr();
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
                rdcErr2[j] = rmsd2;
            }
            index = Collections.binarySearch(helixRdcCaCoVec, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExpCaCo[j] = helixRdcCaCoVec.elementAt(index).getRdc();
                seqNosCaCo[j] = 1;
                rdcErrCaCo[j] = helixRdcCaCoVec.elementAt(index).getErr();
            } else {
                rdcExpCaCo[j] = 0.0;
                seqNosCaCo[j] = 0;
                rdcErrCaCo[j] = 0.0;
            }
            index = Collections.binarySearch(helixRdcCoNVec, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExpCoN[j] = helixRdcCoNVec.elementAt(index).getRdc();
                seqNosCoN[j] = 1;
                rdcErrCoN[j] = helixRdcCoNVec.elementAt(index).getErr();
            } else {
                rdcExpCoN[j] = 0.0;
                seqNosCoN[j] = 0;
                rdcErrCoN[j] = 0.0;
            }
            ++j;
        }
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        Pdb pp = pdbVec.elementAt(0);
        String userDir2 = System.getProperty("user.dir");
        String src2 = String.valueOf(userDir2) + "/inputFiles/";
        String strH1File = String.valueOf(src2) + "H1.pdb";
        Vector<Pdb> ppVecH1 = pp.readPdb(strH1File);
        pp = new Pdb();
        pp = ppVecH1.elementAt(12);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc11 = 10000.0;
        double rRdc12 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        Vector depthVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        double[] rdcCaCoSave = new double[N];
        double[] rdcCoNSave = new double[N];
        int noOfSln = 0;
        int n = 0;
        int N11 = rdcVec1.size();
        int N22 = rdcVec2.size();
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        long startTime = System.currentTimeMillis();
        boolean depthFlag = true;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        double phiAve = 0.0;
        double psiAve = 0.0;
        if (isHelix) {
            phiAve = -1.1397000015522971;
            psiAve = -0.6876597252857658;
        } else {
            phiAve = -2.0943951023931953;
            psiAve = 2.4085543677521746;
        }
        boolean isChanged = false;
        long seed = 999991L;
        Random rr = new Random(seed);
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc11 = 0.0;
                rRdc12 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc11 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc12 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc11 > rRdcFinal1) && !(rRdc12 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = false;
            depthFlag = ff.phiPsiChainTalos(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, isHelix, firstResidueNo, vecTalos);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    Vector pdbHelixTemp = new Vector();
                    pdbHelixTemp = this.modelBuild(phiS, psiS, amide, nh, ca, firstResidueNo, false);
                    double[][] Inv_temp = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
                    Matrix Mat = new Matrix(Inv_temp);
                    double[] sRmsd = new double[1];
                    int[] sizeRdc = new int[1];
                    double[] rdcCoNCal = new double[pdbHelixTemp.size()];
                    double[] rdcCaCoCal = new double[pdbHelixTemp.size()];
                    double r_temp = pdr.BackCal(pdbHelixTemp, rdcVec1, "CA", "HA", Mat, -Syy - Szz, Syy, Szz, 1.0, rdcCaCoCal, sRmsd, sizeRdc);
                    double r_caco = 0.0;
                    double r_con = 0.0;
                    if (helixRdcCaCoVec.size() > 0) {
                        r_caco = pdr.BackCalCACO(pdbHelixTemp, helixRdcCaCoVec, "C", "CA", Mat, -Syy - Szz, Syy, Szz, Const.cacoRatio, rdcCaCoCal, sRmsd, sizeRdc, false);
                    }
                    if (helixRdcCoNVec.size() > 0) {
                        r_con = pdr.BackCalCON(pdbHelixTemp, helixRdcCoNVec, "C", "N", Mat, -Syy - Szz, Syy, Szz, Const.conRatio, rdcCoNCal, sRmsd, sizeRdc, false);
                    }
                    if ((rT = Math.sqrt(rRdc11 / 1.0 / (double)N11) + Math.sqrt(rRdc12 / 1.0 / (double)N22) + wtCoCa * (r_caco / Const.cacoRatio) + wtCoN * (r_con / Const.conRatio) + weightAngles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N))) < rTotal) {
                        Vector<PhiPsi> phiPsiVec_temp = new Vector<PhiPsi>();
                        i = 0;
                        while (i < N) {
                            phiPsiVec_temp.add(new PhiPsi(i, "ALA", phiS[i], psiS[i]));
                            ++i;
                        }
                        boolean[] resIndex = new boolean[pdbHelixTemp.size()];
                        int kk = 0;
                        while (kk < resIndex.length) {
                            resIndex[kk] = false;
                            ++kk;
                        }
                        Vector vecPdbSseRot2 = new Vector();
                        String rotSrc = String.valueOf(src) + "rotasamp-small/";
                        vecPdbSseRot2 = pp.AlaninizeStructure(pdbHelixTemp, resIndex, rotSrc);
                        double[] vdwValue = new double[1];
                        double vdwLevel = 0.05;
                        boolean printVDWViolation = false;
                        int[] clashResNo = new int[2];
                        vdwVec = vander.convert2VDW(vecPdbSseRot2);
                        boolean isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.4, 1, clashResNo);
                        if (isStericClash) {
                            System.out.println("here we have one steric clash...");
                        } else {
                            isChanged = true;
                            rTotal = rT;
                            System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc11 / (double)N11) + "  " + Math.sqrt(rRdc12 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + ", RT = " + rTotal);
                            System.arraycopy(phiS, 0, phiSave, 0, N);
                            System.arraycopy(psiS, 0, psiSave, 0, N);
                            System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                            System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                            System.arraycopy(rdcCaCoCal, 0, rdcCaCoSave, 0, N);
                            System.arraycopy(rdcCoNCal, 0, rdcCoNSave, 0, N);
                        }
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = new Vector();
        if (isChanged) {
            pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, firstResidueNo, false);
        } else {
            pdbHelixN.addAll(pdbVec);
            System.out.println("no better solution is found....");
        }
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" CA-CO RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdcCaCoSave[k] + "  " + rdcExpCaCo[k] + "  " + Math.abs(rdcCaCoSave[k] - rdcExpCaCo[k]));
                ++k;
            }
            System.out.println(" CO-N RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdcCoNSave[k] + "  " + rdcExpCoN[k] + "  " + Math.abs(rdcCoNSave[k] - rdcExpCoN[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector<Pdb> minHelix4RDCs(Vector<Pdb> vecPrePdb, Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, Vector<Dipolar> helixRdcCaCoVec, Vector<Dipolar> helixRdcCoNVec, double[] rdc1Cal, double[] rdc2Cal, Vector<Pdb> pdbVec, double Syy, double Szz, double rmsd1, double rmsd2, int nCycle, double weightAngles, boolean debugDFS, boolean printResults, boolean isHelix, Vector vecTalos, double wtCoCa, double wtCoN, int startNo, int endNo, Vector vecSeq) throws JampackException {
        int i;
        int k;
        int N = pdbVec.size();
        PdbRdc pdr = new PdbRdc();
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcExpCaCo = new double[N];
        double[] rdcExpCoN = new double[N];
        double[] rdcErr1 = new double[N];
        double[] rdcErr2 = new double[N];
        double[] rdcErrCaCo = new double[N];
        double[] rdcErrCoN = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int[] seqNosCaCo = new int[N];
        int[] seqNosCoN = new int[N];
        int no = 0;
        int index = -1;
        int N11 = 0;
        int N22 = 0;
        int j = 0;
        while (j < N) {
            no = startNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = rdcVec1.elementAt(index).getRdc();
                rdcErr1[j] = rdcVec1.elementAt(index).getErr();
                seqNos1[j] = 1;
                ++N11;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
                rdcErr1[j] = rmsd1;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = rdcVec2.elementAt(index).getRdc();
                seqNos2[j] = 1;
                rdcErr2[j] = rdcVec2.elementAt(index).getErr();
                ++N22;
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
                rdcErr2[j] = rmsd2;
            }
            index = Collections.binarySearch(helixRdcCaCoVec, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExpCaCo[j] = helixRdcCaCoVec.elementAt(index).getRdc();
                seqNosCaCo[j] = 1;
                rdcErrCaCo[j] = helixRdcCaCoVec.elementAt(index).getErr();
            } else {
                rdcExpCaCo[j] = 0.0;
                seqNosCaCo[j] = 0;
                rdcErrCaCo[j] = 0.0;
            }
            index = Collections.binarySearch(helixRdcCoNVec, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExpCoN[j] = helixRdcCoNVec.elementAt(index).getRdc();
                seqNosCoN[j] = 1;
                rdcErrCoN[j] = helixRdcCoNVec.elementAt(index).getErr();
            } else {
                rdcExpCoN[j] = 0.0;
                seqNosCoN[j] = 0;
                rdcErrCoN[j] = 0.0;
            }
            ++j;
        }
        seqNos2[0] = 0;
        --N22;
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        int indA = Collections.binarySearch(vecPrePdb, new Pdb(startNo), new Pdb.PdbComparator());
        Pdb pp = new Pdb();
        pp = indA > -1 ? vecPrePdb.elementAt(indA) : pdbVec.elementAt(0);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc11 = 10000.0;
        double rRdc12 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        Vector depthVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        double[] rdcCaCoSave = new double[N];
        double[] rdcCoNSave = new double[N];
        int noOfSln = 0;
        int n = 0;
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        long startTime = System.currentTimeMillis();
        boolean depthFlag = true;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        double phiAve = 0.0;
        double psiAve = 0.0;
        if (isHelix) {
            phiAve = -1.1397000015522971;
            psiAve = -0.6876597252857658;
        } else {
            phiAve = -2.0943951023931953;
            psiAve = 2.4085543677521746;
        }
        boolean isChanged = false;
        long seed = 888L;
        Random rr = new Random(seed);
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc11 = 0.0;
                rRdc12 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc11 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc12 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc11 > rRdcFinal1) && !(rRdc12 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = false;
            depthFlag = ff.phiPsiChainTalos(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, isHelix, startNo, vecTalos);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    Vector pdbHelixTemp = new Vector();
                    pdbHelixTemp = this.modelBuild(phiS, psiS, amide, nh, ca, startNo, false);
                    Vector<Pdb> vecPdbTemp = new Vector<Pdb>();
                    int indTemp = Collections.binarySearch(vecPrePdb, new Pdb(startNo), new Pdb.PdbComparator());
                    if (indTemp > -1) {
                        int tt = 0;
                        while (tt < indTemp) {
                            Pdb ppTemp = vecPrePdb.elementAt(tt);
                            vecPdbTemp.add(ppTemp);
                            ++tt;
                        }
                    }
                    vecPdbTemp.addAll(pdbHelixTemp);
                    double[][] Inv_temp = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
                    Matrix Mat = new Matrix(Inv_temp);
                    double[] sRmsd = new double[1];
                    int[] sizeRdc = new int[1];
                    double[] rdcCoNCal = new double[vecPdbTemp.size()];
                    double[] rdcCaCoCal = new double[vecPdbTemp.size()];
                    double r_caco = 0.0;
                    double r_con = 0.0;
                    if (helixRdcCaCoVec.size() > 0) {
                        r_caco = pdr.BackCalCACO(vecPdbTemp, helixRdcCaCoVec, "C", "CA", Mat, -Syy - Szz, Syy, Szz, Const.cacoRatio, rdcCaCoCal, sRmsd, sizeRdc, false);
                    }
                    if (helixRdcCoNVec.size() > 0) {
                        r_con = pdr.BackCalCON(vecPdbTemp, helixRdcCoNVec, "C", "N", Mat, -Syy - Szz, Syy, Szz, Const.conRatio, rdcCoNCal, sRmsd, sizeRdc, false);
                    }
                    if ((rT = Math.sqrt(rRdc11 / 1.0 / (double)N11) + 1.0 * Math.sqrt(rRdc12 / 1.0 / (double)N22) + wtCoCa * (r_caco / Const.cacoRatio) + wtCoN * (r_con / Const.conRatio) + weightAngles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N))) < rTotal) {
                        Vector<PhiPsi> phiPsiVec_temp = new Vector<PhiPsi>();
                        i = 0;
                        while (i < N) {
                            phiPsiVec_temp.add(new PhiPsi(i, "ALA", phiS[i], psiS[i]));
                            ++i;
                        }
                        boolean[] resIndex = new boolean[vecPdbTemp.size()];
                        int kk = 0;
                        while (kk < resIndex.length) {
                            resIndex[kk] = false;
                            ++kk;
                        }
                        Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, vecPdbTemp);
                        int kk2 = 0;
                        while (kk2 < pdbVecSSE_temp2.size()) {
                            Pdb ppTemp = pdbVecSSE_temp2.elementAt(kk2);
                            String resTemp = ppTemp.getResidue();
                            if (resTemp.equalsIgnoreCase("PRO") || resTemp.equalsIgnoreCase("GLY")) {
                                resIndex[kk2] = true;
                            }
                            ++kk2;
                        }
                        Vector vecPdbSseRot2 = new Vector();
                        String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
                        vecPdbSseRot2 = pp.AlaninizeStructureResName(vecPdbTemp, rotSrc);
                        double[] vdwValue = new double[1];
                        double vdwLevel = 0.05;
                        boolean printVDWViolation = false;
                        int[] clashResNo = new int[2];
                        isChanged = true;
                        rTotal = rT;
                        System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc11 / (double)N11) + "  " + Math.sqrt(rRdc12 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + ", RT = " + rTotal);
                        System.arraycopy(phiS, 0, phiSave, 0, N);
                        System.arraycopy(psiS, 0, psiSave, 0, N);
                        System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                        System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                        System.arraycopy(rdcCaCoCal, 0, rdcCaCoSave, 0, N);
                        System.arraycopy(rdcCoNCal, 0, rdcCoNSave, 0, N);
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = new Vector();
        if (isChanged) {
            pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, startNo, false);
        } else {
            pdbHelixN.addAll(pdbVec);
            System.out.println("no better solution is found....");
        }
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(startNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(startNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" CA-CO RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(startNo + k) + ": " + rdcCaCoSave[k] + "  " + rdcExpCaCo[k] + "  " + Math.abs(rdcCaCoSave[k] - rdcExpCaCo[k]));
                ++k;
            }
            System.out.println(" CO-N RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(startNo + k) + ": " + rdcCoNSave[k] + "  " + rdcExpCoN[k] + "  " + Math.abs(rdcCoNSave[k] - rdcExpCoN[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(startNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector<Pdb> minHelix(Vector<Dipolar> rdcVec1, Vector<Dipolar> rdcVec2, double[] rdc1Cal, double[] rdc2Cal, Vector<Pdb> pdbVec, double Syy, double Szz, double rmsd1, double rmsd2, int nCycle, double weightAngles, boolean debugDFS, boolean printResults, boolean isHelix, double[] NhRdcRmsd, double[] ChRdcRmsd) {
        int k;
        NhRdcRmsd[0] = 999.0;
        ChRdcRmsd[0] = 999.0;
        long seed = 7299L;
        Random rr = new Random(seed);
        int N = pdbVec.size() - 1;
        Dipolar dd1 = rdcVec1.elementAt(0);
        Dipolar dd2 = rdcVec2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        double[] rdcErr1 = new double[N];
        double[] rdcErr2 = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int no = 0;
        int index = -1;
        int j = 0;
        while (j < N) {
            no = firstResidueNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = rdcVec1.elementAt(index).getRdc();
                rdcErr1[j] = rdcVec1.elementAt(index).getErr();
                seqNos1[j] = 1;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
                rdcErr1[j] = rmsd1;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = rdcVec2.elementAt(index).getRdc();
                seqNos2[j] = 1;
                rdcErr2[j] = rdcVec2.elementAt(index).getErr();
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
                rdcErr2[j] = rmsd2;
            }
            ++j;
        }
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        Pdb pp = pdbVec.elementAt(0);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc11 = 10000.0;
        double rRdc12 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        Vector depthVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        int noOfSln = 0;
        int n = 0;
        int N11 = rdcVec1.size();
        int N22 = rdcVec2.size();
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        long startTime = System.currentTimeMillis();
        boolean depthFlag = true;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        double phiAve = 0.0;
        double psiAve = 0.0;
        if (isHelix) {
            phiAve = -1.1397000015522971;
            psiAve = -0.6876597252857658;
        } else {
            phiAve = -2.0943951023931953;
            psiAve = 2.4085543677521746;
        }
        boolean isChanged = false;
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc11 = 0.0;
                rRdc12 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc11 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc12 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc11 > rRdcFinal1) && !(rRdc12 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = false;
            depthFlag = ff.phiPsiChain(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, isHelix);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    rT = Math.sqrt(rRdc11 / (double)N11) + Math.sqrt(rRdc12 / (double)(N22 - 1)) + weightAngles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N));
                    if (rT < rTotal) {
                        isChanged = true;
                        rTotal = rT;
                        System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc11 / (double)N11) + "  " + Math.sqrt(rRdc12 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + ", RT = " + rTotal);
                        NhRdcRmsd[0] = Math.sqrt(rRdc12 / (double)(N22 - 1));
                        ChRdcRmsd[0] = Math.sqrt(rRdc11 / (double)N11);
                        System.arraycopy(phiS, 0, phiSave, 0, N);
                        System.arraycopy(psiS, 0, psiSave, 0, N);
                        System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                        System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = new Vector();
        if (isChanged) {
            pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, firstResidueNo, false);
        } else {
            NhRdcRmsd[0] = 9999.0;
            ChRdcRmsd[0] = 9999.0;
            pdbHelixN.addAll(pdbVec);
            System.out.println("no better solution is found....");
        }
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector minHelix_old(Vector rdcVec1, Vector rdcVec2, double[] rdc1Cal, double[] rdc2Cal, Vector pdbVec, double Syy, double Szz, double rmsd1, double rmsd2, int nCycle, double weightAngles, boolean debugDFS, boolean printResults, boolean isHelix) {
        int k;
        int N = pdbVec.size() - 1;
        Dipolar dd1 = (Dipolar)rdcVec1.elementAt(0);
        Dipolar dd2 = (Dipolar)rdcVec2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int no = 0;
        int index = -1;
        int j = 0;
        while (j < N) {
            no = firstResidueNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = ((Dipolar)rdcVec1.elementAt(index)).getRdc();
                seqNos1[j] = 1;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = ((Dipolar)rdcVec2.elementAt(index)).getRdc();
                seqNos2[j] = 1;
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
            }
            ++j;
        }
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        Pdb pp = (Pdb)pdbVec.elementAt(0);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc11 = 10000.0;
        double rRdc12 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        long seed = 95738579L;
        Random rr = new Random(seed);
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        Vector depthVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        int noOfSln = 0;
        int n = 0;
        int N11 = rdcVec1.size();
        int N22 = rdcVec2.size();
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        long startTime = System.currentTimeMillis();
        boolean depthFlag = true;
        boolean searchDepth = false;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        double phiAve = 0.0;
        double psiAve = 0.0;
        if (isHelix) {
            phiAve = -1.1397000015522971;
            psiAve = -0.6876597252857658;
        } else {
            phiAve = -2.0943951023931953;
            psiAve = 2.4085543677521746;
        }
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc11 = 0.0;
                rRdc12 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc11 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc12 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc11 > rRdcFinal1) && !(rRdc12 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = false;
            depthFlag = ff.phiPsiChain(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, isHelix);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    rT = Math.sqrt(rRdc11 / (double)N11) + Math.sqrt(rRdc12 / (double)(N22 - 1)) + weightAngles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N));
                    if (rT < rTotal) {
                        rTotal = rT;
                        System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc11 / (double)N11) + "  " + Math.sqrt(rRdc12 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + ", RT = " + rTotal);
                        System.arraycopy(phiS, 0, phiSave, 0, N);
                        System.arraycopy(psiS, 0, psiSave, 0, N);
                        System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                        System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, firstResidueNo, false);
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector<Pdb> refineSaupe3(Vector<Pdb> pdbVec, Vector<Dipolar> nhRdc, Vector<Dipolar> cahaRdc, double[] saupeSave) {
        PdbRdc pdr = new PdbRdc();
        Pdb pp = new Pdb();
        int N = pdbVec.size();
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for both CH and NH RDC:  ");
        Matrix mm = pdr.bestFit(pdbVec, nhRdc, cahaRdc, rdc1Cal, rdc2Cal, saupeSave);
        double Syy = saupeSave[0];
        double Szz = saupeSave[1];
        double Sxx = -Syy - Szz;
        double rdc1Rmsd = saupeSave[2];
        double rdc2Rmsd = saupeSave[3];
        double SxxNew = 0.0;
        double SyyNew = 0.0;
        double SzzNew = 0.0;
        if (Math.abs(Sxx) > Math.abs(Syy) && Math.abs(Sxx) > Math.abs(Szz)) {
            SzzNew = Sxx;
        }
        if (Math.abs(Syy) > Math.abs(Sxx) && Math.abs(Syy) > Math.abs(Szz)) {
            SzzNew = Syy;
        }
        if (Math.abs(Szz) > Math.abs(Sxx) && Math.abs(Szz) > Math.abs(Syy)) {
            SzzNew = Szz;
        }
        if (Math.abs(Sxx) < Math.abs(Szz) && Math.abs(Sxx) < Math.abs(Syy)) {
            SxxNew = Sxx;
        }
        if (Math.abs(Syy) < Math.abs(Szz) && Math.abs(Syy) < Math.abs(Sxx)) {
            SxxNew = Syy;
        }
        if (Math.abs(Szz) < Math.abs(Sxx) && Math.abs(Szz) < Math.abs(Syy)) {
            SxxNew = Szz;
        }
        SyyNew = -SxxNew - SzzNew;
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for my own calculation:");
        System.out.println("Sxx, Syy, Szz =    " + (-Syy - Szz) + "    " + Syy + "  " + Szz);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for the whole structure in the conventional format:");
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("A_a, A_r =   " + SzzNew / 2.0 + "   " + (-SyyNew - SzzNew - SyyNew) / 3.0);
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("Sxx, Syy, Szz (in the conventional format)=    " + (-SyyNew - SzzNew) + "    " + SyyNew + "  " + SzzNew);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for only NH RDC:  ");
        Vector<Dipolar> cahaRdc_temp = new Vector<Dipolar>();
        double[] saupeSave_temp = new double[4];
        double[] rdc1Cal_temp = new double[N];
        double[] rdc2Cal_temp = new double[N];
        mm = pdr.bestFit(pdbVec, nhRdc, cahaRdc_temp, rdc1Cal_temp, rdc2Cal_temp, saupeSave_temp);
        Syy = saupeSave_temp[0];
        Szz = saupeSave_temp[1];
        rdc1Rmsd = saupeSave_temp[2];
        rdc2Rmsd = saupeSave_temp[3];
        SxxNew = 0.0;
        SyyNew = 0.0;
        SzzNew = 0.0;
        if (Math.abs(Sxx) > Math.abs(Syy) && Math.abs(Sxx) > Math.abs(Szz)) {
            SzzNew = Sxx;
        }
        if (Math.abs(Syy) > Math.abs(Sxx) && Math.abs(Syy) > Math.abs(Szz)) {
            SzzNew = Syy;
        }
        if (Math.abs(Szz) > Math.abs(Sxx) && Math.abs(Szz) > Math.abs(Syy)) {
            SzzNew = Szz;
        }
        if (Math.abs(Sxx) < Math.abs(Szz) && Math.abs(Sxx) < Math.abs(Syy)) {
            SxxNew = Sxx;
        }
        if (Math.abs(Syy) < Math.abs(Szz) && Math.abs(Syy) < Math.abs(Sxx)) {
            SxxNew = Syy;
        }
        if (Math.abs(Szz) < Math.abs(Sxx) && Math.abs(Szz) < Math.abs(Syy)) {
            SxxNew = Szz;
        }
        SyyNew = -SxxNew - SzzNew;
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("A_a, A_r =   " + Szz / 2.0 + "   " + (-Syy - Szz - Syy) / 3.0);
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("Sxx, Syy, Szz=    " + (-Syy - Szz) + "    " + Syy + "  " + Szz);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for the whole structure in the conventional format:");
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("A_a, A_r =   " + SzzNew / 2.0 + "   " + (-SyyNew - SzzNew - SyyNew) / 3.0);
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("Sxx, Syy, Szz (in the conventional format)=    " + (-SyyNew - SzzNew) + "    " + SyyNew + "  " + SzzNew);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for only CH RDC:  ");
        Vector nhRdc_temp = new Vector();
        mm = pdr.bestFit(pdbVec, nhRdc_temp, cahaRdc, rdc1Cal_temp, rdc2Cal_temp, saupeSave_temp);
        Syy = saupeSave_temp[0];
        Szz = saupeSave_temp[1];
        rdc1Rmsd = saupeSave_temp[2];
        rdc2Rmsd = saupeSave_temp[3];
        SxxNew = 0.0;
        SyyNew = 0.0;
        SzzNew = 0.0;
        if (Math.abs(Sxx) > Math.abs(Syy) && Math.abs(Sxx) > Math.abs(Szz)) {
            SzzNew = Sxx;
        }
        if (Math.abs(Syy) > Math.abs(Sxx) && Math.abs(Syy) > Math.abs(Szz)) {
            SzzNew = Syy;
        }
        if (Math.abs(Szz) > Math.abs(Sxx) && Math.abs(Szz) > Math.abs(Syy)) {
            SzzNew = Szz;
        }
        if (Math.abs(Sxx) < Math.abs(Szz) && Math.abs(Sxx) < Math.abs(Syy)) {
            SxxNew = Sxx;
        }
        if (Math.abs(Syy) < Math.abs(Szz) && Math.abs(Syy) < Math.abs(Sxx)) {
            SxxNew = Syy;
        }
        if (Math.abs(Szz) < Math.abs(Sxx) && Math.abs(Szz) < Math.abs(Syy)) {
            SxxNew = Szz;
        }
        SyyNew = -SxxNew - SzzNew;
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("A_a, A_r =   " + Szz / 2.0 + "   " + (-Syy - Szz - Syy) / 3.0);
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("Sxx, Syy, Szz=    " + (-Syy - Szz) + "    " + Syy + "  " + Szz);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        System.out.println("================================================================================");
        System.out.println("The alignment tensor for the whole structure in the conventional format:");
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("A_a, A_r =   " + SzzNew / 2.0 + "   " + (-SyyNew - SzzNew - SyyNew) / 3.0);
        System.out.println("----------------------------------------------------------------------------------");
        System.out.println("Sxx, Syy, Szz (in the conventional format)=    " + (-SyyNew - SzzNew) + "    " + SyyNew + "  " + SzzNew);
        System.out.println("rdc1Rmsd (CH), rdc2Rmsd (NH)=     :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("Second   (Licong's original version) " + Syy + "  " + Szz + " :  " + rdc1Rmsd + "  " + rdc2Rmsd);
        System.out.println("================================================================================");
        Vector<Pdb> pdbVec2 = pp.newPdb(pdbVec, mm);
        return pdbVec2;
    }

    public Vector minBeta(Vector rdcVec1, Vector rdcVec2, double[] rdc1Cal, double[] rdc2Cal, Vector pdbVec2, double Syy, double Szz, double rmsd1, double rmsd2, Vector pdbS1, Vector hbVecOfE12, int nCycle, double weight4Angles, double hbWeight, boolean debugDFS, boolean printResults) {
        int k;
        int N = pdbVec2.size() - 1;
        Dipolar dd1 = (Dipolar)rdcVec1.elementAt(0);
        Dipolar dd2 = (Dipolar)rdcVec2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int no = 0;
        int index = -1;
        int j = 0;
        while (j < N) {
            no = firstResidueNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = ((Dipolar)rdcVec1.elementAt(index)).getRdc();
                seqNos1[j] = 1;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = ((Dipolar)rdcVec2.elementAt(index)).getRdc();
                seqNos2[j] = 1;
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
            }
            ++j;
        }
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        Pdb pp = (Pdb)pdbVec2.elementAt(0);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc1 = 10000.0;
        double rRdc2 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        long seed = 95738579L;
        Random rr = new Random(seed);
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        int noOfSln = 0;
        int n = 0;
        int N11 = rdcVec1.size();
        int N22 = rdcVec2.size();
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        System.out.println(String.valueOf(rmsd1) + "  " + rmsd2 + " : " + N11 + "  " + N22);
        long startTime = System.currentTimeMillis();
        boolean depthFlag = false;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        PdbRmsd pR = new PdbRmsd();
        double phiAve = -2.0943951023931953;
        double psiAve = 2.4085543677521746;
        double matchScore = 0.0;
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc1 = 0.0;
                rRdc2 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc1 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc2 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc1 > rRdcFinal1) && !(rRdc2 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = ff.phiPsiChain(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, false);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    pdbVec2 = this.modelBuild(phiS, psiS, amide, nh, ca, firstResidueNo, false);
                    matchScore = pR.centerFit(pdbS1, pdbVec2, hbVecOfE12, false);
                    rT = Math.sqrt(rRdc1 / (double)N11) + Math.sqrt(rRdc2 / (double)(N22 - 1)) + weight4Angles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N)) + hbWeight * matchScore;
                    if (rT < rTotal) {
                        rTotal = rT;
                        System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc1 / (double)N11) + "  " + Math.sqrt(rRdc2 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + "  " + matchScore + ", RT = " + rTotal);
                        System.arraycopy(phiS, 0, phiSave, 0, N);
                        System.arraycopy(psiS, 0, psiSave, 0, N);
                        System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                        System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, firstResidueNo, false);
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector minBeta2(Vector rdcVec1, Vector rdcVec2, double[] rdc1Cal, double[] rdc2Cal, Vector pdbVec2, double Syy, double Szz, double rmsd1, double rmsd2, Vector pdbS1, Vector pdbS2, Vector hbVecOfE12, Vector hbVecOfE13, int nCycle, double weight4Angles, double hbWeight, boolean debugDFS, boolean printResults) {
        int k;
        int N = pdbVec2.size() - 1;
        Dipolar dd1 = (Dipolar)rdcVec1.elementAt(0);
        Dipolar dd2 = (Dipolar)rdcVec2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        double[] rdcArr1 = new double[N];
        double[] rdcArr2 = new double[N];
        double[] rdcExp1 = new double[N];
        double[] rdcExp2 = new double[N];
        int[] seqNos1 = new int[N];
        int[] seqNos2 = new int[N];
        int no = 0;
        int index = -1;
        int j = 0;
        while (j < N) {
            no = firstResidueNo + j;
            index = Collections.binarySearch(rdcVec1, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp1[j] = ((Dipolar)rdcVec1.elementAt(index)).getRdc();
                seqNos1[j] = 1;
            } else {
                rdcExp1[j] = rdc1Cal[j];
                seqNos1[j] = 0;
            }
            index = Collections.binarySearch(rdcVec2, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcExp2[j] = ((Dipolar)rdcVec2.elementAt(index)).getRdc();
                seqNos2[j] = 1;
            } else {
                rdcExp2[j] = rdc2Cal[j];
                seqNos2[j] = 0;
            }
            ++j;
        }
        Cartesian cc = new Cartesian();
        String atom = "";
        double[] amide = new double[3];
        double[] ca = new double[3];
        double[] nh = new double[3];
        Pdb pp = (Pdb)pdbVec2.elementAt(0);
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide, nh);
        double[] nToCAVec = this.internuclearVec(amide, ca);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        boolean flag1 = false;
        double rRdc1 = 10000.0;
        double rRdc2 = 10000.0;
        double rT = 100000.0;
        double rTotal = 100000.0;
        long seed = 95738579L;
        Random rr = new Random(seed);
        double rms1 = 0.0;
        double rms2 = 0.0;
        int depth0 = 0;
        Vector ppVec = new Vector();
        double[] ppS = new double[2 * N];
        double[] phiS = new double[N];
        double[] psiS = new double[N];
        double[] phiSave = new double[N];
        double[] psiSave = new double[N];
        double[] rdc1Save = new double[N];
        double[] rdc2Save = new double[N];
        int noOfSln = 0;
        int n = 0;
        int N11 = rdcVec1.size();
        int N22 = rdcVec2.size();
        double phiRmsd = 0.0;
        double psiRmsd = 0.0;
        double rRdcFinal1 = rmsd1 * rmsd1 * (double)N11;
        double rRdcFinal2 = rmsd2 * rmsd2 * (double)N22;
        System.out.println(String.valueOf(rmsd1) + "  " + rmsd2 + " : " + N11 + "  " + N22);
        long startTime = System.currentTimeMillis();
        boolean depthFlag = false;
        boolean rightHand = true;
        PhiPsi ff = new PhiPsi();
        PdbRmsd pR = new PdbRmsd();
        double phiAve = -2.0943951023931953;
        double psiAve = 2.4085543677521746;
        double matchScore = 0.0;
        int mmm = 0;
        while (mmm < nCycle) {
            flag1 = false;
            while (!flag1) {
                flag1 = true;
                rRdc1 = 0.0;
                rRdc2 = 0.0;
                j = 0;
                while (j < N) {
                    rdcArr1[j] = rdcExp1[j] + rmsd1 * rr.nextGaussian();
                    rdcArr2[j] = rdcExp2[j] + rmsd2 * rr.nextGaussian();
                    rms1 = Math.abs(rdcArr1[j] - rdcExp1[j]);
                    rRdc1 += rms1 * rms1 * (double)seqNos1[j];
                    rms2 = Math.abs(rdcArr2[j] - rdcExp2[j]);
                    rRdc2 += rms2 * rms2 * (double)seqNos2[j];
                    ++j;
                }
                flag1 = !(rRdc1 > rRdcFinal1) && !(rRdc2 > rRdcFinal2);
            }
            ppVec = new Vector();
            depthFlag = ff.phiPsiChain(rdcArr1, rdcArr2, mat, Syy, Szz, depth0, N - 1, ppS, ppVec, rightHand, false);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * N);
                k = 0;
                while (k < noOfSln) {
                    phiRmsd = 0.0;
                    psiRmsd = 0.0;
                    n = k * 2 * N;
                    while (n < (k + 1) * 2 * N) {
                        this.phi = (Double)ppVec.elementAt(n);
                        this.psi = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * N) / 2] = this.phi;
                        psiS[(n - k * 2 * N) / 2] = this.psi;
                        phiRmsd += (this.phi - phiAve) * (this.phi - phiAve);
                        psiRmsd += (this.psi - psiAve) * (this.psi - psiAve);
                        n += 2;
                    }
                    pdbVec2 = this.modelBuild(phiS, psiS, amide, nh, ca, firstResidueNo, false);
                    matchScore = pR.centerFit(pdbS1, pdbVec2, hbVecOfE12, false) + pR.centerFit(pdbVec2, pdbS2, hbVecOfE13, false);
                    rT = Math.sqrt(rRdc1 / (double)N11) + Math.sqrt(rRdc2 / (double)(N22 - 1)) + weight4Angles * (Math.sqrt(phiRmsd / (double)N) + Math.sqrt(psiRmsd / (double)N)) + hbWeight * matchScore;
                    if (rT < rTotal) {
                        rTotal = rT;
                        System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc1 / (double)N11) + "  " + Math.sqrt(rRdc2 / (double)(N22 - 1)) + ";  " + Math.sqrt(phiRmsd / (double)N) / (Math.PI / 180) + "  " + Math.sqrt(psiRmsd / (double)N) / (Math.PI / 180) + "  " + matchScore + ", RT = " + rTotal);
                        System.arraycopy(phiS, 0, phiSave, 0, N);
                        System.arraycopy(psiS, 0, psiSave, 0, N);
                        System.arraycopy(rdcArr1, 0, rdc1Save, 0, N);
                        System.arraycopy(rdcArr2, 0, rdc2Save, 0, N);
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i = 0;
        while (i < N) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbHelixN = this.modelBuild(phiSave, psiSave, amide, nh, ca, firstResidueNo, false);
        if (printResults) {
            System.out.println(" CH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc1Save[k] + "  " + rdcExp1[k] + "  " + Math.abs(rdc1Save[k] - rdcExp1[k]));
                ++k;
            }
            System.out.println(" NH RDC: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + ": " + rdc2Save[k] + "  " + rdcExp2[k] + "  " + Math.abs(rdc2Save[k] - rdcExp2[k]));
                ++k;
            }
            System.out.println(" Phi/Psi: ");
            k = 0;
            while (k < N) {
                System.out.println(String.valueOf(firstResidueNo + k) + "   " + phiSave[k] / (Math.PI / 180) + "  " + psiSave[k] / (Math.PI / 180));
                ++k;
            }
        }
        return pdbHelixN;
    }

    public Vector minTurns(Vector h1Vec, Vector asgVec, Vector pdbVec1, Vector pdbVec2, Vector rdcVec1, Vector rdcVec2, double Syy, double Szz, int no1, int no2, double a1, double a2) {
        int i = 0;
        int j = 0;
        PhiPsi ff = new PhiPsi();
        double[] amide1 = new double[3];
        double[] nh1 = new double[3];
        double[] ca1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh2 = new double[3];
        double[] ca2 = new double[3];
        Cartesian cc = new Cartesian();
        String atom = "";
        int index = Collections.binarySearch(pdbVec1, new Pdb(no1), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("Error in the PDB file 1");
            return new Vector();
        }
        Pdb pp = (Pdb)pdbVec1.elementAt(index);
        String resid = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVec = this.internuclearVec(amide1, nh1);
        double[] nToCAVec = this.internuclearVec(amide1, ca1);
        Matrix rg = ff.RgCal(nToNHVec, nToCAVec);
        index = Collections.binarySearch(pdbVec2, new Pdb(no2), new Pdb.PdbComparator());
        if (index < 0) {
            System.out.println("Error in the PDB file 2");
            return new Vector();
        }
        pp = (Pdb)pdbVec2.elementAt(index);
        resid = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("H")) {
                nh2 = cc.getXYZ();
            }
            ++j;
        }
        boolean depth = false;
        int N = no2 - no1;
        Vector ppVec = new Vector();
        double[] ppS = new double[2 * N];
        double[][] restraints = ff.extractRestraints(no1, no2, h1Vec, asgVec, rdcVec1, rdcVec2, a1, a2);
        int numberOfResidues = 4;
        i = 0;
        while (i < numberOfResidues) {
            j = 0;
            while (j < 5) {
                System.out.print(String.valueOf(restraints[i][j]) + "  ");
                ++j;
            }
            System.out.println();
            ++i;
        }
        return ppVec;
    }

    public Vector refineSaupe4RDCsWOAT(Vector rdc1Vec, Vector rdc2Vec, Vector rdcCaCoVec, Vector rdcCoNVec, double[] saupe, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int nCycle, boolean debugDFS, boolean printResults, Vector vecTalos) throws JampackException {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Dipolar dd1 = (Dipolar)rdc1Vec.elementAt(0);
        Dipolar dd2 = (Dipolar)rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = (Dipolar)rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = (Dipolar)rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        int N = lastResidueNo - firstResidueNo;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbVec = this.modelBuild(phiPsiVec, n1, nh1, ca1);
        PdbRdc pdr = new PdbRdc();
        double[] rdc1Cal = new double[pdbVec.size() - 1];
        double[] rdc2Cal = new double[pdbVec.size() - 1];
        double weight4Angles = 10.0;
        Matrix mm = new Matrix(3, 3);
        Vector<Pdb> pdbVec1 = new Vector();
        Vector<Pdb> pdbVec2 = new Vector();
        boolean isHelix = true;
        mm = pdr.bestFit((Vector<Pdb>)pdbVec, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec, mm);
        pdbVec2 = this.minHelix4RDCs(rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, 1.0, 1.0);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, 1.0, 1.0);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, 1.0, 1.0);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        nCycle = 131072;
        pdbVec2 = this.minHelix4RDCs(rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, 1.0, 1.0);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        Vector<Pdb> pdbVecN = pp.newPdb(pdbVec2, mm);
        return pdbVecN;
    }

    public Vector refineSaupe4RDCsWOAT(Vector vecPreBB, Vector pdbVec, Vector rdc1Vec, Vector rdc2Vec, Vector rdcCaCoVec, Vector rdcCoNVec, double[] saupe, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int nCycle, boolean debugDFS, boolean printResults, Vector vecTalos, double wtCoCa, double wtCoN, int starNo, int endNo, Vector vecSeq) throws JampackException {
        boolean i = false;
        Pdb pp = new Pdb();
        PdbRdc pdr = new PdbRdc();
        double[] rdc1Cal = new double[pdbVec.size()];
        double[] rdc2Cal = new double[pdbVec.size()];
        double weight4Angles = 10.0;
        Matrix mm = new Matrix(3, 3);
        Vector<Pdb> pdbVec1 = new Vector();
        Vector<Pdb> pdbVec2 = new Vector();
        boolean isHelix = true;
        mm = pdr.bestFit((Vector<Pdb>)pdbVec, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec, mm);
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        nCycle = 131072;
        pdbVec2 = this.minHelix4RDCs(vecPreBB, rdc2Vec, rdc1Vec, rdcCaCoVec, rdcCoNVec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos, wtCoCa, wtCoN, starNo, endNo, vecSeq);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        Vector<Pdb> pdbVecN = pp.newPdb(pdbVec2, mm);
        return pdbVecN;
    }

    public Vector refineSaupe(Vector rdc1Vec, Vector rdc2Vec, double[] saupe, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int nCycle, boolean debugDFS, boolean printResults, Vector vecTalos) throws JampackException {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Dipolar dd1 = (Dipolar)rdc1Vec.elementAt(0);
        Dipolar dd2 = (Dipolar)rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = (Dipolar)rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = (Dipolar)rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        int N = lastResidueNo - firstResidueNo;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbVec = this.modelBuild(phiPsiVec, n1, nh1, ca1);
        PdbRdc pdr = new PdbRdc();
        double[] rdc1Cal = new double[pdbVec.size() - 1];
        double[] rdc2Cal = new double[pdbVec.size() - 1];
        double weight4Angles = 10.0;
        Matrix mm = new Matrix(3, 3);
        Vector<Pdb> pdbVec1 = new Vector();
        Vector<Pdb> pdbVec2 = new Vector();
        boolean isHelix = true;
        mm = pdr.bestFit((Vector<Pdb>)pdbVec, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec, mm);
        pdbVec2 = this.minHelix(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        pdbVec2 = this.minHelix(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        pdbVec1 = pp.newPdb(pdbVec2, mm);
        nCycle = 131072;
        pdbVec2 = this.minHelix(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbVec1, saupe[0], saupe[1], saupe[2], saupe[3], nCycle, weight4Angles, debugDFS, printResults, isHelix, vecTalos);
        mm = pdr.bestFit(pdbVec2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
        Vector<Pdb> pdbVecN = pp.newPdb(pdbVec2, mm);
        return pdbVecN;
    }

    public Vector refineSaupe2(Vector pdbVec, Vector paraVec, Vector eRdc1Vec, Vector eRdc2Vec, Vector helixRdc1, Vector helixRdc2, double[] saupeSave) {
        int i = 0;
        PdbRdc pdr = new PdbRdc();
        Pdb pp = new Pdb();
        Vector pdbVecN = new Vector();
        Vector strand1Rdc1 = (Vector)eRdc1Vec.elementAt(0);
        Vector strand1Rdc2 = (Vector)eRdc2Vec.elementAt(0);
        Vector strand2Rdc1 = (Vector)eRdc1Vec.elementAt(1);
        Vector strand2Rdc2 = (Vector)eRdc2Vec.elementAt(1);
        Vector strand3Rdc1 = (Vector)eRdc1Vec.elementAt(2);
        Vector strand3Rdc2 = (Vector)eRdc2Vec.elementAt(2);
        Vector strand5Rdc1 = (Vector)eRdc1Vec.elementAt(4);
        Vector strand5Rdc2 = (Vector)eRdc2Vec.elementAt(4);
        Vector nhRdc = new Vector();
        i = 1;
        while (i < strand1Rdc1.size()) {
            nhRdc.add(strand1Rdc1.elementAt(i));
            ++i;
        }
        i = 1;
        while (i < strand2Rdc1.size()) {
            nhRdc.add(strand2Rdc1.elementAt(i));
            ++i;
        }
        i = 1;
        while (i < helixRdc1.size()) {
            nhRdc.add(helixRdc1.elementAt(i));
            ++i;
        }
        i = 1;
        while (i < strand5Rdc1.size()) {
            nhRdc.add(strand5Rdc1.elementAt(i));
            ++i;
        }
        Vector<Dipolar> cahaRdc = new Vector<Dipolar>();
        cahaRdc.addAll(strand1Rdc2);
        cahaRdc.addAll(strand2Rdc2);
        cahaRdc.addAll(helixRdc2);
        cahaRdc.addAll(strand5Rdc2);
        int N = pdbVec.size();
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        Matrix mm = pdr.bestFit((Vector<Pdb>)pdbVec, nhRdc, cahaRdc, rdc1Cal, rdc2Cal, saupeSave);
        Vector<Pdb> pdbVec2 = pp.newPdb(pdbVec, mm);
        return pdbVec2;
    }

    public Vector<Pdb> refineHelix22(Vector vecBB, Vector<Dipolar> rdc1Vec, Vector<Dipolar> rdc2Vec, double Syy, double Szz, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int initialCycle, double w4Angles, double resolution, boolean debugDFS, boolean printResults, double[] nhRdcRmsd, double[] chRdcRmsd) {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Dipolar dd1 = rdc1Vec.elementAt(0);
        Dipolar dd2 = rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector<Pdb> pdbStrand = new Vector<Pdb>();
        pdbStrand.addAll(vecBB);
        PdbRdc pdr = new PdbRdc();
        double[] rmsds = new double[2];
        Vector<Object> pdbStrandN = new Vector();
        Matrix[] mm = new Matrix[4];
        double[] rdc1Rmsd = new double[4];
        double[] rdc2Rmsd = new double[4];
        int N = lastResidueNo - firstResidueNo;
        double[] rdc1Cal = new double[N + 1];
        double[] rdc2Cal = new double[N + 1];
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        Matrix[] mm_temp = new Matrix[4];
        double[] temp1 = new double[1];
        int[] temp2 = new int[1];
        double[][] ss = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix ssMat = new Matrix(ss);
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", ssMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", ssMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        boolean debugEulerFit = false;
        mm[0] = pdr.eulerFit(pdbStrand, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
        rdc1Rms = rmsds[0];
        rdc2Rms = rmsds[1];
        nhRdcRmsd[0] = rdc1Rms;
        chRdcRmsd[0] = rdc2Rms;
        mm[0].print(14, 14);
        if (printResults) {
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            mm[0].print(14, 14);
        }
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        double rms_save = rdc1Rms + rdc2Rms;
        int i_save = 0;
        Vector<Pdb> helixVecN = new Vector();
        i = 1;
        while (i < 4) {
            mm[i] = Const.mat4ThreeDirs[i - 1].times(mm[0]);
            rdc1Rmsd[i] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
            rdc2Rmsd[i] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
            System.out.println("i=" + i);
            helixVecN = pp.newPdb(pdbStrand, Const.mat4ThreeDirs[i - 1]);
            mm_temp[0] = pdr.eulerFit(helixVecN, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
            rdc1Rms = rmsds[0];
            rdc2Rms = rmsds[1];
            if (rdc1Rms + rdc2Rms < rms_save) {
                nhRdcRmsd[0] = rdc1Rms;
                chRdcRmsd[0] = rdc2Rms;
                rms_save = rdc1Rms + rdc2Rms;
                i_save = i;
            }
            mm_temp[0].print(14, 14);
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            ++i;
        }
        System.out.println("i_save=" + i_save);
        pdbStrandN = pp.newPdb(pdbStrand, mm[i_save]);
        Matrix mm2 = new Matrix(3, 3);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        boolean isHelix = true;
        Matrix iMat = Matrix.identity(3, 3);
        double[] saupe = new double[5];
        Vector<Pdb> pdbS2 = new Vector();
        double[] chRdcRmsdTemp = new double[1];
        double[] nhRdcRmsdTemp = new double[1];
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = initialCycle;
            pdbS2 = this.minHelix(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbStrandN, Syy, Szz, rdc2Rms, rdc1Rms, nCycle, w4Angles, debugDFS, printResults, isHelix, nhRdcRmsdTemp, chRdcRmsdTemp);
            mm2 = pdr.bestFit(pdbS2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
            rdc1Rms = saupe[2];
            rdc2Rms = saupe[3];
            pdbStrandN = new Vector();
            pdbStrandN.addAll(pdbS2);
            System.out.println("refinecycle=" + i + ": ");
            ++i;
        }
        if (nhRdcRmsdTemp[0] < 100.0) {
            nhRdcRmsd[0] = nhRdcRmsdTemp[0];
            chRdcRmsd[0] = chRdcRmsdTemp[0];
        }
        System.out.println("====================================");
        return pdbStrandN;
    }

    public Vector<Pdb> refineHelix22NoGridSearch(Vector vecBB, Vector<Dipolar> rdc1Vec, Vector<Dipolar> rdc2Vec, double Syy, double Szz, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int initialCycle, double w4Angles, double resolution, boolean debugDFS, boolean printResults, double[] nhRdcRmsd, double[] chRdcRmsd) {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Dipolar dd1 = rdc1Vec.elementAt(0);
        Dipolar dd2 = rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector<Pdb> pdbStrand = new Vector<Pdb>();
        pdbStrand.addAll(vecBB);
        PdbRdc pdr = new PdbRdc();
        double[] rmsds = new double[2];
        Vector<Pdb> pdbStrandN = new Vector<Pdb>();
        pdbStrandN.addAll(vecBB);
        Matrix[] mm = new Matrix[4];
        double[] rdc1Rmsd = new double[4];
        double[] rdc2Rmsd = new double[4];
        int N = lastResidueNo - firstResidueNo;
        double[] rdc1Cal = new double[N + 1];
        double[] rdc2Cal = new double[N + 1];
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        Matrix[] mm_temp = new Matrix[4];
        double[] temp1 = new double[1];
        int[] temp2 = new int[1];
        double[][] ss = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix ssMat = new Matrix(ss);
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", ssMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal, temp1, temp2);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", ssMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal, temp1, temp2);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        Matrix mm2 = new Matrix(3, 3);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        boolean isHelix = true;
        Matrix iMat = Matrix.identity(3, 3);
        double[] saupe = new double[5];
        Vector<Pdb> pdbS2 = new Vector();
        double[] chRdcRmsdTemp = new double[1];
        double[] nhRdcRmsdTemp = new double[1];
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = initialCycle;
            pdbS2 = this.minHelix(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbStrandN, Syy, Szz, rdc2Rms, rdc1Rms, nCycle, w4Angles, debugDFS, printResults, isHelix, nhRdcRmsdTemp, chRdcRmsdTemp);
            mm2 = pdr.bestFit(pdbS2, rdc1Vec, rdc2Vec, rdc1Cal, rdc2Cal, saupe);
            rdc1Rms = saupe[2];
            rdc2Rms = saupe[3];
            pdbStrandN = new Vector();
            pdbStrandN.addAll(pdbS2);
            System.out.println("refinecycle=" + i + ": ");
            ++i;
        }
        if (nhRdcRmsdTemp[0] < 100.0) {
            nhRdcRmsd[0] = nhRdcRmsdTemp[0];
            chRdcRmsd[0] = chRdcRmsdTemp[0];
        }
        System.out.println("====================================");
        return pdbStrandN;
    }

    public Vector refineHelix(Vector rdcVec1, Vector rdcVec2, double[] n2ca, double Syy, double Szz, Map heliceMap) {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Dipolar dd1 = (Dipolar)rdcVec1.elementAt(0);
        Dipolar dd2 = (Dipolar)rdcVec2.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = (Dipolar)rdcVec1.elementAt(rdcVec1.size() - 1);
        dd2 = (Dipolar)rdcVec2.elementAt(rdcVec2.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        int N = lastResidueNo - firstResidueNo + 1;
        double phiAve = -1.1397000015522971;
        double psiAve = -0.6876597252857658;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbVec = this.modelBuild(phiPsiVec, n1, nh1, ca1);
        int refineCycle = Integer.parseInt((String)heliceMap.get("REFINECYCLE"));
        int dfsCycle = Integer.parseInt((String)heliceMap.get("DFSCYCLE"));
        boolean debugDFS = new Boolean((String)heliceMap.get("DEBUGDFS"));
        boolean printResults = new Boolean((String)heliceMap.get("PRINTRESULTS"));
        double w4Angles = new Double((String)heliceMap.get("WEIGHT4ANGLES"));
        double resolution = new Double((String)heliceMap.get("RESOLUTION"));
        PdbRdc pdr = new PdbRdc();
        double[] rmsds = new double[2];
        Vector<Pdb> pdbVec2 = new Vector();
        Matrix iMat = Matrix.identity(3, 3);
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        Matrix[] mm = new Matrix[4];
        Matrix[] rr = new Matrix[4];
        double[] rdc1Rmsd = new double[4];
        double[] rdc2Rmsd = new double[4];
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        double[] nToCa = new double[3];
        boolean debugEulerFit = true;
        double[][] mmArr = new double[][]{{-0.80382754971551, -0.33178913478673, -0.49373802806329}, {0.17818753051321, 0.65759409409609, -0.73199672907708}, {0.56754777269227, -0.67637709707486, -0.46947156278589}};
        mm[0] = new Matrix(mmArr);
        nToCa = mm[0].times(ca1);
        pdbVec2 = pp.newPdb(pdbVec, mm[0]);
        rdc1Rmsd[0] = pdr.BackCalNH(pdbVec2, rdcVec1, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
        rdc2Rmsd[0] = pdr.BackCal(pdbVec2, rdcVec2, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
        double angle = this.interAngle(nToCa, n2ca);
        i = 1;
        while (i < 4) {
            mm[i] = Const.mat4ThreeDirs[i - 1].times(mm[0]);
            nToCa = mm[i].times(ca1);
            angle = this.interAngle(nToCa, n2ca);
            pdbVec2 = pp.newPdb(pdbVec, mm[i]);
            rdc1Rmsd[i] = pdr.BackCalNH(pdbVec2, rdcVec1, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
            rdc2Rmsd[i] = pdr.BackCal(pdbVec2, rdcVec2, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
            ++i;
        }
        Vector pdbVec1 = pp.newPdb(pdbVec, mm[0]);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        boolean isHelix = true;
        Vector pdbS2 = new Vector();
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = i * dfsCycle;
            pdbS2 = this.minHelix_old(rdcVec2, rdcVec1, rdc2Cal, rdc1Cal, pdbVec1, Syy, Szz, rdc2Rms, rdc1Rms, nCycle, w4Angles, debugDFS, printResults, isHelix);
            rdc1Rms = pdr.BackCalNH(pdbS2, rdcVec1, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
            rdc2Rms = pdr.BackCal(pdbS2, rdcVec2, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
            pdbVec1 = pdbS2;
            ++i;
        }
        return pdbS2;
    }

    public Vector refineStrand(Vector rdc1Vec, Vector rdc2Vec, double Syy, double Szz, double[] ramaFilter, double phiAve, double psiAve, int refineCycle, int initialCycle, double w4Angles, double resolution, boolean debugDFS, boolean printResults) {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pp = new Pdb();
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Dipolar dd1 = (Dipolar)rdc1Vec.elementAt(0);
        Dipolar dd2 = (Dipolar)rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = (Dipolar)rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = (Dipolar)rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbStrand = this.modelBuild(phiPsiVec, n1, nh1, ca1);
        PdbRdc pdr = new PdbRdc();
        double[] rmsds = new double[2];
        Vector pdbStrandN = new Vector();
        Matrix[] mm = new Matrix[4];
        double[] rdc1Rmsd = new double[4];
        double[] rdc2Rmsd = new double[4];
        int N = lastResidueNo - firstResidueNo;
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        double rdc1Rms = 0.0;
        double rdc2Rms = 0.0;
        boolean debugEulerFit = false;
        mm[0] = pdr.eulerFit(pdbStrand, rdc1Vec, rdc2Vec, Syy, Szz, rmsds, resolution, debugEulerFit);
        rdc1Rms = Math.sqrt(rmsds[0] / (double)N);
        rdc2Rms = Math.sqrt(rmsds[1] / (double)N);
        mm[0].print(14, 14);
        if (printResults) {
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2");
            System.out.println(String.valueOf(rdc1Rms) + "  " + rdc2Rms);
            mm[0].print(14, 14);
        }
        rdc1Rmsd[0] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
        rdc2Rmsd[0] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[0], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
        rdc1Rms = rdc1Rmsd[0];
        rdc2Rms = rdc2Rmsd[0];
        i = 1;
        while (i < 4) {
            mm[i] = Const.mat4ThreeDirs[i - 1].times(mm[0]);
            rdc1Rmsd[i] = pdr.BackCalNH(pdbStrand, rdc1Vec, "N", "H", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
            rdc2Rmsd[i] = pdr.BackCal(pdbStrand, rdc2Vec, "CA", "HA", mm[i], -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
            ++i;
        }
        pdbStrandN = pp.newPdb(pdbStrand, mm[2]);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        boolean isHelix = false;
        Matrix iMat = Matrix.identity(3, 3);
        Vector pdbS2 = new Vector();
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = i * initialCycle;
            pdbS2 = this.minHelix_old(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbStrandN, Syy, Szz, rdc2Rms, rdc1Rms, nCycle, w4Angles, debugDFS, printResults, isHelix);
            rdc1Rms = pdr.BackCalNH(pdbS2, rdc1Vec, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
            rdc2Rms = pdr.BackCal(pdbS2, rdc2Vec, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
            pdbStrandN = pdbS2;
            ++i;
        }
        return pdbStrandN;
    }

    public Vector refineStrand(Vector rdc1Vec, Vector rdc2Vec, double Syy, double Szz, double phiAve, double psiAve, int refineCycle, int initialCycle, double resolution, double angleWeight, double hbWeight, Vector pdbS1, Vector hBVecOfE21, boolean printEulerSearch, boolean debugDFS, boolean printResults) {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Pdb pp = new Pdb();
        Dipolar dd1 = (Dipolar)rdc1Vec.elementAt(0);
        Dipolar dd2 = (Dipolar)rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = (Dipolar)rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = (Dipolar)rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbStrand = this.modelBuild(phiPsiVec, n1, nh1, ca1);
        PdbRdc pdr = new PdbRdc();
        PdbRmsd pR = new PdbRmsd();
        double[] rmsds = new double[3];
        int N = lastResidueNo - firstResidueNo + 1;
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        Vector pdbStrandN = new Vector();
        Matrix iMat = Matrix.identity(3, 3);
        double w4HBEulerFit = 5.0;
        printEulerSearch = false;
        Matrix mm = pdr.fit4MissingRdcHB(pdbStrand, rdc1Vec, rdc2Vec, Syy, Szz, pdbS1, rmsds, resolution, w4HBEulerFit, hBVecOfE21, printEulerSearch);
        double rdc1Rms = Math.sqrt(rmsds[0] / (double)(N - 1));
        double rdc2Rms = Math.sqrt(rmsds[1] / (double)(N - 1));
        double hbScores = rmsds[2];
        if (printResults) {
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2,  hbScore");
            System.out.println(String.valueOf(rdc1Rms) + "   " + rdc2Rms + "   " + hbScores);
            mm.print(14, 14);
        }
        Vector pdbVec2 = pp.newPdb(pdbStrand, mm);
        rdc1Rms = pdr.BackCalNH(pdbVec2, rdc1Vec, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
        rdc2Rms = pdr.BackCal(pdbVec2, rdc2Vec, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        Vector pdbS2 = new Vector();
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = i * initialCycle;
            pdbS2 = this.minBeta(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbVec2, Syy, Szz, rdc2Rms, rdc1Rms, pdbS1, hBVecOfE21, nCycle, angleWeight, hbWeight, debugDFS, printResults);
            rdc1Rms = pdr.BackCalNH(pdbS2, rdc1Vec, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
            rdc2Rms = pdr.BackCal(pdbS2, rdc2Vec, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
            pdbVec2 = pdbS2;
            ++i;
        }
        Vector pdbVecN = pR.centerFitVec(pdbS1, pdbVec2, hBVecOfE21, true);
        return pdbVecN;
    }

    public Vector refineStrand2(Vector rdc1Vec, Vector rdc2Vec, double Syy, double Szz, double phiAve, double psiAve, int refineCycle, int initialCycle, double resolution, double angleWeight, double hbWeight, Vector pdbE1, Vector HbondVec, boolean printEulerSearch, boolean debugDFS, boolean printResults) {
        int i = 0;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        Pdb pp = new Pdb();
        Dipolar dd1 = (Dipolar)rdc1Vec.elementAt(0);
        Dipolar dd2 = (Dipolar)rdc2Vec.elementAt(0);
        int firstResidueNo = Math.min(dd1.getResidueNo(), dd2.getResidueNo());
        dd1 = (Dipolar)rdc1Vec.elementAt(rdc1Vec.size() - 1);
        dd2 = (Dipolar)rdc2Vec.elementAt(rdc2Vec.size() - 1);
        int lastResidueNo = Math.max(dd1.getResidueNo(), dd2.getResidueNo()) + 1;
        i = firstResidueNo;
        while (i < lastResidueNo) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbStrand = this.modelBuild(phiPsiVec, n1, nh1, ca1);
        Vector<Pdb> pdbS1 = new Vector<Pdb>();
        int no = 0;
        i = 0;
        while (i < pdbE1.size()) {
            pp = (Pdb)pdbE1.elementAt(i);
            no = pp.getResidueNo();
            if (no < firstResidueNo || no > lastResidueNo) {
                pdbS1.add(pp);
            }
            ++i;
        }
        PdbRdc pdr = new PdbRdc();
        PdbRmsd pR = new PdbRmsd();
        Hbond hb = new Hbond();
        double[] rmsds = new double[3];
        int N = lastResidueNo - firstResidueNo + 1;
        double[] rdc1Cal = new double[N];
        double[] rdc2Cal = new double[N];
        Vector pdbStrandN = new Vector();
        Matrix iMat = Matrix.identity(3, 3);
        double w4HBEulerFit = 1.0;
        printEulerSearch = false;
        String id1 = "E5-E3";
        String id2 = "E3-E4";
        Vector hBVecOfE21 = hb.hbOfTwoStrands(HbondVec, id1);
        Vector hBVecOfE23 = hb.hbOfTwoStrands(HbondVec, id2);
        Matrix mm = pdr.fit4MissingRdcHB2(pdbStrand, rdc1Vec, rdc2Vec, Syy, Szz, pdbS1, pdbS1, rmsds, resolution, w4HBEulerFit, hBVecOfE21, hBVecOfE23, printEulerSearch);
        double rdc1Rms = Math.sqrt(rmsds[0] / (double)(N - 1));
        double rdc2Rms = Math.sqrt(rmsds[1] / (double)(N - 1));
        double hbScores = rmsds[2];
        if (printResults) {
            System.out.println("Results from grid-search: rmsdRdc1,  rmsdRdc2,  hbScore");
            System.out.println(String.valueOf(rdc1Rms) + "   " + rdc2Rms + "   " + hbScores);
            mm.print(14, 14);
        }
        Vector pdbVec2 = pp.newPdb(pdbStrand, mm);
        rdc1Rms = pdr.BackCalNH(pdbVec2, rdc1Vec, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
        rdc2Rms = pdr.BackCal(pdbVec2, rdc2Vec, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
        int nCycle = 1;
        debugDFS = true;
        printResults = true;
        Vector pdbS2 = new Vector();
        i = 1;
        while (i < refineCycle + 1) {
            nCycle = i * initialCycle;
            pdbS2 = this.minBeta2(rdc2Vec, rdc1Vec, rdc2Cal, rdc1Cal, pdbVec2, Syy, Szz, rdc2Rms, rdc1Rms, pdbS1, pdbS1, hBVecOfE21, hBVecOfE23, nCycle, angleWeight, hbWeight, debugDFS, printResults);
            rdc1Rms = pdr.BackCalNH(pdbS2, rdc1Vec, "N", "H", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc1Cal);
            rdc2Rms = pdr.BackCal(pdbS2, rdc2Vec, "CA", "HA", iMat, -Syy - Szz, Syy, Szz, 1.0, rdc2Cal);
            pdbVec2 = pdbS2;
            ++i;
        }
        Vector pdbVecN = pR.centerFitVec(pdbS1, pdbVec2, hBVecOfE21, true);
        Vector<Pdb> sheetPdb = new Vector<Pdb>();
        sheetPdb.addAll(pdbVecN);
        sheetPdb.addAll(pdbS1);
        Collections.sort(sheetPdb, new Pdb.PdbComparator());
        return sheetPdb;
    }

    protected Object clone() {
        try {
            Object s = super.clone();
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class mdComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int d2;
            ModelRdc n1 = (ModelRdc)o1;
            ModelRdc n2 = (ModelRdc)o2;
            int d1 = n1.getResidueNo();
            if (d1 < (d2 = n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

