/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.Dipolar;
import rdcPanda.Hdist;
import rdcPanda.Hsqc;
import rdcPanda.IDof2aryStructure;
import rdcPanda.Matrix;
import rdcPanda.Model;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.PdbRdc;
import rdcPanda.Peak;
import rdcPanda.PhiPsi;
import rdcPanda.Residue;
import rdcPanda.RotaPattern;
import rdcPanda.sp3Carbon;
import rdcPanda.vdw;

public class Pdb {
    private int residueNo;
    private String residue;
    private Vector atomVec = new Vector();
    private double ratio;

    public Pdb() {
        this.residueNo = 0;
        this.residue = null;
        this.atomVec = null;
        this.ratio = 0.0;
    }

    public Pdb(int No) {
        this.residueNo = No;
        this.atomVec = new Vector();
        this.residue = "";
        this.ratio = 0.0;
    }

    public Pdb(int No, String res, Vector aa) {
        this.residueNo = No;
        this.atomVec = aa;
        this.residue = res;
        this.ratio = 0.0;
    }

    public Pdb(int No, String res, Vector aa, double ra) {
        this.residueNo = No;
        this.atomVec = aa;
        this.residue = res;
        this.ratio = ra;
    }

    public Pdb(Pdb pp) {
        this.residueNo = pp.getResidueNo();
        this.residue = pp.getResidue();
        this.ratio = pp.getRotamerRatio();
        Vector<Cartesian> vecAtom = pp.getAtomVec();
        int i = 0;
        while (i < vecAtom.size()) {
            Cartesian cart = vecAtom.elementAt(i);
            Cartesian carNew = new Cartesian(cart);
            this.atomVec.add(carNew);
            ++i;
        }
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public Vector<Cartesian> getAtomVec() {
        return this.atomVec;
    }

    public String getResidue() {
        return this.residue;
    }

    public double getRotamerRatio() {
        return this.ratio;
    }

    public void setResidueNo(int no) {
        this.residueNo = no;
    }

    public void setResidue(String res) {
        this.residue = res;
    }

    public void setAtomVec(Vector aVec) {
        this.atomVec = aVec;
    }

    public void setRotamerRatio(double ra) {
        this.ratio = ra;
    }

    public String toString() {
        String desc = String.valueOf(String.valueOf(this.residueNo)) + "  " + this.residue + "\n";
        String str = "";
        int i = 0;
        while (i < this.atomVec.size()) {
            str = String.valueOf(str) + ((Cartesian)this.atomVec.elementAt(i)).toString() + "\n";
            ++i;
        }
        return String.valueOf(desc) + str;
    }

    public void printArray(double[] n1) {
        int i = 0;
        while (i < n1.length) {
            System.out.print(String.valueOf(n1[i]) + "  ");
            ++i;
        }
        System.out.println();
    }

    public double length(double[] v1) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        return v1Len;
    }

    public double[] dirCos(double[] vec) {
        double len = 0.0;
        double[] dirs = new double[vec.length];
        int i = 0;
        while (i < vec.length) {
            len += vec[i] * vec[i];
            ++i;
        }
        int j = 0;
        while (j < vec.length) {
            dirs[j] = vec[j] / Math.sqrt(len);
            ++j;
        }
        return dirs;
    }

    public double interAngle(double[] v1, double[] v2) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        double v2Len = Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2]);
        double c = (v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2]) / (v1Len * v2Len);
        return Math.acos(c);
    }

    public double[] internuclearVec(double[] n1, double[] n2) {
        return new double[]{n2[0] - n1[0], n2[1] - n1[1], n2[2] - n1[2]};
    }

    public Vector<Pdb> readRotamerPdb(String pdbFile) {
        String ss = "";
        String str = "";
        String r_type = "";
        String pdbID = "";
        int residueNo = 0;
        int noTmp = 0;
        int index = 0;
        Vector<Pdb> pdbVec = new Vector<Pdb>();
        Vector<Cartesian> atoms = new Vector<Cartesian>();
        String form = "";
        double rotaRatio = 1.0;
        try {
            BufferedReader in;
            block15: {
                in = new BufferedReader(new FileReader(pdbFile));
                ss = in.readLine();
                if (ss.length() > 66) {
                    pdbID = ss.substring(62, 66).trim();
                }
                block3: while (true) {
                    String keywords = ss.length() > 5 ? ss.substring(0, 6).trim() : ss.trim();
                    index = ss.indexOf("ratio");
                    if (index > 0) {
                        rotaRatio = new Double(ss.substring(index + 7, ss.length()).trim());
                    }
                    while (keywords.equals("ATOM")) {
                        if (ss.length() <= 54) continue;
                        form = ss.substring(16, 17).trim();
                        String a1_type = ss.substring(12, 16).trim();
                        r_type = ss.substring(17, 20).trim();
                        residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                        double x_in = new Double(ss.substring(30, 38).trim());
                        double y_in = new Double(ss.substring(38, 46).trim());
                        double z_in = new Double(ss.substring(46, 54).trim());
                        atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                        ss = in.readLine();
                        if (ss == null) break block15;
                        if (ss.length() <= 5) continue block3;
                        str = ss.substring(0, 6).trim();
                        if (!str.equals("ATOM")) {
                            if (r_type.length() == 3) {
                                pdbVec.add(new Pdb(residueNo, r_type, atoms, rotaRatio));
                                atoms = new Vector();
                            }
                            if ((index = ss.indexOf("ratio")) <= 0) continue block3;
                            rotaRatio = new Double(ss.substring(index + 7, ss.length()).trim());
                            continue block3;
                        }
                        noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                        while (noTmp == residueNo) {
                            a1_type = ss.substring(12, 16).trim();
                            r_type = ss.substring(17, 20).trim();
                            residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                            x_in = new Double(ss.substring(30, 38).trim());
                            y_in = new Double(ss.substring(38, 46).trim());
                            z_in = new Double(ss.substring(46, 54).trim());
                            atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                            ss = in.readLine();
                            if (ss != null) {
                                if (ss.length() <= 5) continue block3;
                                str = ss.substring(0, 6).trim();
                                if (!str.equals("ATOM")) {
                                    if (r_type.length() == 3) {
                                        pdbVec.add(new Pdb(residueNo, r_type, atoms, rotaRatio));
                                        atoms = new Vector();
                                    }
                                    if ((index = ss.indexOf("ratio")) <= 0) continue block3;
                                    rotaRatio = new Double(ss.substring(index + 7, ss.length()).trim());
                                    continue block3;
                                }
                                noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                                continue;
                            }
                            break block15;
                        }
                        if (r_type.length() == 3) {
                            pdbVec.add(new Pdb(residueNo, r_type, atoms, rotaRatio));
                            atoms = new Vector();
                        }
                        if ((index = ss.indexOf("ratio")) > 0) {
                            rotaRatio = new Double(ss.substring(index + 7, ss.length()).trim());
                        }
                        keywords = str;
                    }
                    ss = in.readLine();
                    if (ss == null) break;
                }
                pdbVec.add(new Pdb(residueNo, r_type, atoms, rotaRatio));
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + pdbFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(pdbVec, new PdbComparator());
        return pdbVec;
    }

    public Vector<Pdb> readPdb(String pdbFile) {
        String ss = "";
        String str = "";
        String r_type = "";
        String pdbID = "";
        int residueNo = 0;
        int noTmp = 0;
        Vector<Pdb> pdbVec = new Vector<Pdb>();
        Vector<Cartesian> atoms = new Vector<Cartesian>();
        String form = "";
        try {
            BufferedReader in;
            block33: {
                in = new BufferedReader(new FileReader(pdbFile));
                ss = in.readLine();
                if (ss.length() > 66) {
                    pdbID = ss.substring(62, 66).trim();
                }
                block3: while (true) {
                    String keywords = ss.length() > 5 ? ss.substring(0, 6).trim() : ss.trim();
                    while (keywords.equals("ATOM") || keywords.equals("HETATM")) {
                        if (ss.length() <= 54) continue;
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block33;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block33;
                            }
                            if (!str.equals("ATOM") && !keywords.equals("HETATM")) {
                                if (r_type.length() != 3) continue block3;
                                if (r_type.equalsIgnoreCase("HID") || r_type.equalsIgnoreCase("HIS")) {
                                    r_type = "HIS";
                                }
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector();
                                continue block3;
                            }
                        }
                        String a1_type = ss.substring(12, 16).trim();
                        r_type = ss.substring(17, 20).trim();
                        residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                        double x_in = new Double(ss.substring(30, 38).trim());
                        double y_in = new Double(ss.substring(38, 46).trim());
                        double z_in = new Double(ss.substring(46, 54).trim());
                        atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                        ss = in.readLine();
                        if (ss == null) break block33;
                        if (ss.length() <= 54) continue block3;
                        str = ss.substring(0, 6).trim();
                        while (str.equals("ANISOU")) {
                            ss = in.readLine();
                            if (ss != null) {
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
                                continue;
                            }
                            break block33;
                        }
                        if (!str.equals("ATOM") && !keywords.equals("HETATM")) {
                            if (r_type.length() != 3) continue block3;
                            if (r_type.equalsIgnoreCase("HID") || r_type.equalsIgnoreCase("HIS")) {
                                r_type = "HIS";
                            }
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector();
                            continue block3;
                        }
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block33;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block33;
                            }
                            if (!str.equals("ATOM") && !keywords.equals("HETATM")) {
                                if (r_type.length() != 3) continue block3;
                                if (r_type.equalsIgnoreCase("HID") || r_type.equalsIgnoreCase("HIS")) {
                                    r_type = "HIS";
                                }
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector();
                                continue block3;
                            }
                        }
                        noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                        while (noTmp == residueNo) {
                            a1_type = ss.substring(12, 16).trim();
                            r_type = ss.substring(17, 20).trim();
                            residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                            x_in = new Double(ss.substring(30, 38).trim());
                            y_in = new Double(ss.substring(38, 46).trim());
                            z_in = new Double(ss.substring(46, 54).trim());
                            atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                            ss = in.readLine();
                            if (ss == null) break block33;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block33;
                            }
                            if (!str.equals("ATOM") && !keywords.equals("HETATM")) {
                                if (r_type.length() != 3) continue block3;
                                if (r_type.equalsIgnoreCase("HID") || r_type.equalsIgnoreCase("HIS")) {
                                    r_type = "HIS";
                                }
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector();
                                continue block3;
                            }
                            form = ss.substring(16, 17).trim();
                            if (form.equals("B")) {
                                ss = in.readLine();
                                if (ss == null) break block33;
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
                                while (str.equals("ANISOU")) {
                                    ss = in.readLine();
                                    if (ss != null) {
                                        if (ss.length() <= 54) continue block3;
                                        str = ss.substring(0, 6).trim();
                                        continue;
                                    }
                                    break block33;
                                }
                                if (!str.equals("ATOM") && !keywords.equals("HETATM")) {
                                    if (r_type.length() != 3) continue block3;
                                    if (r_type.equalsIgnoreCase("HID") || r_type.equalsIgnoreCase("HIS")) {
                                        r_type = "HIS";
                                    }
                                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                    atoms = new Vector();
                                    continue block3;
                                }
                            }
                            noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                        }
                        if (r_type.length() == 3) {
                            if (r_type.equalsIgnoreCase("HID") || r_type.equalsIgnoreCase("HIS")) {
                                r_type = "HIS";
                            }
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector();
                        }
                        keywords = str;
                    }
                    ss = in.readLine();
                    if (ss == null) break;
                }
                if (r_type.equalsIgnoreCase("HID") || r_type.equalsIgnoreCase("HIS")) {
                    r_type = "HIS";
                }
                pdbVec.add(new Pdb(residueNo, r_type, atoms));
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + pdbFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(pdbVec, new PdbComparator());
        return pdbVec;
    }

    public void doCalNOEScores(String src, String strOut, String strInput) throws JampackException {
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        long startTime = System.currentTimeMillis();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strSeq = "";
        String strLocationEnsem = "";
        String strEnsemName = "";
        String strNOETable = "";
        String strNoeFormat = "";
        String strDelimitedTmp = "";
        boolean maxEnsemID = false;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("LOCATIONENSEMBLE")) {
                strLocationEnsem = paraMap.get("LOCATIONENSEMBLE");
            }
            if (paraMap.containsKey("NOEFORMAT")) {
                strNoeFormat = paraMap.get("NOEFORMAT");
            }
            if (paraMap.containsKey("NOE-TABLE")) {
                strNOETable = paraMap.get("NOE-TABLE");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String manualAsgFile = String.valueOf(src) + strNOETable;
        Noe noe_temp = new Noe();
        Vector vecManAsg = new Vector();
        Vector vecManAsgNew = new Vector();
        if (strNoeFormat.equalsIgnoreCase("CYANA")) {
            vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
            vecManAsgNew.addAll(vecManAsg);
        } else {
            vecManAsg = noe_temp.noeReader(manualAsgFile, 0.0);
            vecManAsgNew.addAll(vecManAsg);
        }
        vecManAsg = new Vector();
        vecManAsg.addAll(vecManAsgNew);
        Vector<Object> vecPdb = new Vector();
        String userDir = System.getProperty("user.dir");
        String strInputFile = String.valueOf(userDir) + strLocationEnsem;
        File myDir = new File(strInputFile);
        String[] contents = myDir.list();
        if (contents == null) {
            System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
        }
        String strNoeScore = "";
        int t = 0;
        while (t < contents.length) {
            String filename = contents[t];
            vecPdb = new Vector();
            String strEnsemPdb = "";
            strEnsemPdb = String.valueOf(strInputFile) + filename;
            vecPdb = pp.readPdb(strEnsemPdb);
            double[] noeRmsd = new double[2];
            double[] noeHarmScore = new double[2];
            int[] numConflicts = new int[2];
            double[] vdw_sc = new double[1];
            double[] noe_sc = new double[1];
            noe_temp.noeSatisfiedScoreFF2(vecManAsg, vecPdb, noeRmsd, noeHarmScore, numConflicts);
            System.out.println("the noe score of " + filename + " th pdb is: " + noeHarmScore[0]);
            strNoeScore = String.valueOf(strNoeScore) + " , " + noeHarmScore[0];
            ++t;
        }
        System.out.println("============================");
        System.out.println("Here is the NOE score : " + strNoeScore);
        System.out.println("============================");
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for computing NOE scores is:  " + totalTime + " minutes");
    }

    public static void main1(String[] argv) {
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/xplor/";
        boolean counter = false;
        Vector vecPdb = new Vector();
        Vector<vdw> vecVdw = new Vector<vdw>();
        vdw vv = new vdw();
        String strVdw = "";
        String strNoeRmsd = "";
        System.out.println("vdw=: ");
        int j = 0;
        while (j <= 441) {
            if (j != 18 && j != 235 && j != 351 && j != 387) {
                String strEnsemPdb = String.valueOf(src) + "ff2_complete_" + j + ".pdb";
                Vector vecEnsemble = new Vector();
                double[] vdw_sc = new double[1];
                double[] noe_sc = new double[1];
                vecEnsemble = pp.readPdbAndParaXplor(strEnsemPdb, vdw_sc, noe_sc);
                strVdw = String.valueOf(strVdw) + " , " + vdw_sc[0];
                strNoeRmsd = String.valueOf(strNoeRmsd) + " , " + noe_sc[0];
                if (vdw_sc[0] < 1283.0 && noe_sc[0] < 5753.0) {
                    System.out.println("found one id: " + j);
                }
                vecVdw.add(new vdw(vecPdb, vdw_sc[0], noe_sc[0], j));
            }
            ++j;
        }
        System.out.println("here is the strVdw :" + strVdw);
        System.out.println("============================");
        System.out.println("here is the NOE rmsd :" + strNoeRmsd);
        System.out.println("============================");
        Collections.sort(vecVdw, new vdw.VdwComparator());
        int i = 0;
        while (i < 50) {
            vdw vdw_temp = (vdw)vecVdw.elementAt(i);
            double modID = vdw_temp.getModelID();
            System.out.println("the i-th " + i + ": vdw is: " + modID);
            ++i;
        }
        System.out.println("============================");
        Vector<vdw> vecVdwNoe = new Vector<vdw>();
        vecVdwNoe.addAll(vecVdw);
        Collections.sort(vecVdwNoe, new vdw.VdwNoeComparator());
        int i2 = 0;
        while (i2 < 50) {
            vdw vdw_temp = (vdw)vecVdwNoe.elementAt(i2);
            double modID = vdw_temp.getModelID();
            System.out.println("the i-th " + i2 + ": noe is: " + modID);
            ++i2;
        }
    }

    public static void main00(String[] argv) {
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/xplor/";
        boolean counter = false;
        Vector<Object> vecPdb = new Vector();
        Vector vecVdw = new Vector();
        vdw vv = new vdw();
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        String strVdw = "";
        String strNoeRmsd = "";
        System.out.println("vdw=: ");
        String manualAsgFile = String.valueOf(userDir) + "/inputFiles/ff2_noe_xplor.tbl";
        Assign asg = new Assign();
        String seqFile = String.valueOf(userDir) + "/inputFiles/ff2.seq";
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        Noe noe_temp = new Noe();
        Vector vecManAsg = noe_temp.noeReader2(manualAsgFile, 0.0);
        Vector vecManAsgNew = noe_temp.ConvertXplorAsgToUplFormatFF2(vecManAsg, vecSeq);
        vecManAsg = new Vector();
        vecManAsg.addAll(vecManAsgNew);
        int j = 0;
        while (j <= 441) {
            if (j != 18 && j != 235 && j != 351 && j != 387) {
                double[] noeRmsd = new double[2];
                double[] noeHarmScore = new double[2];
                int[] numConflicts = new int[2];
                vecPdb = new Vector();
                String strEnsemPdb = String.valueOf(src) + "ff2_complete_" + j + ".pdb";
                Vector vecEnsemble = new Vector();
                double[] vdw_sc = new double[1];
                double[] noe_sc = new double[1];
                vecPdb = pp.readPdb(strEnsemPdb);
                noe_temp.noeSatisfiedScoreFF2(vecManAsg, vecPdb, noeRmsd, noeHarmScore, numConflicts);
                if (noeHarmScore[0] < 10.0) {
                    System.out.println("the noe score of " + j + " th pdb is: " + noeHarmScore[0]);
                }
                strNoeRmsd = String.valueOf(strNoeRmsd) + " , " + noeHarmScore[0];
                vdwVec = new Vector();
                vdwVec = vander.convert2VDW(vecPdb);
            }
            ++j;
        }
        System.out.println("here is the strVdw :" + strVdw);
        System.out.println("============================");
        System.out.println("here is the NOE rmsd :" + strNoeRmsd);
        System.out.println("============================");
        Collections.sort(vecVdw, new vdw.VdwComparator());
        int i = 0;
        while (i < 50) {
            vdw vdw_temp = (vdw)vecVdw.elementAt(i);
            double modID = vdw_temp.getModelID();
            System.out.println("the i-th " + i + ": vdw is: " + modID);
            ++i;
        }
        System.out.println("============================");
        Vector vecVdwNoe = new Vector();
        vecVdwNoe.addAll(vecVdw);
        Collections.sort(vecVdwNoe, new vdw.VdwNoeComparator());
        int i2 = 0;
        while (i2 < 50) {
            vdw vdw_temp = (vdw)vecVdwNoe.elementAt(i2);
            double modID = vdw_temp.getModelID();
            System.out.println("the i-th " + i2 + ": noe is: " + modID);
            ++i2;
        }
    }

    public static void main(String[] argv) {
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/test/";
        String srcOut = String.valueOf(userDir) + "/inputFiles/";
        boolean counter = false;
        Vector vecPdb = new Vector();
        Vector vecVdw = new Vector();
        String strLoops = String.valueOf(src) + "2E71-One-New.pdb";
        Vector<Object> vecLoops = new Vector();
        vecLoops = pp.readPdb(strLoops);
        Vector vecTempNew = new Vector();
        Vector<Vector> vecPdbAll = new Vector<Vector>();
        int j = 1;
        while (j <= 1) {
            String strEnsemPdb = String.valueOf(src) + "average.pdb";
            Vector vecEnsemble = pp.readPdbFromEnsemble(strEnsemPdb);
            System.out.println("input: " + strEnsemPdb);
            int t = 0;
            while (t < vecEnsemble.size()) {
                Vector vecPdbTemp = (Vector)vecEnsemble.elementAt(t);
                Vector<Pdb> vecPdbTempNew = pp.nameConvertOrder(vecPdbTemp);
                Vector vecNewPdb = pp.nameConvert4SmallRotLibStr(vecPdbTempNew);
                vecPdbAll.add(vecNewPdb);
                ++t;
            }
            ++j;
        }
        String fileName = String.valueOf(srcOut) + "ff2_all_templates" + ".pdb";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int k = 0;
            while (k < vecPdbAll.size()) {
                out.println("REMARK model " + (k + 1));
                Vector vecOne = (Vector)vecPdbAll.elementAt(k);
                pp.printToFile(vecOne, fileName, out);
                out.println("TER");
                ++k;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Vector readPdbAndNoeRmsdFromEnsemble(String pdbFile) {
        block32: {
            ss = "";
            str = "";
            r_type = "";
            pdbID = "";
            gap = "";
            residueNo = 0;
            noTmp = 0;
            vecEnsemble = new Vector<vdw>();
            pdbVec = new Vector<Pdb>();
            atoms = new Vector<Cartesian>();
            form = "";
            allRmsd = 0.0;
            nhRmsd = 0.0;
            chRmsd = 0.0;
            ensembleID = 0;
            modelID = 0;
            noeRmsd = 0.0;
            st = new StringTokenizer("");
            try {
                in = new BufferedReader(new FileReader(pdbFile));
                ss = in.readLine();
                if (ss.length() > 66) {
                    pdbID = ss.substring(62, 66).trim();
                }
                block3: while (true) {
                    if (ss.length() > 5) {
                        keywords = ss.substring(0, 6).trim();
                        gap = ss.substring(0, 5).trim();
                        if (gap.equalsIgnoreCase("MODEL")) {
                            if (pdbVec.size() > 0) {
                                vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                            }
                            pdbVec = new Vector<E>();
                        }
                    } else {
                        keywords = ss.trim();
                        gap = ss.trim();
                    }
                    while (keywords.equals("ATOM")) {
                        if (ss.length() <= 54) continue;
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block32;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block32;
                            }
                            if (!str.equals("ATOM")) {
                                if (r_type.length() != 3) continue block3;
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                                continue block3;
                            }
                        }
                        a1_type = ss.substring(12, 16).trim();
                        r_type = ss.substring(17, 20).trim();
                        residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                        x_in = new Double(ss.substring(30, 38).trim());
                        y_in = new Double(ss.substring(38, 46).trim());
                        z_in = new Double(ss.substring(46, 54).trim());
                        atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                        ss = in.readLine();
                        if (ss == null) break block32;
                        if (ss.length() <= 54) continue block3;
                        str = ss.substring(0, 6).trim();
                        while (str.equals("ANISOU")) {
                            ss = in.readLine();
                            if (ss != null) {
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
                                continue;
                            }
                            break block32;
                        }
                        if (!str.equals("ATOM")) {
                            if (r_type.length() != 3) continue block3;
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block3;
                        }
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block32;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block32;
                            }
                            if (!str.equals("ATOM")) {
                                if (r_type.length() != 3) continue block3;
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                                continue block3;
                            }
                        }
                        noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                        block8: while (noTmp == residueNo) {
                            block33: {
                                a1_type = ss.substring(12, 16).trim();
                                r_type = ss.substring(17, 20).trim();
                                residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                                x_in = new Double(ss.substring(30, 38).trim());
                                y_in = new Double(ss.substring(38, 46).trim());
                                z_in = new Double(ss.substring(46, 54).trim());
                                atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                                ss = in.readLine();
                                if (ss == null) break block32;
                                if (ss.length() <= 54) break block33;
                                str = ss.substring(0, 6).trim();
                                ** GOTO lbl124
                            }
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block3;
                            while ((ss = in.readLine()) != null) {
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
lbl124:
                                // 2 sources

                                if (str.equals("ANISOU")) continue;
                                if (!str.equals("ATOM")) {
                                    if (r_type.length() != 3) continue block3;
                                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                    atoms = new Vector<E>();
                                    continue block3;
                                }
                                form = ss.substring(16, 17).trim();
                                if (form.equals("B")) {
                                    ss = in.readLine();
                                    if (ss == null) break block32;
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    while (str.equals("ANISOU")) {
                                        ss = in.readLine();
                                        if (ss != null) {
                                            if (ss.length() <= 54) continue block3;
                                            str = ss.substring(0, 6).trim();
                                            continue;
                                        }
                                        break block32;
                                    }
                                    if (!str.equals("ATOM")) {
                                        if (r_type.length() != 3) continue block3;
                                        pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                        atoms = new Vector<E>();
                                        continue block3;
                                    }
                                }
                                noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                                continue block8;
                            }
                            break block32;
                        }
                        if (r_type.length() == 3) {
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                        }
                        keywords = str;
                        if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                        if (pdbVec.size() > 0) {
                            vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                        }
                        pdbVec = new Vector<E>();
                    }
                    ss = in.readLine();
                    if (ss == null) {
                        vecEnsemble.add(new vdw(pdbVec, 0.0, noeRmsd));
                        break;
                    }
                    if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                    if (pdbVec.size() > 0) {
                        vecEnsemble.add(new vdw(pdbVec, 0.0, noeRmsd));
                    }
                    pdbVec = new Vector<E>();
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + pdbFile);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        }
        Collections.sort(pdbVec, new PdbComparator());
        return vecEnsemble;
    }

    /*
     * Unable to fully structure code
     */
    public Vector readPdbAndNoeHarmFromEnsemble(String pdbFile) {
        block29: {
            ss = "";
            str = "";
            r_type = "";
            pdbID = "";
            gap = "";
            residueNo = 0;
            noTmp = 0;
            vecEnsemble = new Vector<vdw>();
            pdbVec = new Vector<Pdb>();
            atoms = new Vector<Cartesian>();
            form = "";
            allRmsd = 0.0;
            nhRmsd = 0.0;
            chRmsd = 0.0;
            ensembleID = 0;
            modelID = 0;
            noeRmsd = 0.0;
            st = new StringTokenizer("");
            in = new BufferedReader(new FileReader(pdbFile));
            ss = in.readLine();
            if (ss != null) break block29;
            return null;
        }
        try {
            if (ss.length() > 66) {
                pdbID = ss.substring(62, 66).trim();
            }
            block4: while (true) {
                if (ss.length() > 5) {
                    keywords = ss.substring(0, 6).trim();
                    gap = ss.substring(0, 5).trim();
                    if (gap.equalsIgnoreCase("MODEL")) {
                        if (pdbVec.size() > 0) {
                            vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                        }
                        pdbVec = new Vector<E>();
                    }
                } else {
                    keywords = ss.trim();
                    gap = ss.trim();
                }
                while (keywords.equals("ATOM")) {
                    if (ss.length() <= 54) continue;
                    form = ss.substring(16, 17).trim();
                    if (form.equals("B")) {
                        ss = in.readLine();
                        if (ss == null) break block4;
                        if (ss.length() <= 54) continue block4;
                        str = ss.substring(0, 6).trim();
                        while (str.equals("ANISOU")) {
                            ss = in.readLine();
                            if (ss == null) break block4;
                            if (ss.length() <= 54) continue block4;
                            str = ss.substring(0, 6).trim();
                        }
                        if (!str.equals("ATOM")) {
                            if (r_type.length() != 3) continue block4;
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block4;
                        }
                    }
                    a1_type = ss.substring(12, 16).trim();
                    r_type = ss.substring(17, 20).trim();
                    residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                    x_in = new Double(ss.substring(30, 38).trim());
                    y_in = new Double(ss.substring(38, 46).trim());
                    z_in = new Double(ss.substring(46, 54).trim());
                    atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                    ss = in.readLine();
                    if (ss == null) break block4;
                    if (ss.length() <= 54) continue block4;
                    str = ss.substring(0, 6).trim();
                    while (str.equals("ANISOU")) {
                        ss = in.readLine();
                        if (ss == null) break block4;
                        if (ss.length() <= 54) continue block4;
                        str = ss.substring(0, 6).trim();
                    }
                    if (!str.equals("ATOM")) {
                        if (r_type.length() != 3) continue block4;
                        pdbVec.add(new Pdb(residueNo, r_type, atoms));
                        atoms = new Vector<E>();
                        continue block4;
                    }
                    form = ss.substring(16, 17).trim();
                    if (form.equals("B")) {
                        ss = in.readLine();
                        if (ss == null) break block4;
                        if (ss.length() <= 54) continue block4;
                        str = ss.substring(0, 6).trim();
                        while (str.equals("ANISOU")) {
                            ss = in.readLine();
                            if (ss == null) break block4;
                            if (ss.length() <= 54) continue block4;
                            str = ss.substring(0, 6).trim();
                        }
                        if (!str.equals("ATOM")) {
                            if (r_type.length() != 3) continue block4;
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block4;
                        }
                    }
                    noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                    block9: while (noTmp == residueNo) {
                        block31: {
                            a1_type = ss.substring(12, 16).trim();
                            r_type = ss.substring(17, 20).trim();
                            residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                            x_in = new Double(ss.substring(30, 38).trim());
                            y_in = new Double(ss.substring(38, 46).trim());
                            z_in = new Double(ss.substring(46, 54).trim());
                            atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                            ss = in.readLine();
                            if (ss == null) break block4;
                            if (ss.length() <= 54) break block31;
                            str = ss.substring(0, 6).trim();
                            ** GOTO lbl125
                        }
                        pdbVec.add(new Pdb(residueNo, r_type, atoms));
                        atoms = new Vector<E>();
                        continue block4;
                        while ((ss = in.readLine()) != null) {
                            if (ss.length() <= 54) continue block4;
                            str = ss.substring(0, 6).trim();
lbl125:
                            // 2 sources

                            if (str.equals("ANISOU")) continue;
                            if (!str.equals("ATOM")) {
                                if (r_type.length() != 3) continue block4;
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                                continue block4;
                            }
                            form = ss.substring(16, 17).trim();
                            if (form.equals("B")) {
                                ss = in.readLine();
                                if (ss == null) break block4;
                                if (ss.length() <= 54) continue block4;
                                str = ss.substring(0, 6).trim();
                                while (str.equals("ANISOU")) {
                                    ss = in.readLine();
                                    if (ss == null) break block4;
                                    if (ss.length() <= 54) continue block4;
                                    str = ss.substring(0, 6).trim();
                                }
                                if (!str.equals("ATOM")) {
                                    if (r_type.length() != 3) continue block4;
                                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                    atoms = new Vector<E>();
                                    continue block4;
                                }
                            }
                            noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                            continue block9;
                        }
                        break block4;
                    }
                    if (r_type.length() == 3) {
                        pdbVec.add(new Pdb(residueNo, r_type, atoms));
                        atoms = new Vector<E>();
                    }
                    keywords = str;
                    if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                    if (pdbVec.size() > 0) {
                        vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                    }
                    pdbVec = new Vector<E>();
                }
                ss = in.readLine();
                if (ss == null) {
                    vecEnsemble.add(new vdw(pdbVec, 0.0, noeRmsd));
                    break;
                }
                if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                if (pdbVec.size() > 0) {
                    vecEnsemble.add(new vdw(pdbVec, 0.0, noeRmsd));
                }
                pdbVec = new Vector<E>();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + pdbFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(pdbVec, new PdbComparator());
        return vecEnsemble;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector readPdbAndParaXplor(String pdbFile, double[] vdwSc, double[] noeSc) {
        block24: {
            ss = "";
            str = "";
            r_type = "";
            pdbID = "";
            gap = "";
            residueNo = 0;
            noTmp = 0;
            vecEnsemble = new Vector<vdw>();
            pdbVec = new Vector<Pdb>();
            atoms = new Vector<Cartesian>();
            form = "";
            allRmsd = 0.0;
            nhRmsd = 0.0;
            chRmsd = 0.0;
            ensembleID = 0;
            modelID = 0;
            noeRmsd = 0.0;
            st = new StringTokenizer("");
            try {
                in = new BufferedReader(new FileReader(pdbFile));
                ss = in.readLine();
                if (ss.length() > 66) {
                    pdbID = ss.substring(62, 66).trim();
                }
lbl24:
                // 18 sources

                block3: while (true) {
                    if (ss.length() > 5) {
                        keywords = ss.substring(0, 6).trim();
                        gap = ss.substring(0, 6).trim();
                        if (gap.equalsIgnoreCase("REMARK")) {
                            if (pdbVec.size() > 0) {
                                vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                            }
                            pdbVec = new Vector<E>();
                            ss = in.readLine();
                            ss = in.readLine();
                            ss = in.readLine();
                            ss = in.readLine();
                            vdwSc[0] = Double.parseDouble(ss.substring(19, ss.length()).trim());
                            ss = in.readLine();
                            ss = in.readLine();
                            noeSc[0] = Double.parseDouble(ss.substring(24, ss.length()).trim());
                            return null;
                        }
                    } else {
                        keywords = ss.trim();
                        gap = ss.trim();
                    }
lbl45:
                    // 4 sources

                    while (true) {
                        block26: {
                            block25: {
                                if (keywords.equals("ATOM")) break block25;
                                ss = in.readLine();
                                if (ss == null) {
                                    vecEnsemble.add(new vdw(pdbVec, 0.0, noeRmsd));
                                    break block24;
                                }
                                break block26;
                            }
                            if (ss.length() <= 54) continue;
                            form = ss.substring(16, 17).trim();
                            if (!form.equals("B")) ** GOTO lbl88
                            ss = in.readLine();
                            if (ss == null) break block24;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            ** GOTO lbl81
                        }
                        if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue block3;
                        if (pdbVec.size() > 0) {
                            vecEnsemble.add(new vdw(pdbVec, 0.0, noeRmsd));
                        }
                        pdbVec = new Vector<E>();
                        ss = in.readLine();
                        noeRmsd = Double.parseDouble(ss.substring(21, ss.length()).trim());
                        continue block3;
                        break;
                    }
                    break;
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + pdbFile);
                break block24;
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
                break block24;
            }
            block5: while ((ss = in.readLine()) != null) {
                block29: {
                    block28: {
                        block27: {
                            if (ss.length() <= 54) ** GOTO lbl24
                            str = ss.substring(0, 6).trim();
lbl81:
                            // 2 sources

                            if (str.equals("ANISOU")) continue;
                            if (str.equals("ATOM")) break block27;
                            if (r_type.length() == 3) {
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                            }
                            ** GOTO lbl24
                        }
                        a1_type = ss.substring(12, 16).trim();
                        r_type = ss.substring(17, 20).trim();
                        residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                        x_in = new Double(ss.substring(30, 38).trim());
                        y_in = new Double(ss.substring(38, 46).trim());
                        z_in = new Double(ss.substring(46, 54).trim());
                        atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                        ss = in.readLine();
                        if (ss == null) break;
                        if (ss.length() <= 54) ** GOTO lbl24
                        str = ss.substring(0, 6).trim();
                        while (str.equals("ANISOU")) {
                            ss = in.readLine();
                            if (ss == null) break block5;
                            if (ss.length() <= 54) ** GOTO lbl24
                            str = ss.substring(0, 6).trim();
                        }
                        if (str.equals("ATOM")) break block28;
                        if (r_type.length() == 3) {
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                        }
                        ** GOTO lbl24
                    }
                    form = ss.substring(16, 17).trim();
                    if (!form.equals("B")) break block29;
                    ss = in.readLine();
                    if (ss == null) break;
                    if (ss.length() <= 54) ** GOTO lbl24
                    str = ss.substring(0, 6).trim();
                    while (str.equals("ANISOU")) {
                        ss = in.readLine();
                        if (ss == null) break block5;
                        if (ss.length() <= 54) ** GOTO lbl24
                        str = ss.substring(0, 6).trim();
                    }
                    if (str.equals("ATOM")) break block29;
                    if (r_type.length() == 3) {
                        pdbVec.add(new Pdb(residueNo, r_type, atoms));
                        atoms = new Vector<E>();
                    }
                    ** GOTO lbl24
                }
                noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                block8: while (noTmp == residueNo) {
                    block30: {
                        a1_type = ss.substring(12, 16).trim();
                        r_type = ss.substring(17, 20).trim();
                        residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                        x_in = new Double(ss.substring(30, 38).trim());
                        y_in = new Double(ss.substring(38, 46).trim());
                        z_in = new Double(ss.substring(46, 54).trim());
                        atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                        ss = in.readLine();
                        if (ss == null) break block5;
                        if (ss.length() <= 54) break block30;
                        str = ss.substring(0, 6).trim();
                        ** GOTO lbl156
                    }
                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                    atoms = new Vector<E>();
                    ** GOTO lbl24
                    while ((ss = in.readLine()) != null) {
                        block32: {
                            block31: {
                                if (ss.length() <= 54) ** GOTO lbl24
                                str = ss.substring(0, 6).trim();
lbl156:
                                // 2 sources

                                if (str.equals("ANISOU")) continue;
                                if (str.equals("ATOM")) break block31;
                                if (r_type.length() == 3) {
                                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                    atoms = new Vector<E>();
                                }
                                ** GOTO lbl24
                            }
                            form = ss.substring(16, 17).trim();
                            if (!form.equals("B")) break block32;
                            ss = in.readLine();
                            if (ss == null) break block5;
                            if (ss.length() <= 54) ** GOTO lbl24
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss == null) break block5;
                                if (ss.length() <= 54) ** GOTO lbl24
                                str = ss.substring(0, 6).trim();
                            }
                            if (str.equals("ATOM")) break block32;
                            if (r_type.length() != 3) ** GOTO lbl24
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            ** continue;
                        }
                        noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                        continue block8;
                    }
                    break block5;
                }
                if (r_type.length() == 3) {
                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                    atoms = new Vector<E>();
                }
                keywords = str;
                if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) ** GOTO lbl45
                if (pdbVec.size() > 0) {
                    vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                }
                pdbVec = new Vector<E>();
                ss = in.readLine();
                noeRmsd = Double.parseDouble(ss.substring(21, ss.length()).trim());
                ** continue;
lbl199:
                // 1 sources

                ** GOTO lbl45
            }
        }
        Collections.sort(pdbVec, new PdbComparator());
        return vecEnsemble;
    }

    public void readPdbEnergy(String pdbFile, double[] scEnerg, int rowPos, int colPos) {
        String ss = "";
        String str = "";
        String r_type = "";
        String pdbID = "";
        String gap = "";
        boolean residueNo = false;
        boolean noTmp = false;
        double allRmsd = 0.0;
        double nhRmsd = 0.0;
        double chRmsd = 0.0;
        boolean ensembleID = false;
        boolean modelID = false;
        double noeRmsd = 0.0;
        StringTokenizer st = new StringTokenizer("");
        try {
            BufferedReader in = new BufferedReader(new FileReader(pdbFile));
            ss = in.readLine();
            if (ss.length() > 66) {
                pdbID = ss.substring(62, 66).trim();
            }
            while (true) {
                if (ss.length() <= 5) {
                    continue;
                }
                String keywords = ss.substring(0, 6).trim();
                gap = ss.substring(0, 6).trim();
                if (gap.equalsIgnoreCase("REMARK")) break;
            }
            if (rowPos == 0) {
                scEnerg[0] = Double.parseDouble(ss.substring(colPos, ss.length()).trim());
                return;
            }
            int t = 0;
            while (t < rowPos) {
                ss = in.readLine();
                ++t;
            }
            int idLimit = 0;
            idLimit = ss.indexOf(46) > ss.indexOf(44) && ss.indexOf(44) != -1 ? ss.indexOf(44) : ss.indexOf(46) + 2;
            String strTemp = ss.substring(colPos, idLimit).trim();
            scEnerg[0] = Double.parseDouble(strTemp);
            return;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + pdbFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Vector readPdbAndParametersFromEnsemble(String pdbFile) {
        block32: {
            ss = "";
            str = "";
            r_type = "";
            pdbID = "";
            gap = "";
            residueNo = 0;
            noTmp = 0;
            vecEnsemble = new Vector<vdw>();
            pdbVec = new Vector<Pdb>();
            atoms = new Vector<Cartesian>();
            form = "";
            allRmsd = 0.0;
            nhRmsd = 0.0;
            chRmsd = 0.0;
            ensembleID = 0;
            modelID = 0;
            noeRmsd = 0.0;
            st = new StringTokenizer("");
            try {
                in = new BufferedReader(new FileReader(pdbFile));
                ss = in.readLine();
                if (ss.length() > 66) {
                    pdbID = ss.substring(62, 66).trim();
                }
                block3: while (true) {
                    if (ss.length() > 5) {
                        keywords = ss.substring(0, 6).trim();
                        gap = ss.substring(0, 5).trim();
                        if (gap.equalsIgnoreCase("MODEL")) {
                            if (pdbVec.size() > 0) {
                                vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                            }
                            pdbVec = new Vector<E>();
                            ss = in.readLine();
                            allRmsd = Double.parseDouble(ss.substring(23, ss.length()).trim());
                            ss = in.readLine();
                            noeRmsd = Double.parseDouble(ss.substring(21, ss.length()).trim());
                        }
                    } else {
                        keywords = ss.trim();
                        gap = ss.trim();
                    }
                    while (keywords.equals("ATOM")) {
                        if (ss.length() <= 54) continue;
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block32;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block32;
                            }
                            if (!str.equals("ATOM")) {
                                if (r_type.length() != 3) continue block3;
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                                continue block3;
                            }
                        }
                        a1_type = ss.substring(12, 16).trim();
                        r_type = ss.substring(17, 20).trim();
                        residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                        x_in = new Double(ss.substring(30, 38).trim());
                        y_in = new Double(ss.substring(38, 46).trim());
                        z_in = new Double(ss.substring(46, 54).trim());
                        atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                        ss = in.readLine();
                        if (ss == null) break block32;
                        if (ss.length() <= 54) continue block3;
                        str = ss.substring(0, 6).trim();
                        while (str.equals("ANISOU")) {
                            ss = in.readLine();
                            if (ss != null) {
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
                                continue;
                            }
                            break block32;
                        }
                        if (!str.equals("ATOM")) {
                            if (r_type.length() != 3) continue block3;
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block3;
                        }
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block32;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block32;
                            }
                            if (!str.equals("ATOM")) {
                                if (r_type.length() != 3) continue block3;
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                                continue block3;
                            }
                        }
                        noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                        block8: while (noTmp == residueNo) {
                            block33: {
                                a1_type = ss.substring(12, 16).trim();
                                r_type = ss.substring(17, 20).trim();
                                residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                                x_in = new Double(ss.substring(30, 38).trim());
                                y_in = new Double(ss.substring(38, 46).trim());
                                z_in = new Double(ss.substring(46, 54).trim());
                                atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                                ss = in.readLine();
                                if (ss == null) break block32;
                                if (ss.length() <= 54) break block33;
                                str = ss.substring(0, 6).trim();
                                ** GOTO lbl128
                            }
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block3;
                            while ((ss = in.readLine()) != null) {
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
lbl128:
                                // 2 sources

                                if (str.equals("ANISOU")) continue;
                                if (!str.equals("ATOM")) {
                                    if (r_type.length() != 3) continue block3;
                                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                    atoms = new Vector<E>();
                                    continue block3;
                                }
                                form = ss.substring(16, 17).trim();
                                if (form.equals("B")) {
                                    ss = in.readLine();
                                    if (ss == null) break block32;
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    while (str.equals("ANISOU")) {
                                        ss = in.readLine();
                                        if (ss != null) {
                                            if (ss.length() <= 54) continue block3;
                                            str = ss.substring(0, 6).trim();
                                            continue;
                                        }
                                        break block32;
                                    }
                                    if (!str.equals("ATOM")) {
                                        if (r_type.length() != 3) continue block3;
                                        pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                        atoms = new Vector<E>();
                                        continue block3;
                                    }
                                }
                                noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                                continue block8;
                            }
                            break block32;
                        }
                        if (r_type.length() == 3) {
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                        }
                        keywords = str;
                        if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                        if (pdbVec.size() > 0) {
                            vecEnsemble.add(new vdw(pdbVec, allRmsd, nhRmsd, chRmsd, ensembleID, modelID));
                        }
                        pdbVec = new Vector<E>();
                        ss = in.readLine();
                        allRmsd = Double.parseDouble(ss.substring(23, ss.length()).trim());
                        ss = in.readLine();
                        noeRmsd = Double.parseDouble(ss.substring(21, ss.length()).trim());
                    }
                    ss = in.readLine();
                    if (ss == null) {
                        vecEnsemble.add(new vdw(pdbVec, allRmsd, noeRmsd));
                        break;
                    }
                    if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                    if (pdbVec.size() > 0) {
                        vecEnsemble.add(new vdw(pdbVec, allRmsd, noeRmsd));
                    }
                    pdbVec = new Vector<E>();
                    ss = in.readLine();
                    allRmsd = Double.parseDouble(ss.substring(23, ss.length()).trim());
                    ss = in.readLine();
                    noeRmsd = Double.parseDouble(ss.substring(21, ss.length()).trim());
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + pdbFile);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        }
        Collections.sort(pdbVec, new PdbComparator());
        return vecEnsemble;
    }

    /*
     * Unable to fully structure code
     */
    public Vector readPdbFromEnsemble(String pdbFile) {
        block30: {
            ss = "";
            str = "";
            r_type = "";
            pdbID = "";
            gap = "";
            residueNo = 0;
            noTmp = 0;
            vecEnsemble = new Vector<Vector<E>>();
            pdbVec = new Vector<Pdb>();
            atoms = new Vector<Cartesian>();
            form = "";
            try {
                in = new BufferedReader(new FileReader(pdbFile));
                ss = in.readLine();
                if (ss.length() > 66) {
                    pdbID = ss.substring(62, 66).trim();
                }
                block3: while (true) {
                    if (ss.length() > 5) {
                        keywords = ss.substring(0, 6).trim();
                        gap = ss.substring(0, 5).trim();
                    } else {
                        keywords = ss.trim();
                        gap = ss.trim();
                    }
                    while (keywords.equals("ATOM")) {
                        if (ss.length() <= 54) continue;
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block30;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block30;
                            }
                            if (!str.equals("ATOM")) {
                                if (r_type.length() != 3) continue block3;
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                                continue block3;
                            }
                        }
                        a1_type = ss.substring(12, 16).trim();
                        r_type = ss.substring(17, 20).trim();
                        residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                        x_in = new Double(ss.substring(30, 38).trim());
                        y_in = new Double(ss.substring(38, 46).trim());
                        z_in = new Double(ss.substring(46, 54).trim());
                        atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                        ss = in.readLine();
                        if (ss == null) break block30;
                        if (ss.length() <= 54) continue block3;
                        str = ss.substring(0, 6).trim();
                        while (str.equals("ANISOU")) {
                            ss = in.readLine();
                            if (ss != null) {
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
                                continue;
                            }
                            break block30;
                        }
                        if (!str.equals("ATOM")) {
                            if (r_type.length() != 3) continue block3;
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block3;
                        }
                        form = ss.substring(16, 17).trim();
                        if (form.equals("B")) {
                            ss = in.readLine();
                            if (ss == null) break block30;
                            if (ss.length() <= 54) continue block3;
                            str = ss.substring(0, 6).trim();
                            while (str.equals("ANISOU")) {
                                ss = in.readLine();
                                if (ss != null) {
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    continue;
                                }
                                break block30;
                            }
                            if (!str.equals("ATOM")) {
                                if (r_type.length() != 3) continue block3;
                                pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                atoms = new Vector<E>();
                                continue block3;
                            }
                        }
                        noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                        block8: while (noTmp == residueNo) {
                            block31: {
                                a1_type = ss.substring(12, 16).trim();
                                r_type = ss.substring(17, 20).trim();
                                residueNo = Integer.parseInt(ss.substring(23, 26).trim());
                                x_in = new Double(ss.substring(30, 38).trim());
                                y_in = new Double(ss.substring(38, 46).trim());
                                z_in = new Double(ss.substring(46, 54).trim());
                                atoms.add(new Cartesian(a1_type, x_in, y_in, z_in));
                                ss = in.readLine();
                                if (ss == null) break block30;
                                if (ss.length() <= 54) break block31;
                                str = ss.substring(0, 6).trim();
                                ** GOTO lbl112
                            }
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                            continue block3;
                            while ((ss = in.readLine()) != null) {
                                if (ss.length() <= 54) continue block3;
                                str = ss.substring(0, 6).trim();
lbl112:
                                // 2 sources

                                if (str.equals("ANISOU")) continue;
                                if (!str.equals("ATOM")) {
                                    if (r_type.length() != 3) continue block3;
                                    pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                    atoms = new Vector<E>();
                                    continue block3;
                                }
                                form = ss.substring(16, 17).trim();
                                if (form.equals("B")) {
                                    ss = in.readLine();
                                    if (ss == null) break block30;
                                    if (ss.length() <= 54) continue block3;
                                    str = ss.substring(0, 6).trim();
                                    while (str.equals("ANISOU")) {
                                        ss = in.readLine();
                                        if (ss != null) {
                                            if (ss.length() <= 54) continue block3;
                                            str = ss.substring(0, 6).trim();
                                            continue;
                                        }
                                        break block30;
                                    }
                                    if (!str.equals("ATOM")) {
                                        if (r_type.length() != 3) continue block3;
                                        pdbVec.add(new Pdb(residueNo, r_type, atoms));
                                        atoms = new Vector<E>();
                                        continue block3;
                                    }
                                }
                                noTmp = Integer.parseInt(ss.substring(23, 26).trim());
                                continue block8;
                            }
                            break block30;
                        }
                        if (r_type.length() == 3) {
                            pdbVec.add(new Pdb(residueNo, r_type, atoms));
                            atoms = new Vector<E>();
                        }
                        keywords = str;
                        if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                        if (pdbVec.size() > 0) {
                            vecEnsemble.add(pdbVec);
                        }
                        pdbVec = new Vector<E>();
                    }
                    ss = in.readLine();
                    if (ss == null) {
                        vecEnsemble.add(pdbVec);
                        break;
                    }
                    if (ss.length() < 5 || !(gap = ss.substring(0, 5).trim()).equalsIgnoreCase("MODEL")) continue;
                    if (pdbVec.size() > 0) {
                        vecEnsemble.add(pdbVec);
                    }
                    pdbVec = new Vector<E>();
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + pdbFile);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        }
        Collections.sort(pdbVec, new PdbComparator());
        return vecEnsemble;
    }

    public Vector<Pdb> newPdb(Vector<Pdb> pdbVec, Matrix R) {
        Cartesian atom = null;
        String atomName = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            int j = 0;
            while (j < atoms.size()) {
                atom = (Cartesian)atoms.elementAt(j);
                atomName = atom.getAtom();
                coord[0] = atom.getX();
                coord[1] = atom.getY();
                coord[2] = atom.getZ();
                coordN = R.times(coord);
                atomVec.add(new Cartesian(atomName, coordN[0], coordN[1], coordN[2]));
                ++j;
            }
            pdbVecN.add(new Pdb(no, resid, atomVec));
            atomVec = new Vector();
            ++i;
        }
        return pdbVecN;
    }

    public Vector<Pdb> newPdbByTranslation(Vector<Pdb> pdbVec, double[] vT) {
        Cartesian atom = null;
        String atomName = "";
        String resid = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            pp = pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            int j = 0;
            while (j < atoms.size()) {
                atom = (Cartesian)atoms.elementAt(j);
                atomName = atom.getAtom();
                coord[0] = atom.getX();
                coord[1] = atom.getY();
                coord[2] = atom.getZ();
                coordN = new double[]{coord[0] + vT[0], coord[1] + vT[1], coord[2] + vT[2]};
                atomVec.add(new Cartesian(atomName, coordN[0], coordN[1], coordN[2]));
                ++j;
            }
            pdbVecN.add(new Pdb(no, resid, atomVec));
            atomVec = new Vector();
            ++i;
        }
        return pdbVecN;
    }

    public double dihedralAngle(double[] n2CO1, double[] n2CA, double[] ca2CO) {
        double[] nToCO1 = this.dirCos(n2CO1);
        double[] nToCA = this.dirCos(n2CA);
        double[] caToCO = this.dirCos(ca2CO);
        double theta_nToCa = Math.acos(nToCA[2]);
        double phi_nToCa = 0.0;
        double x = nToCA[0];
        double y = nToCA[1];
        phi_nToCa = theta_nToCa != 0.0 ? (x > 0.0 ? Math.atan(y / x) : (x < 0.0 ? Math.atan(y / x) + Math.PI : (y > 0.0 ? 1.5707963267948966 : 4.71238898038469))) : 0.0;
        int m = 3;
        int n = 3;
        double[][] A = new double[3][3];
        A[0][0] = Math.sin(phi_nToCa);
        A[0][1] = -Math.cos(phi_nToCa);
        A[0][2] = 0.0;
        A[1][0] = Math.sin(theta_nToCa) * Math.cos(phi_nToCa);
        A[1][1] = Math.sin(theta_nToCa) * Math.sin(phi_nToCa);
        A[1][2] = Math.cos(theta_nToCa);
        A[2][0] = -Math.cos(theta_nToCa) * Math.cos(phi_nToCa);
        A[2][1] = -Math.cos(theta_nToCa) * Math.sin(phi_nToCa);
        A[2][2] = Math.sin(theta_nToCa);
        Matrix Rn2ca = new Matrix(A);
        double[] n2Co1 = Rn2ca.times(nToCO1);
        double[] ca2Co = Rn2ca.times(caToCO);
        double[] n2Ca = Rn2ca.times(nToCA);
        double x1 = ca2Co[0];
        double y1 = ca2Co[1];
        double z1 = ca2Co[2];
        double x2 = n2Co1[0];
        double y2 = n2Co1[1];
        double z2 = n2Co1[2];
        if (1.0 - y1 * y1 <= 0.0 || 1.0 - y2 * y2 <= 0.0) {
            System.out.println("Error in dihedral angle computation");
            System.exit(1);
        }
        double sin_gamma1 = Math.sqrt(1.0 - y1 * y1);
        double sin_gamma2 = Math.sqrt(1.0 - y2 * y2);
        double cosPhi = (z1 * z2 + x1 * x2) / (sin_gamma1 * sin_gamma2);
        double sinPhi = (x1 * z2 - z1 * x2) / (sin_gamma1 * sin_gamma2);
        if (sinPhi > 0.0) {
            return Math.acos(cosPhi);
        }
        if (sinPhi < 0.0) {
            return -Math.acos(cosPhi);
        }
        if (cosPhi > 0.0) {
            return 0.0;
        }
        return Math.PI;
    }

    public double PhiPsiCalPDB(double[] n2CO1, double[] n2CA, double[] ca2CO) {
        double[] nToCO1 = this.dirCos(n2CO1);
        double[] nToCA = this.dirCos(n2CA);
        double[] caToCO = this.dirCos(ca2CO);
        double theta_nToCa = Math.acos(nToCA[2]);
        double phi_nToCa = 0.0;
        double x = nToCA[0];
        double y = nToCA[1];
        phi_nToCa = theta_nToCa != 0.0 ? (x > 0.0 ? Math.atan(y / x) : (x < 0.0 ? Math.atan(y / x) + Math.PI : (y > 0.0 ? 1.5707963267948966 : 4.71238898038469))) : 0.0;
        int m = 3;
        int n = 3;
        double numMin = 1.0E-10;
        double[][] A = new double[3][3];
        A[0][0] = Math.sin(phi_nToCa);
        A[0][1] = -Math.cos(phi_nToCa);
        A[0][2] = 0.0;
        A[1][0] = Math.sin(theta_nToCa) * Math.cos(phi_nToCa);
        A[1][1] = Math.sin(theta_nToCa) * Math.sin(phi_nToCa);
        A[1][2] = Math.cos(theta_nToCa);
        A[2][0] = -Math.cos(theta_nToCa) * Math.cos(phi_nToCa);
        A[2][1] = -Math.cos(theta_nToCa) * Math.sin(phi_nToCa);
        A[2][2] = Math.sin(theta_nToCa);
        Matrix Rn2ca = new Matrix(A);
        double[] n2Co1 = Rn2ca.times(nToCO1);
        double[] ca2Co = Rn2ca.times(caToCO);
        double[] n2Ca = Rn2ca.times(nToCA);
        double x1 = ca2Co[0];
        double y1 = ca2Co[1];
        double z1 = ca2Co[2];
        double x2 = n2Co1[0];
        double y2 = n2Co1[1];
        double z2 = n2Co1[2];
        double sin_gamma1 = Math.sqrt(1.0 - y1 * y1);
        double sin_gamma2 = Math.sqrt(1.0 - y2 * y2);
        double cosPhi = (z1 * z2 + x1 * x2) / (sin_gamma1 * sin_gamma2);
        double sinPhi = (x1 * z2 - z1 * x2) / (sin_gamma1 * sin_gamma2);
        if (sinPhi > 0.0) {
            if (sinPhi > 1.0 && Math.abs(sinPhi - 1.0) < 1.0E-10) {
                return 0.0;
            }
            if (sinPhi > 1.0 && Math.abs(sinPhi - 1.0) >= 1.0E-10) {
                System.out.println("Math Error in PhiPsiCalPDB method");
                return 0.0;
            }
            return Math.acos(cosPhi);
        }
        if (sinPhi < 0.0) {
            if (sinPhi < -1.0 && Math.abs(sinPhi + 1.0) < 1.0E-10) {
                return Math.PI;
            }
            if (sinPhi < -1.0 && Math.abs(sinPhi + 1.0) >= 1.0E-10) {
                System.out.println("Math Error in PhiPsiCalPDB method");
                return 0.0;
            }
            return -Math.acos(cosPhi);
        }
        if (cosPhi > 0.0) {
            return 0.0;
        }
        return Math.PI;
    }

    public Vector PhiPsiTotalPdb(Vector pdbVec) {
        double[] amide1 = new double[3];
        double[] amide2 = new double[3];
        double[] co1 = new double[3];
        double[] co2 = new double[3];
        double[] ca1 = new double[3];
        double[] ca2 = new double[3];
        int no1 = 0;
        int no2 = 0;
        int no3 = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        String resid1 = "";
        String resid2 = "";
        String resid3 = "";
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = (Pdb)pdbVec.elementAt(i);
        no1 = pp.getResidueNo();
        resid1 = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co1 = cc.getXYZ();
            }
            ++j;
        }
        double[] nToCO1Vec = new double[3];
        double[] co1ToNVec = new double[3];
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>(pdbVec.size());
        double[] phiArr = new double[pdbVec.size()];
        double[] psiArr = new double[pdbVec.size()];
        int m = 0;
        while (m < phiPsiVec.size()) {
            phiArr[m] = 999.0;
            psiArr[m] = 999.0;
            ++m;
        }
        phiArr[i] = -2.239991393619066;
        double[] caToNVec = this.internuclearVec(ca1, amide1);
        double[] caToCOVec = this.internuclearVec(ca1, co1);
        pp = (Pdb)pdbVec.elementAt(++i);
        no2 = pp.getResidueNo();
        resid2 = pp.getResidue();
        atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("C")) {
                co2 = cc.getXYZ();
            }
            ++j;
        }
        if (no2 == no1 + 1) {
            co1ToNVec = this.internuclearVec(co1, amide2);
            psiArr[i - 1] = this.PhiPsiCalPDB(caToNVec, caToCOVec, co1ToNVec);
        }
        phiPsiVec.addElement(new PhiPsi(no1, resid1, phiArr[i - 1], psiArr[i - 1]));
        double[] nToCAVec = this.internuclearVec(amide2, ca2);
        caToCOVec = this.internuclearVec(ca2, co2);
        if (no2 == no1 + 1) {
            nToCO1Vec = this.internuclearVec(amide2, co1);
            phiArr[i] = this.PhiPsiCalPDB(nToCO1Vec, nToCAVec, caToCOVec);
        }
        ++i;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            no3 = pp.getResidueNo();
            resid3 = pp.getResidue();
            atomVec = pp.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide1 = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca1 = cc.getXYZ();
                } else if (atom.equals("C")) {
                    co1 = cc.getXYZ();
                }
                ++j;
            }
            if (no3 == no2 + 1) {
                co1ToNVec = this.internuclearVec(co2, amide1);
                k = 0;
                while (k < nToCAVec.length) {
                    caToNVec[k] = -nToCAVec[k];
                    ++k;
                }
                psiArr[i - 1] = this.PhiPsiCalPDB(caToNVec, caToCOVec, co1ToNVec);
            }
            phiPsiVec.addElement(new PhiPsi(no2, resid2, phiArr[i - 1], psiArr[i - 1]));
            nToCAVec = this.internuclearVec(amide1, ca1);
            caToCOVec = this.internuclearVec(ca1, co1);
            if (no3 == no2 + 1) {
                k = 0;
                while (k < co1ToNVec.length) {
                    nToCO1Vec[k] = -co1ToNVec[k];
                    ++k;
                }
                phiArr[i] = this.PhiPsiCalPDB(nToCO1Vec, nToCAVec, caToCOVec);
            }
            k = 0;
            while (k < co1.length) {
                co2[k] = co1[k];
                ++k;
            }
            ++i;
            no2 = no3;
            resid2 = resid3;
        }
        psiArr[i - 1] = -0.6876597252857658;
        phiPsiVec.addElement(new PhiPsi(no2, resid2, phiArr[i - 1], psiArr[i - 1]));
        return phiPsiVec;
    }

    public Vector extractBackbone(Vector pdbVec) {
        Cartesian cc = null;
        String atom = "";
        Vector<Object> atomVec = new Vector();
        Vector<Cartesian> atomVecN = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                } else if (atom.equals("H")) {
                    atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                } else if (atom.equals("CA")) {
                    atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                } else if (atom.equals("HA")) {
                    atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                } else if (atom.equals("C")) {
                    atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                } else if (atom.equals("O")) {
                    atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                }
                ++j;
            }
            pdbVecN.add(new Pdb(no, resid, atomVecN));
            atomVecN = new Vector();
            ++i;
        }
        return pdbVecN;
    }

    public Vector extractFragment(Vector pdbVec, int residueFirst, int residueLast, double[] firstCoords, double[] lastCoords) {
        Pdb pp = new Pdb();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        String atom = "";
        Vector<Object> atomVec = new Vector();
        Vector<Cartesian> atomVecN = new Vector<Cartesian>();
        Cartesian cc = new Cartesian();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            if (no == residueFirst) {
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("N")) {
                        System.arraycopy(cc.getXYZ(), 0, firstCoords, 0, 3);
                    }
                    ++j;
                }
            }
            if (no == residueLast) {
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("N")) {
                        atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                    } else if (atom.equals("HN")) {
                        atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                    } else if (atom.equals("CA")) {
                        atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                        System.arraycopy(cc.getXYZ(), 0, lastCoords, 0, 3);
                    }
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVecN));
            }
            if (no > residueFirst - 1 && no < residueLast) {
                pdbVecN.add(pp);
            }
            ++i;
        }
        Vector pdbBB = this.extractBackbone(pdbVecN);
        return pdbBB;
    }

    public Vector extractFragment(Vector pdbVec, int residueFirst, int residueLast) {
        Pdb pp = new Pdb();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        String atom = "";
        Vector<Object> atomVec = new Vector();
        Vector<Cartesian> atomVecN = new Vector<Cartesian>();
        Cartesian cc = new Cartesian();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            if (no == residueFirst) {
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    ++j;
                }
            }
            if (no == residueLast) {
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("N")) {
                        atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                    } else if (atom.equals("HN") || atom.equals("H")) {
                        atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                    } else if (atom.equals("CA")) {
                        atomVecN.add(new Cartesian(atom, cc.getXYZ()));
                    }
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVecN));
            }
            if (no > residueFirst - 1 && no < residueLast) {
                pdbVecN.add(pp);
            }
            ++i;
        }
        Vector pdbBB = this.extractBackbone(pdbVecN);
        return pdbBB;
    }

    public Vector<Pdb> nameConvert2PDBNew(Vector<Pdb> pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    if (atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("HD3")) {
                        atomName = "HD2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    if (atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    if (atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HA2")) {
                        atomName = "HA1";
                    } else if (atomName.equalsIgnoreCase("HA3")) {
                        atomName = "HA2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HG12")) {
                        atomName = "HG11";
                    } else if (atomName.equalsIgnoreCase("HG13")) {
                        atomName = "HG12";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    if (atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("HD3")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("HE2")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("HE3")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB2";
                    }
                    if (atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("HD3")) {
                        atomName = "HD2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector nameConvert4SmallRotLibCS(Vector pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HH1")) {
                        atomName = "HH11";
                    } else if (atomName.equalsIgnoreCase("2HH1")) {
                        atomName = "HH12";
                    }
                    if (atomName.equalsIgnoreCase("1HH2")) {
                        atomName = "HH21";
                    } else if (atomName.equalsIgnoreCase("2HH2")) {
                        atomName = "HH22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    } else if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE";
                    } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                        atomName = "HE";
                    } else if (atomName.equalsIgnoreCase("3HE") || atomName.equalsIgnoreCase("HE3")) {
                        atomName = "HE";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HE2")) {
                        atomName = "HE21";
                    } else if (atomName.equalsIgnoreCase("2HE2")) {
                        atomName = "HE22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HA") || atomName.equalsIgnoreCase("HA1")) {
                        atomName = "HA2";
                    } else if (atomName.equalsIgnoreCase("2HA") || atomName.equalsIgnoreCase("HA2")) {
                        atomName = "HA3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                        atomName = "HG13";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("1HD1") || atomName.equalsIgnoreCase("HD11")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD1") || atomName.equalsIgnoreCase("HD12")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("3HD1") || atomName.equalsIgnoreCase("HD13")) {
                        atomName = "HD1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2") || atomName.equalsIgnoreCase("HD21")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD2") || atomName.equalsIgnoreCase("HD22")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("3HD2") || atomName.equalsIgnoreCase("HD23")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HD1") || atomName.equalsIgnoreCase("HD11")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD1") || atomName.equalsIgnoreCase("HD12")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("3HD1") || atomName.equalsIgnoreCase("HD13")) {
                        atomName = "HD1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("3HG1") || atomName.equalsIgnoreCase("HG13")) {
                        atomName = "HG1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HZ") || atomName.equalsIgnoreCase("HZ1")) {
                        atomName = "HZ";
                    } else if (atomName.equalsIgnoreCase("2HZ") || atomName.equalsIgnoreCase("HZ2")) {
                        atomName = "HZ";
                    } else if (atomName.equalsIgnoreCase("3HZ") || atomName.equalsIgnoreCase("HZ3")) {
                        atomName = "HZ";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG1";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                        atomName = "HG2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector nameConvert4SmallRotLibStr(Vector pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HH1")) {
                        atomName = "HH11";
                    } else if (atomName.equalsIgnoreCase("2HH1")) {
                        atomName = "HH12";
                    }
                    if (atomName.equalsIgnoreCase("1HH2")) {
                        atomName = "HH21";
                    } else if (atomName.equalsIgnoreCase("2HH2")) {
                        atomName = "HH22";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (!atomName.equalsIgnoreCase("HE2") && !atomName.equalsIgnoreCase("HD1")) {
                        atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    }
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    } else if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("3HE") || atomName.equalsIgnoreCase("HE3")) {
                        atomName = "HE3";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HE2")) {
                        atomName = "HE21";
                    } else if (atomName.equalsIgnoreCase("2HE2")) {
                        atomName = "HE22";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HA") || atomName.equalsIgnoreCase("HA1")) {
                        atomName = "HA2";
                    } else if (atomName.equalsIgnoreCase("2HA") || atomName.equalsIgnoreCase("HA2")) {
                        atomName = "HA3";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                        atomName = "HG13";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1") || atomName.equalsIgnoreCase("HD11")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1") || atomName.equalsIgnoreCase("HD12")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1") || atomName.equalsIgnoreCase("HD13")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2") || atomName.equalsIgnoreCase("HD21")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2") || atomName.equalsIgnoreCase("HD22")) {
                        atomName = "HD22";
                    } else if (atomName.equalsIgnoreCase("3HD2") || atomName.equalsIgnoreCase("HD23")) {
                        atomName = "HD23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1") || atomName.equalsIgnoreCase("HD11")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1") || atomName.equalsIgnoreCase("HD12")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1") || atomName.equalsIgnoreCase("HD13")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                        atomName = "HG11";
                    } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("3HG1") || atomName.equalsIgnoreCase("HG13")) {
                        atomName = "HG13";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HZ") || atomName.equalsIgnoreCase("HZ1")) {
                        atomName = "HZ1";
                    } else if (atomName.equalsIgnoreCase("2HZ") || atomName.equalsIgnoreCase("HZ2")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ") || atomName.equalsIgnoreCase("HZ3")) {
                        atomName = "HZ3";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG1";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                        atomName = "HG23";
                    }
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    coord = atom.getXYZ();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector nameConvertCS(Vector pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB";
                    } else if (atomName.equalsIgnoreCase("3HB")) {
                        atomName = "HB";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HH1")) {
                        atomName = "HH11";
                    } else if (atomName.equalsIgnoreCase("2HH1")) {
                        atomName = "HH12";
                    }
                    if (atomName.equalsIgnoreCase("1HH2")) {
                        atomName = "HH21";
                    } else if (atomName.equalsIgnoreCase("2HH2")) {
                        atomName = "HH22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    } else if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("3HE")) {
                        atomName = "HE3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HE2")) {
                        atomName = "HE21";
                    } else if (atomName.equalsIgnoreCase("2HE2")) {
                        atomName = "HE22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HA")) {
                        atomName = "HA2";
                    } else if (atomName.equalsIgnoreCase("2HA")) {
                        atomName = "HA3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG13";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("3HD2")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("3HG1")) {
                        atomName = "HG1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HZ")) {
                        atomName = "HZ1";
                    } else if (atomName.equalsIgnoreCase("2HZ")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ")) {
                        atomName = "HZ3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG1";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector nameConvertStr(Vector pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HH1")) {
                        atomName = "HH11";
                    } else if (atomName.equalsIgnoreCase("2HH1")) {
                        atomName = "HH12";
                    }
                    if (atomName.equalsIgnoreCase("1HH2")) {
                        atomName = "HH21";
                    } else if (atomName.equalsIgnoreCase("2HH2")) {
                        atomName = "HH22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    } else if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("3HE")) {
                        atomName = "HE3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HE2")) {
                        atomName = "HE21";
                    } else if (atomName.equalsIgnoreCase("2HE2")) {
                        atomName = "HE22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HA")) {
                        atomName = "HA2";
                    } else if (atomName.equalsIgnoreCase("2HA")) {
                        atomName = "HA3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG13";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    } else if (atomName.equalsIgnoreCase("3HD2")) {
                        atomName = "HD23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG11";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("3HG1")) {
                        atomName = "HG13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HZ")) {
                        atomName = "HZ1";
                    } else if (atomName.equalsIgnoreCase("2HZ")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ")) {
                        atomName = "HZ3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG1";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector<Pdb> nameConvertOrder(Vector<Pdb> pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    }
                    if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG") || atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("3HD") || atomName.equalsIgnoreCase("HD3")) {
                        atomName = "HD3";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD1";
                    }
                    if (atomName.equalsIgnoreCase("1HH1")) {
                        atomName = "HH11";
                    } else if (atomName.equalsIgnoreCase("2HH1")) {
                        atomName = "HH12";
                    }
                    if (atomName.equalsIgnoreCase("1HH2")) {
                        atomName = "HH21";
                    } else if (atomName.equalsIgnoreCase("2HH2")) {
                        atomName = "HH22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("TRP")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    } else if (atomName.equalsIgnoreCase("3HE") || atomName.equalsIgnoreCase("HE3")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HZ") || atomName.equalsIgnoreCase("HZ2")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ") || atomName.equalsIgnoreCase("HZ3")) {
                        atomName = "HZ3";
                    } else if (atomName.equalsIgnoreCase("HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("HH")) {
                        atomName = "HH2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG") || atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG3";
                    } else if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("3HE")) {
                        atomName = "HE3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG") || atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HE2")) {
                        atomName = "HE21";
                    } else if (atomName.equalsIgnoreCase("2HE2")) {
                        atomName = "HE22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HA") || atomName.equalsIgnoreCase("HA1")) {
                        atomName = "HA1";
                    } else if (atomName.equalsIgnoreCase("2HA") || atomName.equalsIgnoreCase("HA2")) {
                        atomName = "HA2";
                    } else if (atomName.equalsIgnoreCase("3HA") || atomName.equalsIgnoreCase("HA3")) {
                        atomName = "HA3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                        atomName = "HG11";
                    } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("3HG1") || atomName.equalsIgnoreCase("HG13")) {
                        atomName = "HG13";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    } else if (atomName.equalsIgnoreCase("3HD2")) {
                        atomName = "HD23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG11";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("3HG1")) {
                        atomName = "HG13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG") || atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("3HD") || atomName.equalsIgnoreCase("HD3")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("3HE") || atomName.equalsIgnoreCase("HE3")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HZ")) {
                        atomName = "HZ1";
                    } else if (atomName.equalsIgnoreCase("2HZ")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ")) {
                        atomName = "HZ3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG") || atomName.equalsIgnoreCase("HG3")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("3HD") || atomName.equalsIgnoreCase("HD3")) {
                        atomName = "HD3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG1";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("H")) {
                        atomName = "HN";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector nameConvert(Vector pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HH1")) {
                        atomName = "HH11";
                    } else if (atomName.equalsIgnoreCase("2HH1")) {
                        atomName = "HH12";
                    }
                    if (atomName.equalsIgnoreCase("1HH2")) {
                        atomName = "HH21";
                    } else if (atomName.equalsIgnoreCase("2HH2")) {
                        atomName = "HH22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("TRP")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    } else if (atomName.equalsIgnoreCase("3HE") || atomName.equalsIgnoreCase("HE3")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HZ") || atomName.equalsIgnoreCase("HZ2")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ") || atomName.equalsIgnoreCase("HZ3")) {
                        atomName = "HZ3";
                    } else if (atomName.equalsIgnoreCase("HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("HH")) {
                        atomName = "HH2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    } else if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("3HE")) {
                        atomName = "HE3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HE2")) {
                        atomName = "HE21";
                    } else if (atomName.equalsIgnoreCase("2HE2")) {
                        atomName = "HE22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HA") || atomName.equalsIgnoreCase("HA1")) {
                        atomName = "HA2";
                    } else if (atomName.equalsIgnoreCase("2HA") || atomName.equalsIgnoreCase("HA2")) {
                        atomName = "HA3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                        atomName = "HG13";
                    }
                    if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    } else if (atomName.equalsIgnoreCase("3HD2")) {
                        atomName = "HD23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG11";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG12";
                    } else if (atomName.equalsIgnoreCase("3HG1")) {
                        atomName = "HG13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HZ")) {
                        atomName = "HZ1";
                    } else if (atomName.equalsIgnoreCase("2HZ")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ")) {
                        atomName = "HZ3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                        atomName = "HD3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG1";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("HN")) {
                        atomName = "H";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public String NameFromPdbToBMRB(String resid, String atomNameInput) {
        String atomName = atomNameInput;
        if (atomName.equalsIgnoreCase("HN")) {
            atomName = "H";
        }
        if (resid.equalsIgnoreCase("ALA")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB1";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("3HB") || atomName.equalsIgnoreCase("HB3")) {
                atomName = "HB3";
            }
        } else if (resid.equalsIgnoreCase("ARG")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                atomName = "HG2";
            } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                atomName = "HG3";
            }
            if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                atomName = "HD2";
            } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                atomName = "HD3";
            }
            if (atomName.equalsIgnoreCase("1HH1")) {
                atomName = "HH11";
            } else if (atomName.equalsIgnoreCase("2HH1")) {
                atomName = "HH12";
            }
            if (atomName.equalsIgnoreCase("1HH2")) {
                atomName = "HH21";
            } else if (atomName.equalsIgnoreCase("2HH2")) {
                atomName = "HH22";
            }
        } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("CYS")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
        } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                atomName = "HG2";
            } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                atomName = "HG3";
            } else if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                atomName = "HE1";
            } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                atomName = "HE2";
            } else if (atomName.equalsIgnoreCase("3HE") || atomName.equalsIgnoreCase("HE3")) {
                atomName = "HE3";
            }
        } else if (resid.equalsIgnoreCase("ASN")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HD2")) {
                atomName = "HD21";
            } else if (atomName.equalsIgnoreCase("2HD2")) {
                atomName = "HD22";
            }
        } else if (resid.equalsIgnoreCase("GLN")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                atomName = "HG2";
            } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                atomName = "HG3";
            }
            if (atomName.equalsIgnoreCase("1HE2")) {
                atomName = "HE21";
            } else if (atomName.equalsIgnoreCase("2HE2")) {
                atomName = "HE22";
            }
        } else if (resid.equalsIgnoreCase("GLY")) {
            if (atomName.equalsIgnoreCase("1HA") || atomName.equalsIgnoreCase("HA1")) {
                atomName = "HA2";
            } else if (atomName.equalsIgnoreCase("2HA") || atomName.equalsIgnoreCase("HA2")) {
                atomName = "HA3";
            }
        } else if (resid.equalsIgnoreCase("ILE")) {
            if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                atomName = "HG12";
            } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                atomName = "HG13";
            }
            if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                atomName = "HG21";
            } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                atomName = "HG22";
            } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                atomName = "HG23";
            }
            if (atomName.equalsIgnoreCase("1HD1") || atomName.equalsIgnoreCase("HD11")) {
                atomName = "HD11";
            } else if (atomName.equalsIgnoreCase("2HD1") || atomName.equalsIgnoreCase("HD12")) {
                atomName = "HD12";
            } else if (atomName.equalsIgnoreCase("3HD1") || atomName.equalsIgnoreCase("HD13")) {
                atomName = "HD13";
            }
        } else if (resid.equalsIgnoreCase("LEU")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HD2") || atomName.equalsIgnoreCase("HD21")) {
                atomName = "HD21";
            } else if (atomName.equalsIgnoreCase("2HD2") || atomName.equalsIgnoreCase("HD22")) {
                atomName = "HD22";
            } else if (atomName.equalsIgnoreCase("3HD2") || atomName.equalsIgnoreCase("HD23")) {
                atomName = "HD23";
            }
            if (atomName.equalsIgnoreCase("1HD1") || atomName.equalsIgnoreCase("HD11")) {
                atomName = "HD11";
            } else if (atomName.equalsIgnoreCase("2HD1") || atomName.equalsIgnoreCase("HD12")) {
                atomName = "HD12";
            } else if (atomName.equalsIgnoreCase("3HD1") || atomName.equalsIgnoreCase("HD13")) {
                atomName = "HD13";
            }
        } else if (resid.equalsIgnoreCase("VAL")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                atomName = "HG21";
            } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                atomName = "HG22";
            } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                atomName = "HG23";
            }
            if (atomName.equalsIgnoreCase("1HG1") || atomName.equalsIgnoreCase("HG11")) {
                atomName = "HG11";
            } else if (atomName.equalsIgnoreCase("2HG1") || atomName.equalsIgnoreCase("HG12")) {
                atomName = "HG12";
            } else if (atomName.equalsIgnoreCase("3HG1") || atomName.equalsIgnoreCase("HG13")) {
                atomName = "HG13";
            }
        } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HG") || atomName.equalsIgnoreCase("HG1")) {
                atomName = "HG2";
            } else if (atomName.equalsIgnoreCase("2HG") || atomName.equalsIgnoreCase("HG2")) {
                atomName = "HG3";
            }
            if (atomName.equalsIgnoreCase("1HD") || atomName.equalsIgnoreCase("HD1")) {
                atomName = "HD2";
            } else if (atomName.equalsIgnoreCase("2HD") || atomName.equalsIgnoreCase("HD2")) {
                atomName = "HD3";
            }
            if (atomName.equalsIgnoreCase("1HE") || atomName.equalsIgnoreCase("HE1")) {
                atomName = "HE2";
            } else if (atomName.equalsIgnoreCase("2HE") || atomName.equalsIgnoreCase("HE2")) {
                atomName = "HE3";
            } else if (atomName.equalsIgnoreCase("1HZ") || atomName.equalsIgnoreCase("HZ1")) {
                atomName = "HZ1";
            } else if (atomName.equalsIgnoreCase("2HZ") || atomName.equalsIgnoreCase("HZ2")) {
                atomName = "HZ2";
            } else if (atomName.equalsIgnoreCase("3HZ") || atomName.equalsIgnoreCase("HZ3")) {
                atomName = "HZ3";
            }
        } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
            if (atomName.equalsIgnoreCase("1HB") || atomName.equalsIgnoreCase("HB1")) {
                atomName = "HB2";
            } else if (atomName.equalsIgnoreCase("2HB") || atomName.equalsIgnoreCase("HB2")) {
                atomName = "HB3";
            }
            if (atomName.equalsIgnoreCase("1HD")) {
                atomName = "HD1";
            } else if (atomName.equalsIgnoreCase("2HD")) {
                atomName = "HD2";
            }
            if (atomName.equalsIgnoreCase("1HE")) {
                atomName = "HE1";
            } else if (atomName.equalsIgnoreCase("2HE")) {
                atomName = "HE2";
            }
        } else if (resid.equalsIgnoreCase("THR")) {
            if (atomName.equalsIgnoreCase("1HG")) {
                atomName = "HG1";
            }
            if (atomName.equalsIgnoreCase("1HG2") || atomName.equalsIgnoreCase("HG21")) {
                atomName = "HG21";
            } else if (atomName.equalsIgnoreCase("2HG2") || atomName.equalsIgnoreCase("HG22")) {
                atomName = "HG22";
            } else if (atomName.equalsIgnoreCase("3HG2") || atomName.equalsIgnoreCase("HG23")) {
                atomName = "HG23";
            }
        }
        return atomName;
    }

    public String NameFromBMRBToPDB(String resName, String atomName) {
        String newAtomName = atomName;
        if (resName.equalsIgnoreCase("ALA") && atomName.equalsIgnoreCase("HB")) {
            newAtomName = "HB";
        } else if (resName.equalsIgnoreCase("ILE") && atomName.equalsIgnoreCase("HG2")) {
            newAtomName = "HG2";
        } else if (resName.equalsIgnoreCase("ILE") && atomName.equalsIgnoreCase("HD1")) {
            newAtomName = "HD1";
        } else if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("HD1")) {
            newAtomName = "HD1";
        } else if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("HD2")) {
            newAtomName = "HD2";
        } else if (resName.equalsIgnoreCase("VAL") && atomName.equalsIgnoreCase("HG1")) {
            newAtomName = "HG1";
        } else if (resName.equalsIgnoreCase("VAL") && atomName.equalsIgnoreCase("HG2")) {
            newAtomName = "HG2";
        } else if (resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG2")) {
            newAtomName = "HG2";
        } else if (resName.equalsIgnoreCase("MET") && atomName.equalsIgnoreCase("HE")) {
            newAtomName = "HE";
        } else {
            if (resName.equalsIgnoreCase("ARG") || resName.equalsIgnoreCase("PRO")) {
                if (atomName.equalsIgnoreCase("HB2")) {
                    newAtomName = "HB1";
                }
                if (atomName.equalsIgnoreCase("HB3")) {
                    newAtomName = "HB2";
                }
                if (atomName.equalsIgnoreCase("HG2")) {
                    newAtomName = "HG1";
                }
                if (atomName.equalsIgnoreCase("HG3")) {
                    newAtomName = "HG2";
                }
                if (atomName.equalsIgnoreCase("HD2")) {
                    newAtomName = "HD1";
                }
                if (atomName.equalsIgnoreCase("HD3")) {
                    newAtomName = "HD2";
                }
            }
            if (resName.equalsIgnoreCase("ASP") || resName.equalsIgnoreCase("CYS") || resName.equalsIgnoreCase("HIS") || resName.equalsIgnoreCase("SER") || resName.equalsIgnoreCase("TRP") || resName.equalsIgnoreCase("ASN") || resName.equalsIgnoreCase("LEU") || resName.equalsIgnoreCase("VAL") || resName.equalsIgnoreCase("TYR") || resName.equalsIgnoreCase("PHE")) {
                if (atomName.equalsIgnoreCase("HB2")) {
                    newAtomName = "HB1";
                }
                if (atomName.equalsIgnoreCase("HB3")) {
                    newAtomName = "HB2";
                }
            }
            if (resName.equalsIgnoreCase("GLU") || resName.equalsIgnoreCase("MET") || resName.equalsIgnoreCase("GLN")) {
                if (atomName.equalsIgnoreCase("HB2")) {
                    newAtomName = "HB1";
                }
                if (atomName.equalsIgnoreCase("HB3")) {
                    newAtomName = "HB2";
                }
                if (atomName.equalsIgnoreCase("HG2")) {
                    newAtomName = "HG1";
                }
                if (atomName.equalsIgnoreCase("HG3")) {
                    newAtomName = "HG2";
                }
            }
            if (resName.equalsIgnoreCase("GLY")) {
                if (atomName.equalsIgnoreCase("HA2")) {
                    newAtomName = "HA1";
                }
                if (atomName.equalsIgnoreCase("HA3")) {
                    newAtomName = "HA2";
                }
            }
            if (resName.equalsIgnoreCase("ILE")) {
                if (atomName.equalsIgnoreCase("HG12")) {
                    newAtomName = "HG11";
                }
                if (atomName.equalsIgnoreCase("HG13")) {
                    newAtomName = "HG12";
                }
            }
            if (resName.equalsIgnoreCase("LYS") || resName.equalsIgnoreCase("PRO")) {
                if (atomName.equalsIgnoreCase("HB2")) {
                    newAtomName = "HB1";
                }
                if (atomName.equalsIgnoreCase("HB3")) {
                    newAtomName = "HB2";
                }
                if (atomName.equalsIgnoreCase("HG2")) {
                    newAtomName = "HG1";
                }
                if (atomName.equalsIgnoreCase("HG3")) {
                    newAtomName = "HG2";
                }
                if (atomName.equalsIgnoreCase("HD2")) {
                    newAtomName = "HD1";
                }
                if (atomName.equalsIgnoreCase("HD3")) {
                    newAtomName = "HD2";
                }
                if (atomName.equalsIgnoreCase("HE2")) {
                    newAtomName = "HE1";
                }
                if (atomName.equalsIgnoreCase("HE3")) {
                    newAtomName = "HE2";
                }
            }
            if (atomName.equalsIgnoreCase("H")) {
                newAtomName = "HN";
            }
        }
        return newAtomName;
    }

    public String NameFromPDBToPDB(String resName, String atomName) {
        String newAtomName = atomName;
        if (resName.equalsIgnoreCase("ALA") && atomName.equalsIgnoreCase("HB")) {
            newAtomName = "HB#";
        } else if (resName.equalsIgnoreCase("ILE") && atomName.equalsIgnoreCase("HG2")) {
            newAtomName = "HG2#";
        } else if (resName.equalsIgnoreCase("ILE") && atomName.equalsIgnoreCase("HD1")) {
            newAtomName = "HD1#";
        } else if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("HD1")) {
            newAtomName = "HD1#";
        } else if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("HD2")) {
            newAtomName = "HD2#";
        } else if (resName.equalsIgnoreCase("VAL") && atomName.equalsIgnoreCase("HG1")) {
            newAtomName = "HG1#";
        } else if (resName.equalsIgnoreCase("VAL") && atomName.equalsIgnoreCase("HG2")) {
            newAtomName = "HG2#";
        } else if (resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG2")) {
            newAtomName = "HG2#";
        } else if (resName.equalsIgnoreCase("MET") && atomName.equalsIgnoreCase("HE")) {
            newAtomName = "HE#";
        } else if (resName.equalsIgnoreCase("LYS") && atomName.equalsIgnoreCase("HB")) {
            newAtomName = "HB#";
        } else if (resName.equalsIgnoreCase("LYS") && atomName.equalsIgnoreCase("HE")) {
            newAtomName = "HB#";
        } else if (resName.equalsIgnoreCase("MET") && atomName.equalsIgnoreCase("HB")) {
            newAtomName = "HE#";
        }
        if (atomName.equalsIgnoreCase("H")) {
            newAtomName = "HN";
        }
        return newAtomName;
    }

    public Vector nameConvert22(Vector pdbVec) {
        Cartesian atom = null;
        String atomName = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Cartesian> atomVec = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        double[] coord = new double[3];
        double[] coordN = new double[3];
        Pdb pp = new Pdb();
        int i = 0;
        while (i < pdbVec.size()) {
            int j;
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            if (resid.equalsIgnoreCase("ALA")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB1";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("3HB")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ARG")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HH1")) {
                        atomName = "HH11";
                    } else if (atomName.equalsIgnoreCase("2HH1")) {
                        atomName = "HH12";
                    }
                    if (atomName.equalsIgnoreCase("1HH2")) {
                        atomName = "HH21";
                    } else if (atomName.equalsIgnoreCase("2HH2")) {
                        atomName = "HH22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASP") || resid.equalsIgnoreCase("CYS") || resid.equalsIgnoreCase("HIS") || resid.equalsIgnoreCase("SER") || resid.equalsIgnoreCase("TRP") || resid.equalsIgnoreCase("CYS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLU") || resid.equalsIgnoreCase("MET")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    } else if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("3HE")) {
                        atomName = "HE3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ASN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD21";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLN")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HE2")) {
                        atomName = "HE21";
                    } else if (atomName.equalsIgnoreCase("2HE2")) {
                        atomName = "HE22";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("GLY")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HA")) {
                        atomName = "HA2";
                    } else if (atomName.equalsIgnoreCase("2HA")) {
                        atomName = "HA3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("ILE")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG11";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG12";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG21";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG22";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG23";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD11";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD12";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD13";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LEU")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD2")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD2")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("3HD2")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD1")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("3HD1")) {
                        atomName = "HD1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("VAL")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG2";
                    }
                    if (atomName.equalsIgnoreCase("1HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("2HG1")) {
                        atomName = "HG1";
                    } else if (atomName.equalsIgnoreCase("3HG1")) {
                        atomName = "HG1";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("LYS") || resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE2";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE3";
                    } else if (atomName.equalsIgnoreCase("1HZ")) {
                        atomName = "HZ1";
                    } else if (atomName.equalsIgnoreCase("2HZ")) {
                        atomName = "HZ2";
                    } else if (atomName.equalsIgnoreCase("3HZ")) {
                        atomName = "HZ3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PHE") || resid.equalsIgnoreCase("TYR") || resid.equalsIgnoreCase("HIS")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD1";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD2";
                    }
                    if (atomName.equalsIgnoreCase("1HE")) {
                        atomName = "HE1";
                    } else if (atomName.equalsIgnoreCase("2HE")) {
                        atomName = "HE2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("PRO")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HB")) {
                        atomName = "HB2";
                    } else if (atomName.equalsIgnoreCase("2HB")) {
                        atomName = "HB3";
                    }
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG")) {
                        atomName = "HG3";
                    }
                    if (atomName.equalsIgnoreCase("1HD")) {
                        atomName = "HD2";
                    } else if (atomName.equalsIgnoreCase("2HD")) {
                        atomName = "HD3";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            } else if (resid.equalsIgnoreCase("THR")) {
                j = 0;
                while (j < atoms.size()) {
                    atom = (Cartesian)atoms.elementAt(j);
                    atomName = atom.getAtom();
                    if (atomName.equalsIgnoreCase("1HG")) {
                        atomName = "HG1";
                    }
                    if (atomName.equalsIgnoreCase("1HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("2HG2")) {
                        atomName = "HG2";
                    } else if (atomName.equalsIgnoreCase("3HG2")) {
                        atomName = "HG2";
                    }
                    coord = atom.getXYZ();
                    atomVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    ++j;
                }
                pdbVecN.add(new Pdb(no, resid, atomVec));
                atomVec = new Vector();
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector residueNameUpdate_from_structure(Vector pdbVec1, Vector pdbVec2) {
        Collections.sort(pdbVec2, new PdbComparator());
        String atom = "";
        String atomName2 = "";
        Vector<Object> atoms = new Vector();
        Vector<Object> atomVec = new Vector();
        Vector<Cartesian> atomVecN = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        Matrix mat = new Matrix(3, 3);
        double[] n = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ha = new double[3];
        double[] ha2 = new double[3];
        double[] cb = new double[3];
        double[] co = new double[3];
        double[] o = new double[3];
        double[] nToNhVec = new double[3];
        double[] nToCaVec = new double[3];
        double[] ca2haVec = new double[3];
        Pdb pp = new Pdb();
        Pdb pp2 = new Pdb();
        int index = -1;
        Cartesian cc = new Cartesian();
        double proPhi = -1.1344640137963142;
        Matrix r2yInv = mat.rotationMat(proPhi, "-y");
        Matrix rg = new Matrix(3, 3);
        Matrix rgInv = new Matrix(3, 3);
        PhiPsi ff = new PhiPsi();
        Matrix matT = new Matrix(3, 3);
        sp3Carbon sp3 = new sp3Carbon();
        double[][] coordsCB = new double[3][3];
        double[][] coordsCG = new double[3][3];
        double[][] coordsCD = new double[3][3];
        int i = 0;
        while (i < pdbVec1.size()) {
            pp = (Pdb)pdbVec1.elementAt(i);
            int no = pp.getResidueNo();
            String resid = pp.getResidue().trim();
            atoms = pp.getAtomVec();
            index = Collections.binarySearch(pdbVec2, new Pdb(no), new PdbComparator());
            if (index > -1) {
                int j;
                pp2 = (Pdb)pdbVec2.elementAt(index);
                pp2.setResidue(resid);
                if (resid.equals("PRO")) {
                    atomVec = pp2.getAtomVec();
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("CA")) {
                            ca = cc.getXYZ();
                        }
                        if (atom.equals("HA")) {
                            ha = cc.getXYZ();
                        } else if (atom.equals("N")) {
                            n = cc.getXYZ();
                        } else if (atom.equals("H")) {
                            nh = cc.getXYZ();
                        } else if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("CB")) {
                            cb = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                        }
                        ++j;
                    }
                    atomVecN = new Vector();
                    atomVecN.add(new Cartesian("N", n));
                    atomVecN.add(new Cartesian("CA", ca));
                    atomVecN.add(new Cartesian("HA", ha));
                    atomVecN.add(new Cartesian("CB", cb));
                    atomVecN.add(new Cartesian("C", co));
                    atomVecN.add(new Cartesian("O", o));
                    nToCaVec = this.internuclearVec(n, ca);
                    nToNhVec = this.internuclearVec(n, nh);
                    rg = ff.RgCal(nToNhVec, nToCaVec);
                    rgInv = rg.transpose();
                    matT = rgInv.times(Const.r1x9yInv.times(r2yInv.times(Const.rCBInv)));
                    double[] coordCb = new double[]{0.0, 1.49, 0.0};
                    double[] caToCbVec = matT.times(coordCb);
                    coordCb = ff.addCoords(ca, caToCbVec);
                    Matrix[] tetraCbMat = sp3.tetrahedral(coordCb, matT, Const.proCB);
                    Matrix matCG = tetraCbMat[1];
                    double[][] tetraCG = tetraCbMat[0].getArray();
                    atomVecN.add(new Cartesian("CG", tetraCG[0]));
                    atomVecN.add(new Cartesian("1HB", tetraCG[1]));
                    atomVecN.add(new Cartesian("2HB", tetraCG[2]));
                    double[] coordCG = tetraCG[0];
                    Matrix[] tetraCgMat = sp3.tetrahedral(coordCG, matCG, Const.proCG);
                    Matrix matCD = tetraCgMat[1];
                    double[][] tetraCD = tetraCgMat[0].getArray();
                    atomVecN.add(new Cartesian("CD", tetraCD[0]));
                    atomVecN.add(new Cartesian("1HG", tetraCD[1]));
                    atomVecN.add(new Cartesian("2HG", tetraCD[2]));
                    Matrix[] tetraCdMat = sp3.tetrahedral(tetraCD[0], matCD, Const.proCD);
                    double[][] tetraCD2 = tetraCdMat[0].getArray();
                    atomVecN.add(new Cartesian("1HD", tetraCD2[1]));
                    atomVecN.add(new Cartesian("2HD", tetraCD2[2]));
                    pdbVecN.add(new Pdb(no, resid, atomVecN));
                    atomVecN = new Vector();
                } else if (resid.equals("GLY")) {
                    atomVec = pp2.getAtomVec();
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("CA")) {
                            ca = cc.getXYZ();
                        } else if (atom.equals("HA")) {
                            ha = cc.getXYZ();
                        } else if (atom.equals("N")) {
                            n = cc.getXYZ();
                        } else if (atom.equals("H")) {
                            nh = cc.getXYZ();
                        } else if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("CB")) {
                            cb = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                        }
                        ++j;
                    }
                    atomVecN = new Vector();
                    atomVecN.add(new Cartesian("N", n));
                    atomVecN.add(new Cartesian("H", nh));
                    atomVecN.add(new Cartesian("CA", ca));
                    atomVecN.add(new Cartesian("1HA", ha));
                    ca2haVec = this.internuclearVec(ca, cb);
                    ha2 = new double[]{ca2haVec[0] * 1.09 / 1.531, ca2haVec[1] * 1.09 / 1.531, ca2haVec[2] * 1.09 / 1.531};
                    ha2 = ff.addCoords(ca, ha2);
                    atomVecN.add(new Cartesian("2HA", ha2));
                    atomVecN.add(new Cartesian("C", co));
                    atomVecN.add(new Cartesian("O", o));
                    pdbVecN.add(new Pdb(no, resid, atomVecN));
                    atomVecN = new Vector();
                } else {
                    pdbVecN.add(pp2);
                }
            }
            ++i;
        }
        return pdbVecN;
    }

    public String residueNameFromSeq(Vector seqVec, int resNo) {
        int i = 0;
        while (i < seqVec.size()) {
            Assign asg = (Assign)seqVec.elementAt(i);
            int no = asg.getResidueNo();
            String resid = asg.getResidueType().trim();
            if (resNo == no) {
                return resid;
            }
            ++i;
        }
        return null;
    }

    public Vector<Pdb> residueNameUpdate(Vector<Assign> seqVec, Vector<Pdb> pdbVec2) {
        Collections.sort(pdbVec2, new PdbComparator());
        String atom = "";
        String atomName2 = "";
        Vector atoms = new Vector();
        Vector<Object> atomVec = new Vector();
        Vector<Cartesian> atomVecN = new Vector<Cartesian>();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        Matrix mat = new Matrix(3, 3);
        double[] n = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ha = new double[3];
        double[] ha2 = new double[3];
        double[] cb = new double[3];
        double[] co = new double[3];
        double[] o = new double[3];
        double[] nToNhVec = new double[3];
        double[] nToCaVec = new double[3];
        double[] ca2haVec = new double[3];
        Assign asg = new Assign();
        Pdb pp2 = new Pdb();
        int index = -1;
        Cartesian cc = new Cartesian();
        double proPhi = -1.1344640137963142;
        Matrix r2yInv = mat.rotationMat(proPhi, "-y");
        Matrix rg = new Matrix(3, 3);
        Matrix rgInv = new Matrix(3, 3);
        PhiPsi ff = new PhiPsi();
        Matrix matT = new Matrix(3, 3);
        sp3Carbon sp3 = new sp3Carbon();
        double[][] coordsCB = new double[3][3];
        double[][] coordsCG = new double[3][3];
        double[][] coordsCD = new double[3][3];
        int i = 0;
        while (i < seqVec.size()) {
            asg = seqVec.elementAt(i);
            int no = asg.getResidueNo();
            String resid = asg.getResidueType().trim();
            index = Collections.binarySearch(pdbVec2, new Pdb(no), new PdbComparator());
            if (index > -1) {
                int j;
                pp2 = pdbVec2.elementAt(index);
                pp2.setResidue(resid);
                if (resid.equals("PRO")) {
                    atomVec = pp2.getAtomVec();
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("CA")) {
                            ca = cc.getXYZ();
                        }
                        if (atom.equals("HA")) {
                            ha = cc.getXYZ();
                        } else if (atom.equals("N")) {
                            n = cc.getXYZ();
                        } else if (atom.equals("H")) {
                            nh = cc.getXYZ();
                        } else if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("CB")) {
                            cb = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                        }
                        ++j;
                    }
                    atomVecN = new Vector();
                    atomVecN.add(new Cartesian("N", n));
                    atomVecN.add(new Cartesian("CA", ca));
                    atomVecN.add(new Cartesian("HA", ha));
                    atomVecN.add(new Cartesian("CB", cb));
                    atomVecN.add(new Cartesian("C", co));
                    atomVecN.add(new Cartesian("O", o));
                    nToCaVec = this.internuclearVec(n, ca);
                    nToNhVec = this.internuclearVec(n, nh);
                    rg = ff.RgCal(nToNhVec, nToCaVec);
                    rgInv = rg.transpose();
                    matT = rgInv.times(Const.r1x9yInv.times(r2yInv.times(Const.rCBInv)));
                    double[] coordCb = new double[]{0.0, 1.49, 0.0};
                    double[] caToCbVec = matT.times(coordCb);
                    coordCb = ff.addCoords(ca, caToCbVec);
                    Matrix[] tetraCbMat = sp3.tetrahedral(coordCb, matT, Const.proCB);
                    Matrix matCG = tetraCbMat[1];
                    double[][] tetraCG = tetraCbMat[0].getArray();
                    atomVecN.add(new Cartesian("CG", tetraCG[0]));
                    atomVecN.add(new Cartesian("1HB", tetraCG[1]));
                    atomVecN.add(new Cartesian("2HB", tetraCG[2]));
                    double[] coordCG = tetraCG[0];
                    Matrix[] tetraCgMat = sp3.tetrahedral(coordCG, matCG, Const.proCG);
                    Matrix matCD = tetraCgMat[1];
                    double[][] tetraCD = tetraCgMat[0].getArray();
                    atomVecN.add(new Cartesian("CD", tetraCD[0]));
                    atomVecN.add(new Cartesian("1HG", tetraCD[1]));
                    atomVecN.add(new Cartesian("2HG", tetraCD[2]));
                    Matrix[] tetraCdMat = sp3.tetrahedral(tetraCD[0], matCD, Const.proCD);
                    double[][] tetraCD2 = tetraCdMat[0].getArray();
                    atomVecN.add(new Cartesian("1HD", tetraCD2[1]));
                    atomVecN.add(new Cartesian("2HD", tetraCD2[2]));
                    pdbVecN.add(new Pdb(no, resid, atomVecN));
                    atomVecN = new Vector();
                } else if (resid.equals("GLY")) {
                    atomVec = pp2.getAtomVec();
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("CA")) {
                            ca = cc.getXYZ();
                        } else if (atom.equals("HA") || atom.equals("HA1") || atom.equals("1HA")) {
                            ha = cc.getXYZ();
                        } else if (atom.equals("N")) {
                            n = cc.getXYZ();
                        } else if (atom.equals("H") || atom.equals("HN")) {
                            nh = cc.getXYZ();
                        } else if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("CB")) {
                            cb = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                        }
                        ++j;
                    }
                    atomVecN = new Vector();
                    atomVecN.add(new Cartesian("N", n));
                    atomVecN.add(new Cartesian("HN", nh));
                    atomVecN.add(new Cartesian("CA", ca));
                    atomVecN.add(new Cartesian("HA1", ha));
                    ca2haVec = this.internuclearVec(ca, cb);
                    ha2 = new double[]{ca2haVec[0] * 1.09 / 1.531, ca2haVec[1] * 1.09 / 1.531, ca2haVec[2] * 1.09 / 1.531};
                    ha2 = ff.addCoords(ca, ha2);
                    atomVecN.add(new Cartesian("HA2", ha2));
                    atomVecN.add(new Cartesian("C", co));
                    atomVecN.add(new Cartesian("O", o));
                    pdbVecN.add(new Pdb(no, resid, atomVecN));
                    atomVecN = new Vector();
                } else {
                    pdbVecN.add(pp2);
                }
            }
            ++i;
        }
        return pdbVecN;
    }

    public Vector<Pdb> residueNameUpdateNoStr(Vector<Assign> seqVec, Vector<Pdb> pdbVec2) {
        Collections.sort(pdbVec2, new PdbComparator());
        String atom = "";
        String atomName2 = "";
        Vector atoms = new Vector();
        Vector atomVec = new Vector();
        Vector atomVecN = new Vector();
        Vector<Pdb> pdbVecN = new Vector<Pdb>();
        Matrix mat = new Matrix(3, 3);
        double[] n = new double[3];
        double[] nh = new double[3];
        double[] ca = new double[3];
        double[] ha = new double[3];
        double[] ha2 = new double[3];
        double[] cb = new double[3];
        double[] co = new double[3];
        double[] o = new double[3];
        double[] nToNhVec = new double[3];
        double[] nToCaVec = new double[3];
        double[] ca2haVec = new double[3];
        Assign asg = new Assign();
        Pdb pp2 = new Pdb();
        int index = -1;
        Cartesian cc = new Cartesian();
        double proPhi = -1.1344640137963142;
        Matrix r2yInv = mat.rotationMat(proPhi, "-y");
        Matrix rg = new Matrix(3, 3);
        Matrix rgInv = new Matrix(3, 3);
        PhiPsi ff = new PhiPsi();
        Matrix matT = new Matrix(3, 3);
        sp3Carbon sp3 = new sp3Carbon();
        double[][] coordsCB = new double[3][3];
        double[][] coordsCG = new double[3][3];
        double[][] coordsCD = new double[3][3];
        int i = 0;
        while (i < seqVec.size()) {
            asg = seqVec.elementAt(i);
            int no = asg.getResidueNo();
            String resid = asg.getResidueType().trim();
            index = Collections.binarySearch(pdbVec2, new Pdb(no), new PdbComparator());
            if (index > -1) {
                pp2 = pdbVec2.elementAt(index);
                pp2.setResidue(resid);
                pdbVecN.add(pp2);
            }
            ++i;
        }
        return pdbVecN;
    }

    public boolean isInPdbClusters(Vector vecEnsemblePdb, Vector vecPdb, double rmsThreshold) {
        boolean isInClusters = false;
        int i = 0;
        while (i < vecEnsemblePdb.size()) {
            Vector vecPdbTemp = (Vector)vecEnsemblePdb.elementAt(i);
            double rmsd = this.compRmsdBetwTwoPdbs(vecPdbTemp, vecPdb, true);
            if (rmsd < rmsThreshold) {
                isInClusters = true;
            }
            ++i;
        }
        return isInClusters;
    }

    public boolean isInPointClusters(Vector vecPoints, Cartesian cc, double rmsThreshold) {
        boolean isInClusters = false;
        Cartesian cc0 = new Cartesian();
        int i = 0;
        while (i < vecPoints.size()) {
            Cartesian ccTemp = (Cartesian)vecPoints.elementAt(i);
            double rmsd = cc.measureDist(ccTemp, cc);
            if (rmsd < rmsThreshold) {
                isInClusters = true;
            }
            ++i;
        }
        return isInClusters;
    }

    public void doReadPdbFragments(String src, String strOut, String strInput) throws JampackException {
        boolean isDebug = true;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        String strInPdb = "";
        String strOutStructureName = "";
        String strStartRes = "";
        String strEndRes = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("INPDBNAME")) {
                strInPdb = paraMap.get("INPDBNAME");
            }
            if (paraMap.containsKey("OUTSTRUCTURENAME")) {
                strOutStructureName = paraMap.get("OUTSTRUCTURENAME");
            }
            if (paraMap.containsKey("STARTRESIDUES")) {
                strStartRes = paraMap.get("STARTRESIDUES");
            }
            if (paraMap.containsKey("ENDRESIDUES")) {
                strEndRes = paraMap.get("ENDRESIDUES");
            }
            ++i;
        }
        String userDirTemp = System.getProperty("user.dir");
        String pdbFile = String.valueOf(userDirTemp) + strInPdb;
        Vector<Pdb> vecInPdb = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVecNew = new Vector<Pdb>();
        Vector vecStartRes = asg.getOrder(strStartRes);
        Vector vecEndRes = asg.getOrder(strEndRes);
        int j = 0;
        while (j < vecStartRes.size()) {
            String strStartNo = (String)vecStartRes.elementAt(j);
            int startResNo = Integer.parseInt(strStartNo);
            String strEndNo = (String)vecEndRes.elementAt(j);
            int endResNo = Integer.parseInt(strEndNo);
            i = 0;
            while (i < vecInPdb.size()) {
                Pdb pdb = vecInPdb.elementAt(i);
                int res_no = pdb.getResidueNo();
                if (res_no >= startResNo && res_no <= endResNo) {
                    pdbVecNew.add(pdb);
                }
                ++i;
            }
            ++j;
        }
        Collections.sort(pdbVecNew, new PdbComparator());
        String fileName = String.valueOf(userDirTemp) + strOutStructureName;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("REMARK :  extracted fragments of " + strInPdb);
            pp.printToFile(pdbVecNew, fileName, out);
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Total time for extracting structure fragments:  " + totalTime + " minutes");
    }

    public double compRmsdBetwTwoPdbs(Vector vecPdb1, Vector vecPdb2, boolean isHeavy) {
        double sum = 0.0;
        Vector<Object> atomVec1 = new Vector();
        Vector<Object> atomVec2 = new Vector();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        String atomName1 = "";
        String atomName2 = "";
        int i = 0;
        while (i < vecPdb1.size()) {
            Pdb pdb1 = (Pdb)vecPdb1.elementAt(i);
            int resNo1 = pdb1.getResidueNo();
            atomVec1 = pdb1.getAtomVec();
            int k = 0;
            while (k < atomVec1.size()) {
                ccA = (Cartesian)atomVec1.elementAt(k);
                atomName1 = ccA.getAtom();
                coordA = ccA.getXYZ();
                if (atomName1.equalsIgnoreCase("C") || atomName1.equalsIgnoreCase("CA") || atomName1.equalsIgnoreCase("N") || atomName1.equalsIgnoreCase("O")) {
                    int j = 0;
                    while (j < vecPdb2.size()) {
                        Pdb pdb2 = (Pdb)vecPdb2.elementAt(j);
                        atomVec2 = pdb2.getAtomVec();
                        int resNo2 = pdb2.getResidueNo();
                        int h = 0;
                        while (h < atomVec2.size()) {
                            ccB = (Cartesian)atomVec2.elementAt(h);
                            atomName2 = ccB.getAtom();
                            if ((atomName2.equalsIgnoreCase("C") || atomName2.equalsIgnoreCase("CA") || atomName2.equalsIgnoreCase("N") || atomName2.equalsIgnoreCase("O")) && atomName1.equalsIgnoreCase(atomName2) && resNo2 == resNo1) {
                                coordB = ccB.getXYZ();
                                double distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                                sum += distance * distance;
                            }
                            ++h;
                        }
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
        double rms = Math.sqrt(sum / (double)(4 * vecPdb1.size()));
        return rms;
    }

    public boolean compRmsdRotXrayBB(Vector vecPdbXray, Vector vecRotam, int resNo, double[] rmsd, boolean isHeavy) {
        int ind = Collections.binarySearch(vecPdbXray, new Pdb(resNo), new PdbComparator());
        if (ind < 0) {
            return false;
        }
        Pdb pdb = new Pdb();
        Pdb pdbA = (Pdb)vecPdbXray.elementAt(ind);
        Vector<Pdb> pdbAVec = new Vector<Pdb>();
        pdbAVec.add(pdbA);
        String atom = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        double[] amide = new double[3];
        double[] amide1 = new double[3];
        double[] amide2 = new double[3];
        double[] ha = new double[3];
        double[] ca1 = new double[3];
        double[] ca2 = new double[3];
        double[] trans_vec = new double[3];
        PhiPsi ff = new PhiPsi();
        Matrix rgA = Matrix.identity(3, 3);
        int j = 0;
        while (j < atomVecA.size()) {
            cc = atomVecA.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecStr = this.internuclearVec(ca1, ha);
        double[] CaToNVecStr = this.internuclearVec(ca1, amide);
        Matrix rg = Matrix.identity(3, 3);
        rg = ff.RgCal(CaToHaVecStr, CaToNVecStr);
        Vector<Pdb> pdbANew = pdb.newPdb(pdbAVec, rg);
        Vector<Pdb> pdbVecNew1 = pdb.newPdb(vecPdbXray, rg);
        Pdb pdbTemp = pdbANew.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            }
            ++j;
        }
        Pdb pdbRotA = (Pdb)vecRotam.elementAt(0);
        atomVec = pdbRotA.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecRot = this.internuclearVec(ca2, ha);
        double[] CaToNVecRot = this.internuclearVec(ca2, amide);
        rgA = ff.RgCal(CaToHaVecRot, CaToNVecRot);
        Vector<Pdb> rotamVecNewA_temp = pdb.newPdb(vecRotam, rgA);
        pdbTemp = rotamVecNewA_temp.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            }
            ++j;
        }
        trans_vec = this.internuclearVec(ca2, ca1);
        Vector<Pdb> rotamVecNewA = pdb.newPdbByTranslation(rotamVecNewA_temp, trans_vec);
        Pdb pdb1 = rotamVecNewA.elementAt(0);
        Pdb pdb2 = pdbVecNew1.elementAt(ind);
        rmsd[0] = isHeavy ? this.compResRmsd(pdb1, pdb2) : this.compResRmsdPairWise(pdb1, pdb2);
        return true;
    }

    public double compResRmsd(Pdb pdb1, Pdb pdb2) {
        double rmsd = 0.0;
        double distance = 0.0;
        Vector<Object> atomVec1 = new Vector();
        Vector<Object> atomVec2 = new Vector();
        atomVec1 = pdb1.getAtomVec();
        atomVec2 = pdb2.getAtomVec();
        String resName = pdb1.getResidue();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        String atomName1 = "";
        String atomName2 = "";
        int counter = 0;
        int i = 0;
        while (i < atomVec1.size()) {
            ccA = (Cartesian)atomVec1.elementAt(i);
            atomName1 = ccA.getAtom();
            if (atomName1.equalsIgnoreCase("HN")) {
                atomName1 = "H";
            }
            coordA = ccA.getXYZ();
            if (!(atomName1.substring(0, 1).equalsIgnoreCase("H") || atomName1.equalsIgnoreCase("C") || atomName1.equalsIgnoreCase("O"))) {
                int j = 0;
                while (j < atomVec2.size()) {
                    ccB = (Cartesian)atomVec2.elementAt(j);
                    atomName2 = ccB.getAtom();
                    if (atomName1.equalsIgnoreCase(atomName2)) {
                        coordB = ccB.getXYZ();
                        distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                        rmsd += distance * distance;
                        ++counter;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return Math.sqrt(rmsd / (double)counter);
    }

    public double compResRmsdPairWise(Pdb pdb1, Pdb pdb2) {
        double rmsd = 0.0;
        double distance = 0.0;
        Vector<Object> atomVec1 = new Vector();
        Vector<Object> atomVec2 = new Vector();
        atomVec1 = pdb1.getAtomVec();
        atomVec2 = pdb2.getAtomVec();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        String atomName1 = "";
        String atomName2 = "";
        int counter = 0;
        int i = 0;
        while (i < atomVec1.size()) {
            ccA = (Cartesian)atomVec1.elementAt(i);
            atomName1 = ccA.getAtom();
            if (atomName1.equalsIgnoreCase("HN")) {
                atomName1 = "H";
            }
            if (!(atomName1.equalsIgnoreCase("HN") || atomName1.equalsIgnoreCase("H") || atomName1.equalsIgnoreCase("C") || atomName1.equalsIgnoreCase("O"))) {
                coordA = ccA.getXYZ();
                int j = 0;
                while (j < atomVec2.size()) {
                    ccB = (Cartesian)atomVec2.elementAt(j);
                    atomName2 = ccB.getAtom();
                    if (atomName1.equalsIgnoreCase(atomName2)) {
                        coordB = ccB.getXYZ();
                        distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                        rmsd += distance * distance;
                        ++counter;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return Math.sqrt(rmsd / (double)counter);
    }

    public Vector compDistPatternForSSEPacking(Vector pdbVecA, Vector pdbVecB, double DistBound) {
        int h;
        int resNoB;
        int k;
        int j;
        int resNoA;
        Vector<Hdist> vecHdist = new Vector<Hdist>();
        Pdb pdbA = new Pdb();
        Pdb pdbB = new Pdb();
        Vector<Object> atomVecA = new Vector();
        Vector<Object> atomVecB = new Vector();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        String resNameA = "";
        String resNameB = "";
        String nucleusA = "";
        String nucleusB = "";
        String atomA = "";
        String atomB = "";
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        double distance = 0.0;
        int i = 0;
        while (i < pdbVecA.size()) {
            pdbA = (Pdb)pdbVecA.elementAt(i);
            atomVecA = pdbA.getAtomVec();
            resNoA = pdbA.getResidueNo();
            resNameA = pdbA.getResidue();
            j = 0;
            while (j < atomVecA.size()) {
                ccA = (Cartesian)atomVecA.elementAt(j);
                atomA = ccA.getAtom();
                nucleusA = atomA.substring(0, 1);
                coordA = ccA.getXYZ();
                if (atomA.equalsIgnoreCase("HN")) {
                    atomA = "H";
                }
                if (nucleusA.equalsIgnoreCase("H")) {
                    k = 0;
                    while (k < pdbVecB.size()) {
                        pdbB = (Pdb)pdbVecB.elementAt(k);
                        atomVecB = pdbB.getAtomVec();
                        resNoB = pdbB.getResidueNo();
                        resNameB = pdbB.getResidue();
                        h = 0;
                        while (h < atomVecB.size()) {
                            ccB = (Cartesian)atomVecB.elementAt(h);
                            atomB = ccB.getAtom();
                            nucleusB = atomB.substring(0, 1);
                            coordB = ccB.getXYZ();
                            if (atomB.equalsIgnoreCase("HN")) {
                                atomB = "H";
                            }
                            if (nucleusB.equalsIgnoreCase("H") && (distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]))) < DistBound) {
                                vecHdist.add(new Hdist(ccA, resNoA, resNameA, atomA, ccB, resNoB, resNameB, atomB, distance));
                            }
                            ++h;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pdbVecB.size()) {
            pdbA = (Pdb)pdbVecB.elementAt(i);
            atomVecA = pdbA.getAtomVec();
            resNoA = pdbA.getResidueNo();
            resNameA = pdbA.getResidue();
            j = 0;
            while (j < atomVecA.size()) {
                ccA = (Cartesian)atomVecA.elementAt(j);
                atomA = ccA.getAtom();
                nucleusA = atomA.substring(0, 1);
                coordA = ccA.getXYZ();
                if (atomA.equalsIgnoreCase("HN")) {
                    atomA = "H";
                }
                if (nucleusA.equalsIgnoreCase("H")) {
                    k = 0;
                    while (k < pdbVecA.size()) {
                        pdbB = (Pdb)pdbVecA.elementAt(k);
                        atomVecB = pdbB.getAtomVec();
                        resNoB = pdbB.getResidueNo();
                        resNameB = pdbB.getResidue();
                        h = 0;
                        while (h < atomVecB.size()) {
                            ccB = (Cartesian)atomVecB.elementAt(h);
                            atomB = ccB.getAtom();
                            nucleusB = atomB.substring(0, 1);
                            coordB = ccB.getXYZ();
                            if (atomB.equalsIgnoreCase("HN")) {
                                atomB = "H";
                            }
                            if (nucleusB.equalsIgnoreCase("H") && (distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]))) < DistBound) {
                                vecHdist.add(new Hdist(ccA, resNoA, resNameA, atomA, ccB, resNoB, resNameB, atomB, distance));
                            }
                            ++h;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return vecHdist;
    }

    public Vector compDistPatternFromPairRotams(int resNoA, int resNoB, Pdb pdbA, Pdb pdbB, double DistBound) {
        int k;
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Vector<Cartesian> atomVecB = pdbB.getAtomVec();
        String firstResName = pdbA.getResidue();
        String secondResName = pdbB.getResidue();
        Vector<Hdist> vecHdist = new Vector<Hdist>();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        String atomA = "";
        String atomB = "";
        String nucleusA = "";
        String nucleusB = "";
        double distance = 0.0;
        int i = 0;
        while (i < atomVecA.size()) {
            ccA = atomVecA.elementAt(i);
            atomA = ccA.getAtom();
            nucleusA = atomA.substring(0, 1);
            if (nucleusA.equalsIgnoreCase("H")) {
                coordA = ccA.getXYZ();
                k = 0;
                while (k < atomVecB.size()) {
                    ccB = atomVecB.elementAt(k);
                    atomB = ccB.getAtom();
                    nucleusB = atomB.substring(0, 1);
                    coordB = ccB.getXYZ();
                    if (nucleusB.equalsIgnoreCase("H") && (distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]))) < DistBound) {
                        vecHdist.add(new Hdist(ccA, resNoA, firstResName, atomA, ccB, resNoB, secondResName, atomB, distance));
                    }
                    ++k;
                }
            }
            ++i;
        }
        i = 0;
        while (i < atomVecB.size()) {
            ccB = atomVecB.elementAt(i);
            atomB = ccB.getAtom();
            nucleusB = atomB.substring(0, 1);
            if (nucleusB.equalsIgnoreCase("H")) {
                coordB = ccA.getXYZ();
                k = 0;
                while (k < atomVecA.size()) {
                    ccA = atomVecA.elementAt(k);
                    atomA = ccA.getAtom();
                    nucleusA = atomA.substring(0, 1);
                    coordA = ccA.getXYZ();
                    if (nucleusA.equalsIgnoreCase("H") && (distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]))) < DistBound) {
                        vecHdist.add(new Hdist(ccB, resNoB, secondResName, atomB, ccA, resNoA, firstResName, atomA, distance));
                    }
                    ++k;
                }
            }
            ++i;
        }
        return vecHdist;
    }

    public Vector<Hdist> compDistPatternForRotam(Vector rotamVec, int resNo, Vector pdbVec, double DistBound) {
        Vector<Pdb> pdbVecN = pdbVec;
        Vector pdbRotamNewA = rotamVec;
        int noA = resNo;
        int ind1 = Collections.binarySearch(pdbVecN, new Pdb(noA), new PdbComparator());
        Pdb pdbA = (Pdb)pdbVecN.elementAt(ind1);
        Vector<Pdb> pdbAVec = new Vector<Pdb>();
        pdbAVec.add(pdbA);
        Pdb pdb = new Pdb();
        PhiPsi ff = new PhiPsi();
        String atom = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        String resName = pdbA.getResidue();
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] amide = new double[3];
        double[] amide1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh = new double[3];
        double[] ha = new double[3];
        double[] ca1 = new double[3];
        double[] ca_temp = new double[3];
        double[] ca2 = new double[3];
        double[] trans_vec = new double[3];
        Matrix rgA = Matrix.identity(3, 3);
        int j = 0;
        while (j < atomVecA.size()) {
            cc = atomVecA.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2") || atom.equals("HA1") || atom.equals("HA3")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecStr = pdb.internuclearVec(ca1, ha);
        double[] CaToNVecStr = pdb.internuclearVec(ca1, amide);
        Matrix rg = Matrix.identity(3, 3);
        rg = ff.RgCal(CaToHaVecStr, CaToNVecStr);
        Vector<Pdb> pdbANew = pdb.newPdb(pdbAVec, rg);
        Vector<Pdb> pdbVecNew1 = pdb.newPdb(pdbVecN, rg);
        Pdb pdbTemp = pdbANew.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca_temp = cc.getXYZ();
            }
            ++j;
        }
        Pdb pdbRotA = (Pdb)pdbRotamNewA.elementAt(0);
        atomVec = pdbRotA.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecRot = pdb.internuclearVec(ca2, ha);
        double[] CaToNVecRot = pdb.internuclearVec(ca2, amide);
        rgA = ff.RgCal(CaToHaVecRot, CaToNVecRot);
        Vector<Pdb> rotamVecNewA_temp = pdb.newPdb(pdbRotamNewA, rgA);
        pdbTemp = rotamVecNewA_temp.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            }
            ++j;
        }
        trans_vec = pdb.internuclearVec(ca2, ca_temp);
        Vector<Pdb> rotamVecNewA = pdb.newPdbByTranslation(rotamVecNewA_temp, trans_vec);
        pdbA = rotamVecNewA.elementAt(0);
        Pdb pp = new Pdb();
        pdbVecN = pdbVecNew1;
        ind1 = Collections.binarySearch(pdbVecN, new Pdb(noA), new PdbComparator());
        Pdb pdb222 = pdbVecN.elementAt(ind1);
        double rmsd = pdb.compResRmsd(pdbA, pdb222);
        atomVecA = pdbA.getAtomVec();
        int firstResNo = resNo;
        String firstResName = pdbA.getResidue();
        int secondResNo = 0;
        String secondResName = "";
        String atomA = "";
        String atomB = "";
        cc = new Cartesian();
        String nucleusA = "";
        String nucleusB = "";
        double distance = 0.0;
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        Vector<Hdist> vecHdist = new Vector<Hdist>();
        int i = 0;
        while (i < atomVecA.size()) {
            ccA = atomVecA.elementAt(i);
            atomA = ccA.getAtom();
            nucleusA = atomA.substring(0, 1);
            Peak pk = new Peak();
            String HeavyA = "";
            if (nucleusA.equalsIgnoreCase("H")) {
                HeavyA = pk.GetHeavyAtomFromProton(resName, atomA);
            }
            if (atomA.equalsIgnoreCase("HN")) {
                atomA = "H";
            }
            if (!(atomA.equalsIgnoreCase("HN") || atomA.equalsIgnoreCase("HA") || atomA.equalsIgnoreCase("H") || atomA.equalsIgnoreCase("HA1") || atomA.equalsIgnoreCase("HA2") || !nucleusA.equalsIgnoreCase("H"))) {
                coordA = ccA.getXYZ();
                j = 0;
                while (j < pdbVecN.size()) {
                    Pdb pdbB = pdbVecN.elementAt(j);
                    Vector<Cartesian> atomVecB = pdbB.getAtomVec();
                    secondResNo = pdbB.getResidueNo();
                    secondResName = pdbB.getResidue();
                    int k = 0;
                    while (k < atomVecB.size()) {
                        ccB = atomVecB.elementAt(k);
                        atomB = ccB.getAtom();
                        nucleusB = atomB.substring(0, 1);
                        coordB = ccB.getXYZ();
                        if (atomB.equalsIgnoreCase("HN")) {
                            atomB = "H";
                        }
                        if ((resNo == secondResNo && atomB.substring(0, 1).equalsIgnoreCase("H") || atomB.equalsIgnoreCase("H") || atomB.equalsIgnoreCase("HN") || atomB.equalsIgnoreCase("HA")) && (distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]))) < DistBound) {
                            vecHdist.add(new Hdist(ccA, firstResNo, firstResName, atomA, ccB, secondResNo, secondResName, atomB, distance));
                            vecHdist.add(new Hdist(ccB, secondResNo, secondResName, atomB, ccA, firstResNo, firstResName, atomA, distance));
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return vecHdist;
    }

    public Vector compDistPatternForRotam_old(Vector rotamVec, int resNo, Vector pdbVec, double DistBound) {
        Vector<Pdb> pdbVecN = pdbVec;
        Vector pdbRotamNewA = rotamVec;
        int noA = resNo;
        int ind1 = Collections.binarySearch(pdbVecN, new Pdb(noA), new PdbComparator());
        Pdb pdbA = (Pdb)pdbVecN.elementAt(ind1);
        Vector<Pdb> pdbAVec = new Vector<Pdb>();
        pdbAVec.add(pdbA);
        Pdb pdb = new Pdb();
        PhiPsi ff = new PhiPsi();
        String atom = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] amide = new double[3];
        double[] amide1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh = new double[3];
        double[] ca1 = new double[3];
        double[] ca2 = new double[3];
        double[] trans_vec = new double[3];
        Matrix rgA = Matrix.identity(3, 3);
        int j = 0;
        while (j < atomVecA.size()) {
            cc = atomVecA.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("H") || atom.equals("NH")) {
                nh = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVecStr = pdb.internuclearVec(amide, nh);
        double[] nToCAVecStr = pdb.internuclearVec(amide, ca1);
        Matrix rg = Matrix.identity(3, 3);
        rg = ff.RgCal(nToNHVecStr, nToCAVecStr);
        Vector<Pdb> pdbANew = pdb.newPdb(pdbAVec, rg);
        Vector<Pdb> pdbVecNew1 = pdb.newPdb(pdbVecN, rg);
        Pdb pdbTemp = pdbANew.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide1 = cc.getXYZ();
            }
            ++j;
        }
        Pdb pdbRotA = (Pdb)pdbRotamNewA.elementAt(0);
        atomVec = pdbRotA.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("H") || atom.equals("NH")) {
                nh = cc.getXYZ();
            }
            ++j;
        }
        double[] nToNHVecRot = pdb.internuclearVec(amide, nh);
        double[] nToCAVecRot = pdb.internuclearVec(amide, ca2);
        rgA = ff.RgCal(nToNHVecRot, nToCAVecRot);
        Vector<Pdb> rotamVecNewA_temp = pdb.newPdb(pdbRotamNewA, rgA);
        pdbTemp = rotamVecNewA_temp.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide2 = cc.getXYZ();
            }
            ++j;
        }
        trans_vec = pdb.internuclearVec(amide2, amide1);
        Vector<Pdb> rotamVecNewA = pdb.newPdbByTranslation(rotamVecNewA_temp, trans_vec);
        pdbA = rotamVecNewA.elementAt(0);
        pdbVecN = pdbVecNew1;
        ind1 = Collections.binarySearch(pdbVecN, new Pdb(noA), new PdbComparator());
        Pdb pdb222 = pdbVecN.elementAt(ind1);
        double rmsd = pdb.compResRmsd(pdbA, pdb222);
        System.out.print("The rmsd between original residue and rotmaer is : " + rmsd);
        atomVecA = pdbA.getAtomVec();
        int firstResNo = pdbA.getResidueNo();
        String firstResName = pdbA.getResidue();
        int secondResNo = 0;
        String secondResName = "";
        String atomA = "";
        String atomB = "";
        cc = new Cartesian();
        String nucleusA = "";
        String nucleusB = "";
        double distance = 0.0;
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        System.out.println(" The following shows HNs that intereact with all protons from: " + firstResName + "-" + firstResNo);
        Vector<Hdist> vecHdist = new Vector<Hdist>();
        int i = 0;
        while (i < atomVecA.size()) {
            ccA = atomVecA.elementAt(i);
            atomA = ccA.getAtom();
            nucleusA = atomA.substring(0, 1);
            if (nucleusA.equalsIgnoreCase("H")) {
                System.out.println("========================");
                System.out.println("The proton in " + firstResName + "-" + firstResNo + " is: " + atomA);
                coordA = ccA.getXYZ();
                j = 0;
                while (j < pdbVecN.size()) {
                    Pdb pdbB = pdbVecN.elementAt(j);
                    Vector<Cartesian> atomVecB = pdbB.getAtomVec();
                    secondResNo = pdbB.getResidueNo();
                    secondResName = pdbB.getResidue();
                    int k = 0;
                    while (k < atomVecB.size()) {
                        ccB = atomVecB.elementAt(k);
                        atomB = ccB.getAtom();
                        nucleusB = atomB.substring(0, 1);
                        coordB = ccB.getXYZ();
                        if ((atomB.equalsIgnoreCase("H") || atomB.equalsIgnoreCase("HN") || atomB.equalsIgnoreCase("HA")) && (distance = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]))) < DistBound) {
                            vecHdist.add(new Hdist(ccA, firstResNo, firstResName, atomA, ccB, secondResNo, secondResName, atomB, distance));
                            System.out.println(" The H1 is:" + pdbB.getResidue() + pdbB.getResidueNo() + "-" + atomB + " " + "distance=" + distance);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return vecHdist;
    }

    public boolean measureDisXray(Vector pdbVec, int noA, String residueA, String nucleusA, int noB, String residueB, String nucleusB, double[] distance) {
        int ind1 = Collections.binarySearch(pdbVec, new Pdb(noA), new PdbComparator());
        int ind2 = Collections.binarySearch(pdbVec, new Pdb(noB), new PdbComparator());
        if (ind1 < 0 || ind2 < 0) {
            return false;
        }
        if (nucleusA.equalsIgnoreCase("HN")) {
            nucleusA = "H";
        }
        if (nucleusB.equalsIgnoreCase("HN")) {
            nucleusB = "H";
        } else if (residueB.equalsIgnoreCase("ALA") && nucleusB.equalsIgnoreCase("HB")) {
            nucleusB = "CB";
        } else if (residueB.equalsIgnoreCase("ILE") && nucleusB.equalsIgnoreCase("HG2")) {
            nucleusB = "CG2";
        } else if (residueB.equalsIgnoreCase("ILE") && nucleusB.equalsIgnoreCase("HD1")) {
            nucleusB = "CD1";
        } else if (residueB.equalsIgnoreCase("LEU") && nucleusB.equalsIgnoreCase("HD1")) {
            nucleusB = "CD1";
        } else if (residueB.equalsIgnoreCase("LEU") && nucleusB.equalsIgnoreCase("HD2")) {
            nucleusB = "CD2";
        } else if (residueB.equalsIgnoreCase("VAL") && nucleusB.equalsIgnoreCase("HG1")) {
            nucleusB = "CG1";
        } else if (residueB.equalsIgnoreCase("VAL") && nucleusB.equalsIgnoreCase("HG2")) {
            nucleusB = "CG2";
        } else if (residueB.equalsIgnoreCase("THR") && nucleusB.equalsIgnoreCase("HG2")) {
            nucleusB = "CG2";
        }
        Pdb pdbA = (Pdb)pdbVec.elementAt(ind1);
        Pdb pdbB = (Pdb)pdbVec.elementAt(ind2);
        String atom = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Vector<Cartesian> atomVecB = pdbB.getAtomVec();
        Cartesian cc = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        boolean found = false;
        i = 0;
        while (i < atomVecA.size()) {
            cc = atomVecA.elementAt(i);
            atom = cc.getAtom();
            if (atom.equalsIgnoreCase(nucleusA)) {
                coordA = cc.getXYZ();
                found = true;
            }
            ++i;
        }
        if (!found) {
            return found;
        }
        found = false;
        i = 0;
        while (i < atomVecB.size()) {
            cc = atomVecB.elementAt(i);
            atom = cc.getAtom();
            if (atom.equalsIgnoreCase(nucleusB)) {
                coordB = cc.getXYZ();
                found = true;
            }
            ++i;
        }
        if (!found) {
            return found;
        }
        distance[0] = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
        return true;
    }

    public boolean measurePackDisAllRotamers(Vector pdbVecA, Vector pdbVecB, int noA, String nucleusA, int noB, String nucleusB, double lower, double upper, double[] disRMS, double[] distance) {
        int ind1 = Collections.binarySearch(pdbVecA, new Pdb(noA), new PdbComparator());
        int ind2 = Collections.binarySearch(pdbVecB, new Pdb(noB), new PdbComparator());
        if (ind1 < 0 || ind2 < 0) {
            return false;
        }
        if (nucleusA.equalsIgnoreCase("H")) {
            nucleusA = "HN";
        }
        if (nucleusB.equalsIgnoreCase("H")) {
            nucleusB = "HN";
        }
        Pdb pdbA = (Pdb)pdbVecA.elementAt(ind1);
        Pdb pdbB = (Pdb)pdbVecB.elementAt(ind2);
        String atomA = "";
        String atomB = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Vector<Cartesian> atomVecB = pdbB.getAtomVec();
        Cartesian cc = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        boolean foundA = false;
        boolean foundB = false;
        boolean found = false;
        TreeMap fromCBMap = new TreeMap();
        Residue resid = new Residue();
        double disDifMin = 1000.0;
        double distanceMin = 10000.0;
        double disDif = 0.0;
        i = 0;
        while (i < atomVecA.size()) {
            cc = atomVecA.elementAt(i);
            atomA = cc.getAtom();
            foundA = false;
            if (atomA.equalsIgnoreCase(nucleusA)) {
                coordA = cc.getXYZ();
                foundA = true;
            }
            if (nucleusA.length() >= 2) {
                String temp;
                if (nucleusA.substring(0, 1).equalsIgnoreCase("Q") && !nucleusA.substring(1, 2).equalsIgnoreCase("Q") && atomA.length() >= 2) {
                    temp = "H" + nucleusA.substring(1, nucleusA.length());
                    if (atomA.length() >= temp.length() && atomA.substring(0, temp.length()).equalsIgnoreCase(temp)) {
                        foundA = true;
                        coordA = cc.getXYZ();
                    }
                }
                if (nucleusA.substring(0, 2).equalsIgnoreCase("QQ") && atomA.length() >= 2) {
                    temp = "H" + nucleusA.substring(2, nucleusA.length());
                    if (atomA.length() >= temp.length() && atomA.substring(0, temp.length()).equalsIgnoreCase(temp)) {
                        foundA = true;
                        coordA = cc.getXYZ();
                    }
                }
            }
            if (foundA) {
                foundB = false;
                double disFromCB = 0.0;
                double dis2CB = 0.0;
                int j = 0;
                while (j < atomVecB.size()) {
                    disDif = 0.0;
                    cc = atomVecB.elementAt(j);
                    atomB = cc.getAtom();
                    if (atomB.equalsIgnoreCase(nucleusB)) {
                        foundB = true;
                        coordB = cc.getXYZ();
                        double dist_temp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                        if (dist_temp > lower && dist_temp < upper) {
                            disDif = 0.0;
                        } else if (dist_temp <= lower) {
                            disDif = lower - dist_temp;
                        } else if (dist_temp >= upper) {
                            disDif = dist_temp - upper;
                        }
                        if (disDif < disDifMin) {
                            disDifMin = disDif;
                            distanceMin = dist_temp;
                        }
                    }
                    if (nucleusB.length() >= 2) {
                        double dist_temp;
                        if (nucleusB.substring(0, 1).equalsIgnoreCase("Q") && !nucleusB.substring(1, 2).equalsIgnoreCase("Q") && atomB.length() >= 2) {
                            String temp = "H" + nucleusB.substring(1, nucleusB.length());
                            if (atomB.length() >= temp.length() && atomB.substring(0, temp.length()).equalsIgnoreCase(temp)) {
                                foundB = true;
                                coordB = cc.getXYZ();
                                dist_temp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                                if (dist_temp > lower && dist_temp < upper) {
                                    disDif = 0.0;
                                } else if (dist_temp <= lower) {
                                    disDif = lower - dist_temp;
                                } else if (dist_temp >= upper) {
                                    disDif = dist_temp - upper;
                                }
                                if (disDif < disDifMin) {
                                    disDifMin = disDif;
                                    distanceMin = dist_temp;
                                }
                            }
                        }
                        if (nucleusB.substring(0, 2).equalsIgnoreCase("QQ") && atomB.length() >= 2) {
                            String temp = "H" + nucleusB.substring(2, nucleusB.length());
                            if (atomB.length() >= temp.length() && atomB.substring(0, temp.length()).equalsIgnoreCase(temp)) {
                                foundB = true;
                                coordB = cc.getXYZ();
                                dist_temp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                                if (dist_temp > lower && dist_temp < upper) {
                                    disDif = 0.0;
                                } else if (dist_temp <= lower) {
                                    disDif = lower - dist_temp;
                                } else if (dist_temp >= upper) {
                                    disDif = dist_temp - upper;
                                }
                                if (disDif < disDifMin) {
                                    disDifMin = disDif;
                                    distanceMin = dist_temp;
                                }
                            }
                        }
                    }
                    ++j;
                }
                if (foundA & foundB) {
                    found = true;
                }
            }
            ++i;
        }
        disRMS[0] = disDifMin;
        distance[0] = distanceMin;
        if (!found) {
            System.out.println("debugging: Not found atom name");
        }
        return found;
    }

    public boolean measureDis(Vector pdbVec, int noA, String residueA, String nucleusA, int noB, String residueB, String nucleusB, double[] distance) {
        int ind1 = Collections.binarySearch(pdbVec, new Pdb(noA), new PdbComparator());
        int ind2 = Collections.binarySearch(pdbVec, new Pdb(noB), new PdbComparator());
        if (ind1 < 0 || ind2 < 0) {
            return false;
        }
        if (nucleusA.equalsIgnoreCase("HN")) {
            nucleusA = "H";
        }
        if (nucleusB.equalsIgnoreCase("HN")) {
            nucleusB = "H";
        }
        Pdb pdbA = (Pdb)pdbVec.elementAt(ind1);
        Pdb pdbB = (Pdb)pdbVec.elementAt(ind2);
        String atom = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Vector<Cartesian> atomVecB = pdbB.getAtomVec();
        Cartesian cc = new Cartesian();
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        boolean found = false;
        Map fromCBMap = new TreeMap();
        Residue resid = new Residue();
        i = 0;
        while (i < atomVecA.size()) {
            cc = atomVecA.elementAt(i);
            atom = cc.getAtom();
            if (atom.equalsIgnoreCase(nucleusA)) {
                coordA = cc.getXYZ();
                found = true;
            }
            ++i;
        }
        if (!found) {
            return found;
        }
        found = false;
        double disFromCB = 0.0;
        double dis2CB = 0.0;
        i = 0;
        while (i < atomVecB.size()) {
            cc = atomVecB.elementAt(i);
            atom = cc.getAtom();
            if (atom.equalsIgnoreCase(nucleusB)) {
                coordB = cc.getXYZ();
                distance[0] = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                return true;
            }
            if (!residueB.equals("PRO") && atom.equals("CB")) {
                coordB = cc.getXYZ();
                dis2CB = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                fromCBMap = resid.fromCB(residueB);
                if (fromCBMap.get(nucleusB) != null) {
                    disFromCB = (Double)fromCBMap.get(nucleusB);
                    distance[0] = noA == noB ? dis2CB - disFromCB * Math.cos(0.7853981633974483) : dis2CB - disFromCB * Math.cos(0.2617993877991494);
                    found = true;
                } else {
                    System.out.println(String.valueOf(residueB) + " " + nucleusB + " Can NOT be found");
                }
            }
            ++i;
        }
        if (!found) {
            return found;
        }
        return true;
    }

    public double compOverAllRmsdBetweenRotXray(Vector pdbBBVec, Vector asgVec, String rotSrc, Vector hnNoeVec, Vector cNoeVec, Vector pdbVecXray, double distBound, int pickNum) {
        Pdb pp = new Pdb();
        String rotamFile = "";
        Vector<Object> pdbRotam = new Vector();
        Vector pdbRotamNewStr = new Vector();
        Vector pdbRotamNewCS = new Vector();
        Vector pdbRotamNewRef = new Vector();
        double[] rmsd = new double[pdbBBVec.size()];
        RotaPattern rp = new RotaPattern();
        int counter = 0;
        double sum = 0.0;
        int i = 0;
        while (i < pdbBBVec.size()) {
            rmsd[i] = 0.0;
            Pdb pdb = (Pdb)pdbBBVec.elementAt(i);
            String resName = pdb.getResidue();
            int resNo = pdb.getResidueNo();
            if (resNo != 1 && resNo != 72) {
                if (resNo == 55) {
                    System.out.println("we stop hreee....");
                }
                Vector pdbRotVec = new Vector();
                if (resName.equalsIgnoreCase("GLY")) {
                    int ind1 = Collections.binarySearch(pdbBBVec, new Pdb(resNo), new PdbComparator());
                    Pdb pdbA = (Pdb)pdbBBVec.elementAt(ind1);
                    pdbRotVec.add(pdbA);
                    pdbRotamNewStr = pdbRotVec;
                } else {
                    rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
                    pdbRotam = pp.readPdb(rotamFile);
                    pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
                    pdbRotVec = pdbRotamNewCS = pp.nameConvert4SmallRotLibCS(pdbRotam);
                }
                int indRef = Collections.binarySearch(pdbBBVec, new Pdb(resNo), new PdbComparator());
                int[] index = new int[2];
                if (indRef >= 0) {
                    pdbRotamNewRef = rp.RefineRotLib(pdbRotVec, pdbBBVec, asgVec, hnNoeVec, cNoeVec, resNo, distBound, 1, index, pdbVecXray);
                }
                double[] rms = new double[1];
                Pdb pdb_temp = (Pdb)pdbRotamNewStr.elementAt(index[0]);
                Vector<Pdb> pdbRotamNewStr2 = new Vector<Pdb>();
                pdbRotamNewStr2.add(pdb_temp);
                boolean isHeavy = true;
                boolean hasRmsd = pp.compRmsdRotXrayBB(pdbVecXray, pdbRotamNewStr2, resNo, rms, isHeavy);
                if (hasRmsd && (double)index[1] / (double)pdbRotVec.size() >= 0.0) {
                    System.out.print("average number of peaks is: " + index[1] + "\n");
                    System.out.print("ratio between number of peaks and number of rotamers is: " + (double)index[1] / (double)pdbRotVec.size() + "\n");
                    System.out.print("resiudue No=" + resNo + " res name=" + resName + " rmsd=" + rms[0] + "\n");
                    System.out.println("=====================================");
                    rmsd[i] = rms[0];
                    sum += rms[0] * rms[0];
                    ++counter;
                }
            }
            ++i;
        }
        System.out.print("\noverall rmsd=" + Math.sqrt(sum / (double)counter) + " total num=" + counter + "\n");
        return Math.sqrt(sum / (double)counter);
    }

    public boolean isInAtomVec(Vector vecAtom, String atomName) {
        boolean isIn = false;
        int j = 0;
        while (j < vecAtom.size()) {
            Cartesian cc = (Cartesian)vecAtom.elementAt(j);
            String strTemp = cc.getAtom();
            if (strTemp.equalsIgnoreCase(atomName)) {
                isIn = true;
                break;
            }
            ++j;
        }
        return isIn;
    }

    public Vector<Pdb> OutputBackbone(Vector<Pdb> vecPdb) {
        Vector<Pdb> vecNewBB = new Vector<Pdb>();
        Pdb pdb = new Pdb();
        Vector<Object> atomVec = new Vector();
        double[] coord = new double[3];
        int i = 0;
        while (i < vecPdb.size()) {
            pdb = vecPdb.elementAt(i);
            atomVec = pdb.getAtomVec();
            int resNo = pdb.getResidueNo();
            String resName = pdb.getResidue();
            Vector<Cartesian> atomBBVec = new Vector<Cartesian>();
            int j = 0;
            while (j < atomVec.size()) {
                block8: {
                    String atomName;
                    block9: {
                        block7: {
                            Cartesian cc = (Cartesian)atomVec.elementAt(j);
                            coord = cc.getXYZ();
                            atomName = cc.getAtom();
                            boolean isAlreadyIn = false;
                            if (!atomName.equalsIgnoreCase("H") && !atomName.equalsIgnoreCase("HN") && !atomName.equalsIgnoreCase("HA") && !atomName.equalsIgnoreCase("N") && !atomName.equalsIgnoreCase("CA") && !atomName.equalsIgnoreCase("O") && !atomName.equalsIgnoreCase("C") && !atomName.equalsIgnoreCase("CB") && !atomName.equalsIgnoreCase("HB")) break block7;
                            if (this.isInAtomVec(atomBBVec, atomName)) break block8;
                            atomBBVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                        }
                        if (atomName.length() <= 2 || !atomName.substring(0, 2).equalsIgnoreCase("HA")) break block9;
                        if (this.isInAtomVec(atomBBVec, atomName)) break block8;
                        if (atomName.substring(0, 2).equalsIgnoreCase("HA")) {
                            atomBBVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                        }
                    }
                    if (!this.isInAtomVec(atomBBVec, atomName) && atomName.length() > 2 && atomName.substring(0, 2).equalsIgnoreCase("HB")) {
                        atomBBVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                    }
                }
                ++j;
            }
            vecNewBB.add(new Pdb(resNo, resName, atomBBVec));
            ++i;
        }
        return vecNewBB;
    }

    public Vector OutputBackboneNoCB(Vector vecPdb) {
        Vector<Pdb> vecNewBB = new Vector<Pdb>();
        Pdb pdb = new Pdb();
        Vector<Object> atomVec = new Vector();
        double[] coord = new double[3];
        int i = 0;
        while (i < vecPdb.size()) {
            pdb = (Pdb)vecPdb.elementAt(i);
            atomVec = pdb.getAtomVec();
            int resNo = pdb.getResidueNo();
            String resName = pdb.getResidue();
            Vector<Cartesian> atomBBVec = new Vector<Cartesian>();
            int j = 0;
            while (j < atomVec.size()) {
                Cartesian cc = (Cartesian)atomVec.elementAt(j);
                coord = cc.getXYZ();
                String atomName = cc.getAtom();
                if (atomName.equalsIgnoreCase("H") || atomName.equalsIgnoreCase("HN") || atomName.equalsIgnoreCase("HA") || atomName.equalsIgnoreCase("N") || atomName.equalsIgnoreCase("CA") || atomName.equalsIgnoreCase("O") || atomName.equalsIgnoreCase("C")) {
                    atomBBVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                }
                if (atomName.length() > 2 && atomName.substring(0, 2).equalsIgnoreCase("HA") && atomName.substring(0, 2).equalsIgnoreCase("HA")) {
                    atomBBVec.add(new Cartesian(atomName, coord[0], coord[1], coord[2]));
                }
                ++j;
            }
            vecNewBB.add(new Pdb(resNo, resName, atomBBVec));
            ++i;
        }
        return vecNewBB;
    }

    public Vector<Pdb> CombinRotBB(Vector<Pdb> rotamVec, Vector<Pdb> pdbVecN, int resNo) {
        String strComb;
        Cartesian ccCombin;
        Vector<Cartesian> atomVecCombin;
        Pdb pdbCombin;
        Pdb pp = new Pdb();
        Vector<Pdb> pdbRotamNewA = rotamVec;
        int noA = resNo;
        int ind1 = Collections.binarySearch(pdbVecN, new Pdb(noA), new PdbComparator());
        Pdb pdbA = pdbVecN.elementAt(ind1);
        Vector<Pdb> pdbAVec = new Vector<Pdb>();
        pdbAVec.add(pdbA);
        Pdb pdb = new Pdb();
        PhiPsi ff = new PhiPsi();
        String atom = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Pdb pdbTempRot = rotamVec.elementAt(0);
        String resName = pdbTempRot.getResidue();
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Cartesian ccA = new Cartesian();
        Cartesian ccB = new Cartesian();
        double[] amide = new double[3];
        double[] amide1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh = new double[3];
        double[] ha = new double[3];
        double[] ca1 = new double[3];
        double[] ca_temp = new double[3];
        double[] ca2 = new double[3];
        double[] trans_vec = new double[3];
        Matrix rgA = Matrix.identity(3, 3);
        int j = 0;
        while (j < atomVecA.size()) {
            cc = atomVecA.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecStr = pdb.internuclearVec(ca1, ha);
        double[] CaToNVecStr = pdb.internuclearVec(ca1, amide);
        Matrix rg = Matrix.identity(3, 3);
        rg = ff.RgCal(CaToHaVecStr, CaToNVecStr);
        Vector<Pdb> pdbANew = pdb.newPdb(pdbAVec, rg);
        Vector<Pdb> pdbVecNew1 = pdb.newPdb(pdbVecN, rg);
        Pdb pdbTemp = pdbANew.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca_temp = cc.getXYZ();
            }
            ++j;
        }
        Pdb pdbRotA = pdbRotamNewA.elementAt(0);
        atomVec = pdbRotA.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecRot = pdb.internuclearVec(ca2, ha);
        double[] CaToNVecRot = pdb.internuclearVec(ca2, amide);
        rgA = ff.RgCal(CaToHaVecRot, CaToNVecRot);
        Vector<Pdb> rotamVecNewA_temp = pdb.newPdb(pdbRotamNewA, rgA);
        pdbTemp = rotamVecNewA_temp.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            }
            ++j;
        }
        trans_vec = pdb.internuclearVec(ca2, ca_temp);
        Vector<Pdb> rotamVecNewA = pdb.newPdbByTranslation(rotamVecNewA_temp, trans_vec);
        Vector<Pdb> vecNewPdb = new Vector<Pdb>();
        Vector<Cartesian> vecAtom4Res = new Vector<Cartesian>();
        int i = 0;
        while (i < pdbANew.size()) {
            pdbCombin = pdbANew.elementAt(i);
            atomVecCombin = pdbCombin.getAtomVec();
            j = 0;
            while (j < atomVecCombin.size()) {
                ccCombin = atomVecCombin.elementAt(j);
                strComb = ccCombin.getAtom();
                if (strComb.equalsIgnoreCase("HN") || strComb.equalsIgnoreCase("H") || strComb.equalsIgnoreCase("N") || strComb.equalsIgnoreCase("CA") || strComb.equalsIgnoreCase("HA") || strComb.equalsIgnoreCase("C") || strComb.equalsIgnoreCase("O")) {
                    vecAtom4Res.add(ccCombin);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < rotamVecNewA.size()) {
            pdbCombin = rotamVecNewA.elementAt(i);
            atomVecCombin = pdbCombin.getAtomVec();
            j = 0;
            while (j < atomVecCombin.size()) {
                ccCombin = atomVecCombin.elementAt(j);
                strComb = ccCombin.getAtom();
                if (!(strComb.equalsIgnoreCase("HN") || strComb.equalsIgnoreCase("H") || strComb.equalsIgnoreCase("N") || strComb.equalsIgnoreCase("CA") || strComb.equalsIgnoreCase("HA") || strComb.equalsIgnoreCase("C") || strComb.equalsIgnoreCase("O"))) {
                    vecAtom4Res.add(ccCombin);
                }
                ++j;
            }
            ++i;
        }
        int ind2 = Collections.binarySearch(pdbVecNew1, new Pdb(resNo), new PdbComparator());
        i = 0;
        while (i < pdbVecNew1.size()) {
            Pdb pdbTemp2 = pdbVecNew1.elementAt(i);
            if (i == ind2) {
                vecNewPdb.add(new Pdb(resNo, resName, vecAtom4Res));
            } else {
                vecNewPdb.add(pdbTemp2);
            }
            ++i;
        }
        return vecNewPdb;
    }

    public Vector<Pdb> AllRotamersStructure(Vector pdbBBVec, String rotSrc) {
        Vector<Object> pdbRotam = new Vector();
        Vector pdbRotamNewStr = new Vector();
        Vector pdbRotamNewCS = new Vector();
        Vector pdbRotamNewRef = new Vector();
        Pdb pp = new Pdb();
        RotaPattern rp = new RotaPattern();
        Vector<Object> vecGrowPdb = new Vector();
        vecGrowPdb = pdbBBVec;
        int j = 0;
        while (j < pdbBBVec.size()) {
            Pdb pdb = (Pdb)vecGrowPdb.elementAt(j);
            String resName = pdb.getResidue();
            int resNo = pdb.getResidueNo();
            Vector pdbRotVec = new Vector();
            Vector<Pdb> vecSelectedRot = new Vector<Pdb>();
            pdbRotamNewStr = new Vector();
            if (resName.equalsIgnoreCase("GLY11")) {
                int ind1 = Collections.binarySearch(vecGrowPdb, new Pdb(resNo), new PdbComparator());
                Pdb pdbA = (Pdb)vecGrowPdb.elementAt(ind1);
                pdbRotVec.add(pdbA);
                vecSelectedRot.addAll(pdbRotVec);
            } else {
                String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
                pdbRotam = pp.readPdb(rotamFile);
                pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
                pdbRotVec = pdbRotamNewCS = pp.nameConvert4SmallRotLibCS(pdbRotam);
            }
            vecSelectedRot.addAll(pdbRotam);
            Vector<Pdb> vecTemp = pp.CombinRotBB(vecSelectedRot, (Vector<Pdb>)vecGrowPdb, resNo);
            vecGrowPdb = new Vector();
            vecGrowPdb = vecTemp;
            ++j;
        }
        return vecGrowPdb;
    }

    public Vector<Pdb> RotamSelectAndStructure(double csErrH, double csErrN, double csErrCA, Vector<Pdb> pdbBBVec, Vector asgVec, String rotSrc, Vector<Noesy> NoesyVec, double distBound, int pickNum, double constant) {
        Vector<Object> pdbRotam = new Vector();
        Vector pdbRotamNewStr = new Vector();
        Vector pdbRotamNewCS = new Vector();
        Vector pdbRotamNewRef = new Vector();
        Pdb pp = new Pdb();
        RotaPattern rp = new RotaPattern();
        Vector<Pdb> vecGrowPdb = new Vector();
        vecGrowPdb = pdbBBVec;
        int j = 0;
        while (j < pdbBBVec.size()) {
            Pdb pdb = vecGrowPdb.elementAt(j);
            String resName = pdb.getResidue();
            int resNo = pdb.getResidueNo();
            Vector pdbRotVec = new Vector();
            String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
            pdbRotam = pp.readRotamerPdb(rotamFile);
            pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
            pdbRotVec = pdbRotam;
            int indRef = Collections.binarySearch(vecGrowPdb, new Pdb(resNo), new PdbComparator());
            int[] index = new int[2];
            if (indRef >= 0) {
                pdbRotamNewRef = rp.RefineRotLibNew(csErrH, csErrN, csErrCA, pdbRotVec, vecGrowPdb, asgVec, NoesyVec, resNo, distBound, pickNum, pdbRotVec, constant);
            }
            if ((double)index[0] < 0.0) {
                index[0] = 0;
            }
            Vector<Pdb> vecSelectedRot = new Vector<Pdb>();
            Pdb pdb_temp = (Pdb)pdbRotamNewStr.elementAt(index[0]);
            vecSelectedRot.add(pdb_temp);
            Vector<Pdb> vecTemp = pp.CombinRotBB(pdbRotamNewRef, vecGrowPdb, resNo);
            vecGrowPdb = vecTemp;
            ++j;
        }
        return vecGrowPdb;
    }

    public Vector AlaninizeStructure(Vector vecPdb, boolean[] resIndex, String rotSrc) throws JampackException {
        Pdb pp = new Pdb();
        Vector<Object> pdbRotam = new Vector();
        String resName = "ALA";
        String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
        pdbRotam = pp.readPdb(rotamFile);
        Vector pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
        Vector<Object> pdbRotamPro = new Vector();
        String resNamePro = "PRO";
        String rotamFilePro = String.valueOf(rotSrc) + resNamePro.toLowerCase() + ".pdb";
        pdbRotamPro = pp.readPdb(rotamFilePro);
        Vector pdbRotamNewStrProAll = pp.nameConvert4SmallRotLibStr(pdbRotamPro);
        Pdb pp_temp = new Pdb();
        pp_temp = (Pdb)pdbRotamNewStrProAll.elementAt(0);
        Vector<Pdb> pdbRotamNewStrPro = new Vector<Pdb>();
        pdbRotamNewStrPro.add(pp_temp);
        Vector<Pdb> vecGrowPdb = new Vector<Pdb>();
        vecGrowPdb.addAll(vecPdb);
        int i = 0;
        while (i < vecPdb.size()) {
            Vector<Pdb> vecTemp;
            Pdb pdb = (Pdb)vecPdb.elementAt(i);
            int res_no = pdb.getResidueNo();
            String res = pdb.getResidue();
            if (!resIndex[i] && res.equalsIgnoreCase("PRO")) {
                vecTemp = pp.CombinRotBB(pdbRotamNewStrPro, vecGrowPdb, res_no);
                vecGrowPdb = new Vector();
                vecGrowPdb.addAll(vecTemp);
            } else if (!(resIndex[i] || res.equalsIgnoreCase("PRO") || res.equalsIgnoreCase("GLY"))) {
                vecTemp = pp.CombinRotBB(pdbRotamNewStr, vecGrowPdb, res_no);
                vecGrowPdb = new Vector();
                vecGrowPdb.addAll(vecTemp);
            }
            ++i;
        }
        Model md = new Model();
        Vector vecGrowPdbNew = new Vector();
        vecGrowPdbNew = md.BackonbeRotation(vecGrowPdb, vecPdb);
        return vecGrowPdbNew;
    }

    public Vector AlaninizeStructureResName(Vector vecPdb, String rotSrc) throws JampackException {
        Pdb pp = new Pdb();
        Vector<Object> pdbRotam = new Vector();
        String resName = "ALA";
        String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
        pdbRotam = pp.readPdb(rotamFile);
        Vector pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
        Vector<Pdb> pdbRotamGly = new Vector();
        String resNameGLY = "GLYTEMP";
        String rotamFileGly = String.valueOf(rotSrc) + resNameGLY.toLowerCase() + ".pdb";
        pdbRotamGly = pp.readPdb(rotamFileGly);
        Vector<Object> pdbRotamPro = new Vector();
        String resNamePro = "PRO";
        String rotamFilePro = String.valueOf(rotSrc) + resNamePro.toLowerCase() + ".pdb";
        pdbRotamPro = pp.readPdb(rotamFilePro);
        Vector pdbRotamNewStrProAll = pp.nameConvert4SmallRotLibStr(pdbRotamPro);
        Pdb pp_temp = new Pdb();
        pp_temp = (Pdb)pdbRotamNewStrProAll.elementAt(0);
        Vector<Pdb> pdbRotamNewStrPro = new Vector<Pdb>();
        pdbRotamNewStrPro.add(pp_temp);
        Vector<Pdb> vecGrowPdb = new Vector<Pdb>();
        vecGrowPdb.addAll(vecPdb);
        int i = 0;
        while (i < vecPdb.size()) {
            Vector<Pdb> vecTemp;
            Pdb pdb = (Pdb)vecPdb.elementAt(i);
            int res_no = pdb.getResidueNo();
            String res = pdb.getResidue();
            if (res.equalsIgnoreCase("PRO")) {
                vecTemp = pp.CombinRotBB(pdbRotamNewStrPro, vecGrowPdb, res_no);
                vecGrowPdb = new Vector();
                vecGrowPdb.addAll(vecTemp);
            } else if (res.equalsIgnoreCase("GLY")) {
                vecTemp = pp.CombinRotBB(pdbRotamGly, vecGrowPdb, res_no);
                vecGrowPdb = new Vector();
                vecGrowPdb.addAll(vecTemp);
            } else if (!res.equalsIgnoreCase("PRO") && !res.equalsIgnoreCase("GLY")) {
                vecTemp = pp.CombinRotBB(pdbRotamNewStr, vecGrowPdb, res_no);
                vecGrowPdb = new Vector();
                vecGrowPdb.addAll(vecTemp);
            }
            ++i;
        }
        Model md = new Model();
        Vector vecGrowPdbNew = new Vector();
        vecGrowPdbNew = md.BackonbeRotation(vecGrowPdb, vecPdb);
        return vecGrowPdbNew;
    }

    public Vector RotamSelectAndStructureNoClash(double csErrH, double csErrN, double csErrCA, Vector pdbBBVec, Vector asgVec, String rotSrc, Vector NoesyVec, double distBound, int pickNum, boolean[] resIndex) throws JampackException {
        Vector<Object> pdbRotam = new Vector();
        Vector pdbRotamNewStr = new Vector();
        Vector pdbRotamNewCS = new Vector();
        Vector pdbRotamNewRef = new Vector();
        Pdb pp = new Pdb();
        RotaPattern rp = new RotaPattern();
        Vector<Object> vecGrowPdb = new Vector();
        vecGrowPdb = this.RotamSelectAndStructure(csErrH, csErrN, csErrCA, pdbBBVec, asgVec, rotSrc, NoesyVec, distBound, pickNum, 0.0);
        Vector vecPdbSseRot2 = new Vector();
        vecPdbSseRot2 = pp.AlaninizeStructure(vecGrowPdb, resIndex, rotSrc);
        vecGrowPdb = new Vector();
        vecGrowPdb.addAll(vecPdbSseRot2);
        Vector<Vector> vecRot4AllResidues = new Vector<Vector>();
        int[] rotID = new int[pdbBBVec.size()];
        int j = 0;
        while (j < pdbBBVec.size()) {
            rotID[j] = 0;
            Pdb pdb = (Pdb)vecGrowPdb.elementAt(j);
            String resName = pdb.getResidue();
            int resNo = pdb.getResidueNo();
            Vector pdbRotVec = new Vector();
            if (resName.equalsIgnoreCase("GLY")) {
                int ind1 = Collections.binarySearch(vecGrowPdb, new Pdb(resNo), new PdbComparator());
                Pdb pdbA = (Pdb)vecGrowPdb.elementAt(ind1);
                pdbRotVec.add(pdbA);
                pdbRotamNewStr.addAll(pdbRotVec);
            } else {
                String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
                pdbRotam = pp.readPdb(rotamFile);
                pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
                pdbRotVec = pdbRotamNewCS = pp.nameConvert4SmallRotLibCS(pdbRotam);
            }
            int indRef = Collections.binarySearch(vecGrowPdb, new Pdb(resNo), new PdbComparator());
            int[] index = new int[2];
            if (indRef >= 0) {
                pdbRotamNewRef = rp.RefineRotLibNew(csErrH, csErrN, csErrCA, pdbRotVec, vecGrowPdb, asgVec, NoesyVec, resNo, distBound, pdbRotVec.size(), pdbRotamNewStr, 0.0);
            }
            vecRot4AllResidues.add(pdbRotamNewRef);
            ++j;
        }
        Vector vecRefineGrowPdb = new Vector();
        vecRefineGrowPdb = this.RefineRotamerSelection(vecGrowPdb, vecRot4AllResidues, rotID);
        return vecRefineGrowPdb;
    }

    public Vector RefineRotamerSelection(Vector vecGrowPdb, Vector vecRot4AllResidues, int[] rotID) {
        int[] clashResNo;
        Vector vecRefinePdb = new Vector();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        vdwVec = vander.convert2VDW(vecGrowPdb);
        boolean isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.8, 1, clashResNo = new int[2]);
        if (!isStericClash) {
            return vecGrowPdb;
        }
        int resNo1 = clashResNo[0];
        int resNo2 = clashResNo[1];
        int index1 = Collections.binarySearch(vecGrowPdb, new Pdb(resNo1), new PdbComparator());
        int index2 = Collections.binarySearch(vecGrowPdb, new Pdb(resNo2), new PdbComparator());
        Vector vecRot1 = (Vector)vecRot4AllResidues.elementAt(index1);
        int rotNum1 = vecRot1.size();
        Vector vecRot2 = (Vector)vecRot4AllResidues.elementAt(index2);
        int rotNum2 = vecRot2.size();
        Pdb pp = new Pdb();
        boolean isRefined = false;
        int i = 0;
        while (i < vecRot1.size()) {
            Pdb pdbRot = (Pdb)vecRot1.elementAt(i);
            Vector<Pdb> vecPdbRot = new Vector<Pdb>();
            vecPdbRot.add(pdbRot);
            Vector<Pdb> vecTemp1 = pp.CombinRotBB(vecPdbRot, (Vector<Pdb>)vecGrowPdb, resNo1);
            boolean isBreak = false;
            int j = 0;
            while (j < vecRot2.size()) {
                Pdb pdbRot2 = (Pdb)vecRot2.elementAt(j);
                Vector<Pdb> vecPdbRot2 = new Vector<Pdb>();
                vecPdbRot2.add(pdbRot2);
                Vector<Pdb> vecTemp2 = pp.CombinRotBB(vecPdbRot2, vecTemp1, resNo2);
                vdwVec = vander.convert2VDW(vecTemp2);
                isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.8, 1, clashResNo);
                if (!(clashResNo[0] == resNo1 && clashResNo[1] == resNo2 || clashResNo[0] == resNo2 && clashResNo[1] == resNo1)) {
                    System.out.println("We have refined the roatmer position at residue: " + resNo1 + " and residue: " + resNo2);
                    isRefined = true;
                    vecGrowPdb = new Vector();
                    vecGrowPdb = vecTemp2;
                    isBreak = true;
                    break;
                }
                ++j;
            }
            if (isBreak) break;
            ++i;
        }
        if (!isRefined) {
            System.out.println("We counldn't refine the rotamer selection at residue:" + resNo1 + " and residue: " + resNo2);
        }
        vecRefinePdb = this.RefineRotamerSelection(vecGrowPdb, vecRot4AllResidues, rotID);
        return vecRefinePdb;
    }

    public Vector RefineRotamerSelectionRandom(Vector vecGrowPdb, Vector vecRot4AllResidues, int[] rotID) {
        int[] clashResNo;
        Vector vecRefinePdb = new Vector();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        vdwVec = vander.convert2VDW(vecGrowPdb);
        boolean isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.25, 1, clashResNo = new int[2]);
        if (!isStericClash) {
            return vecGrowPdb;
        }
        int resNo1 = clashResNo[0];
        int resNo2 = clashResNo[1];
        int index1 = Collections.binarySearch(vecGrowPdb, new Pdb(resNo1), new PdbComparator());
        int index2 = Collections.binarySearch(vecGrowPdb, new Pdb(resNo2), new PdbComparator());
        Vector vecRot1 = (Vector)vecRot4AllResidues.elementAt(index1);
        int rotNum1 = vecRot1.size();
        Vector vecRot2 = (Vector)vecRot4AllResidues.elementAt(index2);
        int rotNum2 = vecRot2.size();
        Random generator = new Random();
        Pdb pp = new Pdb();
        boolean isRefined = false;
        double tet = generator.nextGaussian();
        double temp1 = (double)vecRot1.size() * generator.nextGaussian();
        if (temp1 < 0.0) {
            temp1 = -temp1;
        }
        int i = (int)Math.min(Math.floor(temp1), (double)(vecRot1.size() - 1));
        Pdb pdbRot = (Pdb)vecRot1.elementAt(i);
        Vector<Pdb> vecPdbRot = new Vector<Pdb>();
        vecPdbRot.add(pdbRot);
        Vector<Pdb> vecTemp1 = pp.CombinRotBB(vecPdbRot, vecGrowPdb, resNo1);
        boolean isBreak = false;
        double temp2 = (double)vecRot2.size() * generator.nextGaussian();
        if (temp2 < 0.0) {
            temp2 = -temp2;
        }
        int j = (int)Math.min(Math.floor(temp2), (double)(vecRot2.size() - 1));
        Pdb pdbRot2 = (Pdb)vecRot2.elementAt(j);
        Vector<Pdb> vecPdbRot2 = new Vector<Pdb>();
        vecPdbRot2.add(pdbRot2);
        Vector<Pdb> vecTemp2 = pp.CombinRotBB(vecPdbRot2, vecTemp1, resNo2);
        vdwVec = vander.convert2VDW(vecTemp2);
        isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.25, 1, clashResNo);
        if (!(clashResNo[0] == resNo1 && clashResNo[1] == resNo2 || clashResNo[0] == resNo2 && clashResNo[1] == resNo1)) {
            System.out.println("We have refined the roatmer position at residue: " + resNo1 + " and residue: " + resNo2);
            isRefined = true;
            vecGrowPdb = new Vector<Pdb>();
            vecGrowPdb.addAll(vecTemp2);
            isBreak = true;
        }
        if (!isRefined) {
            System.out.println("We counldn't refine the rotamer selection at residue:" + resNo1 + " and residue: " + resNo2);
        }
        vecRefinePdb = this.RefineRotamerSelectionRandom(vecGrowPdb, vecRot4AllResidues, rotID);
        return vecRefinePdb;
    }

    public Vector RefineRotamerSelectionSearch(Vector vecGrowPdb, int resNo, String rotSrc, int depth) {
        Random generator = new Random();
        Pdb pp = new Pdb();
        Vector vecRefinePdb = new Vector();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        int ind = Collections.binarySearch(vecGrowPdb, new Pdb(resNo), new PdbComparator());
        Pdb pdb = (Pdb)vecGrowPdb.elementAt(ind);
        String resName = pdb.getResidue();
        Vector<Pdb> pdbRotVec = new Vector<Pdb>();
        Vector<Object> pdbRotamNewStr = new Vector();
        if (resName.equalsIgnoreCase("GLY")) {
            int ind1 = Collections.binarySearch(vecGrowPdb, new Pdb(resNo), new PdbComparator());
            Pdb pdbA = (Pdb)vecGrowPdb.elementAt(ind1);
            pdbRotVec.add(pdbA);
            pdbRotamNewStr.addAll(pdbRotVec);
        } else {
            String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
            Vector<Pdb> pdbRotam = pp.readPdb(rotamFile);
            pdbRotamNewStr = pdbRotam;
        }
        int minClashes = 99999;
        int minID = 0;
        double minRmsd = 99999.9;
        int i = 0;
        while (i < pdbRotamNewStr.size()) {
            Pdb ppRot = (Pdb)pdbRotamNewStr.elementAt(i);
            Vector<Pdb> vecRotTemp = new Vector<Pdb>();
            vecRotTemp.add(ppRot);
            Vector<Object> vecTemp = new Vector();
            vecTemp = pp.CombinRotBB(vecRotTemp, vecGrowPdb, resNo);
            vdwVec = new Vector();
            vdwVec = vander.convert2VDW(vecTemp);
            int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.4);
            if (minClashes > numClashes) {
                minClashes = numClashes;
                minID = i;
            }
            ++i;
        }
        System.out.println("depth: " + depth + " current reside id: " + resNo + " rotamer ID: " + minID);
        Pdb ppRotNew = (Pdb)pdbRotamNewStr.elementAt(minID);
        Vector<Pdb> vecRotTempNew = new Vector<Pdb>();
        vecRotTempNew.add(ppRotNew);
        Vector<Object> vecTempNew = new Vector();
        vecTempNew = pp.CombinRotBB(vecRotTempNew, vecGrowPdb, resNo);
        vecGrowPdb = new Vector();
        vecGrowPdb.addAll(vecTempNew);
        boolean[] resClash = new boolean[140];
        int numRes = vander.OutputStericClashResidues(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.4, 1, resClash, true);
        if (numRes <= 4 || depth >= 100) {
            return vecGrowPdb;
        }
        int rnumber = generator.nextInt(resClash.length);
        int nextResNo = -1;
        int i2 = resNo + 1;
        while (i2 < resClash.length) {
            if (resClash[i2]) {
                nextResNo = i2;
                break;
            }
            ++i2;
        }
        if (nextResNo < 0) {
            int firstClash = 0;
            int i3 = 0;
            while (i3 < resClash.length) {
                if (resClash[i3]) {
                    firstClash = i3;
                    break;
                }
                ++i3;
            }
            nextResNo = firstClash;
        }
        return this.RefineRotamerSelectionSearch(vecGrowPdb, nextResNo, rotSrc, depth + 1);
    }

    public boolean RefineRotamerSelectionRecur(Vector vecGrowPdb, Vector vecRot4AllResidues, int resInd, Vector vecSavePdb, boolean[] resNoeIndex) {
        Vector vecRefinePdb = new Vector();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        int resIndex = resInd;
        int[] clashResNo = new int[2];
        if (!resNoeIndex[resInd]) {
            int index_temp = -1;
            int j = resInd + 1;
            while (j < resNoeIndex.length) {
                if (resNoeIndex[j]) {
                    index_temp = j;
                    resIndex = j;
                    break;
                }
                ++j;
            }
            if (index_temp == -1) {
                return false;
            }
        }
        Vector vecRot1 = (Vector)vecRot4AllResidues.elementAt(resIndex);
        int rotNum1 = vecRot1.size();
        Pdb pp_temp = (Pdb)vecGrowPdb.elementAt(resIndex);
        int resNo1 = pp_temp.getResidueNo();
        Pdb pp = new Pdb();
        boolean isRefined = false;
        int i = 0;
        while (i < vecRot1.size()) {
            Pdb pdbRot = (Pdb)vecRot1.elementAt(i);
            Vector<Pdb> vecPdbRot = new Vector<Pdb>();
            vecPdbRot.add(pdbRot);
            Vector<Pdb> vecTemp1 = pp.CombinRotBB(vecPdbRot, vecGrowPdb, resNo1);
            vecGrowPdb = new Vector<Pdb>();
            vecGrowPdb.addAll(vecTemp1);
            if (resIndex >= vecGrowPdb.size() - 1) {
                vdwVec = vander.convert2VDW(vecGrowPdb);
                boolean isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.5, 1, clashResNo);
                if (!isStericClash) {
                    vecSavePdb.add(vecGrowPdb);
                    return true;
                }
                return false;
            }
            int index_temp = -1;
            int j = resIndex + 1;
            while (j < resNoeIndex.length) {
                if (resNoeIndex[j]) {
                    index_temp = j;
                    break;
                }
                ++j;
            }
            if (index_temp < 0) {
                vdwVec = vander.convert2VDW(vecGrowPdb);
                boolean isStericClash = vander.checkStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.5, 1, clashResNo);
                if (!isStericClash) {
                    vecSavePdb.add(vecGrowPdb);
                    return true;
                }
                return false;
            }
            this.RefineRotamerSelectionRecur(vecGrowPdb, vecRot4AllResidues, index_temp, vecSavePdb, resNoeIndex);
            ++i;
        }
        return true;
    }

    public Vector AssembleTwoSSEs(Vector vecSSEPdb1, Vector vecSSEPdb2, int brkResNo, Vector<Dipolar> rdcVecNh, Vector<Dipolar> rdcVecCh, double Syy, double Szz) throws JampackException {
        double Sxx = -Syy - Szz;
        double nhRms = 0.0;
        double chRms = 0.0;
        Vector vecStrPdb = new Vector();
        Vector vecPhiPsiSSE1 = this.PhiPsiTotalPdb(vecSSEPdb1);
        Vector vecPhiPsiSSE2 = this.PhiPsiTotalPdb(vecSSEPdb2);
        double deviation = 5.0;
        double resolution = 1.0;
        ModelRdc mdc = new ModelRdc();
        PdbRdc pdc = new PdbRdc();
        Model md = new Model();
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Pdb pdb11 = (Pdb)vecSSEPdb1.elementAt(0);
        Pdb pdb12 = (Pdb)vecSSEPdb1.elementAt(vecSSEPdb1.size() - 1);
        int resNo11 = pdb11.getResidueNo();
        int resNo12 = pdb12.getResidueNo();
        Vector<Cartesian> atomVec = pdb11.getAtomVec();
        int j = 0;
        while (j < atomVec.size()) {
            Cartesian cc = atomVec.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            }
            if (atom.equals("N")) {
                n1 = cc.getXYZ();
            }
            if (atom.equals("H") || atom.equals("HN")) {
                nh1 = cc.getXYZ();
            }
            ++j;
        }
        Pdb pdb22 = (Pdb)vecSSEPdb2.elementAt(vecSSEPdb2.size() - 1);
        int resNo22 = pdb22.getResidueNo();
        Vector vecPhiPsiAll = new Vector();
        Vector<PhiPsi> vecPhiPsiFirst = new Vector<PhiPsi>();
        double[] phiFirst = new double[vecPhiPsiSSE1.size()];
        double[] psiFirst = new double[vecPhiPsiSSE1.size()];
        int i = 0;
        while (i < vecPhiPsiSSE1.size()) {
            PhiPsi phipsi = (PhiPsi)vecPhiPsiSSE1.elementAt(i);
            int resNo = phipsi.getResidueNo();
            double phi_temp = phipsi.getPhi();
            double psi_temp = phipsi.getPsi();
            phiFirst[i] = phi_temp;
            psiFirst[i] = psi_temp;
            if (resNo >= resNo11 && resNo < brkResNo) {
                vecPhiPsiFirst.add(phipsi);
            }
            ++i;
        }
        Vector<PhiPsi> vecPhiPsiSec = new Vector<PhiPsi>();
        int i2 = 0;
        while (i2 < vecPhiPsiSSE2.size()) {
            PhiPsi phipsi = (PhiPsi)vecPhiPsiSSE2.elementAt(i2);
            int resNo = phipsi.getResidueNo();
            if (resNo > brkResNo && resNo <= resNo22) {
                vecPhiPsiSec.add(phipsi);
            }
            ++i2;
        }
        Vector<PhiPsi> phiPsiVec_temp = new Vector<PhiPsi>();
        int i3 = resNo11;
        while (i3 <= resNo12) {
            phiPsiVec_temp.add(new PhiPsi(i3, "ALA", -1.1397000015522971, -0.6876597252857658));
            ++i3;
        }
        double[] n1_temp = new double[]{0.0, 0.0, 0.0};
        double[] nh1_temp = new double[]{0.0, 0.0, -1.02};
        double[] ca1_temp = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        int brkIndex = Collections.binarySearch(vecSSEPdb1, new Pdb(brkResNo), new PdbComparator());
        if (brkIndex < 0) {
            System.out.println("We couldnot find the residue Index");
            return null;
        }
        PhiPsi phipsiBrk = (PhiPsi)vecPhiPsiSSE1.elementAt(brkIndex);
        String brkResName = phipsiBrk.getResidue();
        double phiBrk = phipsiBrk.getPhi();
        double psiBrk = phipsiBrk.getPsi();
        double phiBrkDegree = phiBrk * 180.0 / Math.PI;
        double psiBrkDegree = psiBrk * 180.0 / Math.PI;
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        double minScore = 99999.9;
        double[][] eMat = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        Matrix A = new Matrix(eMat);
        double[] sRmsdCH = new double[1];
        int[] sizeCH = new int[1];
        double[] sRmsdNH = new double[1];
        int[] sizeNH = new int[1];
        Vector vecPdbBest = new Vector();
        int i4 = (int)(phiBrkDegree - deviation);
        while ((double)i4 <= Math.ceil(phiBrkDegree + deviation)) {
            double phiValue = (double)i4 * resolution * Math.PI / 180.0;
            System.out.println("i=" + i4 + " phiValue=" + phiValue);
            int k = (int)(psiBrkDegree - deviation);
            while ((double)k <= psiBrkDegree + deviation) {
                double psiValue = (double)k * resolution * Math.PI / 180.0;
                System.out.println("k=" + k + " phiValue=" + psiValue);
                vecPhiPsiAll = new Vector();
                vecPhiPsiAll.addAll(vecPhiPsiFirst);
                vecPhiPsiAll.add(new PhiPsi(brkResNo, brkResName, phiValue, psiValue));
                vecPhiPsiAll.addAll(vecPhiPsiSec);
                vecStrPdb = new Vector();
                vecStrPdb = mdc.modelBuild(vecPhiPsiAll, n1_temp, nh1_temp, ca1_temp);
                Collections.sort(vecStrPdb, new PdbComparator());
                Vector vecStrPdbNew = new Vector();
                vecStrPdbNew = md.BackonbeRotation(vecStrPdb, vecSSEPdb1);
                Collections.sort(vecStrPdbNew, new PdbComparator());
                vdwVec = vander.convert2VDW(vecStrPdbNew);
                hasVDW = vander.computeVDW(vdwVec, vdwValue, vdwLevel, printVDWViolation, false);
                double[] rdc1Cal = new double[vecStrPdbNew.size()];
                double[] rdc2Cal = new double[vecStrPdbNew.size()];
                nhRms = pdc.BackCalNH(vecStrPdbNew, rdcVecNh, "N", "H", A, Sxx, Syy, Szz, 1.0, rdc1Cal, sRmsdNH, sizeNH);
                chRms = pdc.BackCal(vecStrPdbNew, rdcVecCh, "CA", "HA", A, Sxx, Syy, Szz, 1.0, rdc2Cal, sRmsdCH, sizeCH);
                double sc = nhRms + chRms;
                if (minScore > sc) {
                    System.out.println("score=: " + sc + "  vdw= " + vdwValue[0] + " nhRms=" + nhRms + " chRms=" + chRms);
                    vecPdbBest = new Vector();
                    vecPdbBest.addAll(vecStrPdbNew);
                    minScore = sc;
                }
                ++k;
            }
            ++i4;
        }
        return vecPdbBest;
    }

    public Vector LoopComputFromNOEPatterns(double csErrH, double csErrN, double csErrCA, Vector seqVec, Vector vecPdbBbSSE, Vector asgVec, String rotSrc, Vector NoesyVec, double distBound, int firstResNo, int secondResNo) {
        double resolution = 4.0;
        ModelRdc mdc = new ModelRdc();
        Vector pdbLoopVec = new Vector();
        Vector<Pdb> vecGrowPdb = new Vector<Pdb>();
        vecGrowPdb = vecPdbBbSSE;
        Pdb pp = new Pdb();
        Vector pdbRotamNewRef = new Vector();
        RotaPattern rp = new RotaPattern();
        Vector vecPhiPsiSSE = this.PhiPsiTotalPdb(vecPdbBbSSE);
        double prePhi = 0.0;
        int i = 0;
        while (i < vecPhiPsiSSE.size()) {
            PhiPsi phipsi = (PhiPsi)vecPhiPsiSSE.elementAt(i);
            if (phipsi.getResidueNo() == firstResNo - 1) {
                prePhi = phipsi.getPhi();
            }
            ++i;
        }
        i = firstResNo;
        while (i < secondResNo + 1) {
            int index = Collections.binarySearch(vecGrowPdb, new Pdb(i - 1), new PdbComparator());
            if (index < 0) {
                System.out.println("We couldnot find the residue Index");
                return null;
            }
            Pdb pdbFirst = (Pdb)vecGrowPdb.elementAt(index);
            Vector<Object> atomVec = new Vector();
            Cartesian cc = new Cartesian();
            double[] n1 = new double[]{0.0, 0.0, 0.0};
            double[] nh1 = new double[]{0.0, 0.0, 0.0};
            double[] ca1 = new double[]{0.0, 0.0, 0.0};
            atomVec = pdbFirst.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                String atom = cc.getAtom();
                if (atom.equals("CA")) {
                    ca1 = cc.getXYZ();
                }
                if (atom.equals("N")) {
                    n1 = cc.getXYZ();
                }
                if (atom.equals("H") || atom.equals("HN")) {
                    nh1 = cc.getXYZ();
                }
                ++j;
            }
            Vector<Pdb> vecGrowPdbNew = new Vector<Pdb>();
            int t = 0;
            while (t < vecGrowPdb.size()) {
                Pdb pdbTemp = (Pdb)vecGrowPdb.elementAt(t);
                int resNoTemp = pdbTemp.getResidueNo();
                if (resNoTemp < i - 1 || resNoTemp > secondResNo) {
                    vecGrowPdbNew.add(pdbTemp);
                }
                ++t;
            }
            double maxScore = -999999.9;
            double phiMax = 0.0;
            double psiPreMax = 0.0;
            double phiValue = 0.0;
            double psiPreValue = 0.0;
            Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
            String residPre = this.residueNameFromSeq(seqVec, i - 1);
            String residCur = this.residueNameFromSeq(seqVec, i);
            j = 0;
            while ((double)j < 360.0 / resolution) {
                psiPreValue = (double)j * resolution * Math.PI / 180.0;
                System.out.println("j=" + j + " psiPreValue=" + psiPreValue);
                int k = 0;
                while ((double)k < 360.0 / resolution) {
                    phiValue = (double)k * resolution * Math.PI / 180.0;
                    System.out.println("k=" + k + " phiValue=" + phiValue);
                    pdbLoopVec = new Vector();
                    phiPsiVec = new Vector();
                    phiPsiVec.add(new PhiPsi(i - 1, residPre, prePhi, psiPreValue));
                    phiPsiVec.add(new PhiPsi(i, residPre, phiValue, 0.0));
                    pdbLoopVec = mdc.modelBuild(phiPsiVec, n1, nh1, ca1);
                    Vector<Pdb> vecTemp = new Vector<Pdb>();
                    vecTemp.addAll(vecGrowPdbNew);
                    vecTemp.addAll(pdbLoopVec);
                    Collections.sort(vecTemp, new PdbComparator());
                    Pdb pdb = (Pdb)pdbLoopVec.elementAt(1);
                    String resName = pdb.getResidue();
                    int resNo = pdb.getResidueNo();
                    Vector pdbRotVec = new Vector();
                    if (resName.equalsIgnoreCase("GLY")) {
                        int ind1 = Collections.binarySearch(vecTemp, new Pdb(resNo), new PdbComparator());
                        Pdb pdbA = (Pdb)vecTemp.elementAt(ind1);
                        pdbRotVec.add(pdbA);
                    } else {
                        Vector pdbRotamNewCS;
                        String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
                        Vector<Pdb> pdbRotam = pp.readPdb(rotamFile);
                        Vector pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
                        pdbRotVec = pdbRotamNewCS = pp.nameConvert4SmallRotLibCS(pdbRotam);
                    }
                    double[] index_temp = new double[2];
                    pdbRotamNewRef = rp.RefineRotLib(csErrH, csErrN, csErrCA, pdbRotVec, vecTemp, asgVec, NoesyVec, resNo, distBound, 1, index_temp);
                    if (maxScore < index_temp[1]) {
                        maxScore = index_temp[1];
                        phiMax = phiValue;
                        psiPreMax = psiPreValue;
                    }
                    ++k;
                }
                ++j;
            }
            System.out.println("i-1=" + (i - 1) + " psiPreMax=" + psiPreMax + " i=" + i + " phiMax=" + phiMax);
            vecGrowPdb = new Vector<Pdb>();
            vecGrowPdb.addAll(vecGrowPdbNew);
            pdbLoopVec = new Vector();
            phiPsiVec = new Vector();
            phiPsiVec.add(new PhiPsi(i - 1, residPre, prePhi, psiPreMax));
            phiPsiVec.add(new PhiPsi(i, residCur, phiMax, 0.0));
            pdbLoopVec = mdc.modelBuild(phiPsiVec, n1, nh1, ca1);
            vecGrowPdb.addAll(pdbLoopVec);
            Collections.sort(vecGrowPdb, new PdbComparator());
            prePhi = phiMax;
            ++i;
        }
        return vecGrowPdb;
    }

    public boolean measureDisFromRotam(Vector pdbVec, Vector rotamVecA, Vector rotamVecB, int noA, String residueA, String nucleusA, int noB, String residueB, String nucleusB, double[] distance) {
        int ind1 = Collections.binarySearch(pdbVec, new Pdb(noA), new PdbComparator());
        int ind2 = Collections.binarySearch(pdbVec, new Pdb(noB), new PdbComparator());
        if (ind1 < 0 || ind2 < 0) {
            return false;
        }
        if (nucleusA.equalsIgnoreCase("HN")) {
            nucleusA = "H";
        }
        if (nucleusB.equalsIgnoreCase("HN")) {
            nucleusB = "H";
        }
        Pdb pdb = new Pdb();
        Pdb pdbA = (Pdb)pdbVec.elementAt(ind1);
        Vector<Pdb> pdbAVec = new Vector<Pdb>();
        pdbAVec.add(pdbA);
        String atom = "";
        Vector<Cartesian> atomVecA = pdbA.getAtomVec();
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        double[] amide = new double[3];
        double[] amide1 = new double[3];
        double[] amide2 = new double[3];
        double[] ha = new double[3];
        double[] ca1 = new double[3];
        double[] ca2 = new double[3];
        double[] trans_vec = new double[3];
        PhiPsi ff = new PhiPsi();
        Matrix rgA = Matrix.identity(3, 3);
        int j = 0;
        while (j < atomVecA.size()) {
            cc = atomVecA.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecStr = this.internuclearVec(ca1, ha);
        double[] CaToNVecStr = this.internuclearVec(ca1, amide);
        Matrix rg = Matrix.identity(3, 3);
        rg = ff.RgCal(CaToHaVecStr, CaToNVecStr);
        Vector<Pdb> pdbANew = pdb.newPdb(pdbAVec, rg);
        Vector<Pdb> pdbVecNew1 = pdb.newPdb(pdbVec, rg);
        Pdb pdbTemp = pdbANew.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            }
            ++j;
        }
        Pdb pdbRotA = (Pdb)rotamVecA.elementAt(0);
        atomVec = pdbRotA.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        double[] CaToHaVecRot = this.internuclearVec(ca2, ha);
        double[] CaToNVecRot = this.internuclearVec(ca2, amide);
        rgA = ff.RgCal(CaToHaVecRot, CaToNVecRot);
        Vector<Pdb> rotamVecNewA_temp = pdb.newPdb(rotamVecA, rgA);
        pdbTemp = rotamVecNewA_temp.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            }
            ++j;
        }
        trans_vec = this.internuclearVec(ca2, ca1);
        Vector<Pdb> rotamVecNewA = pdb.newPdbByTranslation(rotamVecNewA_temp, trans_vec);
        Pdb pdbB = pdbVecNew1.elementAt(ind2);
        Vector<Pdb> pdbBVec = new Vector<Pdb>();
        pdbBVec.add(pdbB);
        Vector<Cartesian> atomVecB = pdbB.getAtomVec();
        Matrix rgB = Matrix.identity(3, 3);
        j = 0;
        while (j < atomVecB.size()) {
            cc = atomVecB.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        CaToHaVecStr = this.internuclearVec(ca1, ha);
        CaToNVecStr = this.internuclearVec(ca1, amide);
        rg = ff.RgCal(CaToHaVecStr, CaToNVecStr);
        Vector<Pdb> pdbBNew = pdb.newPdb(pdbBVec, rg);
        pdbTemp = pdbBNew.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca1 = cc.getXYZ();
            }
            ++j;
        }
        Vector<Pdb> rotamVecNewA2 = pdb.newPdb(rotamVecNewA, rg);
        Vector<Pdb> pdbVecNew2 = pdb.newPdb(pdbVecNew1, rg);
        Pdb pdbRotB = (Pdb)rotamVecB.elementAt(0);
        atomVec = pdbRotB.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("N")) {
                amide = cc.getXYZ();
            } else if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            } else if (atom.equals("HA") || atom.equals("HA2")) {
                ha = cc.getXYZ();
            }
            ++j;
        }
        CaToHaVecRot = this.internuclearVec(ca2, ha);
        CaToNVecRot = this.internuclearVec(ca2, amide);
        rgB = ff.RgCal(CaToHaVecRot, CaToNVecRot);
        Vector<Pdb> rotamVecNewB_temp = pdb.newPdb(rotamVecB, rgB);
        pdbTemp = rotamVecNewB_temp.elementAt(0);
        atomVec = pdbTemp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = (Cartesian)atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("CA")) {
                ca2 = cc.getXYZ();
            }
            ++j;
        }
        trans_vec = this.internuclearVec(ca2, ca1);
        Vector<Pdb> rotamVecNewB = pdb.newPdbByTranslation(rotamVecNewB_temp, trans_vec);
        double minDis = 999.9;
        double disTemp = 0.0;
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        boolean foundA = false;
        boolean foundB = false;
        int i = 0;
        while (i < rotamVecNewA2.size()) {
            Pdb pdbAA = rotamVecNewA2.elementAt(i);
            atomVecA = pdbAA.getAtomVec();
            int i1 = 0;
            while (i1 < atomVecA.size()) {
                cc = atomVecA.elementAt(i1);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("HN")) {
                    atom = "H";
                }
                if (atom.equalsIgnoreCase(nucleusA)) {
                    coordA = cc.getXYZ();
                    foundA = true;
                }
                ++i1;
            }
            j = 0;
            while (j < rotamVecNewB.size()) {
                Pdb pdbBB = rotamVecNewB.elementAt(j);
                atomVecB = pdbBB.getAtomVec();
                int j1 = 0;
                while (j1 < atomVecB.size()) {
                    cc = atomVecB.elementAt(j1);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("HN")) {
                        atom = "H";
                    }
                    if (atom.equalsIgnoreCase(nucleusB)) {
                        coordB = cc.getXYZ();
                        foundB = true;
                        disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                        if (minDis > disTemp) {
                            minDis = disTemp;
                        }
                    }
                    ++j1;
                }
                disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                if (minDis > disTemp) {
                    minDis = disTemp;
                }
                ++j;
            }
            ++i;
        }
        distance[0] = minDis;
        return foundA && foundB;
    }

    public void statsOfSixAngles(String pdbLists) {
        String src = "/net/drizzle/wlincong/pdbLocal/pdb/ultraHPdb/";
        PhiPsi ff = new PhiPsi();
        Pdb pp = new Pdb();
        Vector<Object> pdbVec = new Vector();
        Vector<String> fileVec = new Vector<String>();
        Vector phiPsiRdc = new Vector();
        Vector angles = new Vector();
        Vector allAngles = new Vector();
        try {
            String ss;
            BufferedReader in = new BufferedReader(new FileReader(pdbLists));
            while ((ss = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(ss);
                while (st.hasMoreTokens()) {
                    fileVec.add(st.nextToken());
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + pdbLists);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        double theta1 = 0.0;
        double theta3 = 0.0;
        double theta5 = 0.0;
        double theta6 = 0.0;
        double theta7 = 0.0;
        double theta9 = 0.0;
        int i = 0;
        while (i < fileVec.size()) {
            pdbVec = pp.readPdb(String.valueOf(src) + (String)fileVec.elementAt(i));
            angles = this.sixAngles(pdbVec);
            allAngles.addAll(angles);
            ++i;
        }
        double theta = 0.0;
        int sampleSize = allAngles.size();
        System.out.println(sampleSize);
        double sum = 0.0;
        int N = 0;
        int j = 0;
        while (j < allAngles.size()) {
            theta = (Double)allAngles.elementAt(j);
            if (theta < 2.5) {
                sum += theta;
                ++N;
            }
            ++j;
        }
        System.out.println("Theta = " + sum * 180.0 / ((double)N * Math.PI));
    }

    public Vector radiiFromCb(Vector pdbVec, String residue, String hAtom) {
        int no = 0;
        int i = 0;
        int j = 0;
        String resid = "";
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = new Pdb();
        double[] cb = new double[3];
        double[] h1 = new double[3];
        double[] d1 = new double[3];
        Vector<Double> disVec = new Vector<Double>();
        double len = 0.0;
        boolean hasCB = false;
        i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            no = pp.getResidueNo();
            resid = pp.getResidue();
            this.atomVec = pp.getAtomVec();
            if (resid.equals(residue)) {
                j = 0;
                while (j < this.atomVec.size()) {
                    cc = (Cartesian)this.atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("CB")) {
                        cb = cc.getXYZ();
                        hasCB = true;
                    }
                    ++j;
                }
                if (hasCB) {
                    j = 0;
                    while (j < this.atomVec.size()) {
                        cc = (Cartesian)this.atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.indexOf(hAtom) > -1) {
                            h1 = cc.getXYZ();
                            d1 = this.internuclearVec(cb, h1);
                            len = this.length(d1);
                            disVec.add(new Double(len));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return disVec;
    }

    public Vector radiiFromNH(Vector pdbVec, String residue, String hAtom) {
        int no = 0;
        int i = 0;
        int j = 0;
        String resid = "";
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = new Pdb();
        double[] cb = new double[3];
        double[] h1 = new double[3];
        double[] d1 = new double[3];
        Vector<Double> disVec = new Vector<Double>();
        double len = 0.0;
        boolean hasCB = false;
        i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            no = pp.getResidueNo();
            resid = pp.getResidue();
            this.atomVec = pp.getAtomVec();
            if (resid.equals(residue)) {
                j = 0;
                while (j < this.atomVec.size()) {
                    cc = (Cartesian)this.atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("H")) {
                        cb = cc.getXYZ();
                        hasCB = true;
                    }
                    ++j;
                }
                if (hasCB) {
                    j = 0;
                    while (j < this.atomVec.size()) {
                        cc = (Cartesian)this.atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.indexOf(hAtom) > -1) {
                            h1 = cc.getXYZ();
                            d1 = this.internuclearVec(cb, h1);
                            len = this.length(d1);
                            disVec.add(new Double(len));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return disVec;
    }

    public Vector sixAngles(Vector pdbVec) {
        double dCA2HA;
        double angleNCAHA;
        double[] coI = new double[3];
        double[] amide1 = new double[3];
        double[] amide2 = new double[3];
        double[] nh1 = new double[3];
        double[] nh2 = new double[3];
        double[] ha1 = new double[3];
        double[] ha2 = new double[3];
        double[] o1 = new double[3];
        double[] o2 = new double[3];
        double[] co1 = new double[3];
        double[] co2 = new double[3];
        double[] ca1 = new double[3];
        double[] ca2 = new double[3];
        double[] nToCO1Vec = new double[3];
        double[] co1ToNVec = new double[3];
        double[] caToCOVec = new double[3];
        double[] coToCAVec = new double[3];
        double[] nToCAVec = new double[3];
        double[] caToNVec = new double[3];
        double[] nToNHVec = new double[3];
        double[] nToNHVec2 = new double[3];
        double[] caToHAVec = new double[3];
        double[] coToOVec = new double[3];
        double dCO2O = 0.0;
        int no1 = 0;
        int no2 = 0;
        int no3 = 0;
        int i = 0;
        int j = 0;
        int k = 0;
        String resid1 = "";
        String resid2 = "";
        String resid3 = "";
        Cartesian cc = new Cartesian();
        String atom = "";
        double theta1 = 0.5235987755982988;
        double theta3 = -0.3490658503988659;
        double theta9 = 0.0;
        Matrix rg = new Matrix(3, 3);
        double deg = 57.29577951308232;
        Vector phiPsiVec = new Vector();
        Vector<Double> theta1Vec = new Vector<Double>();
        Vector<Double> theta3Vec = new Vector<Double>();
        Vector<Double> theta5Vec = new Vector<Double>();
        Vector<Double> theta6Vec = new Vector<Double>();
        Vector<Double> theta7Vec = new Vector<Double>();
        Vector<Double> theta9Vec = new Vector<Double>();
        Vector<Double> angleNCAHAVec = new Vector<Double>();
        Vector<Double> angleOCONVec = new Vector<Double>();
        Vector<Double> omegaVec = new Vector<Double>();
        Vector<Double> angleNCACOHAVec = new Vector<Double>();
        double angleNCACOHA = 0.0;
        double[] ppp = new double[4];
        Pdb pp = (Pdb)pdbVec.elementAt(i);
        no1 = pp.getResidueNo();
        resid1 = pp.getResidue();
        Vector<Cartesian> atomVec = pp.getAtomVec();
        j = 0;
        while (j < atomVec.size()) {
            cc = atomVec.elementAt(j);
            atom = cc.getAtom();
            if (atom.equals("C")) {
                coI = cc.getXYZ();
            }
            ++j;
        }
        pp = (Pdb)pdbVec.elementAt(++i);
        no2 = pp.getResidueNo();
        resid2 = pp.getResidue();
        atomVec = pp.getAtomVec();
        if (!resid2.equals("PRO")) {
            j = 0;
            while (j < atomVec.size()) {
                cc = atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("N")) {
                    amide1 = cc.getXYZ();
                } else if (atom.equals("H")) {
                    nh1 = cc.getXYZ();
                } else if (atom.equals("CA")) {
                    ca1 = cc.getXYZ();
                } else if (atom.equals("C")) {
                    co1 = cc.getXYZ();
                } else if (atom.equals("HA")) {
                    ha1 = cc.getXYZ();
                } else if (atom.equals("O")) {
                    o1 = cc.getXYZ();
                }
                ++j;
            }
            nToNHVec = this.internuclearVec(amide1, nh1);
            nToCAVec = this.internuclearVec(amide1, ca1);
            caToHAVec = this.internuclearVec(ca1, ha1);
            angleNCAHA = Math.PI - this.interAngle(nToCAVec, caToHAVec);
            angleNCAHAVec.add(new Double(angleNCAHA));
            dCA2HA = this.length(caToHAVec);
            coToOVec = this.internuclearVec(o1, co1);
            dCO2O = this.length(coToOVec);
            theta1 = this.interAngle(nToNHVec, nToCAVec) - 1.5707963267948966;
            theta1Vec.addElement(new Double(theta1));
            caToCOVec = this.internuclearVec(ca1, co1);
            coToCAVec = this.internuclearVec(co1, ca1);
            theta3 = this.interAngle(nToCAVec, caToCOVec) - 1.5707963267948966;
            theta3Vec.addElement(new Double(theta3));
            angleNCACOHA = this.PhiPsiCalPDB(caToCOVec, nToCAVec, caToHAVec);
            angleNCACOHAVec.add(new Double(angleNCACOHA));
            if (no2 == no1 + 1) {
                co1ToNVec = this.internuclearVec(coI, amide1);
                theta9 = this.PhiPsiCalPDB(nToNHVec, nToCAVec, co1ToNVec);
                theta9Vec.addElement(new Double(theta9));
            }
        } else {
            j = 0;
            while (j < atomVec.size()) {
                cc = atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equals("C")) {
                    co1 = cc.getXYZ();
                }
                ++j;
            }
        }
        ++i;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            no3 = pp.getResidueNo();
            resid3 = pp.getResidue();
            atomVec = pp.getAtomVec();
            if (!resid3.equals("PRO")) {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("N")) {
                        amide1 = cc.getXYZ();
                    } else if (atom.equals("H")) {
                        nh1 = cc.getXYZ();
                    } else if (atom.equals("CA")) {
                        ca1 = cc.getXYZ();
                    } else if (atom.equals("C")) {
                        co1 = cc.getXYZ();
                    } else if (atom.equals("HA")) {
                        ha1 = cc.getXYZ();
                    } else if (atom.equals("O")) {
                        o1 = cc.getXYZ();
                    }
                    ++j;
                }
                nToNHVec2 = this.internuclearVec(amide2, nh2);
                nToCAVec = this.internuclearVec(amide2, ca2);
                caToHAVec = this.internuclearVec(ca2, ha2);
                angleNCAHA = Math.PI - this.interAngle(nToCAVec, caToHAVec);
                angleNCAHAVec.add(new Double(angleNCAHA));
                dCA2HA = this.length(caToHAVec);
                if (no3 == no2 + 1) {
                    co1ToNVec = this.internuclearVec(co1, amide2);
                    double angleOCON = Math.PI - this.interAngle(coToOVec, co1ToNVec);
                    angleOCONVec.add(new Double(angleOCON));
                    double theta5 = 1.5707963267948966 - this.interAngle(caToCOVec, co1ToNVec);
                    double omega1 = this.PhiPsiCalPDB(co1ToNVec, caToCOVec, coToOVec);
                    omegaVec.add(new Double(omega1));
                    coToOVec = this.internuclearVec(o2, co2);
                    dCO2O = this.length(coToOVec);
                    double theta6 = this.PhiPsiCalPDB(coToCAVec, co1ToNVec, nToNHVec2);
                    double theta7 = 1.5707963267948966 - this.interAngle(co1ToNVec, nToNHVec2);
                    theta5Vec.addElement(new Double(theta5));
                    theta6Vec.addElement(new Double(theta6));
                    theta7Vec.addElement(new Double(theta7));
                    if (!resid2.equals("PRO")) {
                        theta9Vec.addElement(new Double(theta9));
                    }
                    theta9 = this.PhiPsiCalPDB(nToNHVec2, nToCAVec, co1ToNVec);
                }
                k = 0;
                while (k < nToNHVec2.length) {
                    nToNHVec[k] = nToNHVec2[k];
                    ++k;
                }
                theta1 = this.interAngle(nToNHVec, nToCAVec) - 1.5707963267948966;
                theta1Vec.addElement(new Double(theta1));
                caToCOVec = this.internuclearVec(ca2, co2);
                coToCAVec = this.internuclearVec(co2, ca2);
                theta3 = this.interAngle(nToCAVec, caToCOVec) - 1.5707963267948966;
                theta3Vec.addElement(new Double(theta3));
                angleNCACOHA = this.PhiPsiCalPDB(caToCOVec, nToCAVec, caToHAVec);
                angleNCACOHAVec.add(new Double(angleNCACOHA));
            } else {
                j = 0;
                while (j < atomVec.size()) {
                    cc = atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equals("C")) {
                        co2 = cc.getXYZ();
                    }
                    ++j;
                }
            }
            no2 = no3;
            resid2 = resid3;
            k = 0;
            while (k < co2.length) {
                co1[k] = co2[k];
                ++k;
            }
            ++i;
        }
        return angleNCACOHAVec;
    }

    public void printToFile(Vector pdbVec, String fileName, PrintWriter out) {
        int d = 3;
        int w = 0;
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(3);
        format.setGroupingUsed(false);
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int padding = 0;
        int atomNo = 0;
        String str = "";
        Pdb ppTem = (Pdb)pdbVec.elementAt(0);
        int curNo = ppTem.getResidueNo();
        int preNo = ppTem.getResidueNo();
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            curNo = pp.getResidueNo();
            String noS = String.valueOf(pp.getResidueNo());
            String resid = pp.getResidue();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                String atom = cc.getAtom();
                if (!atom.substring(0, 1).equalsIgnoreCase("Q")) {
                    double x = cc.getX();
                    double y = cc.getY();
                    double z = cc.getZ();
                    String sX = format.format(x);
                    String sY = format.format(y);
                    String sZ = format.format(z);
                    w = 8;
                    padding = w - sX.length();
                    int k = 0;
                    while (k < padding) {
                        sX = " " + sX;
                        ++k;
                    }
                    padding = w - sY.length();
                    k = 0;
                    while (k < padding) {
                        sY = " " + sY;
                        ++k;
                    }
                    padding = w - sZ.length();
                    k = 0;
                    while (k < padding) {
                        sZ = " " + sZ;
                        ++k;
                    }
                    str = String.valueOf(str) + "ATOM  ";
                    w = 5;
                    String atomStr = String.valueOf(++atomNo);
                    padding = w - atomStr.length();
                    k = 0;
                    while (k < padding) {
                        atomStr = " " + atomStr;
                        ++k;
                    }
                    str = String.valueOf(str) + atomStr + " ";
                    w = 4;
                    if (Character.isDigit(atom.charAt(0)) || atom.length() >= 4) {
                        padding = w - atom.length();
                        k = 0;
                        while (k < padding) {
                            atom = String.valueOf(atom) + " ";
                            ++k;
                        }
                    } else {
                        atom = " " + atom;
                        padding = w - atom.length();
                        k = 0;
                        while (k < padding) {
                            atom = String.valueOf(atom) + " ";
                            ++k;
                        }
                    }
                    str = String.valueOf(str) + atom + " ";
                    str = String.valueOf(str) + resid + "  ";
                    w = 4;
                    padding = w - noS.length();
                    k = 0;
                    while (k < padding) {
                        noS = " " + noS;
                        ++k;
                    }
                    str = String.valueOf(str) + noS + "    ";
                    str = String.valueOf(str) + sX + sY + sZ + " ";
                    str = String.valueOf(str) + " 1.00 ";
                    str = String.valueOf(str) + " 0.00 ";
                    padding = 80 - str.length();
                    k = 0;
                    while (k < padding) {
                        str = String.valueOf(str) + " ";
                        ++k;
                    }
                    out.println(str);
                    noS = String.valueOf(pp.getResidueNo());
                    str = "";
                }
                ++j;
            }
            preNo = curNo;
            ++i;
        }
    }

    public void printToFileCyanaFormat(Vector pdbVec, String fileName, PrintWriter out) {
        int d = 3;
        int w = 0;
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(3);
        format.setGroupingUsed(false);
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int padding = 0;
        int atomNo = 0;
        String str = "";
        Pdb ppTem = (Pdb)pdbVec.elementAt(0);
        int curNo = ppTem.getResidueNo();
        int preNo = ppTem.getResidueNo();
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            curNo = pp.getResidueNo();
            String noS = String.valueOf(pp.getResidueNo());
            String resid = pp.getResidue();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                String atom = cc.getAtom();
                if (!atom.substring(0, 1).equalsIgnoreCase("Q")) {
                    double x = cc.getX();
                    double y = cc.getY();
                    double z = cc.getZ();
                    String sX = format.format(x);
                    String sY = format.format(y);
                    String sZ = format.format(z);
                    w = 8;
                    padding = w - sX.length();
                    int k = 0;
                    while (k < padding) {
                        sX = " " + sX;
                        ++k;
                    }
                    padding = w - sY.length();
                    k = 0;
                    while (k < padding) {
                        sY = " " + sY;
                        ++k;
                    }
                    padding = w - sZ.length();
                    k = 0;
                    while (k < padding) {
                        sZ = " " + sZ;
                        ++k;
                    }
                    w = 5;
                    String atomStr = String.valueOf(++atomNo);
                    padding = w - atomStr.length();
                    k = 0;
                    while (k < padding) {
                        atomStr = " " + atomStr;
                        ++k;
                    }
                    str = String.valueOf(str) + atomStr;
                    w = 5;
                    if (Character.isDigit(atom.charAt(0)) || atom.length() >= 4) {
                        atom = " " + atom;
                        padding = w - atom.length();
                        k = 0;
                        while (k < padding) {
                            atom = String.valueOf(atom) + " ";
                            ++k;
                        }
                    } else {
                        atom = " " + atom;
                        padding = w - atom.length();
                        k = 0;
                        while (k < padding) {
                            atom = String.valueOf(atom) + " ";
                            ++k;
                        }
                    }
                    str = String.valueOf(str) + atom;
                    w = 4;
                    padding = w - noS.length();
                    k = 0;
                    while (k < padding) {
                        noS = " " + noS;
                        ++k;
                    }
                    str = String.valueOf(str) + "   " + noS + " ";
                    str = String.valueOf(str) + resid;
                    str = String.valueOf(str) + "     " + sX + "   " + sY + "   " + sZ + " ";
                    padding = 80 - str.length();
                    k = 0;
                    while (k < padding) {
                        str = String.valueOf(str) + " ";
                        ++k;
                    }
                    out.println(str);
                    noS = String.valueOf(pp.getResidueNo());
                    str = "";
                }
                ++j;
            }
            preNo = curNo;
            ++i;
        }
    }

    public void print(Vector pdbVec) {
        int d = 3;
        int w = 0;
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(3);
        format.setMinimumFractionDigits(3);
        format.setGroupingUsed(false);
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int padding = 0;
        int atomNo = 0;
        String str = "";
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            String noS = String.valueOf(pp.getResidueNo());
            String resid = pp.getResidue();
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                String atom = cc.getAtom();
                double x = cc.getX();
                double y = cc.getY();
                double z = cc.getZ();
                String sX = format.format(x);
                String sY = format.format(y);
                String sZ = format.format(z);
                w = 8;
                padding = w - sX.length();
                int k = 0;
                while (k < padding) {
                    sX = " " + sX;
                    ++k;
                }
                padding = w - sY.length();
                k = 0;
                while (k < padding) {
                    sY = " " + sY;
                    ++k;
                }
                padding = w - sZ.length();
                k = 0;
                while (k < padding) {
                    sZ = " " + sZ;
                    ++k;
                }
                str = String.valueOf(str) + "ATOM  ";
                w = 5;
                String atomStr = String.valueOf(++atomNo);
                padding = w - atomStr.length();
                k = 0;
                while (k < padding) {
                    atomStr = " " + atomStr;
                    ++k;
                }
                str = String.valueOf(str) + atomStr + " ";
                w = 4;
                if (Character.isDigit(atom.charAt(0)) || atom.length() >= 4) {
                    padding = w - atom.length();
                    k = 0;
                    while (k < padding) {
                        atom = String.valueOf(atom) + " ";
                        ++k;
                    }
                } else {
                    atom = " " + atom;
                    padding = w - atom.length();
                    k = 0;
                    while (k < padding) {
                        atom = String.valueOf(atom) + " ";
                        ++k;
                    }
                }
                str = String.valueOf(str) + atom + " ";
                str = String.valueOf(str) + resid + "  ";
                w = 4;
                padding = w - noS.length();
                k = 0;
                while (k < padding) {
                    noS = " " + noS;
                    ++k;
                }
                str = String.valueOf(str) + noS + "    ";
                str = String.valueOf(str) + sX + sY + sZ + " ";
                str = String.valueOf(str) + " 1.00 ";
                str = String.valueOf(str) + " 0.00 ";
                padding = 80 - str.length();
                k = 0;
                while (k < padding) {
                    str = String.valueOf(str) + " ";
                    ++k;
                }
                System.out.println(str);
                noS = String.valueOf(pp.getResidueNo());
                str = "";
                ++j;
            }
            ++i;
        }
    }

    public void h1Distance(String pdbLists, String aaType, String nucType) {
        String src = "/net/drizzle/wlincong/pdbLocal/pdb/ultraHPdb/";
        Pdb pp = new Pdb();
        Vector<Object> pdbVec = new Vector();
        Vector<String> fileVec = new Vector<String>();
        Vector phiPsiRdc = new Vector();
        Vector disVec = new Vector();
        Vector allDisVec = new Vector();
        try {
            String ss;
            BufferedReader in = new BufferedReader(new FileReader(pdbLists));
            while ((ss = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(ss);
                while (st.hasMoreTokens()) {
                    fileVec.add(st.nextToken());
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + pdbLists);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        int i = 0;
        while (i < fileVec.size()) {
            pdbVec = pp.readPdb(String.valueOf(src) + (String)fileVec.elementAt(i));
            disVec = this.radiiFromNH(pdbVec, aaType, nucType);
            allDisVec.addAll(disVec);
            ++i;
        }
        double theta = 0.0;
        int sampleSize = allDisVec.size();
        double sum = 0.0;
        int N = 0;
        int j = 0;
        while (j < allDisVec.size()) {
            theta = (Double)allDisVec.elementAt(j);
            System.out.println(theta);
            sum += theta;
            ++N;
            ++j;
        }
    }

    public static void main0(String[] argv) {
        int ensembleID;
        long startTime = System.currentTimeMillis();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        ModelRdc mdc = new ModelRdc();
        Model mod = new Model();
        String paraFile = String.valueOf(src) + "parameter.txt";
        Vector paraVec = mod.parameterReader(paraFile);
        IDof2aryStructure id2ary = new IDof2aryStructure();
        String id2aryFile = String.valueOf(src) + "secondaryElements.txt";
        Vector idVec = id2ary.IDof2aryStructureReader(id2aryFile);
        Vector[] orderVec = id2ary.getOrder(id2aryFile);
        int i = 0;
        while (i < idVec.size()) {
            id2ary = (IDof2aryStructure)idVec.elementAt(i);
            System.out.println(id2ary);
            ++i;
        }
        Pdb pp = new Pdb();
        String rdcNhFile = String.valueOf(src) + "nhRdc.txt";
        String rdcChFile = String.valueOf(src) + "chRdc.txt";
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(rdcNhFile);
        Vector cahaRdc = dd.rdcRead(rdcChFile);
        Vector<Vector<Dipolar>> hRdc1Vec = dd.rdcReader(rdcNhFile, idVec, "H");
        Vector<Vector<Dipolar>> hRdc2Vec = dd.rdcReader(rdcChFile, idVec, "H");
        Vector<Dipolar> helixRdc1Vec = hRdc1Vec.elementAt(0);
        Vector<Dipolar> helixRdc2Vec = hRdc2Vec.elementAt(0);
        double[] saupe = new double[5];
        Map saupeMap = (Map)paraVec.elementAt(0);
        int refineCycle = Integer.parseInt((String)saupeMap.get("REFINECYCLE"));
        int dfsCycle = Integer.parseInt((String)saupeMap.get("DFSCYCLE"));
        boolean debugDFS = new Boolean((String)saupeMap.get("DEBUGDFS"));
        boolean printResults = new Boolean((String)saupeMap.get("PRINTRESULTS"));
        PdbRdc pdr = new PdbRdc();
        double[] ramaFilter = new double[]{-1.7453292519943295, -0.5235987755982988, -1.5707963267948966, -0.2617993877991494};
        double phiAve = -1.1397000015522971;
        double psiAve = -0.6876597252857658;
        double[] n1 = new double[]{0.0, 0.0, 0.0};
        double[] nh1 = new double[]{0.0, 0.0, -1.02};
        double[] ca1 = new double[]{0.0, 1.458 * Math.cos(0.5085994160066596), 1.458 * Math.sin(0.5085994160066596)};
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        i = 42;
        while (i <= 47) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiAve, psiAve));
            ++i;
        }
        Vector pdbHelix42To47 = mdc.modelBuild(phiPsiVec, n1, nh1, ca1);
        double Syy = 4.376784017029875;
        double Szz = 8.196982687769985;
        Map helixMap = (Map)paraVec.elementAt(1);
        double resolution = new Double((String)helixMap.get("RESOLUTION"));
        refineCycle = Integer.parseInt((String)helixMap.get("REFINECYCLE"));
        dfsCycle = Integer.parseInt((String)helixMap.get("DFSCYCLE"));
        debugDFS = new Boolean((String)helixMap.get("DEBUGDFS"));
        printResults = new Boolean((String)helixMap.get("PRINTRESULTS"));
        double w4Angles = new Double((String)helixMap.get("WEIGHT4ANGLES"));
        phiAve = -1.1397000015522971;
        psiAve = -0.6876597252857658;
        Pdb temp2 = new Pdb();
        resolution = 1.0;
        refineCycle = 6;
        dfsCycle = 931072;
        debugDFS = true;
        printResults = true;
        w4Angles = 0.6;
        double rdcRmsdThreshold = 0.0;
        String strPdbOptimal = String.valueOf(src) + "H5NEW.pdb";
        Vector<Pdb> ppVecOptimal42To47 = pp.readPdb(strPdbOptimal);
        Vector<Pdb> vecBBTemp = pp.OutputBackbone(ppVecOptimal42To47);
        mdc.PrintAllByGridSearch(vecBBTemp, helixRdc1Vec, helixRdc2Vec, Syy, Szz, resolution, rdcRmsdThreshold);
        System.out.println("noting... ");
        int ensembleIDTemp = 5;
        int nTotalModel = 9;
        Vector vecVdw = new Vector();
        int j = 0;
        while (j <= nTotalModel) {
            Vector vecEnsemblePdb = new Vector();
            String strEnsemPdb = String.valueOf(src) + "final_ensemble" + j + ".pdb";
            vecEnsemblePdb = pp.readPdbAndParametersFromEnsemble(strEnsemPdb);
            System.out.println("input: " + strEnsemPdb);
            vecVdw.addAll(vecEnsemblePdb);
            ++j;
        }
        Collections.sort(vecVdw, new vdw.VdwComparator());
        String fileNameTemp = String.valueOf(src) + "final_ensemble_all" + ".pdb";
        int chosenNumTemp = vecVdw.size();
        Vector vecPdbTemp = new Vector();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileNameTemp)));
            i = 0;
            while (i < Math.min(chosenNumTemp, vecVdw.size())) {
                vdw vdw1 = new vdw();
                vdw1 = (vdw)vecVdw.elementAt(i);
                vecPdbTemp = vdw1.getPDB();
                double sc = vdw1.getVdwScore();
                System.out.println(String.valueOf(i) + "th score =" + sc);
                out.println("MODEL" + i);
                out.println("REMARK     original ensembleID:" + vdw1.getEnsembleID());
                out.println("REMARK     original modelID:" + vdw1.getModelID());
                out.println("REMARK     overall (ch and nh) RDC RMSD:" + sc);
                out.println("REMARK     HN RDC RMSD:" + vdw1.getNhRmsd());
                out.println("REMARK     CaHa RDC RMSD:" + vdw1.getChRmsd());
                pp.printToFile(vecPdbTemp, fileNameTemp, out);
                out.println("TER");
                out.println("ENDMDL");
                ++i;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileNameTemp);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Vector vecPdb = new Vector();
        resolution = 2.0;
        refineCycle = 3;
        double[] nhRdcRmsd = new double[1];
        double[] chRdcRmsd = new double[1];
        Vector<vdw> vecVdwScore = new Vector<vdw>();
        j = ensembleID = 9;
        while (j <= ensembleID) {
            String strEnsemPdb = String.valueOf(src) + "IdealHelix" + j + ".pdb";
            Vector vecEnsemblePdb = pp.readPdbFromEnsemble(strEnsemPdb);
            System.out.println("input: " + strEnsemPdb);
            vecVdwScore = new Vector();
            i = 14;
            while (i >= 9) {
                String fileNameOne = String.valueOf(src) + "final_ensemble" + ensembleID + "00" + i + ".pdb";
                try {
                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileNameOne)));
                    System.out.println(" i= " + i);
                    vecPdb = new Vector();
                    vecPdb = (Vector)vecEnsemblePdb.elementAt(i);
                    refineCycle = 3;
                    System.out.println("===============helix1=====================");
                    Vector<Pdb> helixPdbVec22 = mdc.refineHelix22NoGridSearch(vecPdb, helixRdc1Vec, helixRdc2Vec, Syy, Szz, ramaFilter, phiAve, psiAve, refineCycle, dfsCycle, w4Angles, resolution, debugDFS, printResults, nhRdcRmsd, chRdcRmsd);
                    temp2 = new Pdb();
                    temp2.print(helixPdbVec22);
                    refineCycle = 1;
                    System.out.println("===============helix2=====================");
                    Vector<Pdb> helixPdbVec2 = mdc.refineHelix22(helixPdbVec22, helixRdc1Vec, helixRdc2Vec, Syy, Szz, ramaFilter, phiAve, psiAve, refineCycle, dfsCycle, w4Angles, resolution, debugDFS, printResults, nhRdcRmsd, chRdcRmsd);
                    temp2.print(helixPdbVec2);
                    System.out.println("===============helix3=====================");
                    Vector<Pdb> helixPdbVec3 = mdc.refineHelix22(helixPdbVec2, helixRdc1Vec, helixRdc2Vec, Syy, Szz, ramaFilter, phiAve, psiAve, refineCycle, dfsCycle, w4Angles, resolution, debugDFS, printResults, nhRdcRmsd, chRdcRmsd);
                    temp2.print(helixPdbVec3);
                    vecVdwScore.add(new vdw(helixPdbVec3, nhRdcRmsd[0] + chRdcRmsd[0], nhRdcRmsd[0], chRdcRmsd[0], j, i));
                    double temp = nhRdcRmsd[0] + chRdcRmsd[0];
                    out.println("MODEL" + i);
                    out.println("REMARK     original ensembleID:" + ensembleID);
                    out.println("REMARK     original modelID:" + i);
                    out.println("REMARK     overall (ch and nh) RDC RMSD:" + temp);
                    out.println("REMARK     HN RDC RMSD:" + nhRdcRmsd[0]);
                    out.println("REMARK     CaHa RDC RMSD:" + chRdcRmsd[0]);
                    pp.printToFile(helixPdbVec3, fileNameOne, out);
                    out.println("TER");
                    out.println("ENDMDL");
                    out.println("END");
                    out.close();
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found: " + fileNameOne);
                }
                catch (IOException e) {
                    System.out.println("IOException: the stack trace is:");
                    e.printStackTrace();
                }
                --i;
            }
            ++j;
        }
        Collections.sort(vecVdwScore, new vdw.VdwComparator());
        String fileName = String.valueOf(src) + "final_ensemble" + ensembleID + ".pdb";
        int chosenNum = vecVdwScore.size();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            i = 0;
            while (i < Math.min(chosenNum, vecVdwScore.size())) {
                vdw vdw1 = new vdw();
                vdw1 = (vdw)vecVdwScore.elementAt(i);
                vecPdb = vdw1.getPDB();
                double sc = vdw1.getVdwScore();
                System.out.println(String.valueOf(i) + "th score =" + sc);
                out.println("MODEL" + i);
                out.println("REMARK     original ensembleID:" + vdw1.getEnsembleID());
                out.println("REMARK     original modelID:" + vdw1.getModelID());
                out.println("REMARK     overall (ch and nh) RDC RMSD:" + sc);
                out.println("REMARK     HN RDC RMSD:" + vdw1.getNhRmsd());
                out.println("REMARK     CaHa RDC RMSD:" + vdw1.getChRmsd());
                pp.printToFile(vecPdb, fileName, out);
                out.println("TER");
                out.println("ENDMDL");
                ++i;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public String obtainPdbAtomNameScheme(Vector<Pdb> vecPdb) {
        String atom;
        Cartesian cc;
        int j;
        Vector<Cartesian> vecAtom;
        String res;
        Pdb pdb;
        String nameScheme = "PDB-NEW";
        int i = 0;
        while (i < vecPdb.size()) {
            pdb = vecPdb.elementAt(i);
            res = pdb.getResidue();
            vecAtom = pdb.getAtomVec();
            if (!(res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("GLY") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("THR") || res.equalsIgnoreCase("VAL"))) {
                j = 0;
                while (j < vecAtom.size()) {
                    cc = vecAtom.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("HB3")) {
                        nameScheme = "BMRB-NEW";
                        return nameScheme;
                    }
                    if (atom.equalsIgnoreCase("3HB")) {
                        nameScheme = "BMRB-OLD";
                        return nameScheme;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < vecPdb.size()) {
            pdb = vecPdb.elementAt(i);
            res = pdb.getResidue();
            vecAtom = pdb.getAtomVec();
            if (!(res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("GLY") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("THR") || res.equalsIgnoreCase("VAL"))) {
                j = 0;
                while (j < vecAtom.size()) {
                    cc = vecAtom.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("2HB")) {
                        nameScheme = "PDB-OLD";
                        return nameScheme;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return nameScheme;
    }

    public Vector<Assign> getSeqFromPdb(Vector<Pdb> vecPdb) {
        Vector<Assign> vecSegTemp = new Vector<Assign>();
        int i = 0;
        while (i < vecPdb.size()) {
            Pdb pdb = vecPdb.elementAt(i);
            int resNo = pdb.getResidueNo();
            String res = pdb.getResidue();
            if (res.equalsIgnoreCase("HIE") || res.equalsIgnoreCase("HID")) {
                res = "HIS";
            }
            if (res.equalsIgnoreCase("CYX")) {
                res = "CYS";
            }
            vecSegTemp.add(new Assign(resNo, res));
            ++i;
        }
        return vecSegTemp;
    }

    public static class PdbComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            int d2;
            Pdb n1 = (Pdb)o1;
            Pdb n2 = (Pdb)o2;
            int d1 = n1.getResidueNo();
            if (d1 < (d2 = n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

