/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.H1CS;
import rdcPanda.Hsqc;
import rdcPanda.Model;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.Peak;

public class vdw {
    String _id;
    double[] _coord = new double[3];
    Vector vecPdb = new Vector();
    double vdw_score = 0.0;
    double nhRmsd = 0.0;
    double chRmsd = 0.0;
    double noeRmsd = 0.0;
    int ensembleID = 0;
    int modelID = 0;

    public vdw() {
    }

    public vdw(Vector vecPp, double sc) {
        this.vecPdb = vecPp;
        this.vdw_score = sc;
    }

    public vdw(Vector vecPp, double sc, double noe_sc) {
        this.vecPdb = vecPp;
        this.vdw_score = sc;
        this.noeRmsd = noe_sc;
    }

    public vdw(Vector vecPp, double sc, double noe_sc, int modID) {
        this.vecPdb = vecPp;
        this.vdw_score = sc;
        this.noeRmsd = noe_sc;
        this.modelID = modID;
    }

    public vdw(Vector vecPp, double sc, double noe_sc, int modID, String id) {
        this.vecPdb = vecPp;
        this.vdw_score = sc;
        this.noeRmsd = noe_sc;
        this.modelID = modID;
        this._id = id;
    }

    public vdw(Vector vecPp, double sc, double nhRms, double chRms, int enID, int modID) {
        this.vecPdb = vecPp;
        this.vdw_score = sc;
        this.nhRmsd = nhRms;
        this.chRmsd = chRms;
        this.ensembleID = enID;
        this.modelID = modID;
    }

    public vdw(String id2, double[] coord2) {
        this._id = id2;
        System.arraycopy(coord2, 0, this._coord, 0, 3);
    }

    public Vector getPDB() {
        return this.vecPdb;
    }

    public double getVdwScore() {
        return this.vdw_score;
    }

    public double getNoeRmsd() {
        return this.noeRmsd;
    }

    public double getEnsembleID() {
        return this.ensembleID;
    }

    public double getModelID() {
        return this.modelID;
    }

    public String getStringID() {
        return this._id;
    }

    public double getNhRmsd() {
        return this.nhRmsd;
    }

    public double getChRmsd() {
        return this.chRmsd;
    }

    public String getID() {
        return this._id;
    }

    public double[] getCoord() {
        return this._coord;
    }

    public void setID(String id2) {
        this._id = id2;
    }

    public void setCoord(double[] coord2) {
        System.arraycopy(coord2, 0, this._coord, 0, 3);
    }

    public double length(double[] v1) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        return v1Len;
    }

    public double[] internuclearVec(double[] n1, double[] n2) {
        return new double[]{n2[0] - n1[0], n2[1] - n1[1], n2[2] - n1[2]};
    }

    public Vector convert2VDW(Vector pdbVec) {
        Pdb pp = new Pdb();
        String name = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Vector<vdw> vdwVec = new Vector<vdw>();
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            int no = pp.getResidueNo();
            atomVec = pp.getAtomVec();
            String resid = pp.getResidue();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                String atom = cc.getAtom();
                name = String.valueOf(resid) + no + "_" + atom;
                vdwVec.add(new vdw(name, cc.getXYZ()));
                ++j;
            }
            ++i;
        }
        return vdwVec;
    }

    public Vector convert2VDW(Pdb[] pdbVec) {
        Pdb pp = new Pdb();
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Vector<vdw> vdwVec = new Vector<vdw>();
        String name = "";
        int i = 0;
        while (i < pdbVec.length) {
            pp = pdbVec[i];
            int no = pp.getResidueNo();
            atomVec = pp.getAtomVec();
            String resid = pp.getResidue();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                name = String.valueOf(resid) + no + "_" + cc.getAtom();
                vdwVec.add(new vdw(name, cc.getXYZ()));
                ++j;
            }
            ++i;
        }
        return vdwVec;
    }

    public boolean computeVDW(Vector vdwVec, double[] vdwValue, boolean isHelix) {
        int index = -1;
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        vdw vander1 = new vdw();
        vdw vander2 = new vdw();
        double rms = 0.0;
        double distance = 0.0;
        double rmsOne = 0.0;
        String resid = "";
        boolean isHbond = false;
        int i = 0;
        while (i < vdwVec.size()) {
            vander1 = (vdw)vdwVec.elementAt(i);
            String id1 = vander1.getID();
            resid = id1.substring(0, 3);
            index = id1.indexOf("_");
            int no1 = Integer.parseInt(id1.substring(3, index).trim());
            if (index <= -1) {
                return false;
            }
            String name1 = id1.substring(index + 1);
            coord1 = vander1.getCoord();
            int j = i + 1;
            while (j < vdwVec.size()) {
                vander2 = (vdw)vdwVec.elementAt(j);
                String id2 = vander2.getID();
                index = id2.indexOf("_");
                int no2 = Integer.parseInt(id2.substring(3, index).trim());
                if (index <= -1) {
                    return false;
                }
                String name2 = id2.substring(index + 1);
                coord2 = vander2.getCoord();
                distance = this.length(this.internuclearVec(coord2, coord1));
                isHbond = false;
                if (isHelix && name1.equals("O") && name2.equals("H") && no2 - no1 == 4) {
                    isHbond = true;
                }
                if (!this.isBonded(no1, no2, name1, name2)) {
                    rmsOne = this.checkVDW(name1, name2, distance, isHbond);
                    rms += Math.sqrt(rmsOne);
                }
                ++j;
            }
            ++i;
        }
        vdwValue[0] = rms;
        return true;
    }

    public boolean computeVDW(Vector vdwVec, double[] vdwValue, double vdwLevel, boolean printVDWViolation) {
        int index = -1;
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        vdw vander1 = new vdw();
        vdw vander2 = new vdw();
        double rms = 0.0;
        double distance = 0.0;
        double rmsOne = 0.0;
        String resid = "";
        int i = 0;
        while (i < vdwVec.size()) {
            vander1 = (vdw)vdwVec.elementAt(i);
            String id1 = vander1.getID();
            resid = id1.substring(0, 3);
            index = id1.indexOf("_");
            int no1 = Integer.parseInt(id1.substring(3, index).trim());
            if (index <= -1) {
                return false;
            }
            String name1 = id1.substring(index + 1);
            coord1 = vander1.getCoord();
            int j = i + 1;
            while (j < vdwVec.size()) {
                vander2 = (vdw)vdwVec.elementAt(j);
                String id2 = vander2.getID();
                index = id2.indexOf("_");
                int no2 = Integer.parseInt(id2.substring(3, index).trim());
                if (index <= -1) {
                    return false;
                }
                String name2 = id2.substring(index + 1);
                coord2 = vander2.getCoord();
                distance = this.length(this.internuclearVec(coord2, coord1));
                if (!this.isBonded(resid, no1, no2, name1, name2)) {
                    rmsOne = this.checkVDW(name1, name2, distance, false);
                    if (rmsOne > vdwLevel && printVDWViolation) {
                        System.out.println(String.valueOf(id1) + "  " + id2 + "  " + Math.sqrt(rmsOne) + "  " + distance);
                    }
                    rms += Math.sqrt(rmsOne);
                }
                ++j;
            }
            ++i;
        }
        vdwValue[0] = rms;
        return true;
    }

    public boolean computeVDW(Vector vdwVec, double[] vdwValue, double vdwLevel, boolean printVDWViolation, boolean isHelix) {
        int index = -1;
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        vdw vander1 = new vdw();
        vdw vander2 = new vdw();
        double rms = 0.0;
        double distance = 0.0;
        double rmsOne = 0.0;
        String resid = "";
        boolean isHbond = false;
        int i = 0;
        while (i < vdwVec.size()) {
            vander1 = (vdw)vdwVec.elementAt(i);
            String id1 = vander1.getID();
            resid = id1.substring(0, 3);
            index = id1.indexOf("_");
            int no1 = Integer.parseInt(id1.substring(3, index).trim());
            if (index <= -1) {
                return false;
            }
            String name1 = id1.substring(index + 1);
            coord1 = vander1.getCoord();
            int j = i + 1;
            while (j < vdwVec.size()) {
                vander2 = (vdw)vdwVec.elementAt(j);
                String id2 = vander2.getID();
                index = id2.indexOf("_");
                int no2 = Integer.parseInt(id2.substring(3, index).trim());
                if (index <= -1) {
                    return false;
                }
                String name2 = id2.substring(index + 1);
                coord2 = vander2.getCoord();
                distance = this.length(this.internuclearVec(coord2, coord1));
                isHbond = false;
                if (!this.isBonded(resid, no1, no2, name1, name2)) {
                    if (isHelix && name1.equals("O") && name2.equals("H") && no2 - no1 == 4) {
                        isHbond = true;
                    }
                    if ((rmsOne = this.checkVDW(name1, name2, distance, isHbond)) > vdwLevel && printVDWViolation) {
                        System.out.println(String.valueOf(id1) + "  " + id2 + "  " + Math.sqrt(rmsOne) + "   " + distance);
                    }
                    rms += Math.sqrt(rmsOne);
                }
                ++j;
            }
            ++i;
        }
        vdwValue[0] = rms;
        return true;
    }

    public int OutputStericClashResidues(Vector vdwVec, double[] vdwValue, double vdwLevel, boolean printVDWViolation, boolean isHelix, double stericThreshold, int numThreshold, boolean[] resClash, boolean isPrint) {
        int nClashRes = 0;
        int index = -1;
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        vdw vander1 = new vdw();
        vdw vander2 = new vdw();
        double rms = 0.0;
        double distance = 0.0;
        double rmsOne = 0.0;
        String resid = "";
        boolean isHbond = false;
        int numClashes = 0;
        int i = 0;
        while (i < resClash.length) {
            resClash[i] = false;
            ++i;
        }
        i = 0;
        while (i < vdwVec.size()) {
            vander1 = (vdw)vdwVec.elementAt(i);
            String id1 = vander1.getID();
            resid = id1.substring(0, 3);
            index = id1.indexOf("_");
            int no1 = Integer.parseInt(id1.substring(3, index).trim());
            if (index > -1) {
                String name1 = id1.substring(index + 1);
                coord1 = vander1.getCoord();
                int j = i + 1;
                while (j < vdwVec.size()) {
                    vander2 = (vdw)vdwVec.elementAt(j);
                    String id2 = vander2.getID();
                    numClashes = 0;
                    index = id2.indexOf("_");
                    int no2 = Integer.parseInt(id2.substring(3, index).trim());
                    if (index > -1) {
                        String name2 = id2.substring(index + 1);
                        coord2 = vander2.getCoord();
                        distance = this.length(this.internuclearVec(coord2, coord1));
                        isHbond = false;
                        if (!this.isBonded(resid, no1, no2, name1, name2)) {
                            double rmsd;
                            if (isHelix && name1.equals("O") && name2.equals("H") && no2 - no1 == 4) {
                                isHbond = true;
                            }
                            if ((rmsd = Math.sqrt(rmsOne = this.checkVDW(name1, name2, distance, isHbond))) > stericThreshold) {
                                ++numClashes;
                            }
                            if (numClashes >= numThreshold) {
                                resClash[no1] = true;
                                resClash[no2] = true;
                            }
                            if (rmsOne > vdwLevel && printVDWViolation) {
                                System.out.println(String.valueOf(id1) + "  " + id2 + "  " + Math.sqrt(rmsOne) + "   " + distance);
                            }
                            rms += Math.sqrt(rmsOne);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        vdwValue[0] = rms;
        i = 0;
        while (i < resClash.length) {
            if (resClash[i]) {
                ++nClashRes;
            }
            ++i;
        }
        String strOut = "";
        if (isPrint) {
            i = 0;
            while (i < resClash.length) {
                if (resClash[i]) {
                    strOut = String.valueOf(strOut) + " , " + i;
                }
                ++i;
            }
            System.out.println("Clash residues: " + strOut);
        }
        return nClashRes;
    }

    public boolean checkStericClash(Vector vdwVec, double[] vdwValue, double vdwLevel, boolean printVDWViolation, boolean isHelix, double stericThreshold, int numThreshold, int[] clashIndex) {
        int index = -1;
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        vdw vander1 = new vdw();
        vdw vander2 = new vdw();
        double rms = 0.0;
        double distance = 0.0;
        double rmsOne = 0.0;
        String resid = "";
        boolean isHbond = false;
        int numClashes = 0;
        int i = 0;
        while (i < vdwVec.size()) {
            vander1 = (vdw)vdwVec.elementAt(i);
            String id1 = vander1.getID();
            resid = id1.substring(0, 3);
            index = id1.indexOf("_");
            int no1 = Integer.parseInt(id1.substring(3, index).trim());
            if (index > -1) {
                String name1 = id1.substring(index + 1);
                coord1 = vander1.getCoord();
                int j = i + 1;
                while (j < vdwVec.size()) {
                    vander2 = (vdw)vdwVec.elementAt(j);
                    String id2 = vander2.getID();
                    index = id2.indexOf("_");
                    int no2 = Integer.parseInt(id2.substring(3, index).trim());
                    if (index > -1) {
                        String name2 = id2.substring(index + 1);
                        coord2 = vander2.getCoord();
                        distance = this.length(this.internuclearVec(coord2, coord1));
                        isHbond = false;
                        if (!this.isBonded(resid, no1, no2, name1, name2)) {
                            double rmsd;
                            if (isHelix && name1.equals("O") && name2.equals("H") && no2 - no1 == 4) {
                                isHbond = true;
                            }
                            if ((rmsd = Math.sqrt(rmsOne = this.checkVDW(name1, name2, distance, isHbond))) > stericThreshold) {
                                ++numClashes;
                            }
                            if (numClashes >= numThreshold) {
                                clashIndex[0] = no1;
                                clashIndex[1] = no2;
                                return true;
                            }
                            if (rmsOne > vdwLevel && printVDWViolation) {
                                System.out.println(String.valueOf(id1) + "  " + id2 + "  " + Math.sqrt(rmsOne) + "   " + distance);
                            }
                            rms += Math.sqrt(rmsOne);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        vdwValue[0] = rms;
        clashIndex[0] = 0;
        clashIndex[1] = 0;
        return false;
    }

    public int countStericClash(Vector vdwVec, double[] vdwValue, double vdwLevel, boolean printVDWViolation, boolean isHelix, double stericThreshold) {
        int index = -1;
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        vdw vander1 = new vdw();
        vdw vander2 = new vdw();
        double rms = 0.0;
        double distance = 0.0;
        double rmsOne = 0.0;
        String resid = "";
        boolean isHbond = false;
        int numClashes = 0;
        int i = 0;
        while (i < vdwVec.size()) {
            vander1 = (vdw)vdwVec.elementAt(i);
            String id1 = vander1.getID();
            resid = id1.substring(0, 3);
            index = id1.indexOf("_");
            int no1 = Integer.parseInt(id1.substring(3, index).trim());
            if (index > -1) {
                String name1 = id1.substring(index + 1);
                coord1 = vander1.getCoord();
                int j = i + 1;
                while (j < vdwVec.size()) {
                    vander2 = (vdw)vdwVec.elementAt(j);
                    String id2 = vander2.getID();
                    index = id2.indexOf("_");
                    int no2 = Integer.parseInt(id2.substring(3, index).trim());
                    if (index > -1) {
                        String name2 = id2.substring(index + 1);
                        coord2 = vander2.getCoord();
                        distance = this.length(this.internuclearVec(coord2, coord1));
                        isHbond = false;
                        if (!this.isBonded(resid, no1, no2, name1, name2)) {
                            double rmsd;
                            if (isHelix && name1.equals("O") && (name2.equals("H") || name2.equals("HN")) && no2 - no1 == 4) {
                                isHbond = true;
                            }
                            if (isHelix && name2.equals("O") && (name1.equals("H") || name1.equals("HN")) && no1 - no2 == 4) {
                                isHbond = true;
                            }
                            if ((rmsd = Math.sqrt(rmsOne = this.checkVDW(name1, name2, distance, isHbond))) > stericThreshold) {
                                ++numClashes;
                            }
                            if (rmsOne > vdwLevel && printVDWViolation) {
                                System.out.println(String.valueOf(id1) + "  " + id2 + "  " + Math.sqrt(rmsOne) + "   " + distance);
                            }
                            rms += Math.sqrt(rmsOne);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        vdwValue[0] = rms;
        return numClashes;
    }

    public int countStericClashBetweenTwo(Vector vdwVec, Vector vdwVec2, double[] vdwValue, double vdwLevel, boolean printVDWViolation, boolean isHelix, double stericThreshold) {
        int index = -1;
        double[] coord1 = new double[3];
        double[] coord2 = new double[3];
        vdw vander1 = new vdw();
        vdw vander2 = new vdw();
        double rms = 0.0;
        double distance = 0.0;
        double rmsOne = 0.0;
        String resid = "";
        boolean isHbond = false;
        int numClashes = 0;
        int i = 0;
        while (i < vdwVec.size()) {
            vander1 = (vdw)vdwVec.elementAt(i);
            String id1 = vander1.getID();
            resid = id1.substring(0, 3);
            index = id1.indexOf("_");
            int no1 = Integer.parseInt(id1.substring(3, index).trim());
            if (index > -1) {
                String name1 = id1.substring(index + 1);
                coord1 = vander1.getCoord();
                int j = i + 1;
                while (j < vdwVec2.size()) {
                    vander2 = (vdw)vdwVec2.elementAt(j);
                    String id2 = vander2.getID();
                    index = id2.indexOf("_");
                    int no2 = Integer.parseInt(id2.substring(3, index).trim());
                    if (index > -1) {
                        String name2 = id2.substring(index + 1);
                        coord2 = vander2.getCoord();
                        distance = this.length(this.internuclearVec(coord2, coord1));
                        isHbond = false;
                        if (!this.isBonded(resid, no1, no2, name1, name2)) {
                            double rmsd;
                            if (isHelix && name1.equals("O") && (name2.equals("H") || name2.equals("HN")) && no2 - no1 == 4) {
                                isHbond = true;
                            }
                            if (isHelix && name2.equals("O") && (name1.equals("H") || name1.equals("HN")) && no1 - no2 == 4) {
                                isHbond = true;
                            }
                            if ((rmsd = Math.sqrt(rmsOne = this.checkVDW(name1, name2, distance, isHbond))) > stericThreshold) {
                                ++numClashes;
                            }
                            if (rmsOne > vdwLevel && printVDWViolation) {
                                System.out.println(String.valueOf(id1) + "  " + id2 + "  " + Math.sqrt(rmsOne) + "   " + distance);
                            }
                            rms += Math.sqrt(rmsOne);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        vdwValue[0] = rms;
        return numClashes;
    }

    public boolean isBonded(int no1, int no2, String atom1, String atom2) {
        if (no1 == no2) {
            if (atom1.equals("H")) {
                return atom2.equals("N");
            }
            if (atom1.equals("N")) {
                return atom2.equals("H") || atom2.equals("CA");
            }
            if (atom1.equals("CA")) {
                return atom2.equals("N") || atom2.equals("C") || atom2.equals("HA") || atom2.equals("CB");
            }
            if (atom1.equals("C")) {
                return atom2.equals("CA") || atom2.equals("O");
            }
            if (atom1.equals("HA")) {
                return atom2.equals("CA");
            }
            if (atom1.equals("CB")) {
                return atom2.equals("CA") || atom2.equals("1HB") || atom2.equals("2HB") || atom2.equals("3HB");
            }
            if (atom1.indexOf("HB") > -1 && atom2.indexOf("HB") > -1) {
                return true;
            }
        } else if (no2 - no1 == 1) {
            if (atom1.equals("C")) {
                return atom2.equals("N");
            }
        } else if (no1 - no2 == 1 && atom1.equals("N")) {
            return atom2.equals("C");
        }
        return false;
    }

    public boolean isBonded(String resid, int no1, int no2, String atom1, String atom2) {
        if (no1 == no2) {
            if (Const.bondsMap.containsKey(resid)) {
                Vector bondsVec = (Vector)Const.bondsMap.get(resid);
                if (Collections.binarySearch(bondsVec, String.valueOf(atom1) + "_" + atom2) > -1) {
                    return true;
                }
            } else {
                System.out.println("no such residue " + resid);
            }
        } else if (no2 - no1 == 1) {
            if (atom1.equals("C")) {
                return atom2.equals("N");
            }
        } else if (no1 - no2 == 1 && atom1.equals("N")) {
            return atom2.equals("C");
        }
        return false;
    }

    public double checkVDW(String atom1, String atom2, double distance, boolean isHbond) {
        double rms = 0.0;
        if (atom1.indexOf("H") > -1 && atom2.indexOf("H") > -1) {
            rms = distance > 1.8 ? 0.0 : (1.8 - distance) * (1.8 - distance);
        } else if (atom1.indexOf("C") > -1 && atom2.indexOf("C") > -1) {
            rms = distance > 2.45 ? 0.0 : (2.45 - distance) * (2.45 - distance);
        } else if (atom1.indexOf("N") > -1 && atom2.indexOf("N") > -1) {
            rms = distance > 2.5 ? 0.0 : (2.5 - distance) * (2.5 - distance);
        } else if (atom1.indexOf("O") > -1 && atom2.indexOf("O") > -1) {
            rms = distance > 2.5 ? 0.0 : (2.5 - distance) * (2.5 - distance);
        } else if (atom1.indexOf("S") > -1 && atom2.indexOf("S") > -1) {
            rms = distance > 2.5 ? 0.0 : (2.5 - distance) * (2.5 - distance);
        } else if (atom1.indexOf("H") > -1 && atom2.indexOf("O") > -1 || atom1.indexOf("O") > -1 && atom2.indexOf("H") > -1) {
            rms = isHbond ? (distance > 1.569 ? 0.0 : (1.569 - distance) * (1.569 - distance)) : (distance > 2.0 ? 0.0 : (2.0 - distance) * (2.0 - distance));
        } else if (atom1.indexOf("H") > -1 && atom2.indexOf("C") > -1 || atom1.indexOf("C") > -1 && atom2.indexOf("H") > -1) {
            rms = distance > 2.03 ? 0.0 : (2.03 - distance) * (2.03 - distance);
        } else if (atom1.indexOf("H") > -1 && atom2.indexOf("N") > -1 || atom1.indexOf("N") > -1 && atom2.indexOf("H") > -1) {
            rms = distance > 2.0 ? 0.0 : (2.0 - distance) * (2.0 - distance);
        } else if (atom1.indexOf("H") > -1 && atom2.indexOf("S") > -1 || atom1.indexOf("S") > -1 && atom2.indexOf("H") > -1) {
            rms = distance > 2.2 ? 0.0 : (2.2 - distance) * (2.2 - distance);
        } else if (atom1.indexOf("C") > -1 && atom2.indexOf("O") > -1 || atom1.indexOf("O") > -1 && atom2.indexOf("C") > -1) {
            rms = distance > 2.4 ? 0.0 : (2.4 - distance) * (2.4 - distance);
        } else if (atom1.indexOf("N") > -1 && atom2.indexOf("O") > -1 || atom1.indexOf("O") > -1 && atom2.indexOf("N") > -1) {
            rms = distance > 2.25 ? 0.0 : (2.25 - distance) * (2.25 - distance);
        } else if (atom1.indexOf("N") > -1 && atom2.indexOf("C") > -1 || atom1.indexOf("C") > -1 && atom2.indexOf("N") > -1) {
            rms = distance > 2.45 ? 0.0 : (2.45 - distance) * (2.45 - distance);
        } else if (atom1.indexOf("C") > -1 && atom2.indexOf("S") > -1 || atom1.indexOf("S") > -1 && atom2.indexOf("C") > -1) {
            rms = distance > 2.3 ? 0.0 : (2.3 - distance) * (2.3 - distance);
        } else if (atom1.indexOf("N") > -1 && atom2.indexOf("S") > -1 || atom1.indexOf("S") > -1 && atom2.indexOf("N") > -1) {
            rms = distance > 2.1 ? 0.0 : (2.1 - distance) * (2.1 - distance);
        } else if (atom1.indexOf("O") > -1 && atom2.indexOf("S") > -1 || atom1.indexOf("S") > -1 && atom2.indexOf("O") > -1) {
            rms = distance > 2.2 ? 0.0 : (2.2 - distance) * (2.2 - distance);
        } else if (atom1.indexOf("Q") > -1 || atom2.indexOf("Q") > -1) {
            rms = 0.0;
        } else {
            System.out.println("NO such atoms in checkVDW  " + atom1 + "   " + atom2);
        }
        return rms;
    }

    public void mergeAndCluster(String src, String srcOut, String strPreEnsemb, int maxStr, int maxEnsemSize, double resolution, String strNewEnsemb, String strDelimit) throws JampackException {
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector vecPdb = new Vector();
        Vector vecVdw = new Vector();
        Vector vecEnsemPdbNew = new Vector();
        Model md = new Model();
        int counter = 0;
        Vector<Vector> vecEnsemAfterThin = new Vector<Vector>();
        Vector vecRefPdb = new Vector();
        int t = 0;
        while (t < maxEnsemSize) {
            int j = 0;
            while (j <= maxStr) {
                String strEnsemPdb = "";
                strEnsemPdb = maxEnsemSize <= 1 ? String.valueOf(src) + strPreEnsemb + j + ".pdb" : String.valueOf(src) + strPreEnsemb + t + strDelimit + j + ".pdb";
                System.out.println("input: " + strEnsemPdb);
                File f = new File(strEnsemPdb);
                if (!f.exists()) {
                    System.out.println("Couldn't find file " + strEnsemPdb + " for clustering, continue...");
                } else {
                    Vector vecEnsemble = pp.readPdbAndNoeHarmFromEnsemble(strEnsemPdb);
                    if (vecEnsemble != null) {
                        int i = 0;
                        while (i < vecEnsemble.size()) {
                            vecVdw = new Vector();
                            vdw Vdw = (vdw)vecEnsemble.elementAt(i);
                            vecPdb = Vdw.getPDB();
                            if (vecPdb.size() >= 1) {
                                double noeRms = Vdw.getNoeRmsd();
                                Vector<Pdb> vecTempPdbBB = pp.OutputBackbone(vecPdb);
                                if (vecEnsemAfterThin.size() == 1) {
                                    Vector vecTempPdb = (Vector)vecEnsemAfterThin.elementAt(0);
                                    vecRefPdb.addAll(vecTempPdb);
                                }
                                Vector vecPdbRotate = new Vector();
                                vecPdbRotate = vecEnsemAfterThin.size() > 1 ? md.BackonbeRotation(vecPdb, vecRefPdb) : vecPdb;
                                boolean isInPreClusters = pp.isInPdbClusters(vecEnsemAfterThin, vecPdbRotate, resolution);
                                if (!isInPreClusters) {
                                    vecEnsemAfterThin.add(vecPdbRotate);
                                    String fileName = String.valueOf(srcOut) + strNewEnsemb + counter + ".pdb";
                                    try {
                                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                        out.println("REMARK     the structure index: " + counter);
                                        pp.printToFile(vecPdb, fileName, out);
                                        out.println("TER");
                                        out.println("END");
                                        out.close();
                                        ++counter;
                                    }
                                    catch (FileNotFoundException e) {
                                        System.out.println("File not found: " + fileName);
                                    }
                                    catch (IOException e) {
                                        System.out.println("IOException: the stack trace is:");
                                        e.printStackTrace();
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++j;
            }
            ++t;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public void mergeAndClusterAll(String src, String srcOut, double resolution, String strNewEnsemb) throws JampackException {
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector vecPdb = new Vector();
        Vector vecVdw = new Vector();
        Vector vecEnsemPdbNew = new Vector();
        Model md = new Model();
        String userDir = System.getProperty("user.dir");
        File myDir = new File(src);
        String[] contents = myDir.list();
        if (contents == null) {
            System.out.println(String.valueOf(myDir.getName()) + " is not a directory");
        }
        int counter = 0;
        Vector vecEnsemAfterThin = new Vector();
        Vector vecRefPdb = new Vector();
        int t = 0;
        while (t < contents.length) {
            String filename = contents[t];
            String strEnsemPdb = "";
            strEnsemPdb = String.valueOf(src) + filename;
            System.out.println("input: " + strEnsemPdb);
            File f = new File(strEnsemPdb);
            if (!f.exists()) {
                System.out.println("Couldn't find file " + strEnsemPdb + " for clustering, continue...");
            } else {
                Vector vecEnsemble = pp.readPdbAndNoeHarmFromEnsemble(strEnsemPdb);
                if (vecEnsemble != null) {
                    int i = 0;
                    while (i < vecEnsemble.size()) {
                        vecVdw = new Vector();
                        vdw Vdw = (vdw)vecEnsemble.elementAt(i);
                        vecPdb = Vdw.getPDB();
                        if (vecPdb.size() >= 1) {
                            double noeRms = Vdw.getNoeRmsd();
                            Vector<Pdb> vecTempPdbBB = pp.OutputBackbone(vecPdb);
                            if (vecEnsemAfterThin.size() == 1) {
                                Vector vecTempPdb = (Vector)vecEnsemAfterThin.elementAt(0);
                                vecRefPdb.addAll(vecTempPdb);
                            }
                            Vector vecPdbRotate = new Vector();
                            vecPdbRotate = vecEnsemAfterThin.size() > 1 ? md.BackonbeRotation(vecPdb, vecRefPdb) : vecPdb;
                            boolean isInPreClusters = false;
                            vecEnsemAfterThin = new Vector();
                            String outPackPath = String.valueOf(userDir) + strNewEnsemb;
                            int idPath = outPackPath.lastIndexOf(47);
                            String outPackDir = outPackPath.substring(0, idPath + 1);
                            File DirNewEnsem = new File(outPackDir);
                            String[] contentsNew = DirNewEnsem.list();
                            int x = 0;
                            while (x < contentsNew.length) {
                                String filenameNew = contentsNew[x];
                                String strEnsemPdbNew = "";
                                strEnsemPdbNew = String.valueOf(outPackDir) + filenameNew;
                                File f_new = new File(strEnsemPdbNew);
                                if (!f_new.exists()) {
                                    System.out.println("Couldn't find file " + strEnsemPdbNew + " for clustering, continue...");
                                } else {
                                    double resolutionNew;
                                    vdw VdwNew;
                                    Vector vecPdbNew;
                                    double rmsd;
                                    Vector vecEnsembleNew = pp.readPdbAndNoeHarmFromEnsemble(strEnsemPdbNew);
                                    if (vecEnsembleNew != null && (rmsd = pp.compRmsdBetwTwoPdbs(vecPdbNew = (VdwNew = (vdw)vecEnsembleNew.elementAt(0)).getPDB(), vecPdbRotate, true)) < (resolutionNew = resolution * 2.0)) {
                                        isInPreClusters = true;
                                        break;
                                    }
                                }
                                ++x;
                            }
                            if (!isInPreClusters) {
                                String fileName = String.valueOf(userDir) + strNewEnsemb + counter + ".pdb";
                                try {
                                    PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                    out.println("REMARK     the structure index: " + counter);
                                    pp.printToFile(vecPdb, fileName, out);
                                    out.println("TER");
                                    out.println("END");
                                    out.close();
                                    ++counter;
                                }
                                catch (FileNotFoundException e) {
                                    System.out.println("File not found: " + fileName);
                                }
                                catch (IOException e) {
                                    System.out.println("IOException: the stack trace is:");
                                    e.printStackTrace();
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            ++t;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
    }

    public static void main(String[] argv) throws JampackException {
        long startTime = System.currentTimeMillis();
        int chosenNum = 25;
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        String paramFile = String.valueOf(src) + "parameters.input";
        Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        double noeBound = 0.0;
        String strSeq = "";
        String strBB = "";
        String strReson = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String strManualAsg = "";
        String strSSES = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("NOEBOUND")) {
                noeBound = Double.parseDouble(paraMap.get("NOEBOUND"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            strSeq = strSeq.toLowerCase();
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            strNoesy2D = strNoesy2D.toLowerCase();
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            strHnNoesy3D = strHnNoesy3D.toLowerCase();
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            strHaNoesy3D = strHaNoesy3D.toLowerCase();
            if (paraMap.containsKey("MANUAL-ASSIGNMENT")) {
                strManualAsg = paraMap.get("MANUAL-ASSIGNMENT");
            }
            strManualAsg = strManualAsg.toLowerCase();
            if (paraMap.containsKey("SSES")) {
                strSSES = paraMap.get("SSES");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String pdbFile = String.valueOf(src) + strBB;
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<H1CS> assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Object> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = noesy.NoesyReaderNMRView(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNewNoesy = noesy.SetCalibration(vecNoesy);
        String manualAsgFile = String.valueOf(src) + strManualAsg;
        Noe noe_temp = new Noe();
        Vector vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
        int numFiles = 50;
        Vector vecPdb = new Vector();
        Vector vecVdw = new Vector();
        Vector vecEnsemPdbNew = new Vector();
        Vector vecVdwScoreNew = new Vector();
        Vector vecVdwScore = new Vector();
        Model md = new Model();
        String strNOEScore = "[ ";
        int counter = 0;
        Vector vecEnsemAfterThin = new Vector();
        Vector vecRefPdb = new Vector();
        int j = 13;
        while (j <= 441) {
            String strEnsemPdb = String.valueOf(src) + "FF2FinalNew" + j + ".pdb";
            Vector vecEnsemble = pp.readPdbAndNoeHarmFromEnsemble(strEnsemPdb);
            System.out.println("input: " + strEnsemPdb);
            if (vecEnsemble != null) {
                double[] vdwScore = new double[vecEnsemble.size()];
                vdw vander = new vdw();
                Vector vdwVec = new Vector();
                double[] vdwValue = new double[1];
                boolean hasVDW = false;
                double vdwLevel = 0.05;
                boolean printVDWViolation = false;
                int i2 = 0;
                while (i2 < vecEnsemble.size()) {
                    vecVdw = new Vector();
                    vdw Vdw = (vdw)vecEnsemble.elementAt(i2);
                    vecPdb = Vdw.getPDB();
                    double noeRms = Vdw.getNoeRmsd();
                    Vector<Pdb> vecTempPdbBB = pp.OutputBackbone(vecPdb);
                    double[] noeRmsd = new double[2];
                    double[] noeHarmScore = new double[2];
                    int[] numConflicts = new int[2];
                    boolean[] resIndex = new boolean[vecTempPdbBB.size()];
                    int kk = 0;
                    while (kk < resIndex.length) {
                        resIndex[kk] = false;
                        ++kk;
                    }
                    Vector vecTempPdbALA = pp.AlaninizeStructure(vecTempPdbBB, resIndex, rotSrc);
                    Vector<Pdb> vecTempPdbRot = pp.RotamSelectAndStructure(2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, vecTempPdbBB, assignVec, rotSrc, vecNewNoesy, noeBound, 1, 0.0);
                    boolean[] resClash = new boolean[140];
                    vdwVec = vander.convert2VDW(vecTempPdbRot);
                    vander.OutputStericClashResidues(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.4, 1, resClash, true);
                    int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.8);
                    Vector vecTemptt = new Vector();
                    if (numClashes > 0) {
                        int firstClash = 0;
                        i2 = 0;
                        while (i2 < resClash.length) {
                            if (resClash[i2]) {
                                firstClash = i2;
                                break;
                            }
                            ++i2;
                        }
                        vecTemptt = pp.RefineRotamerSelectionSearch(vecTempPdbRot, firstClash, rotSrc, 0);
                    } else {
                        vecTemptt = vecTempPdbRot;
                    }
                    String fileName = String.valueOf(src) + "FF2FinalWSc" + j + ".pdb";
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                        out.println("MODEL" + i2);
                        strNOEScore = String.valueOf(strNOEScore) + numConflicts[0] + " , ";
                        System.out.println("current ensemble ID: " + j + " noe Harm score: " + noeRmsd[0] + " numbr of conflicts: " + numConflicts[0]);
                        pp.printToFile(vecTemptt, fileName, out);
                        out.println("TER");
                        out.println("ENDMDL");
                        out.println("END");
                        out.close();
                        ++counter;
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("File not found: " + fileName);
                    }
                    catch (IOException e) {
                        System.out.println("IOException: the stack trace is:");
                        e.printStackTrace();
                    }
                    ++i2;
                }
            }
            ++j;
        }
        System.out.println("The NOE satisfication score is: ");
        System.out.println("strNOEScore= " + strNOEScore);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public void measureVDW4Ensemble() {
        long startTime = System.currentTimeMillis();
        int chosenNum = 25;
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        int numFiles = 50;
        Vector vecPdb = new Vector();
        Vector vecVdw = new Vector();
        Vector vecEnsemPdbNew = new Vector();
        Vector vecVdwScoreNew = new Vector();
        Vector vecVdwScore = new Vector();
        int j = 0;
        while (j <= 300) {
            Vector vecEnsemAfterThin = new Vector();
            String strEnsemPdb = String.valueOf(src) + "packing" + j + ".pdb";
            Vector vecEnsemble = pp.readPdbAndNoeRmsdFromEnsemble(strEnsemPdb);
            System.out.println("input: " + strEnsemPdb);
            double[] vdwScore = new double[vecEnsemble.size()];
            vdw vander = new vdw();
            Vector vdwVec = new Vector();
            double[] vdwValue = new double[1];
            boolean hasVDW = false;
            double vdwLevel = 0.05;
            boolean printVDWViolation = false;
            String fileName = String.valueOf(src) + "packingNew" + j + ".pdb";
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                int i = 0;
                while (i < vecEnsemble.size()) {
                    vecVdw = new Vector();
                    vdw Vdw = (vdw)vecEnsemble.elementAt(i);
                    vecPdb = Vdw.getPDB();
                    double noeRms = Vdw.getNoeRmsd();
                    vdwVec = vander.convert2VDW(vecPdb);
                    hasVDW = vander.computeVDW(vdwVec, vdwValue, vdwLevel, printVDWViolation, false);
                    vdwScore[i] = vdwValue[0];
                    out.println("MODEL" + i);
                    out.println("REMARK     VDW energy: " + vdwValue[0]);
                    out.println("REMARK :   NOE RMSD=:" + noeRms);
                    pp.printToFile(vecPdb, fileName, out);
                    out.println("TER");
                    out.println("ENDMDL");
                    ++i;
                }
                out.println("END");
                out.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + fileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
            ++j;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public static class VdwComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            vdw n1 = (vdw)o1;
            vdw n2 = (vdw)o2;
            double d1 = n1.getVdwScore();
            if (d1 < (d2 = n2.getVdwScore())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class VdwNoeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            vdw n1 = (vdw)o1;
            vdw n2 = (vdw)o2;
            double d1 = n1.getNoeRmsd();
            if (d1 < (d2 = n2.getNoeRmsd())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

